/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public final class AspectRatioFrameLayout
extends FrameLayout {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_FRACTION = 0.01f;
    private float videoAspectRatio;

    public AspectRatioFrameLayout(Context context) {
        super(context);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAspectRatio(float widthHeightRatio) {
        if (this.videoAspectRatio != widthHeightRatio) {
            this.videoAspectRatio = widthHeightRatio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.videoAspectRatio == 0.0f) {
            return;
        }
        int width = this.getMeasuredWidth();
        float viewAspectRatio = (float)width / (float)(height = this.getMeasuredHeight());
        float aspectDeformation = this.videoAspectRatio / viewAspectRatio - 1.0f;
        if (Math.abs(aspectDeformation) <= 0.01f) {
            return;
        }
        if (aspectDeformation > 0.0f) {
            height = (int)((float)width / this.videoAspectRatio);
        } else {
            width = (int)((float)height * this.videoAspectRatio);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }
}

