/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import com.google.android.exoplayer.util.Util;

@TargetApi(value=16)
public final class DecoderInfo {
    public final String name;
    public final MediaCodecInfo.CodecCapabilities capabilities;
    public final boolean adaptive;

    DecoderInfo(String name, MediaCodecInfo.CodecCapabilities capabilities) {
        this.name = name;
        this.capabilities = capabilities;
        this.adaptive = DecoderInfo.isAdaptive(capabilities);
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities != null && Util.SDK_INT >= 19 && DecoderInfo.isAdaptiveV19(capabilities);
    }

    @TargetApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("adaptive-playback");
    }
}

