/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.os.Handler;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.NetworkLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DefaultLoadControl
implements LoadControl {
    public static final int DEFAULT_LOW_WATERMARK_MS = 15000;
    public static final int DEFAULT_HIGH_WATERMARK_MS = 30000;
    public static final float DEFAULT_LOW_BUFFER_LOAD = 0.2f;
    public static final float DEFAULT_HIGH_BUFFER_LOAD = 0.8f;
    private static final int ABOVE_HIGH_WATERMARK = 0;
    private static final int BETWEEN_WATERMARKS = 1;
    private static final int BELOW_LOW_WATERMARK = 2;
    private final Allocator allocator;
    private final List<Object> loaders;
    private final HashMap<Object, LoaderState> loaderStates;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final long lowWatermarkUs;
    private final long highWatermarkUs;
    private final float lowBufferLoad;
    private final float highBufferLoad;
    private int targetBufferSize;
    private long maxLoadStartPositionUs;
    private int bufferState;
    private boolean fillingBuffers;
    private boolean streamingPrioritySet;

    public DefaultLoadControl(Allocator allocator) {
        this(allocator, null, null);
    }

    public DefaultLoadControl(Allocator allocator, Handler eventHandler, EventListener eventListener) {
        this(allocator, eventHandler, eventListener, 15000, 30000, 0.2f, 0.8f);
    }

    public DefaultLoadControl(Allocator allocator, Handler eventHandler, EventListener eventListener, int lowWatermarkMs, int highWatermarkMs, float lowBufferLoad, float highBufferLoad) {
        this.allocator = allocator;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.loaders = new ArrayList<Object>();
        this.loaderStates = new HashMap();
        this.lowWatermarkUs = (long)lowWatermarkMs * 1000L;
        this.highWatermarkUs = (long)highWatermarkMs * 1000L;
        this.lowBufferLoad = lowBufferLoad;
        this.highBufferLoad = highBufferLoad;
    }

    @Override
    public void register(Object loader, int bufferSizeContribution) {
        this.loaders.add(loader);
        this.loaderStates.put(loader, new LoaderState(bufferSizeContribution));
        this.targetBufferSize += bufferSizeContribution;
    }

    @Override
    public void unregister(Object loader) {
        this.loaders.remove(loader);
        LoaderState state = this.loaderStates.remove(loader);
        this.targetBufferSize -= state.bufferSizeContribution;
        this.updateControlState();
    }

    @Override
    public void trimAllocator() {
        this.allocator.trim(this.targetBufferSize);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public boolean update(Object loader, long playbackPositionUs, long nextLoadPositionUs, boolean loading) {
        int currentBufferSize;
        int bufferState;
        boolean bufferStateChanged;
        boolean loaderStateChanged;
        int loaderBufferState = this.getLoaderBufferState(playbackPositionUs, nextLoadPositionUs);
        LoaderState loaderState = this.loaderStates.get(loader);
        boolean bl = loaderStateChanged = loaderState.bufferState != loaderBufferState || loaderState.nextLoadPositionUs != nextLoadPositionUs || loaderState.loading != loading;
        if (loaderStateChanged) {
            loaderState.bufferState = loaderBufferState;
            loaderState.nextLoadPositionUs = nextLoadPositionUs;
            loaderState.loading = loading;
        }
        boolean bl2 = bufferStateChanged = this.bufferState != (bufferState = this.getBufferState(currentBufferSize = this.allocator.getTotalBytesAllocated()));
        if (bufferStateChanged) {
            this.bufferState = bufferState;
        }
        if (loaderStateChanged || bufferStateChanged) {
            this.updateControlState();
        }
        return currentBufferSize < this.targetBufferSize && nextLoadPositionUs != -1L && nextLoadPositionUs <= this.maxLoadStartPositionUs;
    }

    private int getLoaderBufferState(long playbackPositionUs, long nextLoadPositionUs) {
        if (nextLoadPositionUs == -1L) {
            return 0;
        }
        long timeUntilNextLoadPosition = nextLoadPositionUs - playbackPositionUs;
        return timeUntilNextLoadPosition > this.highWatermarkUs ? 0 : (timeUntilNextLoadPosition < this.lowWatermarkUs ? 2 : 1);
    }

    private int getBufferState(int currentBufferSize) {
        float bufferLoad = (float)currentBufferSize / (float)this.targetBufferSize;
        return bufferLoad > this.highBufferLoad ? 0 : (bufferLoad < this.lowBufferLoad ? 2 : 1);
    }

    private void updateControlState() {
        int i;
        boolean loading = false;
        boolean haveNextLoadPosition = false;
        int highestState = this.bufferState;
        for (i = 0; i < this.loaders.size(); ++i) {
            LoaderState loaderState = this.loaderStates.get(this.loaders.get(i));
            loading |= loaderState.loading;
            haveNextLoadPosition |= loaderState.nextLoadPositionUs != -1L;
            highestState = Math.max(highestState, loaderState.bufferState);
        }
        boolean bl = this.fillingBuffers = !this.loaders.isEmpty() && (loading || haveNextLoadPosition) && (highestState == 2 || highestState == 1 && this.fillingBuffers);
        if (this.fillingBuffers && !this.streamingPrioritySet) {
            NetworkLock.instance.add(0);
            this.streamingPrioritySet = true;
            this.notifyLoadingChanged(true);
        } else if (!this.fillingBuffers && this.streamingPrioritySet && !loading) {
            NetworkLock.instance.remove(0);
            this.streamingPrioritySet = false;
            this.notifyLoadingChanged(false);
        }
        this.maxLoadStartPositionUs = -1L;
        if (this.fillingBuffers) {
            for (i = 0; i < this.loaders.size(); ++i) {
                Object loader = this.loaders.get(i);
                LoaderState loaderState = this.loaderStates.get(loader);
                long loaderTime = loaderState.nextLoadPositionUs;
                if (loaderTime == -1L || this.maxLoadStartPositionUs != -1L && loaderTime >= this.maxLoadStartPositionUs) continue;
                this.maxLoadStartPositionUs = loaderTime;
            }
        }
    }

    private void notifyLoadingChanged(final boolean loading) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultLoadControl.this.eventListener.onLoadingChanged(loading);
                }
            });
        }
    }

    private static class LoaderState {
        public final int bufferSizeContribution;
        public int bufferState;
        public boolean loading;
        public long nextLoadPositionUs;

        public LoaderState(int bufferSizeContribution) {
            this.bufferSizeContribution = bufferSizeContribution;
            this.bufferState = 0;
            this.loading = false;
            this.nextLoadPositionUs = -1L;
        }
    }

    public static interface EventListener {
        public void onLoadingChanged(boolean var1);
    }
}

