/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.ExoPlayerImplInternal;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TrackRenderer;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArraySet;

final class ExoPlayerImpl
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    private final Handler eventHandler;
    private final ExoPlayerImplInternal internalPlayer;
    private final CopyOnWriteArraySet<ExoPlayer.Listener> listeners;
    private final MediaFormat[][] trackFormats;
    private final int[] selectedTrackIndices;
    private boolean playWhenReady;
    private int playbackState;
    private int pendingPlayWhenReadyAcks;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(int rendererCount, int minBufferMs, int minRebufferMs) {
        Log.i((String)TAG, (String)"Init 1.5.11");
        this.playWhenReady = false;
        this.playbackState = 1;
        this.listeners = new CopyOnWriteArraySet();
        this.trackFormats = new MediaFormat[rendererCount][];
        this.selectedTrackIndices = new int[rendererCount];
        this.eventHandler = new Handler(){

            public void handleMessage(Message msg) {
                ExoPlayerImpl.this.handleEvent(msg);
            }
        };
        this.internalPlayer = new ExoPlayerImplInternal(this.eventHandler, this.playWhenReady, this.selectedTrackIndices, minBufferMs, minRebufferMs);
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    @Override
    public void addListener(ExoPlayer.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExoPlayer.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getPlaybackState() {
        return this.playbackState;
    }

    @Override
    public void prepare(TrackRenderer ... renderers) {
        Arrays.fill((Object[])this.trackFormats, null);
        this.internalPlayer.prepare(renderers);
    }

    @Override
    public int getTrackCount(int rendererIndex) {
        return this.trackFormats[rendererIndex] != null ? this.trackFormats[rendererIndex].length : 0;
    }

    @Override
    public MediaFormat getTrackFormat(int rendererIndex, int trackIndex) {
        return this.trackFormats[rendererIndex][trackIndex];
    }

    @Override
    public void setSelectedTrack(int rendererIndex, int trackIndex) {
        if (this.selectedTrackIndices[rendererIndex] != trackIndex) {
            this.selectedTrackIndices[rendererIndex] = trackIndex;
            this.internalPlayer.setRendererSelectedTrack(rendererIndex, trackIndex);
        }
    }

    @Override
    public int getSelectedTrack(int rendererIndex) {
        return this.selectedTrackIndices[rendererIndex];
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        if (this.playWhenReady != playWhenReady) {
            this.playWhenReady = playWhenReady;
            ++this.pendingPlayWhenReadyAcks;
            this.internalPlayer.setPlayWhenReady(playWhenReady);
            for (ExoPlayer.Listener listener : this.listeners) {
                listener.onPlayerStateChanged(playWhenReady, this.playbackState);
            }
        }
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.playWhenReady;
    }

    @Override
    public boolean isPlayWhenReadyCommitted() {
        return this.pendingPlayWhenReadyAcks == 0;
    }

    @Override
    public void seekTo(long positionMs) {
        this.internalPlayer.seekTo(positionMs);
    }

    @Override
    public void stop() {
        this.internalPlayer.stop();
    }

    @Override
    public void release() {
        this.internalPlayer.release();
        this.eventHandler.removeCallbacksAndMessages(null);
    }

    @Override
    public void sendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        this.internalPlayer.sendMessage(target, messageType, message);
    }

    @Override
    public void blockingSendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        this.internalPlayer.blockingSendMessage(target, messageType, message);
    }

    @Override
    public long getDuration() {
        return this.internalPlayer.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.internalPlayer.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.internalPlayer.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        long bufferedPosition = this.getBufferedPosition();
        long duration = this.getDuration();
        return bufferedPosition == -1L || duration == -1L ? 0 : (int)(duration == 0L ? 100L : bufferedPosition * 100L / duration);
    }

    void handleEvent(Message msg) {
        switch (msg.what) {
            case 1: {
                System.arraycopy(msg.obj, 0, this.trackFormats, 0, this.trackFormats.length);
                this.playbackState = msg.arg1;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
                }
                break;
            }
            case 2: {
                this.playbackState = msg.arg1;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
                }
                break;
            }
            case 3: {
                --this.pendingPlayWhenReadyAcks;
                if (this.pendingPlayWhenReadyAcks != 0) break;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayWhenReadyCommitted();
                }
                break;
            }
            case 4: {
                ExoPlaybackException exception = (ExoPlaybackException)msg.obj;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerError(exception);
                }
                break;
            }
        }
    }
}

