/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.StandaloneMediaClock;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.PriorityHandlerThread;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class ExoPlayerImplInternal
implements Handler.Callback {
    private static final String TAG = "ExoPlayerImplInternal";
    public static final int MSG_PREPARED = 1;
    public static final int MSG_STATE_CHANGED = 2;
    public static final int MSG_SET_PLAY_WHEN_READY_ACK = 3;
    public static final int MSG_ERROR = 4;
    private static final int MSG_PREPARE = 1;
    private static final int MSG_INCREMENTAL_PREPARE = 2;
    private static final int MSG_SET_PLAY_WHEN_READY = 3;
    private static final int MSG_STOP = 4;
    private static final int MSG_RELEASE = 5;
    private static final int MSG_SEEK_TO = 6;
    private static final int MSG_DO_SOME_WORK = 7;
    private static final int MSG_SET_RENDERER_SELECTED_TRACK = 8;
    private static final int MSG_CUSTOM = 9;
    private static final int PREPARE_INTERVAL_MS = 10;
    private static final int RENDERING_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private final Handler handler;
    private final HandlerThread internalPlaybackThread;
    private final Handler eventHandler;
    private final StandaloneMediaClock standaloneMediaClock;
    private final AtomicInteger pendingSeekCount;
    private final List<TrackRenderer> enabledRenderers;
    private final MediaFormat[][] trackFormats;
    private final int[] selectedTrackIndices;
    private final long minBufferUs;
    private final long minRebufferUs;
    private TrackRenderer[] renderers;
    private TrackRenderer rendererMediaClockSource;
    private MediaClock rendererMediaClock;
    private boolean released;
    private boolean playWhenReady;
    private boolean rebuffering;
    private int state;
    private int customMessagesSent = 0;
    private int customMessagesProcessed = 0;
    private long lastSeekPositionMs;
    private long elapsedRealtimeUs;
    private volatile long durationUs;
    private volatile long positionUs;
    private volatile long bufferedPositionUs;

    public ExoPlayerImplInternal(Handler eventHandler, boolean playWhenReady, int[] selectedTrackIndices, int minBufferMs, int minRebufferMs) {
        this.eventHandler = eventHandler;
        this.playWhenReady = playWhenReady;
        this.minBufferUs = (long)minBufferMs * 1000L;
        this.minRebufferUs = (long)minRebufferMs * 1000L;
        this.selectedTrackIndices = Arrays.copyOf(selectedTrackIndices, selectedTrackIndices.length);
        this.state = 1;
        this.durationUs = -1L;
        this.bufferedPositionUs = -1L;
        this.standaloneMediaClock = new StandaloneMediaClock();
        this.pendingSeekCount = new AtomicInteger();
        this.enabledRenderers = new ArrayList<TrackRenderer>(selectedTrackIndices.length);
        this.trackFormats = new MediaFormat[selectedTrackIndices.length][];
        this.internalPlaybackThread = new PriorityHandlerThread("ExoPlayerImplInternal:Handler", -16);
        this.internalPlaybackThread.start();
        this.handler = new Handler(this.internalPlaybackThread.getLooper(), (Handler.Callback)this);
    }

    public Looper getPlaybackLooper() {
        return this.internalPlaybackThread.getLooper();
    }

    public long getCurrentPosition() {
        return this.pendingSeekCount.get() > 0 ? this.lastSeekPositionMs : this.positionUs / 1000L;
    }

    public long getBufferedPosition() {
        return this.bufferedPositionUs == -1L ? -1L : this.bufferedPositionUs / 1000L;
    }

    public long getDuration() {
        return this.durationUs == -1L ? -1L : this.durationUs / 1000L;
    }

    public void prepare(TrackRenderer ... renderers) {
        this.handler.obtainMessage(1, (Object)renderers).sendToTarget();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.handler.obtainMessage(3, playWhenReady ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(long positionMs) {
        this.lastSeekPositionMs = positionMs;
        this.pendingSeekCount.incrementAndGet();
        this.handler.obtainMessage(6, Util.getTopInt(positionMs), Util.getBottomInt(positionMs)).sendToTarget();
    }

    public void stop() {
        this.handler.sendEmptyMessage(4);
    }

    public void setRendererSelectedTrack(int rendererIndex, int trackIndex) {
        this.handler.obtainMessage(8, rendererIndex, trackIndex).sendToTarget();
    }

    public void sendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        ++this.customMessagesSent;
        this.handler.obtainMessage(9, messageType, 0, (Object)Pair.create((Object)target, (Object)message)).sendToTarget();
    }

    public synchronized void blockingSendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        if (this.released) {
            Log.w((String)TAG, (String)("Sent message(" + messageType + ") after release. Message ignored."));
            return;
        }
        int messageNumber = this.customMessagesSent++;
        this.handler.obtainMessage(9, messageType, 0, (Object)Pair.create((Object)target, (Object)message)).sendToTarget();
        while (this.customMessagesProcessed <= messageNumber) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void release() {
        if (this.released) {
            return;
        }
        this.handler.sendEmptyMessage(5);
        while (!this.released) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.internalPlaybackThread.quit();
    }

    public boolean handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 1: {
                    this.prepareInternal((TrackRenderer[])msg.obj);
                    return true;
                }
                case 2: {
                    this.incrementalPrepareInternal();
                    return true;
                }
                case 3: {
                    this.setPlayWhenReadyInternal(msg.arg1 != 0);
                    return true;
                }
                case 7: {
                    this.doSomeWork();
                    return true;
                }
                case 6: {
                    this.seekToInternal(Util.getLong(msg.arg1, msg.arg2));
                    return true;
                }
                case 4: {
                    this.stopInternal();
                    return true;
                }
                case 5: {
                    this.releaseInternal();
                    return true;
                }
                case 9: {
                    this.sendMessageInternal(msg.arg1, msg.obj);
                    return true;
                }
                case 8: {
                    this.setRendererSelectedTrackInternal(msg.arg1, msg.arg2);
                    return true;
                }
            }
            return false;
        }
        catch (ExoPlaybackException e) {
            Log.e((String)TAG, (String)"Internal track renderer error.", (Throwable)e);
            this.eventHandler.obtainMessage(4, (Object)e).sendToTarget();
            this.stopInternal();
            return true;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Internal runtime error.", (Throwable)e);
            this.eventHandler.obtainMessage(4, (Object)new ExoPlaybackException(e, true)).sendToTarget();
            this.stopInternal();
            return true;
        }
    }

    private void setState(int state) {
        if (this.state != state) {
            this.state = state;
            this.eventHandler.obtainMessage(2, state, 0).sendToTarget();
        }
    }

    private void prepareInternal(TrackRenderer[] renderers) throws ExoPlaybackException {
        this.resetInternal();
        this.renderers = renderers;
        Arrays.fill((Object[])this.trackFormats, null);
        this.setState(2);
        this.incrementalPrepareInternal();
    }

    private void incrementalPrepareInternal() throws ExoPlaybackException {
        long operationStartTimeMs = SystemClock.elapsedRealtime();
        boolean prepared = true;
        for (int rendererIndex = 0; rendererIndex < this.renderers.length; ++rendererIndex) {
            int state;
            TrackRenderer renderer = this.renderers[rendererIndex];
            if (renderer.getState() != 0 || (state = renderer.prepare(this.positionUs)) != 0) continue;
            renderer.maybeThrowError();
            prepared = false;
        }
        if (!prepared) {
            this.scheduleNextOperation(2, operationStartTimeMs, 10L);
            return;
        }
        long durationUs = 0L;
        boolean allRenderersEnded = true;
        boolean allRenderersReadyOrEnded = true;
        for (int rendererIndex = 0; rendererIndex < this.renderers.length; ++rendererIndex) {
            int trackIndex;
            TrackRenderer renderer = this.renderers[rendererIndex];
            int rendererTrackCount = renderer.getTrackCount();
            MediaFormat[] rendererTrackFormats = new MediaFormat[rendererTrackCount];
            for (trackIndex = 0; trackIndex < rendererTrackCount; ++trackIndex) {
                rendererTrackFormats[trackIndex] = renderer.getFormat(trackIndex);
            }
            this.trackFormats[rendererIndex] = rendererTrackFormats;
            if (rendererTrackCount <= 0) continue;
            if (durationUs != -1L) {
                long trackDurationUs = renderer.getDurationUs();
                if (trackDurationUs == -1L) {
                    durationUs = -1L;
                } else if (trackDurationUs != -2L) {
                    durationUs = Math.max(durationUs, trackDurationUs);
                }
            }
            if (0 > (trackIndex = this.selectedTrackIndices[rendererIndex]) || trackIndex >= rendererTrackFormats.length) continue;
            this.enableRenderer(renderer, trackIndex, false);
            allRenderersEnded = allRenderersEnded && renderer.isEnded();
            allRenderersReadyOrEnded = allRenderersReadyOrEnded && this.rendererReadyOrEnded(renderer);
        }
        this.durationUs = durationUs;
        this.state = allRenderersEnded && (durationUs == -1L || durationUs <= this.positionUs) ? 5 : (allRenderersReadyOrEnded ? 4 : 3);
        this.eventHandler.obtainMessage(1, this.state, 0, (Object)this.trackFormats).sendToTarget();
        if (this.playWhenReady && this.state == 4) {
            this.startRenderers();
        }
        this.handler.sendEmptyMessage(7);
    }

    private void enableRenderer(TrackRenderer renderer, int trackIndex, boolean joining) throws ExoPlaybackException {
        renderer.enable(trackIndex, this.positionUs, joining);
        this.enabledRenderers.add(renderer);
        MediaClock mediaClock = renderer.getMediaClock();
        if (mediaClock != null) {
            Assertions.checkState(this.rendererMediaClock == null);
            this.rendererMediaClock = mediaClock;
            this.rendererMediaClockSource = renderer;
        }
    }

    private boolean rendererReadyOrEnded(TrackRenderer renderer) {
        if (renderer.isEnded()) {
            return true;
        }
        if (!renderer.isReady()) {
            return false;
        }
        if (this.state == 4) {
            return true;
        }
        long rendererDurationUs = renderer.getDurationUs();
        long rendererBufferedPositionUs = renderer.getBufferedPositionUs();
        long minBufferDurationUs = this.rebuffering ? this.minRebufferUs : this.minBufferUs;
        return minBufferDurationUs <= 0L || rendererBufferedPositionUs == -1L || rendererBufferedPositionUs == -3L || rendererBufferedPositionUs >= this.positionUs + minBufferDurationUs || rendererDurationUs != -1L && rendererDurationUs != -2L && rendererBufferedPositionUs >= rendererDurationUs;
    }

    private void setPlayWhenReadyInternal(boolean playWhenReady) throws ExoPlaybackException {
        try {
            this.rebuffering = false;
            this.playWhenReady = playWhenReady;
            if (!playWhenReady) {
                this.stopRenderers();
                this.updatePositionUs();
            } else if (this.state == 4) {
                this.startRenderers();
                this.handler.sendEmptyMessage(7);
            } else if (this.state == 3) {
                this.handler.sendEmptyMessage(7);
            }
        }
        finally {
            this.eventHandler.obtainMessage(3).sendToTarget();
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        this.rebuffering = false;
        this.standaloneMediaClock.start();
        for (int i = 0; i < this.enabledRenderers.size(); ++i) {
            this.enabledRenderers.get(i).start();
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.standaloneMediaClock.stop();
        for (int i = 0; i < this.enabledRenderers.size(); ++i) {
            this.ensureStopped(this.enabledRenderers.get(i));
        }
    }

    private void updatePositionUs() {
        if (this.rendererMediaClock != null && this.enabledRenderers.contains(this.rendererMediaClockSource) && !this.rendererMediaClockSource.isEnded()) {
            this.positionUs = this.rendererMediaClock.getPositionUs();
            this.standaloneMediaClock.setPositionUs(this.positionUs);
        } else {
            this.positionUs = this.standaloneMediaClock.getPositionUs();
        }
        this.elapsedRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
    }

    private void doSomeWork() throws ExoPlaybackException {
        TraceUtil.beginSection("doSomeWork");
        long operationStartTimeMs = SystemClock.elapsedRealtime();
        long bufferedPositionUs = this.durationUs != -1L ? this.durationUs : Long.MAX_VALUE;
        boolean allRenderersEnded = true;
        boolean allRenderersReadyOrEnded = true;
        this.updatePositionUs();
        for (int i = 0; i < this.enabledRenderers.size(); ++i) {
            TrackRenderer renderer = this.enabledRenderers.get(i);
            renderer.doSomeWork(this.positionUs, this.elapsedRealtimeUs);
            allRenderersEnded = allRenderersEnded && renderer.isEnded();
            boolean rendererReadyOrEnded = this.rendererReadyOrEnded(renderer);
            if (!rendererReadyOrEnded) {
                renderer.maybeThrowError();
            }
            boolean bl = allRenderersReadyOrEnded = allRenderersReadyOrEnded && rendererReadyOrEnded;
            if (bufferedPositionUs == -1L) continue;
            long rendererDurationUs = renderer.getDurationUs();
            long rendererBufferedPositionUs = renderer.getBufferedPositionUs();
            if (rendererBufferedPositionUs == -1L) {
                bufferedPositionUs = -1L;
                continue;
            }
            if (rendererBufferedPositionUs == -3L || rendererDurationUs != -1L && rendererDurationUs != -2L && rendererBufferedPositionUs >= rendererDurationUs) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, rendererBufferedPositionUs);
        }
        this.bufferedPositionUs = bufferedPositionUs;
        if (allRenderersEnded && (this.durationUs == -1L || this.durationUs <= this.positionUs)) {
            this.setState(5);
            this.stopRenderers();
        } else if (this.state == 3 && allRenderersReadyOrEnded) {
            this.setState(4);
            if (this.playWhenReady) {
                this.startRenderers();
            }
        } else if (this.state == 4 && !allRenderersReadyOrEnded) {
            this.rebuffering = this.playWhenReady;
            this.setState(3);
            this.stopRenderers();
        }
        this.handler.removeMessages(7);
        if (this.playWhenReady && this.state == 4 || this.state == 3) {
            this.scheduleNextOperation(7, operationStartTimeMs, 10L);
        } else if (!this.enabledRenderers.isEmpty()) {
            this.scheduleNextOperation(7, operationStartTimeMs, 1000L);
        }
        TraceUtil.endSection();
    }

    private void scheduleNextOperation(int operationType, long thisOperationStartTimeMs, long intervalMs) {
        long nextOperationStartTimeMs = thisOperationStartTimeMs + intervalMs;
        long nextOperationDelayMs = nextOperationStartTimeMs - SystemClock.elapsedRealtime();
        if (nextOperationDelayMs <= 0L) {
            this.handler.sendEmptyMessage(operationType);
        } else {
            this.handler.sendEmptyMessageDelayed(operationType, nextOperationDelayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToInternal(long positionMs) throws ExoPlaybackException {
        try {
            if (positionMs == this.positionUs / 1000L) {
                return;
            }
            this.rebuffering = false;
            this.positionUs = positionMs * 1000L;
            this.standaloneMediaClock.stop();
            this.standaloneMediaClock.setPositionUs(this.positionUs);
            if (this.state == 1 || this.state == 2) {
                return;
            }
            for (int i = 0; i < this.enabledRenderers.size(); ++i) {
                TrackRenderer renderer = this.enabledRenderers.get(i);
                this.ensureStopped(renderer);
                renderer.seekTo(this.positionUs);
            }
            this.setState(3);
            this.handler.sendEmptyMessage(7);
        }
        finally {
            this.pendingSeekCount.decrementAndGet();
        }
    }

    private void stopInternal() {
        this.resetInternal();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        this.resetInternal();
        this.setState(1);
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal() {
        this.handler.removeMessages(7);
        this.handler.removeMessages(2);
        this.rebuffering = false;
        this.standaloneMediaClock.stop();
        if (this.renderers == null) {
            return;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            TrackRenderer renderer = this.renderers[i];
            this.stopAndDisable(renderer);
            this.release(renderer);
        }
        this.renderers = null;
        this.rendererMediaClock = null;
        this.rendererMediaClockSource = null;
        this.enabledRenderers.clear();
    }

    private void stopAndDisable(TrackRenderer renderer) {
        try {
            this.ensureDisabled(renderer);
        }
        catch (ExoPlaybackException e) {
            Log.e((String)TAG, (String)"Stop failed.", (Throwable)e);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Stop failed.", (Throwable)e);
        }
    }

    private void release(TrackRenderer renderer) {
        try {
            renderer.release();
        }
        catch (ExoPlaybackException e) {
            Log.e((String)TAG, (String)"Release failed.", (Throwable)e);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Release failed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void sendMessageInternal(int what, Object obj) throws ExoPlaybackException {
        try {
            Pair targetAndMessage = (Pair)obj;
            ((ExoPlayer.ExoPlayerComponent)targetAndMessage.first).handleMessage(what, targetAndMessage.second);
            if (this.state != 1 && this.state != 2) {
                this.handler.sendEmptyMessage(7);
            }
        }
        finally {
            ExoPlayerImplInternal exoPlayerImplInternal = this;
            synchronized (exoPlayerImplInternal) {
                ++this.customMessagesProcessed;
                this.notifyAll();
            }
        }
    }

    private void setRendererSelectedTrackInternal(int rendererIndex, int trackIndex) throws ExoPlaybackException {
        boolean shouldEnable;
        if (this.selectedTrackIndices[rendererIndex] == trackIndex) {
            return;
        }
        this.selectedTrackIndices[rendererIndex] = trackIndex;
        if (this.state == 1 || this.state == 2) {
            return;
        }
        TrackRenderer renderer = this.renderers[rendererIndex];
        int rendererState = renderer.getState();
        if (rendererState == 0 || rendererState == -1 || renderer.getTrackCount() == 0) {
            return;
        }
        boolean isEnabled = rendererState == 2 || rendererState == 3;
        boolean bl = shouldEnable = 0 <= trackIndex && trackIndex < this.trackFormats[rendererIndex].length;
        if (isEnabled) {
            if (!shouldEnable && renderer == this.rendererMediaClockSource) {
                this.standaloneMediaClock.setPositionUs(this.rendererMediaClock.getPositionUs());
            }
            this.ensureDisabled(renderer);
            this.enabledRenderers.remove(renderer);
        }
        if (shouldEnable) {
            boolean playing = this.playWhenReady && this.state == 4;
            boolean joining = !isEnabled && playing;
            this.enableRenderer(renderer, trackIndex, joining);
            if (playing) {
                renderer.start();
            }
            this.handler.sendEmptyMessage(7);
        }
    }

    private void ensureStopped(TrackRenderer renderer) throws ExoPlaybackException {
        if (renderer.getState() == 3) {
            renderer.stop();
        }
    }

    private void ensureDisabled(TrackRenderer renderer) throws ExoPlaybackException {
        this.ensureStopped(renderer);
        if (renderer.getState() == 2) {
            renderer.disable();
            if (renderer == this.rendererMediaClockSource) {
                this.rendererMediaClock = null;
                this.rendererMediaClockSource = null;
            }
        }
    }
}

