/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaExtractor;
import android.net.Uri;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

@Deprecated
@TargetApi(value=16)
public final class FrameworkSampleSource
implements SampleSource,
SampleSource.SampleSourceReader {
    private static final int ALLOWED_FLAGS_MASK = 3;
    private static final int TRACK_STATE_DISABLED = 0;
    private static final int TRACK_STATE_ENABLED = 1;
    private static final int TRACK_STATE_FORMAT_SENT = 2;
    private final Context context;
    private final Uri uri;
    private final Map<String, String> headers;
    private final FileDescriptor fileDescriptor;
    private final long fileDescriptorOffset;
    private final long fileDescriptorLength;
    private IOException preparationError;
    private MediaExtractor extractor;
    private MediaFormat[] trackFormats;
    private boolean prepared;
    private int remainingReleaseCount;
    private int[] trackStates;
    private boolean[] pendingDiscontinuities;
    private long lastSeekPositionUs;
    private long pendingSeekPositionUs;

    public FrameworkSampleSource(Context context, Uri uri, Map<String, String> headers) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.context = Assertions.checkNotNull(context);
        this.uri = Assertions.checkNotNull(uri);
        this.headers = headers;
        this.fileDescriptor = null;
        this.fileDescriptorOffset = 0L;
        this.fileDescriptorLength = 0L;
    }

    public FrameworkSampleSource(FileDescriptor fileDescriptor, long fileDescriptorOffset, long fileDescriptorLength) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.fileDescriptor = Assertions.checkNotNull(fileDescriptor);
        this.fileDescriptorOffset = fileDescriptorOffset;
        this.fileDescriptorLength = fileDescriptorLength;
        this.context = null;
        this.uri = null;
        this.headers = null;
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        ++this.remainingReleaseCount;
        return this;
    }

    @Override
    public boolean prepare(long positionUs) {
        if (!this.prepared) {
            if (this.preparationError != null) {
                return false;
            }
            this.extractor = new MediaExtractor();
            try {
                if (this.context != null) {
                    this.extractor.setDataSource(this.context, this.uri, this.headers);
                } else {
                    this.extractor.setDataSource(this.fileDescriptor, this.fileDescriptorOffset, this.fileDescriptorLength);
                }
            }
            catch (IOException e) {
                this.preparationError = e;
                return false;
            }
            this.trackStates = new int[this.extractor.getTrackCount()];
            this.pendingDiscontinuities = new boolean[this.trackStates.length];
            this.trackFormats = new MediaFormat[this.trackStates.length];
            for (int i = 0; i < this.trackStates.length; ++i) {
                this.trackFormats[i] = FrameworkSampleSource.createMediaFormat(this.extractor.getTrackFormat(i));
            }
            this.prepared = true;
        }
        return true;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.trackStates.length;
    }

    @Override
    public MediaFormat getFormat(int track) {
        Assertions.checkState(this.prepared);
        return this.trackFormats[track];
    }

    @Override
    public void enable(int track, long positionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[track] == 0);
        this.trackStates[track] = 1;
        this.extractor.selectTrack(track);
        this.seekToUsInternal(positionUs, positionUs != 0L);
    }

    @Override
    public boolean continueBuffering(int track, long positionUs) {
        return true;
    }

    @Override
    public long readDiscontinuity(int track) {
        if (this.pendingDiscontinuities[track]) {
            this.pendingDiscontinuities[track] = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int track, long positionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[track] != 0);
        if (this.pendingDiscontinuities[track]) {
            return -2;
        }
        if (this.trackStates[track] != 2) {
            formatHolder.format = this.trackFormats[track];
            formatHolder.drmInitData = Util.SDK_INT >= 18 ? this.getDrmInitDataV18() : null;
            this.trackStates[track] = 2;
            return -4;
        }
        int extractorTrackIndex = this.extractor.getSampleTrackIndex();
        if (extractorTrackIndex == track) {
            if (sampleHolder.data != null) {
                int offset = sampleHolder.data.position();
                sampleHolder.size = this.extractor.readSampleData(sampleHolder.data, offset);
                sampleHolder.data.position(offset + sampleHolder.size);
            } else {
                sampleHolder.size = 0;
            }
            sampleHolder.timeUs = this.extractor.getSampleTime();
            sampleHolder.flags = this.extractor.getSampleFlags() & 3;
            if (sampleHolder.isEncrypted()) {
                sampleHolder.cryptoInfo.setFromExtractorV16(this.extractor);
            }
            this.pendingSeekPositionUs = -1L;
            this.extractor.advance();
            return -3;
        }
        return extractorTrackIndex < 0 ? -1 : -2;
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[track] != 0);
        this.extractor.unselectTrack(track);
        this.pendingDiscontinuities[track] = false;
        this.trackStates[track] = 0;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.preparationError != null) {
            throw this.preparationError;
        }
    }

    @Override
    public void seekToUs(long positionUs) {
        Assertions.checkState(this.prepared);
        this.seekToUsInternal(positionUs, false);
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.prepared);
        long bufferedDurationUs = this.extractor.getCachedDuration();
        if (bufferedDurationUs == -1L) {
            return -1L;
        }
        long sampleTime = this.extractor.getSampleTime();
        return sampleTime == -1L ? -3L : sampleTime + bufferedDurationUs;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0 && this.extractor != null) {
            this.extractor.release();
            this.extractor = null;
        }
    }

    @TargetApi(value=18)
    private DrmInitData getDrmInitDataV18() {
        Map psshInfo = this.extractor.getPsshInfo();
        if (psshInfo == null || psshInfo.isEmpty()) {
            return null;
        }
        DrmInitData.Mapped drmInitData = new DrmInitData.Mapped();
        for (UUID uuid : psshInfo.keySet()) {
            byte[] psshAtom = PsshAtomUtil.buildPsshAtom(uuid, (byte[])psshInfo.get(uuid));
            drmInitData.put(uuid, new DrmInitData.SchemeInitData("video/mp4", psshAtom));
        }
        return drmInitData;
    }

    private void seekToUsInternal(long positionUs, boolean force) {
        if (force || this.pendingSeekPositionUs != positionUs) {
            this.lastSeekPositionUs = positionUs;
            this.pendingSeekPositionUs = positionUs;
            this.extractor.seekTo(positionUs, 0);
            for (int i = 0; i < this.trackStates.length; ++i) {
                if (this.trackStates[i] == 0) continue;
                this.pendingDiscontinuities[i] = true;
            }
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private static MediaFormat createMediaFormat(android.media.MediaFormat format) {
        String mimeType = format.getString("mime");
        String language = FrameworkSampleSource.getOptionalStringV16(format, "language");
        int maxInputSize = FrameworkSampleSource.getOptionalIntegerV16(format, "max-input-size");
        int width = FrameworkSampleSource.getOptionalIntegerV16(format, "width");
        int height = FrameworkSampleSource.getOptionalIntegerV16(format, "height");
        int rotationDegrees = FrameworkSampleSource.getOptionalIntegerV16(format, "rotation-degrees");
        int channelCount = FrameworkSampleSource.getOptionalIntegerV16(format, "channel-count");
        int sampleRate = FrameworkSampleSource.getOptionalIntegerV16(format, "sample-rate");
        int encoderDelay = FrameworkSampleSource.getOptionalIntegerV16(format, "encoder-delay");
        int encoderPadding = FrameworkSampleSource.getOptionalIntegerV16(format, "encoder-padding");
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
        int i = 0;
        while (format.containsKey("csd-" + i)) {
            ByteBuffer buffer = format.getByteBuffer("csd-" + i);
            byte[] data = new byte[buffer.limit()];
            buffer.get(data);
            initializationData.add(data);
            buffer.flip();
            ++i;
        }
        long durationUs = format.containsKey("durationUs") ? format.getLong("durationUs") : -1L;
        int pcmEncoding = "audio/raw".equals(mimeType) ? 2 : -1;
        MediaFormat mediaFormat = new MediaFormat(null, mimeType, -1, maxInputSize, durationUs, width, height, rotationDegrees, -1.0f, channelCount, sampleRate, language, Long.MAX_VALUE, initializationData, false, -1, -1, pcmEncoding, encoderDelay, encoderPadding, null, -1);
        mediaFormat.setFrameworkFormatV16(format);
        return mediaFormat;
    }

    @TargetApi(value=16)
    private static final String getOptionalStringV16(android.media.MediaFormat format, String key) {
        return format.containsKey(key) ? format.getString(key) : null;
    }

    @TargetApi(value=16)
    private static final int getOptionalIntegerV16(android.media.MediaFormat format, String key) {
        return format.containsKey(key) ? format.getInteger(key) : -1;
    }
}

