/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaClock;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer.util.MimeTypes;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecAudioTrackRenderer
extends MediaCodecTrackRenderer
implements MediaClock {
    public static final int MSG_SET_VOLUME = 1;
    public static final int MSG_SET_PLAYBACK_PARAMS = 2;
    private final EventListener eventListener;
    private final AudioTrack audioTrack;
    private boolean passthroughEnabled;
    private android.media.MediaFormat passthroughMediaFormat;
    private int pcmEncoding;
    private int audioSessionId;
    private long currentPositionUs;
    private boolean allowPositionDiscontinuity;
    private boolean audioTrackHasData;
    private long lastFeedElapsedRealtimeMs;

    public MediaCodecAudioTrackRenderer(SampleSource source, MediaCodecSelector mediaCodecSelector) {
        this(source, mediaCodecSelector, null, true);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys) {
        this(source, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, (Handler)null, (EventListener)null);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, MediaCodecSelector mediaCodecSelector, Handler eventHandler, EventListener eventListener) {
        this(source, mediaCodecSelector, (DrmSessionManager)null, true, eventHandler, eventListener);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener) {
        this(source, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener, null, 3);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener, AudioCapabilities audioCapabilities, int streamType) {
        this(new SampleSource[]{source}, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener, audioCapabilities, streamType);
    }

    public MediaCodecAudioTrackRenderer(SampleSource[] sources, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener, AudioCapabilities audioCapabilities, int streamType) {
        super(sources, mediaCodecSelector, (DrmSessionManager<FrameworkMediaCrypto>)drmSessionManager, playClearSamplesWithoutKeys, eventHandler, (MediaCodecTrackRenderer.EventListener)eventListener);
        this.eventListener = eventListener;
        this.audioSessionId = 0;
        this.audioTrack = new AudioTrack(audioCapabilities, streamType);
    }

    @Override
    protected boolean handlesTrack(MediaCodecSelector mediaCodecSelector, MediaFormat mediaFormat) throws MediaCodecUtil.DecoderQueryException {
        String mimeType = mediaFormat.mimeType;
        return MimeTypes.isAudio(mimeType) && ("audio/x-unknown".equals(mimeType) || this.allowPassthrough(mimeType) && mediaCodecSelector.getPassthroughDecoderInfo() != null || mediaCodecSelector.getDecoderInfo(mimeType, false) != null);
    }

    @Override
    protected DecoderInfo getDecoderInfo(MediaCodecSelector mediaCodecSelector, String mimeType, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        DecoderInfo passthroughDecoderInfo;
        if (this.allowPassthrough(mimeType) && (passthroughDecoderInfo = mediaCodecSelector.getPassthroughDecoderInfo()) != null) {
            this.passthroughEnabled = true;
            return passthroughDecoderInfo;
        }
        this.passthroughEnabled = false;
        return super.getDecoderInfo(mediaCodecSelector, mimeType, requiresSecureDecoder);
    }

    protected boolean allowPassthrough(String mimeType) {
        return this.audioTrack.isPassthroughSupported(mimeType);
    }

    @Override
    protected void configureCodec(MediaCodec codec, boolean codecIsAdaptive, android.media.MediaFormat format, MediaCrypto crypto) {
        String mimeType = format.getString("mime");
        if (this.passthroughEnabled) {
            format.setString("mime", "audio/raw");
            codec.configure(format, null, crypto, 0);
            format.setString("mime", mimeType);
            this.passthroughMediaFormat = format;
        } else {
            codec.configure(format, null, crypto, 0);
            this.passthroughMediaFormat = null;
        }
    }

    @Override
    protected MediaClock getMediaClock() {
        return this;
    }

    @Override
    protected void onInputFormatChanged(MediaFormatHolder holder) throws ExoPlaybackException {
        super.onInputFormatChanged(holder);
        this.pcmEncoding = "audio/raw".equals(holder.format.mimeType) ? holder.format.pcmEncoding : 2;
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec codec, android.media.MediaFormat outputFormat) {
        boolean passthrough = this.passthroughMediaFormat != null;
        String mimeType = passthrough ? this.passthroughMediaFormat.getString("mime") : "audio/raw";
        android.media.MediaFormat format = passthrough ? this.passthroughMediaFormat : outputFormat;
        int channelCount = format.getInteger("channel-count");
        int sampleRate = format.getInteger("sample-rate");
        this.audioTrack.configure(mimeType, channelCount, sampleRate, this.pcmEncoding);
    }

    protected void onAudioSessionId(int audioSessionId) {
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.audioTrack.play();
    }

    @Override
    protected void onStopped() {
        this.audioTrack.pause();
        super.onStopped();
    }

    @Override
    protected boolean isEnded() {
        return super.isEnded() && !this.audioTrack.hasPendingData();
    }

    @Override
    protected boolean isReady() {
        return this.audioTrack.hasPendingData() || super.isReady();
    }

    @Override
    public long getPositionUs() {
        long newCurrentPositionUs = this.audioTrack.getCurrentPositionUs(this.isEnded());
        if (newCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? newCurrentPositionUs : Math.max(this.currentPositionUs, newCurrentPositionUs);
            this.allowPositionDiscontinuity = false;
        }
        return this.currentPositionUs;
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.audioSessionId = 0;
        try {
            this.audioTrack.release();
        }
        finally {
            super.onDisabled();
        }
    }

    @Override
    protected void onDiscontinuity(long positionUs) throws ExoPlaybackException {
        super.onDiscontinuity(positionUs);
        this.audioTrack.reset();
        this.currentPositionUs = positionUs;
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo, int bufferIndex, boolean shouldSkip) throws ExoPlaybackException {
        int handleBufferResult;
        if (this.passthroughEnabled && (bufferInfo.flags & 2) != 0) {
            codec.releaseOutputBuffer(bufferIndex, false);
            return true;
        }
        if (shouldSkip) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.codecCounters.skippedOutputBufferCount;
            this.audioTrack.handleDiscontinuity();
            return true;
        }
        if (!this.audioTrack.isInitialized()) {
            try {
                if (this.audioSessionId != 0) {
                    this.audioTrack.initialize(this.audioSessionId);
                } else {
                    this.audioSessionId = this.audioTrack.initialize();
                    this.onAudioSessionId(this.audioSessionId);
                }
                this.audioTrackHasData = false;
            }
            catch (AudioTrack.InitializationException e) {
                this.notifyAudioTrackInitializationError(e);
                throw new ExoPlaybackException(e);
            }
            if (this.getState() == 3) {
                this.audioTrack.play();
            }
        } else {
            boolean audioTrackHadData = this.audioTrackHasData;
            this.audioTrackHasData = this.audioTrack.hasPendingData();
            if (audioTrackHadData && !this.audioTrackHasData && this.getState() == 3) {
                long elapsedSinceLastFeedMs = SystemClock.elapsedRealtime() - this.lastFeedElapsedRealtimeMs;
                long bufferSizeUs = this.audioTrack.getBufferSizeUs();
                long bufferSizeMs = bufferSizeUs == -1L ? -1L : bufferSizeUs / 1000L;
                this.notifyAudioTrackUnderrun(this.audioTrack.getBufferSize(), bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }
        try {
            handleBufferResult = this.audioTrack.handleBuffer(buffer, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs);
            this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        }
        catch (AudioTrack.WriteException e) {
            this.notifyAudioTrackWriteError(e);
            throw new ExoPlaybackException(e);
        }
        if ((handleBufferResult & 1) != 0) {
            this.handleAudioTrackDiscontinuity();
            this.allowPositionDiscontinuity = true;
        }
        if ((handleBufferResult & 2) != 0) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.codecCounters.renderedOutputBufferCount;
            return true;
        }
        return false;
    }

    @Override
    protected void onOutputStreamEnded() {
        this.audioTrack.handleEndOfStream();
    }

    protected void handleAudioTrackDiscontinuity() {
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 1: {
                this.audioTrack.setVolume(((Float)message).floatValue());
                break;
            }
            case 2: {
                this.audioTrack.setPlaybackParams((PlaybackParams)message);
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    private void notifyAudioTrackInitializationError(final AudioTrack.InitializationException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackInitializationError(e);
                }
            });
        }
    }

    private void notifyAudioTrackWriteError(final AudioTrack.WriteException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackWriteError(e);
                }
            });
        }
    }

    private void notifyAudioTrackUnderrun(final int bufferSize, final long bufferSizeMs, final long elapsedSinceLastFeedMs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
                }
            });
        }
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onAudioTrackInitializationError(AudioTrack.InitializationException var1);

        public void onAudioTrackWriteError(AudioTrack.WriteException var1);

        public void onAudioTrackUnderrun(int var1, long var2, long var4);
    }
}

