/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=16)
public final class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final DecoderInfo PASSTHROUGH_DECODER_INFO = new DecoderInfo("OMX.google.raw.decoder", null);
    private static final Map<CodecKey, List<DecoderInfo>> decoderInfosCache = new HashMap<CodecKey, List<DecoderInfo>>();
    private static int maxH264DecodableFrameSize = -1;

    private MediaCodecUtil() {
    }

    public static void warmCodec(String mimeType, boolean secure) {
        try {
            MediaCodecUtil.getDecoderInfos(mimeType, secure);
        }
        catch (DecoderQueryException e) {
            Log.e((String)TAG, (String)"Codec warming failed", (Throwable)e);
        }
    }

    public static DecoderInfo getPassthroughDecoderInfo() {
        return PASSTHROUGH_DECODER_INFO;
    }

    public static DecoderInfo getDecoderInfo(String mimeType, boolean secure) throws DecoderQueryException {
        List<DecoderInfo> decoderInfos = MediaCodecUtil.getDecoderInfos(mimeType, secure);
        return decoderInfos.isEmpty() ? null : decoderInfos.get(0);
    }

    public static synchronized List<DecoderInfo> getDecoderInfos(String mimeType, boolean secure) throws DecoderQueryException {
        CodecKey key = new CodecKey(mimeType, secure);
        List<DecoderInfo> decoderInfos = decoderInfosCache.get(key);
        if (decoderInfos != null) {
            return decoderInfos;
        }
        MediaCodecListCompat mediaCodecList = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21(secure) : new MediaCodecListCompatV16();
        decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList);
        if (secure && decoderInfos.isEmpty() && 21 <= Util.SDK_INT && Util.SDK_INT <= 23 && !(decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList = new MediaCodecListCompatV16())).isEmpty()) {
            Log.w((String)TAG, (String)("MediaCodecList API didn't list secure decoder for: " + mimeType + ". Assuming: " + decoderInfos.get((int)0).name));
        }
        decoderInfos = Collections.unmodifiableList(decoderInfos);
        decoderInfosCache.put(key, decoderInfos);
        return decoderInfos;
    }

    private static List<DecoderInfo> getDecoderInfosInternal(CodecKey key, MediaCodecListCompat mediaCodecList) throws DecoderQueryException {
        try {
            ArrayList<DecoderInfo> decoderInfos = new ArrayList<DecoderInfo>();
            String mimeType = key.mimeType;
            int numberOfCodecs = mediaCodecList.getCodecCount();
            boolean secureDecodersExplicit = mediaCodecList.secureDecodersExplicit();
            for (int i = 0; i < numberOfCodecs; ++i) {
                String codecName;
                MediaCodecInfo codecInfo = mediaCodecList.getCodecInfoAt(i);
                if (!MediaCodecUtil.isCodecUsableDecoder(codecInfo, codecName = codecInfo.getName(), secureDecodersExplicit)) continue;
                for (String supportedType : codecInfo.getSupportedTypes()) {
                    if (!supportedType.equalsIgnoreCase(mimeType)) continue;
                    try {
                        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(supportedType);
                        boolean secure = mediaCodecList.isSecurePlaybackSupported(mimeType, capabilities);
                        if (secureDecodersExplicit && key.secure == secure || !secureDecodersExplicit && !key.secure) {
                            decoderInfos.add(new DecoderInfo(codecName, capabilities));
                            continue;
                        }
                        if (secureDecodersExplicit || !secure) continue;
                        decoderInfos.add(new DecoderInfo(codecName + ".secure", capabilities));
                        return decoderInfos;
                    }
                    catch (Exception e) {
                        if (Util.SDK_INT <= 23 && !decoderInfos.isEmpty()) {
                            Log.e((String)TAG, (String)("Skipping codec " + codecName + " (failed to query capabilities)"));
                            continue;
                        }
                        Log.e((String)TAG, (String)("Failed to query codec " + codecName + " (" + supportedType + ")"));
                        throw e;
                    }
                }
            }
            return decoderInfos;
        }
        catch (Exception e) {
            throw new DecoderQueryException(e);
        }
    }

    private static boolean isCodecUsableDecoder(MediaCodecInfo info, String name, boolean secureDecodersExplicit) {
        if (info.isEncoder() || !secureDecodersExplicit && name.endsWith(".secure")) {
            return false;
        }
        if (Util.SDK_INT < 21 && ("CIPAACDecoder".equals(name) || "CIPMP3Decoder".equals(name) || "CIPVorbisDecoder".equals(name) || "AACDecoder".equals(name) || "MP3Decoder".equals(name))) {
            return false;
        }
        if (Util.SDK_INT < 18 && "OMX.SEC.MP3.Decoder".equals(name)) {
            return false;
        }
        if (Util.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(name) && "a70".equals(Util.DEVICE)) {
            return false;
        }
        if (Util.SDK_INT == 16 && Util.DEVICE != null && "OMX.qcom.audio.decoder.mp3".equals(name) && ("dlxu".equals(Util.DEVICE) || "protou".equals(Util.DEVICE) || "ville".equals(Util.DEVICE) || "villeplus".equals(Util.DEVICE) || "villec2".equals(Util.DEVICE) || Util.DEVICE.startsWith("gee") || "C6602".equals(Util.DEVICE) || "C6603".equals(Util.DEVICE) || "C6606".equals(Util.DEVICE) || "C6616".equals(Util.DEVICE) || "L36h".equals(Util.DEVICE) || "SO-02E".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(name) && ("C1504".equals(Util.DEVICE) || "C1505".equals(Util.DEVICE) || "C1604".equals(Util.DEVICE) || "C1605".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT <= 19 && Util.DEVICE != null && (Util.DEVICE.startsWith("d2") || Util.DEVICE.startsWith("serrano") || Util.DEVICE.startsWith("jflte") || Util.DEVICE.startsWith("santos")) && "samsung".equals(Util.MANUFACTURER) && name.equals("OMX.SEC.vp8.dec")) {
            return false;
        }
        return Util.SDK_INT > 19 || Util.DEVICE == null || !Util.DEVICE.startsWith("jflte") || !"OMX.qcom.video.decoder.vp8".equals(name);
    }

    @TargetApi(value=21)
    public static boolean isSizeSupportedV21(String mimeType, boolean secure, int width, int height) throws DecoderQueryException {
        Assertions.checkState(Util.SDK_INT >= 21);
        MediaCodecInfo.VideoCapabilities videoCapabilities = MediaCodecUtil.getVideoCapabilitiesV21(mimeType, secure);
        return videoCapabilities != null && videoCapabilities.isSizeSupported(width, height);
    }

    @TargetApi(value=21)
    public static boolean isSizeAndRateSupportedV21(String mimeType, boolean secure, int width, int height, double frameRate) throws DecoderQueryException {
        Assertions.checkState(Util.SDK_INT >= 21);
        MediaCodecInfo.VideoCapabilities videoCapabilities = MediaCodecUtil.getVideoCapabilitiesV21(mimeType, secure);
        return videoCapabilities != null && videoCapabilities.areSizeAndRateSupported(width, height, frameRate);
    }

    @Deprecated
    public static boolean isH264ProfileSupported(int profile, int level) throws DecoderQueryException {
        DecoderInfo decoderInfo = MediaCodecUtil.getDecoderInfo("video/avc", false);
        if (decoderInfo == null) {
            return false;
        }
        for (MediaCodecInfo.CodecProfileLevel profileLevel : decoderInfo.capabilities.profileLevels) {
            if (profileLevel.profile != profile || profileLevel.level < level) continue;
            return true;
        }
        return false;
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        if (maxH264DecodableFrameSize == -1) {
            int result = 0;
            DecoderInfo decoderInfo = MediaCodecUtil.getDecoderInfo("video/avc", false);
            if (decoderInfo != null) {
                for (MediaCodecInfo.CodecProfileLevel profileLevel : decoderInfo.capabilities.profileLevels) {
                    result = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(profileLevel.level), result);
                }
                result = Math.max(result, 172800);
            }
            maxH264DecodableFrameSize = result;
        }
        return maxH264DecodableFrameSize;
    }

    @TargetApi(value=21)
    private static MediaCodecInfo.VideoCapabilities getVideoCapabilitiesV21(String mimeType, boolean secure) throws DecoderQueryException {
        DecoderInfo decoderInfo = MediaCodecUtil.getDecoderInfo(mimeType, secure);
        return decoderInfo == null ? null : decoderInfo.capabilities.getVideoCapabilities();
    }

    private static int avcLevelToMaxFrameSize(int avcLevel) {
        switch (avcLevel) {
            case 1: {
                return 25344;
            }
            case 2: {
                return 25344;
            }
            case 8: {
                return 101376;
            }
            case 16: {
                return 101376;
            }
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: {
                return 414720;
            }
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: {
                return 0x200000;
            }
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: {
                return 0x900000;
            }
        }
        return -1;
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;

        public CodecKey(String mimeType, boolean secure) {
            this.mimeType = mimeType;
            this.secure = secure;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.secure ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != CodecKey.class) {
                return false;
            }
            CodecKey other = (CodecKey)obj;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)other.mimeType) && this.secure == other.secure;
        }
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public MediaCodecInfo getCodecInfoAt(int index) {
            return MediaCodecList.getCodecInfoAt((int)index);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }

        @Override
        public boolean isSecurePlaybackSupported(String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return "video/avc".equals(mimeType);
        }
    }

    @TargetApi(value=21)
    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        private MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean includeSecure) {
            this.codecKind = includeSecure ? 1 : 0;
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public MediaCodecInfo getCodecInfoAt(int index) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[index];
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }

        @Override
        public boolean isSecurePlaybackSupported(String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureSupported("secure-playback");
        }

        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public MediaCodecInfo getCodecInfoAt(int var1);

        public boolean secureDecodersExplicit();

        public boolean isSecurePlaybackSupported(String var1, MediaCodecInfo.CodecCapabilities var2);
    }

    public static class DecoderQueryException
    extends IOException {
        private DecoderQueryException(Throwable cause) {
            super("Failed to query underlying media codecs", cause);
        }
    }
}

