/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.os.Handler;
import android.os.SystemClock;
import android.view.Surface;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.VideoFrameReleaseTimeHelper;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecVideoTrackRenderer
extends MediaCodecTrackRenderer {
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    public static final int MSG_SET_SURFACE = 1;
    private final VideoFrameReleaseTimeHelper frameReleaseTimeHelper;
    private final EventListener eventListener;
    private final long allowedJoiningTimeUs;
    private final int videoScalingMode;
    private final int maxDroppedFrameCountToNotify;
    private Surface surface;
    private boolean reportedDrawnToSurface;
    private boolean renderedFirstFrame;
    private long joiningDeadlineUs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrameCount;
    private int consecutiveDroppedFrameCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int lastReportedWidth;
    private int lastReportedHeight;
    private int lastReportedUnappliedRotationDegrees;
    private float lastReportedPixelWidthHeightRatio;

    public MediaCodecVideoTrackRenderer(Context context, SampleSource source, MediaCodecSelector mediaCodecSelector, int videoScalingMode) {
        this(context, source, mediaCodecSelector, videoScalingMode, 0L);
    }

    public MediaCodecVideoTrackRenderer(Context context, SampleSource source, MediaCodecSelector mediaCodecSelector, int videoScalingMode, long allowedJoiningTimeMs) {
        this(context, source, mediaCodecSelector, videoScalingMode, allowedJoiningTimeMs, null, null, -1);
    }

    public MediaCodecVideoTrackRenderer(Context context, SampleSource source, MediaCodecSelector mediaCodecSelector, int videoScalingMode, long allowedJoiningTimeMs, Handler eventHandler, EventListener eventListener, int maxDroppedFrameCountToNotify) {
        this(context, source, mediaCodecSelector, videoScalingMode, allowedJoiningTimeMs, null, false, eventHandler, eventListener, maxDroppedFrameCountToNotify);
    }

    public MediaCodecVideoTrackRenderer(Context context, SampleSource source, MediaCodecSelector mediaCodecSelector, int videoScalingMode, long allowedJoiningTimeMs, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener, int maxDroppedFrameCountToNotify) {
        super(source, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, (MediaCodecTrackRenderer.EventListener)eventListener);
        this.frameReleaseTimeHelper = new VideoFrameReleaseTimeHelper(context);
        this.videoScalingMode = videoScalingMode;
        this.allowedJoiningTimeUs = allowedJoiningTimeMs * 1000L;
        this.eventListener = eventListener;
        this.maxDroppedFrameCountToNotify = maxDroppedFrameCountToNotify;
        this.joiningDeadlineUs = -1L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
    }

    @Override
    protected boolean handlesTrack(MediaCodecSelector mediaCodecSelector, MediaFormat mediaFormat) throws MediaCodecUtil.DecoderQueryException {
        String mimeType = mediaFormat.mimeType;
        return MimeTypes.isVideo(mimeType) && ("video/x-unknown".equals(mimeType) || mediaCodecSelector.getDecoderInfo(mimeType, false) != null);
    }

    @Override
    protected void onEnabled(int track, long positionUs, boolean joining) throws ExoPlaybackException {
        super.onEnabled(track, positionUs, joining);
        if (joining && this.allowedJoiningTimeUs > 0L) {
            this.joiningDeadlineUs = SystemClock.elapsedRealtime() * 1000L + this.allowedJoiningTimeUs;
        }
        this.frameReleaseTimeHelper.enable();
    }

    @Override
    protected void onDiscontinuity(long positionUs) throws ExoPlaybackException {
        super.onDiscontinuity(positionUs);
        this.renderedFirstFrame = false;
        this.consecutiveDroppedFrameCount = 0;
        this.joiningDeadlineUs = -1L;
    }

    @Override
    protected boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || !this.codecInitialized() || this.getSourceState() == 2)) {
            this.joiningDeadlineUs = -1L;
            return true;
        }
        if (this.joiningDeadlineUs == -1L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() * 1000L < this.joiningDeadlineUs) {
            return true;
        }
        this.joiningDeadlineUs = -1L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineUs = -1L;
        this.maybeNotifyDroppedFrameCount();
        super.onStopped();
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
        this.frameReleaseTimeHelper.disable();
        super.onDisabled();
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.setSurface((Surface)message);
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void setSurface(Surface surface) throws ExoPlaybackException {
        if (this.surface == surface) {
            return;
        }
        this.surface = surface;
        this.reportedDrawnToSurface = false;
        int state = this.getState();
        if (state == 2 || state == 3) {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    @Override
    protected boolean shouldInitCodec() {
        return super.shouldInitCodec() && this.surface != null && this.surface.isValid();
    }

    @Override
    protected void configureCodec(MediaCodec codec, boolean codecIsAdaptive, android.media.MediaFormat format, MediaCrypto crypto) {
        this.maybeSetMaxInputSize(format, codecIsAdaptive);
        codec.configure(format, this.surface, crypto, 0);
    }

    @Override
    protected void onInputFormatChanged(MediaFormatHolder holder) throws ExoPlaybackException {
        super.onInputFormatChanged(holder);
        this.pendingPixelWidthHeightRatio = holder.format.pixelWidthHeightRatio == -1.0f ? 1.0f : holder.format.pixelWidthHeightRatio;
        this.pendingRotationDegrees = holder.format.rotationDegrees == -1 ? 0 : holder.format.rotationDegrees;
    }

    protected final boolean haveRenderedFirstFrame() {
        return this.renderedFirstFrame;
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec codec, android.media.MediaFormat outputFormat) {
        boolean hasCrop = outputFormat.containsKey(KEY_CROP_RIGHT) && outputFormat.containsKey(KEY_CROP_LEFT) && outputFormat.containsKey(KEY_CROP_BOTTOM) && outputFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = hasCrop ? outputFormat.getInteger(KEY_CROP_RIGHT) - outputFormat.getInteger(KEY_CROP_LEFT) + 1 : outputFormat.getInteger("width");
        this.currentHeight = hasCrop ? outputFormat.getInteger(KEY_CROP_BOTTOM) - outputFormat.getInteger(KEY_CROP_TOP) + 1 : outputFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (Util.SDK_INT >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int rotatedHeight = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = rotatedHeight;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        codec.setVideoScalingMode(this.videoScalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec codec, boolean codecIsAdaptive, MediaFormat oldFormat, MediaFormat newFormat) {
        return newFormat.mimeType.equals(oldFormat.mimeType) && (codecIsAdaptive || oldFormat.width == newFormat.width && oldFormat.height == newFormat.height);
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo, int bufferIndex, boolean shouldSkip) {
        if (shouldSkip) {
            this.skipOutputBuffer(codec, bufferIndex);
            this.consecutiveDroppedFrameCount = 0;
            return true;
        }
        if (!this.renderedFirstFrame) {
            if (Util.SDK_INT >= 21) {
                this.renderOutputBufferV21(codec, bufferIndex, System.nanoTime());
            } else {
                this.renderOutputBuffer(codec, bufferIndex);
            }
            this.consecutiveDroppedFrameCount = 0;
            return true;
        }
        if (this.getState() != 3) {
            return false;
        }
        long elapsedSinceStartOfLoopUs = SystemClock.elapsedRealtime() * 1000L - elapsedRealtimeUs;
        long earlyUs = bufferInfo.presentationTimeUs - positionUs - elapsedSinceStartOfLoopUs;
        long systemTimeNs = System.nanoTime();
        long unadjustedFrameReleaseTimeNs = systemTimeNs + earlyUs * 1000L;
        long adjustedReleaseTimeNs = this.frameReleaseTimeHelper.adjustReleaseTime(bufferInfo.presentationTimeUs, unadjustedFrameReleaseTimeNs);
        earlyUs = (adjustedReleaseTimeNs - systemTimeNs) / 1000L;
        if (earlyUs < -30000L) {
            this.dropOutputBuffer(codec, bufferIndex);
            return true;
        }
        if (Util.SDK_INT >= 21) {
            if (earlyUs < 50000L) {
                this.renderOutputBufferV21(codec, bufferIndex, adjustedReleaseTimeNs);
                this.consecutiveDroppedFrameCount = 0;
                return true;
            }
        } else if (earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(codec, bufferIndex);
            this.consecutiveDroppedFrameCount = 0;
            return true;
        }
        return false;
    }

    protected void skipOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("skipVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.codecCounters.skippedOutputBufferCount;
    }

    protected void dropOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("dropVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.codecCounters.droppedOutputBufferCount;
        ++this.droppedFrameCount;
        ++this.consecutiveDroppedFrameCount;
        this.codecCounters.maxConsecutiveDroppedOutputBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.codecCounters.maxConsecutiveDroppedOutputBufferCount);
        if (this.droppedFrameCount == this.maxDroppedFrameCountToNotify) {
            this.maybeNotifyDroppedFrameCount();
        }
    }

    protected void renderOutputBuffer(MediaCodec codec, int bufferIndex) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        codec.releaseOutputBuffer(bufferIndex, true);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        this.renderedFirstFrame = true;
        this.maybeNotifyDrawnToSurface();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec codec, int bufferIndex, long releaseTimeNs) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        codec.releaseOutputBuffer(bufferIndex, releaseTimeNs);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        this.renderedFirstFrame = true;
        this.maybeNotifyDrawnToSurface();
    }

    @SuppressLint(value={"InlinedApi"})
    private void maybeSetMaxInputSize(android.media.MediaFormat format, boolean codecIsAdaptive) {
        int minCompressionRatio;
        int maxPixels;
        if (format.containsKey("max-input-size")) {
            return;
        }
        int maxHeight = format.getInteger("height");
        if (codecIsAdaptive && format.containsKey("max-height")) {
            maxHeight = Math.max(maxHeight, format.getInteger("max-height"));
        }
        int maxWidth = format.getInteger("width");
        if (codecIsAdaptive && format.containsKey("max-width")) {
            maxWidth = Math.max(maxHeight, format.getInteger("max-width"));
        }
        switch (format.getString("mime")) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                maxPixels = maxWidth * maxHeight;
                minCompressionRatio = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(Util.MODEL)) {
                    return;
                }
                maxPixels = (maxWidth + 15) / 16 * ((maxHeight + 15) / 16) * 16 * 16;
                minCompressionRatio = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                maxPixels = maxWidth * maxHeight;
                minCompressionRatio = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                maxPixels = maxWidth * maxHeight;
                minCompressionRatio = 4;
                break;
            }
            default: {
                return;
            }
        }
        int maxInputSize = maxPixels * 3 / (2 * minCompressionRatio);
        format.setInteger("max-input-size", maxInputSize);
    }

    private void maybeNotifyVideoSizeChanged() {
        if (this.eventHandler == null || this.eventListener == null || this.lastReportedWidth == this.currentWidth && this.lastReportedHeight == this.currentHeight && this.lastReportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.lastReportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio) {
            return;
        }
        final int currentWidth = this.currentWidth;
        final int currentHeight = this.currentHeight;
        final int currentUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
        final float currentPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onVideoSizeChanged(currentWidth, currentHeight, currentUnappliedRotationDegrees, currentPixelWidthHeightRatio);
            }
        });
        this.lastReportedWidth = currentWidth;
        this.lastReportedHeight = currentHeight;
        this.lastReportedUnappliedRotationDegrees = currentUnappliedRotationDegrees;
        this.lastReportedPixelWidthHeightRatio = currentPixelWidthHeightRatio;
    }

    private void maybeNotifyDrawnToSurface() {
        if (this.eventHandler == null || this.eventListener == null || this.reportedDrawnToSurface) {
            return;
        }
        final Surface surface = this.surface;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onDrawnToSurface(surface);
            }
        });
        this.reportedDrawnToSurface = true;
    }

    private void maybeNotifyDroppedFrameCount() {
        if (this.eventHandler == null || this.eventListener == null || this.droppedFrameCount == 0) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        final int countToNotify = this.droppedFrameCount;
        final long elapsedToNotify = now - this.droppedFrameAccumulationStartTimeMs;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onDroppedFrames(countToNotify, elapsedToNotify);
            }
        });
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = now;
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onDroppedFrames(int var1, long var2);

        public void onVideoSizeChanged(int var1, int var2, int var3, float var4);

        public void onDrawnToSurface(Surface var1);
    }
}

