/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import java.io.IOException;
import java.util.Arrays;

public abstract class SampleSourceTrackRenderer
extends TrackRenderer {
    private final SampleSource.SampleSourceReader[] sources;
    private int[] handledSourceIndices;
    private int[] handledSourceTrackIndices;
    private SampleSource.SampleSourceReader enabledSource;
    private int enabledSourceTrackIndex;
    private long durationUs;

    public SampleSourceTrackRenderer(SampleSource ... sources) {
        this.sources = new SampleSource.SampleSourceReader[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            this.sources[i] = sources[i].register();
        }
    }

    @Override
    protected final boolean doPrepare(long positionUs) throws ExoPlaybackException {
        boolean allSourcesPrepared = true;
        for (int i = 0; i < this.sources.length; ++i) {
            allSourcesPrepared &= this.sources[i].prepare(positionUs);
        }
        if (!allSourcesPrepared) {
            return false;
        }
        int totalSourceTrackCount = 0;
        for (int i = 0; i < this.sources.length; ++i) {
            totalSourceTrackCount += this.sources[i].getTrackCount();
        }
        long durationUs = 0L;
        int handledTrackCount = 0;
        int[] handledSourceIndices = new int[totalSourceTrackCount];
        int[] handledTrackIndices = new int[totalSourceTrackCount];
        int sourceCount = this.sources.length;
        for (int sourceIndex = 0; sourceIndex < sourceCount; ++sourceIndex) {
            SampleSource.SampleSourceReader source = this.sources[sourceIndex];
            int sourceTrackCount = source.getTrackCount();
            for (int trackIndex = 0; trackIndex < sourceTrackCount; ++trackIndex) {
                boolean handlesTrack;
                MediaFormat format = source.getFormat(trackIndex);
                try {
                    handlesTrack = this.handlesTrack(format);
                }
                catch (MediaCodecUtil.DecoderQueryException e) {
                    throw new ExoPlaybackException(e);
                }
                if (!handlesTrack) continue;
                handledSourceIndices[handledTrackCount] = sourceIndex;
                handledTrackIndices[handledTrackCount] = trackIndex;
                ++handledTrackCount;
                if (durationUs == -1L) continue;
                long trackDurationUs = format.durationUs;
                if (trackDurationUs == -1L) {
                    durationUs = -1L;
                    continue;
                }
                if (trackDurationUs == -2L) continue;
                durationUs = Math.max(durationUs, trackDurationUs);
            }
        }
        this.durationUs = durationUs;
        this.handledSourceIndices = Arrays.copyOf(handledSourceIndices, handledTrackCount);
        this.handledSourceTrackIndices = Arrays.copyOf(handledTrackIndices, handledTrackCount);
        return true;
    }

    @Override
    protected void onEnabled(int track, long positionUs, boolean joining) throws ExoPlaybackException {
        positionUs = this.shiftInputPosition(positionUs);
        this.enabledSource = this.sources[this.handledSourceIndices[track]];
        this.enabledSourceTrackIndex = this.handledSourceTrackIndices[track];
        this.enabledSource.enable(this.enabledSourceTrackIndex, positionUs);
        this.onDiscontinuity(positionUs);
    }

    @Override
    protected final void seekTo(long positionUs) throws ExoPlaybackException {
        positionUs = this.shiftInputPosition(positionUs);
        this.enabledSource.seekToUs(positionUs);
        this.checkForDiscontinuity(positionUs);
    }

    @Override
    protected final void doSomeWork(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        positionUs = this.shiftInputPosition(positionUs);
        boolean sourceIsReady = this.enabledSource.continueBuffering(this.enabledSourceTrackIndex, positionUs);
        positionUs = this.checkForDiscontinuity(positionUs);
        this.doSomeWork(positionUs, elapsedRealtimeUs, sourceIsReady);
    }

    @Override
    protected long getBufferedPositionUs() {
        return this.enabledSource.getBufferedPositionUs();
    }

    @Override
    protected long getDurationUs() {
        return this.durationUs;
    }

    @Override
    protected void maybeThrowError() throws ExoPlaybackException {
        if (this.enabledSource != null) {
            this.maybeThrowError(this.enabledSource);
        } else {
            int sourceCount = this.sources.length;
            for (int i = 0; i < sourceCount; ++i) {
                this.maybeThrowError(this.sources[i]);
            }
        }
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.enabledSource.disable(this.enabledSourceTrackIndex);
        this.enabledSource = null;
    }

    @Override
    protected void onReleased() throws ExoPlaybackException {
        int sourceCount = this.sources.length;
        for (int i = 0; i < sourceCount; ++i) {
            this.sources[i].release();
        }
    }

    @Override
    protected final int getTrackCount() {
        return this.handledSourceTrackIndices.length;
    }

    @Override
    protected final MediaFormat getFormat(int track) {
        SampleSource.SampleSourceReader source = this.sources[this.handledSourceIndices[track]];
        return source.getFormat(this.handledSourceTrackIndices[track]);
    }

    protected long shiftInputPosition(long positionUs) {
        return positionUs;
    }

    protected final int readSource(long positionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder) {
        return this.enabledSource.readData(this.enabledSourceTrackIndex, positionUs, formatHolder, sampleHolder);
    }

    protected abstract boolean handlesTrack(MediaFormat var1) throws MediaCodecUtil.DecoderQueryException;

    protected abstract void onDiscontinuity(long var1) throws ExoPlaybackException;

    protected abstract void doSomeWork(long var1, long var3, boolean var5) throws ExoPlaybackException;

    private long checkForDiscontinuity(long positionUs) throws ExoPlaybackException {
        long discontinuityPositionUs = this.enabledSource.readDiscontinuity(this.enabledSourceTrackIndex);
        if (discontinuityPositionUs != Long.MIN_VALUE) {
            this.onDiscontinuity(discontinuityPositionUs);
            return discontinuityPositionUs;
        }
        return positionUs;
    }

    private void maybeThrowError(SampleSource.SampleSourceReader source) throws ExoPlaybackException {
        try {
            source.maybeThrowError();
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
    }
}

