/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.Arrays;

public final class SingleSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
Loader.Callback,
Loader.Loadable {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private static final int INITIAL_SAMPLE_SIZE = 1;
    private static final int STATE_SEND_FORMAT = 0;
    private static final int STATE_SEND_SAMPLE = 1;
    private static final int STATE_END_OF_STREAM = 2;
    private final Uri uri;
    private final DataSource dataSource;
    private final MediaFormat format;
    private final int minLoadableRetryCount;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final int eventSourceId;
    private int state;
    private byte[] sampleData;
    private int sampleSize;
    private long pendingDiscontinuityPositionUs;
    private boolean loadingFinished;
    private Loader loader;
    private IOException currentLoadableException;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;

    public SingleSampleSource(Uri uri, DataSource dataSource, MediaFormat format) {
        this(uri, dataSource, format, 3);
    }

    public SingleSampleSource(Uri uri, DataSource dataSource, MediaFormat format, int minLoadableRetryCount) {
        this(uri, dataSource, format, minLoadableRetryCount, null, null, 0);
    }

    public SingleSampleSource(Uri uri, DataSource dataSource, MediaFormat format, int minLoadableRetryCount, Handler eventHandler, EventListener eventListener, int eventSourceId) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.format = format;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.eventSourceId = eventSourceId;
        this.sampleData = new byte[1];
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        return this;
    }

    @Override
    public boolean prepare(long positionUs) {
        if (this.loader == null) {
            this.loader = new Loader("Loader:" + this.format.mimeType);
        }
        return true;
    }

    @Override
    public int getTrackCount() {
        return 1;
    }

    @Override
    public MediaFormat getFormat(int track) {
        return this.format;
    }

    @Override
    public void enable(int track, long positionUs) {
        this.state = 0;
        this.pendingDiscontinuityPositionUs = Long.MIN_VALUE;
        this.clearCurrentLoadableException();
        this.maybeStartLoading();
    }

    @Override
    public boolean continueBuffering(int track, long positionUs) {
        this.maybeStartLoading();
        return this.loadingFinished;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.currentLoadableException != null && this.currentLoadableExceptionCount > this.minLoadableRetryCount) {
            throw this.currentLoadableException;
        }
    }

    @Override
    public long readDiscontinuity(int track) {
        long discontinuityPositionUs = this.pendingDiscontinuityPositionUs;
        this.pendingDiscontinuityPositionUs = Long.MIN_VALUE;
        return discontinuityPositionUs;
    }

    @Override
    public int readData(int track, long positionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder) {
        if (this.state == 2) {
            return -1;
        }
        if (this.state == 0) {
            formatHolder.format = this.format;
            this.state = 1;
            return -4;
        }
        Assertions.checkState(this.state == 1);
        if (!this.loadingFinished) {
            return -2;
        }
        sampleHolder.timeUs = 0L;
        sampleHolder.size = this.sampleSize;
        sampleHolder.flags = 1;
        sampleHolder.ensureSpaceForWrite(sampleHolder.size);
        sampleHolder.data.put(this.sampleData, 0, this.sampleSize);
        this.state = 2;
        return -3;
    }

    @Override
    public void seekToUs(long positionUs) {
        if (this.state == 2) {
            this.pendingDiscontinuityPositionUs = positionUs;
            this.state = 1;
        }
    }

    @Override
    public long getBufferedPositionUs() {
        return this.loadingFinished ? -3L : 0L;
    }

    @Override
    public void disable(int track) {
        this.state = 2;
    }

    @Override
    public void release() {
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    private void maybeStartLoading() {
        if (this.loadingFinished || this.state == 2 || this.loader.isLoading()) {
            return;
        }
        if (this.currentLoadableException != null) {
            long elapsedMillis = SystemClock.elapsedRealtime() - this.currentLoadableExceptionTimestamp;
            if (elapsedMillis < this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                return;
            }
            this.currentLoadableException = null;
        }
        this.loader.startLoading(this, this);
    }

    private void clearCurrentLoadableException() {
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        this.loadingFinished = true;
        this.clearCurrentLoadableException();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException e) {
        this.currentLoadableException = e;
        ++this.currentLoadableExceptionCount;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyLoadError(e);
        this.maybeStartLoading();
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public boolean isLoadCanceled() {
        return false;
    }

    @Override
    public void load() throws IOException, InterruptedException {
        this.sampleSize = 0;
        try {
            this.dataSource.open(new DataSpec(this.uri));
            int result = 0;
            while (result != -1) {
                this.sampleSize += result;
                if (this.sampleSize == this.sampleData.length) {
                    this.sampleData = Arrays.copyOf(this.sampleData, this.sampleData.length * 2);
                }
                result = this.dataSource.read(this.sampleData, this.sampleSize, this.sampleData.length - this.sampleSize);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    private void notifyLoadError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    SingleSampleSource.this.eventListener.onLoadError(SingleSampleSource.this.eventSourceId, e);
                }
            });
        }
    }

    public static interface EventListener {
        public void onLoadError(int var1, IOException var2);
    }
}

