/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.util.Clock;

public interface TimeRange {
    public boolean isStatic();

    public long[] getCurrentBoundsMs(long[] var1);

    public long[] getCurrentBoundsUs(long[] var1);

    public static final class DynamicTimeRange
    implements TimeRange {
        private final long minStartTimeUs;
        private final long maxEndTimeUs;
        private final long elapsedRealtimeAtStartUs;
        private final long bufferDepthUs;
        private final Clock systemClock;

        public DynamicTimeRange(long minStartTimeUs, long maxEndTimeUs, long elapsedRealtimeAtStartUs, long bufferDepthUs, Clock systemClock) {
            this.minStartTimeUs = minStartTimeUs;
            this.maxEndTimeUs = maxEndTimeUs;
            this.elapsedRealtimeAtStartUs = elapsedRealtimeAtStartUs;
            this.bufferDepthUs = bufferDepthUs;
            this.systemClock = systemClock;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public long[] getCurrentBoundsMs(long[] out) {
            out = this.getCurrentBoundsUs(out);
            out[0] = out[0] / 1000L;
            out[1] = out[1] / 1000L;
            return out;
        }

        @Override
        public long[] getCurrentBoundsUs(long[] out) {
            if (out == null || out.length < 2) {
                out = new long[2];
            }
            long currentEndTimeUs = Math.min(this.maxEndTimeUs, this.systemClock.elapsedRealtime() * 1000L - this.elapsedRealtimeAtStartUs);
            long currentStartTimeUs = this.minStartTimeUs;
            if (this.bufferDepthUs != -1L) {
                currentStartTimeUs = Math.max(currentStartTimeUs, currentEndTimeUs - this.bufferDepthUs);
            }
            out[0] = currentStartTimeUs;
            out[1] = currentEndTimeUs;
            return out;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (int)this.minStartTimeUs;
            result = 31 * result + (int)this.maxEndTimeUs;
            result = 31 * result + (int)this.elapsedRealtimeAtStartUs;
            result = 31 * result + (int)this.bufferDepthUs;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DynamicTimeRange other = (DynamicTimeRange)obj;
            return other.minStartTimeUs == this.minStartTimeUs && other.maxEndTimeUs == this.maxEndTimeUs && other.elapsedRealtimeAtStartUs == this.elapsedRealtimeAtStartUs && other.bufferDepthUs == this.bufferDepthUs;
        }
    }

    public static final class StaticTimeRange
    implements TimeRange {
        private final long startTimeUs;
        private final long endTimeUs;

        public StaticTimeRange(long startTimeUs, long endTimeUs) {
            this.startTimeUs = startTimeUs;
            this.endTimeUs = endTimeUs;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public long[] getCurrentBoundsMs(long[] out) {
            out = this.getCurrentBoundsUs(out);
            out[0] = out[0] / 1000L;
            out[1] = out[1] / 1000L;
            return out;
        }

        @Override
        public long[] getCurrentBoundsUs(long[] out) {
            if (out == null || out.length < 2) {
                out = new long[]{this.startTimeUs, this.endTimeUs};
            }
            return out;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (int)this.startTimeUs;
            result = 31 * result + (int)this.endTimeUs;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StaticTimeRange other = (StaticTimeRange)obj;
            return other.startTimeUs == this.startTimeUs && other.endTimeUs == this.endTimeUs;
        }
    }
}

