/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.audio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;

public final class AudioCapabilitiesReceiver {
    private final Context context;
    private final Listener listener;
    private final BroadcastReceiver receiver;
    AudioCapabilities audioCapabilities;

    public AudioCapabilitiesReceiver(Context context, Listener listener) {
        this.context = Assertions.checkNotNull(context);
        this.listener = Assertions.checkNotNull(listener);
        this.receiver = Util.SDK_INT >= 21 ? new HdmiAudioPlugBroadcastReceiver() : null;
    }

    public AudioCapabilities register() {
        Intent stickyIntent = this.receiver == null ? null : this.context.registerReceiver(this.receiver, new IntentFilter("android.media.action.HDMI_AUDIO_PLUG"));
        this.audioCapabilities = AudioCapabilities.getCapabilities(stickyIntent);
        return this.audioCapabilities;
    }

    public void unregister() {
        if (this.receiver != null) {
            this.context.unregisterReceiver(this.receiver);
        }
    }

    private final class HdmiAudioPlugBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiAudioPlugBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            AudioCapabilities newAudioCapabilities;
            if (!this.isInitialStickyBroadcast() && !(newAudioCapabilities = AudioCapabilities.getCapabilities(intent)).equals(AudioCapabilitiesReceiver.this.audioCapabilities)) {
                AudioCapabilitiesReceiver.this.audioCapabilities = newAudioCapabilities;
                AudioCapabilitiesReceiver.this.listener.onAudioCapabilitiesChanged(newAudioCapabilities);
            }
        }
    }

    public static interface Listener {
        public void onAudioCapabilitiesChanged(AudioCapabilities var1);
    }
}

