/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.audio;

import android.annotation.TargetApi;
import android.media.AudioTimestamp;
import android.media.PlaybackParams;
import android.os.ConditionVariable;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.exoplayer.C;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.util.Ac3Util;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.DtsUtil;
import com.google.android.exoplayer.util.Util;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public final class AudioTrack {
    public static final int RESULT_POSITION_DISCONTINUITY = 1;
    public static final int RESULT_BUFFER_CONSUMED = 2;
    public static final int SESSION_ID_NOT_SET = 0;
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;
    private static final long MIN_BUFFER_DURATION_US = 250000L;
    private static final long MAX_BUFFER_DURATION_US = 750000L;
    private static final long PASSTHROUGH_BUFFER_DURATION_US = 250000L;
    private static final int BUFFER_MULTIPLICATION_FACTOR = 4;
    private static final String TAG = "AudioTrack";
    private static final long MAX_AUDIO_TIMESTAMP_OFFSET_US = 5000000L;
    private static final long MAX_LATENCY_US = 5000000L;
    private static final int START_NOT_SET = 0;
    private static final int START_IN_SYNC = 1;
    private static final int START_NEED_SYNC = 2;
    private static final int MAX_PLAYHEAD_OFFSET_COUNT = 10;
    private static final int MIN_PLAYHEAD_OFFSET_SAMPLE_INTERVAL_US = 30000;
    private static final int MIN_TIMESTAMP_SAMPLE_INTERVAL_US = 500000;
    public static boolean enablePreV21AudioSessionWorkaround = false;
    public static boolean failOnSpuriousAudioTimestamp = false;
    private final AudioCapabilities audioCapabilities;
    private final int streamType;
    private final ConditionVariable releasingConditionVariable;
    private final long[] playheadOffsets;
    private final AudioTrackUtil audioTrackUtil;
    private android.media.AudioTrack keepSessionIdAudioTrack;
    private android.media.AudioTrack audioTrack;
    private int sampleRate;
    private int channelConfig;
    private int sourceEncoding;
    private int targetEncoding;
    private boolean passthrough;
    private int pcmFrameSize;
    private int bufferSize;
    private long bufferSizeUs;
    private int nextPlayheadOffsetIndex;
    private int playheadOffsetCount;
    private long smoothedPlayheadOffsetUs;
    private long lastPlayheadSampleTimeUs;
    private boolean audioTimestampSet;
    private long lastTimestampSampleTimeUs;
    private Method getLatencyMethod;
    private long submittedPcmBytes;
    private long submittedEncodedFrames;
    private int framesPerEncodedSample;
    private int startMediaTimeState;
    private long startMediaTimeUs;
    private long resumeSystemTimeUs;
    private long latencyUs;
    private float volume;
    private byte[] temporaryBuffer;
    private int temporaryBufferOffset;
    private int bufferBytesRemaining;
    private ByteBuffer resampledBuffer;
    private boolean useResampledBuffer;

    public AudioTrack() {
        this(null, 3);
    }

    public AudioTrack(AudioCapabilities audioCapabilities, int streamType) {
        this.audioCapabilities = audioCapabilities;
        this.streamType = streamType;
        this.releasingConditionVariable = new ConditionVariable(true);
        if (Util.SDK_INT >= 18) {
            try {
                this.getLatencyMethod = android.media.AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.audioTrackUtil = Util.SDK_INT >= 23 ? new AudioTrackUtilV23() : (Util.SDK_INT >= 19 ? new AudioTrackUtilV19() : new AudioTrackUtil());
        this.playheadOffsets = new long[10];
        this.volume = 1.0f;
        this.startMediaTimeState = 0;
    }

    public boolean isPassthroughSupported(String mimeType) {
        return this.audioCapabilities != null && this.audioCapabilities.supportsEncoding(AudioTrack.getEncodingForMimeType(mimeType));
    }

    public boolean isInitialized() {
        return this.audioTrack != null;
    }

    public long getCurrentPositionUs(boolean sourceEnded) {
        long currentPositionUs;
        if (!this.hasCurrentPositionUs()) {
            return Long.MIN_VALUE;
        }
        if (this.audioTrack.getPlayState() == 3) {
            this.maybeSampleSyncParams();
        }
        long systemClockUs = System.nanoTime() / 1000L;
        if (this.audioTimestampSet) {
            long presentationDiff = systemClockUs - this.audioTrackUtil.getTimestampNanoTime() / 1000L;
            long actualSpeedPresentationDiff = (long)((float)presentationDiff * this.audioTrackUtil.getPlaybackSpeed());
            long framesDiff = this.durationUsToFrames(actualSpeedPresentationDiff);
            long currentFramePosition = this.audioTrackUtil.getTimestampFramePosition() + framesDiff;
            currentPositionUs = this.framesToDurationUs(currentFramePosition) + this.startMediaTimeUs;
        } else {
            currentPositionUs = this.playheadOffsetCount == 0 ? this.audioTrackUtil.getPlaybackHeadPositionUs() + this.startMediaTimeUs : systemClockUs + this.smoothedPlayheadOffsetUs + this.startMediaTimeUs;
            if (!sourceEnded) {
                currentPositionUs -= this.latencyUs;
            }
        }
        return currentPositionUs;
    }

    public void configure(String mimeType, int channelCount, int sampleRate, int pcmEncoding) {
        this.configure(mimeType, channelCount, sampleRate, pcmEncoding, 0);
    }

    public void configure(String mimeType, int channelCount, int sampleRate, int pcmEncoding, int specifiedBufferSize) {
        int sourceEncoding;
        boolean passthrough;
        int channelConfig;
        switch (channelCount) {
            case 1: {
                channelConfig = 4;
                break;
            }
            case 2: {
                channelConfig = 12;
                break;
            }
            case 3: {
                channelConfig = 28;
                break;
            }
            case 4: {
                channelConfig = 204;
                break;
            }
            case 5: {
                channelConfig = 220;
                break;
            }
            case 6: {
                channelConfig = 252;
                break;
            }
            case 7: {
                channelConfig = 1276;
                break;
            }
            case 8: {
                channelConfig = C.CHANNEL_OUT_7POINT1_SURROUND;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel count: " + channelCount);
            }
        }
        boolean bl = passthrough = !"audio/raw".equals(mimeType);
        if (passthrough) {
            sourceEncoding = AudioTrack.getEncodingForMimeType(mimeType);
        } else if (pcmEncoding == 3 || pcmEncoding == 2 || pcmEncoding == Integer.MIN_VALUE || pcmEncoding == 0x40000000) {
            sourceEncoding = pcmEncoding;
        } else {
            throw new IllegalArgumentException("Unsupported PCM encoding: " + pcmEncoding);
        }
        if (this.isInitialized() && this.sourceEncoding == sourceEncoding && this.sampleRate == sampleRate && this.channelConfig == channelConfig) {
            return;
        }
        this.reset();
        this.sourceEncoding = sourceEncoding;
        this.passthrough = passthrough;
        this.sampleRate = sampleRate;
        this.channelConfig = channelConfig;
        this.targetEncoding = passthrough ? sourceEncoding : 2;
        this.pcmFrameSize = 2 * channelCount;
        if (specifiedBufferSize != 0) {
            this.bufferSize = specifiedBufferSize;
        } else if (passthrough) {
            this.bufferSize = this.targetEncoding == 5 || this.targetEncoding == 6 ? 20480 : 49152;
        } else {
            int minBufferSize = android.media.AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)this.targetEncoding);
            Assertions.checkState(minBufferSize != -2);
            int multipliedBufferSize = minBufferSize * 4;
            int minAppBufferSize = (int)this.durationUsToFrames(250000L) * this.pcmFrameSize;
            int maxAppBufferSize = (int)Math.max((long)minBufferSize, this.durationUsToFrames(750000L) * (long)this.pcmFrameSize);
            this.bufferSize = multipliedBufferSize < minAppBufferSize ? minAppBufferSize : (multipliedBufferSize > maxAppBufferSize ? maxAppBufferSize : multipliedBufferSize);
        }
        this.bufferSizeUs = passthrough ? -1L : this.framesToDurationUs(this.pcmBytesToFrames(this.bufferSize));
    }

    public int initialize() throws InitializationException {
        return this.initialize(0);
    }

    public int initialize(int sessionId) throws InitializationException {
        this.releasingConditionVariable.block();
        this.audioTrack = sessionId == 0 ? new android.media.AudioTrack(this.streamType, this.sampleRate, this.channelConfig, this.targetEncoding, this.bufferSize, 1) : new android.media.AudioTrack(this.streamType, this.sampleRate, this.channelConfig, this.targetEncoding, this.bufferSize, 1, sessionId);
        this.checkAudioTrackInitialized();
        sessionId = this.audioTrack.getAudioSessionId();
        if (enablePreV21AudioSessionWorkaround && Util.SDK_INT < 21) {
            if (this.keepSessionIdAudioTrack != null && sessionId != this.keepSessionIdAudioTrack.getAudioSessionId()) {
                this.releaseKeepSessionIdAudioTrack();
            }
            if (this.keepSessionIdAudioTrack == null) {
                int sampleRate = 4000;
                int channelConfig = 4;
                int encoding = 2;
                int bufferSize = 2;
                this.keepSessionIdAudioTrack = new android.media.AudioTrack(this.streamType, sampleRate, channelConfig, encoding, bufferSize, 0, sessionId);
            }
        }
        this.audioTrackUtil.reconfigure(this.audioTrack, this.needsPassthroughWorkarounds());
        this.setAudioTrackVolume();
        return sessionId;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getBufferSizeUs() {
        return this.bufferSizeUs;
    }

    public void play() {
        if (this.isInitialized()) {
            this.resumeSystemTimeUs = System.nanoTime() / 1000L;
            this.audioTrack.play();
        }
    }

    public void handleDiscontinuity() {
        if (this.startMediaTimeState == 1) {
            this.startMediaTimeState = 2;
        }
    }

    public int handleBuffer(ByteBuffer buffer, int offset, int size, long presentationTimeUs) throws WriteException {
        if (this.needsPassthroughWorkarounds()) {
            if (this.audioTrack.getPlayState() == 2) {
                return 0;
            }
            if (this.audioTrack.getPlayState() == 1 && this.audioTrackUtil.getPlaybackHeadPosition() != 0L) {
                return 0;
            }
        }
        int result = 0;
        if (this.bufferBytesRemaining == 0) {
            if (size == 0) {
                return 2;
            }
            boolean bl = this.useResampledBuffer = this.targetEncoding != this.sourceEncoding;
            if (this.useResampledBuffer) {
                Assertions.checkState(this.targetEncoding == 2);
                buffer = this.resampledBuffer = AudioTrack.resampleTo16BitPcm(buffer, offset, size, this.sourceEncoding, this.resampledBuffer);
                offset = this.resampledBuffer.position();
                size = this.resampledBuffer.limit();
            }
            this.bufferBytesRemaining = size;
            buffer.position(offset);
            if (this.passthrough && this.framesPerEncodedSample == 0) {
                this.framesPerEncodedSample = AudioTrack.getFramesPerEncodedSample(this.targetEncoding, buffer);
            }
            if (this.startMediaTimeState == 0) {
                this.startMediaTimeUs = Math.max(0L, presentationTimeUs);
                this.startMediaTimeState = 1;
            } else {
                long expectedBufferStartTime = this.startMediaTimeUs + this.framesToDurationUs(this.getSubmittedFrames());
                if (this.startMediaTimeState == 1 && Math.abs(expectedBufferStartTime - presentationTimeUs) > 200000L) {
                    Log.e((String)TAG, (String)("Discontinuity detected [expected " + expectedBufferStartTime + ", got " + presentationTimeUs + "]"));
                    this.startMediaTimeState = 2;
                }
                if (this.startMediaTimeState == 2) {
                    this.startMediaTimeUs += presentationTimeUs - expectedBufferStartTime;
                    this.startMediaTimeState = 1;
                    result |= 1;
                }
            }
            if (Util.SDK_INT < 21) {
                if (this.temporaryBuffer == null || this.temporaryBuffer.length < size) {
                    this.temporaryBuffer = new byte[size];
                }
                buffer.get(this.temporaryBuffer, 0, size);
                this.temporaryBufferOffset = 0;
            }
        }
        int bytesWritten = 0;
        if (Util.SDK_INT < 21) {
            int bytesPending = (int)(this.submittedPcmBytes - this.audioTrackUtil.getPlaybackHeadPosition() * (long)this.pcmFrameSize);
            int bytesToWrite = this.bufferSize - bytesPending;
            if (bytesToWrite > 0 && (bytesWritten = this.audioTrack.write(this.temporaryBuffer, this.temporaryBufferOffset, bytesToWrite = Math.min(this.bufferBytesRemaining, bytesToWrite))) >= 0) {
                this.temporaryBufferOffset += bytesWritten;
            }
        } else {
            ByteBuffer data = this.useResampledBuffer ? this.resampledBuffer : buffer;
            bytesWritten = AudioTrack.writeNonBlockingV21(this.audioTrack, data, this.bufferBytesRemaining);
        }
        if (bytesWritten < 0) {
            throw new WriteException(bytesWritten);
        }
        this.bufferBytesRemaining -= bytesWritten;
        if (!this.passthrough) {
            this.submittedPcmBytes += (long)bytesWritten;
        }
        if (this.bufferBytesRemaining == 0) {
            if (this.passthrough) {
                this.submittedEncodedFrames += (long)this.framesPerEncodedSample;
            }
            result |= 2;
        }
        return result;
    }

    public void handleEndOfStream() {
        if (this.isInitialized()) {
            this.audioTrackUtil.handleEndOfStream(this.getSubmittedFrames());
        }
    }

    public boolean hasPendingData() {
        return this.isInitialized() && (this.getSubmittedFrames() > this.audioTrackUtil.getPlaybackHeadPosition() || this.overrideHasPendingData());
    }

    public void setPlaybackParams(PlaybackParams playbackParams) {
        this.audioTrackUtil.setPlaybackParameters(playbackParams);
    }

    public void setVolume(float volume) {
        if (this.volume != volume) {
            this.volume = volume;
            this.setAudioTrackVolume();
        }
    }

    private void setAudioTrackVolume() {
        if (this.isInitialized()) {
            if (Util.SDK_INT >= 21) {
                AudioTrack.setAudioTrackVolumeV21(this.audioTrack, this.volume);
            } else {
                AudioTrack.setAudioTrackVolumeV3(this.audioTrack, this.volume);
            }
        }
    }

    public void pause() {
        if (this.isInitialized()) {
            this.resetSyncParams();
            this.audioTrackUtil.pause();
        }
    }

    public void reset() {
        if (this.isInitialized()) {
            this.submittedPcmBytes = 0L;
            this.submittedEncodedFrames = 0L;
            this.framesPerEncodedSample = 0;
            this.bufferBytesRemaining = 0;
            this.startMediaTimeState = 0;
            this.latencyUs = 0L;
            this.resetSyncParams();
            int playState = this.audioTrack.getPlayState();
            if (playState == 3) {
                this.audioTrack.pause();
            }
            final android.media.AudioTrack toRelease = this.audioTrack;
            this.audioTrack = null;
            this.audioTrackUtil.reconfigure(null, false);
            this.releasingConditionVariable.close();
            new Thread(){

                @Override
                public void run() {
                    try {
                        toRelease.flush();
                        toRelease.release();
                    }
                    finally {
                        AudioTrack.this.releasingConditionVariable.open();
                    }
                }
            }.start();
        }
    }

    public void release() {
        this.reset();
        this.releaseKeepSessionIdAudioTrack();
    }

    private void releaseKeepSessionIdAudioTrack() {
        if (this.keepSessionIdAudioTrack == null) {
            return;
        }
        final android.media.AudioTrack toRelease = this.keepSessionIdAudioTrack;
        this.keepSessionIdAudioTrack = null;
        new Thread(){

            @Override
            public void run() {
                toRelease.release();
            }
        }.start();
    }

    private boolean hasCurrentPositionUs() {
        return this.isInitialized() && this.startMediaTimeState != 0;
    }

    private void maybeSampleSyncParams() {
        long playbackPositionUs = this.audioTrackUtil.getPlaybackHeadPositionUs();
        if (playbackPositionUs == 0L) {
            return;
        }
        long systemClockUs = System.nanoTime() / 1000L;
        if (systemClockUs - this.lastPlayheadSampleTimeUs >= 30000L) {
            this.playheadOffsets[this.nextPlayheadOffsetIndex] = playbackPositionUs - systemClockUs;
            this.nextPlayheadOffsetIndex = (this.nextPlayheadOffsetIndex + 1) % 10;
            if (this.playheadOffsetCount < 10) {
                ++this.playheadOffsetCount;
            }
            this.lastPlayheadSampleTimeUs = systemClockUs;
            this.smoothedPlayheadOffsetUs = 0L;
            for (int i = 0; i < this.playheadOffsetCount; ++i) {
                this.smoothedPlayheadOffsetUs += this.playheadOffsets[i] / (long)this.playheadOffsetCount;
            }
        }
        if (this.needsPassthroughWorkarounds()) {
            return;
        }
        if (systemClockUs - this.lastTimestampSampleTimeUs >= 500000L) {
            this.audioTimestampSet = this.audioTrackUtil.updateTimestamp();
            if (this.audioTimestampSet) {
                long audioTimestampUs = this.audioTrackUtil.getTimestampNanoTime() / 1000L;
                long audioTimestampFramePosition = this.audioTrackUtil.getTimestampFramePosition();
                if (audioTimestampUs < this.resumeSystemTimeUs) {
                    this.audioTimestampSet = false;
                } else if (Math.abs(audioTimestampUs - systemClockUs) > 5000000L) {
                    String message = "Spurious audio timestamp (system clock mismatch): " + audioTimestampFramePosition + ", " + audioTimestampUs + ", " + systemClockUs + ", " + playbackPositionUs;
                    if (failOnSpuriousAudioTimestamp) {
                        throw new InvalidAudioTrackTimestampException(message);
                    }
                    Log.w((String)TAG, (String)message);
                    this.audioTimestampSet = false;
                } else if (Math.abs(this.framesToDurationUs(audioTimestampFramePosition) - playbackPositionUs) > 5000000L) {
                    String message = "Spurious audio timestamp (frame position mismatch): " + audioTimestampFramePosition + ", " + audioTimestampUs + ", " + systemClockUs + ", " + playbackPositionUs;
                    if (failOnSpuriousAudioTimestamp) {
                        throw new InvalidAudioTrackTimestampException(message);
                    }
                    Log.w((String)TAG, (String)message);
                    this.audioTimestampSet = false;
                }
            }
            if (this.getLatencyMethod != null && !this.passthrough) {
                try {
                    this.latencyUs = (long)((Integer)this.getLatencyMethod.invoke((Object)this.audioTrack, (Object[])null)).intValue() * 1000L - this.bufferSizeUs;
                    this.latencyUs = Math.max(this.latencyUs, 0L);
                    if (this.latencyUs > 5000000L) {
                        Log.w((String)TAG, (String)("Ignoring impossibly large audio latency: " + this.latencyUs));
                        this.latencyUs = 0L;
                    }
                }
                catch (Exception e) {
                    this.getLatencyMethod = null;
                }
            }
            this.lastTimestampSampleTimeUs = systemClockUs;
        }
    }

    private void checkAudioTrackInitialized() throws InitializationException {
        int state = this.audioTrack.getState();
        if (state == 1) {
            return;
        }
        try {
            this.audioTrack.release();
        }
        catch (Exception exception) {
        }
        finally {
            this.audioTrack = null;
        }
        throw new InitializationException(state, this.sampleRate, this.channelConfig, this.bufferSize);
    }

    private long pcmBytesToFrames(long byteCount) {
        return byteCount / (long)this.pcmFrameSize;
    }

    private long framesToDurationUs(long frameCount) {
        return frameCount * 1000000L / (long)this.sampleRate;
    }

    private long durationUsToFrames(long durationUs) {
        return durationUs * (long)this.sampleRate / 1000000L;
    }

    private long getSubmittedFrames() {
        return this.passthrough ? this.submittedEncodedFrames : this.pcmBytesToFrames(this.submittedPcmBytes);
    }

    private void resetSyncParams() {
        this.smoothedPlayheadOffsetUs = 0L;
        this.playheadOffsetCount = 0;
        this.nextPlayheadOffsetIndex = 0;
        this.lastPlayheadSampleTimeUs = 0L;
        this.audioTimestampSet = false;
        this.lastTimestampSampleTimeUs = 0L;
    }

    private boolean needsPassthroughWorkarounds() {
        return Util.SDK_INT < 23 && (this.targetEncoding == 5 || this.targetEncoding == 6);
    }

    private boolean overrideHasPendingData() {
        return this.needsPassthroughWorkarounds() && this.audioTrack.getPlayState() == 2 && this.audioTrack.getPlaybackHeadPosition() == 0;
    }

    private static ByteBuffer resampleTo16BitPcm(ByteBuffer buffer, int offset, int size, int sourceEncoding, ByteBuffer out) {
        int resampledSize;
        switch (sourceEncoding) {
            case 3: {
                resampledSize = size * 2;
                break;
            }
            case -2147483648: {
                resampledSize = size / 3 * 2;
                break;
            }
            case 0x40000000: {
                resampledSize = size / 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ByteBuffer resampledBuffer = out;
        if (resampledBuffer == null || resampledBuffer.capacity() < resampledSize) {
            resampledBuffer = ByteBuffer.allocateDirect(resampledSize);
        }
        resampledBuffer.position(0);
        resampledBuffer.limit(resampledSize);
        int limit = offset + size;
        switch (sourceEncoding) {
            case 3: {
                for (int i = offset; i < limit; ++i) {
                    resampledBuffer.put((byte)0);
                    resampledBuffer.put((byte)((buffer.get(i) & 0xFF) - 128));
                }
                break;
            }
            case -2147483648: {
                for (int i = offset; i < limit; i += 3) {
                    resampledBuffer.put(buffer.get(i + 1));
                    resampledBuffer.put(buffer.get(i + 2));
                }
                break;
            }
            case 0x40000000: {
                for (int i = offset; i < limit; i += 4) {
                    resampledBuffer.put(buffer.get(i + 2));
                    resampledBuffer.put(buffer.get(i + 3));
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        resampledBuffer.position(0);
        return resampledBuffer;
    }

    private static int getEncodingForMimeType(String mimeType) {
        switch (mimeType) {
            case "audio/ac3": {
                return 5;
            }
            case "audio/eac3": {
                return 6;
            }
            case "audio/vnd.dts": {
                return 7;
            }
            case "audio/vnd.dts.hd": {
                return 8;
            }
        }
        return 0;
    }

    private static int getFramesPerEncodedSample(int encoding, ByteBuffer buffer) {
        if (encoding == 7 || encoding == 8) {
            return DtsUtil.parseDtsAudioSampleCount(buffer);
        }
        if (encoding == 5) {
            return Ac3Util.getAc3SyncframeAudioSampleCount();
        }
        if (encoding == 6) {
            return Ac3Util.parseEAc3SyncframeAudioSampleCount(buffer);
        }
        throw new IllegalStateException("Unexpected audio encoding: " + encoding);
    }

    @TargetApi(value=21)
    private static int writeNonBlockingV21(android.media.AudioTrack audioTrack, ByteBuffer buffer, int size) {
        return audioTrack.write(buffer, size, 1);
    }

    @TargetApi(value=21)
    private static void setAudioTrackVolumeV21(android.media.AudioTrack audioTrack, float volume) {
        audioTrack.setVolume(volume);
    }

    private static void setAudioTrackVolumeV3(android.media.AudioTrack audioTrack, float volume) {
        audioTrack.setStereoVolume(volume, volume);
    }

    @TargetApi(value=23)
    private static class AudioTrackUtilV23
    extends AudioTrackUtilV19 {
        private PlaybackParams playbackParams;
        private float playbackSpeed = 1.0f;

        @Override
        public void reconfigure(android.media.AudioTrack audioTrack, boolean needsPassthroughWorkaround) {
            super.reconfigure(audioTrack, needsPassthroughWorkaround);
            this.maybeApplyPlaybackParams();
        }

        @Override
        public void setPlaybackParameters(PlaybackParams playbackParams) {
            this.playbackParams = playbackParams = (playbackParams != null ? playbackParams : new PlaybackParams()).allowDefaults();
            this.playbackSpeed = playbackParams.getSpeed();
            this.maybeApplyPlaybackParams();
        }

        @Override
        public float getPlaybackSpeed() {
            return this.playbackSpeed;
        }

        private void maybeApplyPlaybackParams() {
            if (this.audioTrack != null && this.playbackParams != null) {
                this.audioTrack.setPlaybackParams(this.playbackParams);
            }
        }
    }

    @TargetApi(value=19)
    private static class AudioTrackUtilV19
    extends AudioTrackUtil {
        private final AudioTimestamp audioTimestamp = new AudioTimestamp();
        private long rawTimestampFramePositionWrapCount;
        private long lastRawTimestampFramePosition;
        private long lastTimestampFramePosition;

        @Override
        public void reconfigure(android.media.AudioTrack audioTrack, boolean needsPassthroughWorkaround) {
            super.reconfigure(audioTrack, needsPassthroughWorkaround);
            this.rawTimestampFramePositionWrapCount = 0L;
            this.lastRawTimestampFramePosition = 0L;
            this.lastTimestampFramePosition = 0L;
        }

        @Override
        public boolean updateTimestamp() {
            boolean updated = this.audioTrack.getTimestamp(this.audioTimestamp);
            if (updated) {
                long rawFramePosition = this.audioTimestamp.framePosition;
                if (this.lastRawTimestampFramePosition > rawFramePosition) {
                    ++this.rawTimestampFramePositionWrapCount;
                }
                this.lastRawTimestampFramePosition = rawFramePosition;
                this.lastTimestampFramePosition = rawFramePosition + (this.rawTimestampFramePositionWrapCount << 32);
            }
            return updated;
        }

        @Override
        public long getTimestampNanoTime() {
            return this.audioTimestamp.nanoTime;
        }

        @Override
        public long getTimestampFramePosition() {
            return this.lastTimestampFramePosition;
        }
    }

    private static class AudioTrackUtil {
        protected android.media.AudioTrack audioTrack;
        private boolean needsPassthroughWorkaround;
        private int sampleRate;
        private long lastRawPlaybackHeadPosition;
        private long rawPlaybackHeadWrapCount;
        private long passthroughWorkaroundPauseOffset;
        private long stopTimestampUs;
        private long stopPlaybackHeadPosition;
        private long endPlaybackHeadPosition;

        private AudioTrackUtil() {
        }

        public void reconfigure(android.media.AudioTrack audioTrack, boolean needsPassthroughWorkaround) {
            this.audioTrack = audioTrack;
            this.needsPassthroughWorkaround = needsPassthroughWorkaround;
            this.stopTimestampUs = -1L;
            this.lastRawPlaybackHeadPosition = 0L;
            this.rawPlaybackHeadWrapCount = 0L;
            this.passthroughWorkaroundPauseOffset = 0L;
            if (audioTrack != null) {
                this.sampleRate = audioTrack.getSampleRate();
            }
        }

        public void handleEndOfStream(long submittedFrames) {
            this.stopPlaybackHeadPosition = this.getPlaybackHeadPosition();
            this.stopTimestampUs = SystemClock.elapsedRealtime() * 1000L;
            this.endPlaybackHeadPosition = submittedFrames;
            this.audioTrack.stop();
        }

        public void pause() {
            if (this.stopTimestampUs != -1L) {
                return;
            }
            this.audioTrack.pause();
        }

        public long getPlaybackHeadPosition() {
            if (this.stopTimestampUs != -1L) {
                long elapsedTimeSinceStopUs = SystemClock.elapsedRealtime() * 1000L - this.stopTimestampUs;
                long framesSinceStop = elapsedTimeSinceStopUs * (long)this.sampleRate / 1000000L;
                return Math.min(this.endPlaybackHeadPosition, this.stopPlaybackHeadPosition + framesSinceStop);
            }
            int state = this.audioTrack.getPlayState();
            if (state == 1) {
                return 0L;
            }
            long rawPlaybackHeadPosition = 0xFFFFFFFFL & (long)this.audioTrack.getPlaybackHeadPosition();
            if (this.needsPassthroughWorkaround) {
                if (state == 2 && rawPlaybackHeadPosition == 0L) {
                    this.passthroughWorkaroundPauseOffset = this.lastRawPlaybackHeadPosition;
                }
                rawPlaybackHeadPosition += this.passthroughWorkaroundPauseOffset;
            }
            if (this.lastRawPlaybackHeadPosition > rawPlaybackHeadPosition) {
                ++this.rawPlaybackHeadWrapCount;
            }
            this.lastRawPlaybackHeadPosition = rawPlaybackHeadPosition;
            return rawPlaybackHeadPosition + (this.rawPlaybackHeadWrapCount << 32);
        }

        public long getPlaybackHeadPositionUs() {
            return this.getPlaybackHeadPosition() * 1000000L / (long)this.sampleRate;
        }

        public boolean updateTimestamp() {
            return false;
        }

        public long getTimestampNanoTime() {
            throw new UnsupportedOperationException();
        }

        public long getTimestampFramePosition() {
            throw new UnsupportedOperationException();
        }

        public void setPlaybackParameters(PlaybackParams playbackParams) {
            throw new UnsupportedOperationException();
        }

        public float getPlaybackSpeed() {
            return 1.0f;
        }
    }

    public static final class InvalidAudioTrackTimestampException
    extends RuntimeException {
        public InvalidAudioTrackTimestampException(String message) {
            super(message);
        }
    }

    public static final class WriteException
    extends Exception {
        public final int errorCode;

        public WriteException(int errorCode) {
            super("AudioTrack write failed: " + errorCode);
            this.errorCode = errorCode;
        }
    }

    public static final class InitializationException
    extends Exception {
        public final int audioTrackState;

        public InitializationException(int audioTrackState, int sampleRate, int channelConfig, int bufferSize) {
            super("AudioTrack init failed: " + audioTrackState + ", Config(" + sampleRate + ", " + channelConfig + ", " + bufferSize + ")");
            this.audioTrackState = audioTrackState;
        }
    }
}

