/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

public class ChunkExtractorWrapper
implements ExtractorOutput,
TrackOutput {
    private final Extractor extractor;
    private boolean extractorInitialized;
    private SingleTrackOutput output;
    private boolean seenTrack;
    private int seenTrackId;

    public ChunkExtractorWrapper(Extractor extractor) {
        this.extractor = extractor;
    }

    public void init(SingleTrackOutput output) {
        this.output = output;
        if (!this.extractorInitialized) {
            this.extractor.init(this);
            this.extractorInitialized = true;
        } else {
            this.extractor.seek();
        }
    }

    public int read(ExtractorInput input) throws IOException, InterruptedException {
        int result = this.extractor.read(input, null);
        Assertions.checkState(result != 1);
        return result;
    }

    @Override
    public TrackOutput track(int id) {
        Assertions.checkState(!this.seenTrack || id == this.seenTrackId);
        this.seenTrack = true;
        this.seenTrackId = id;
        return this;
    }

    @Override
    public void endTracks() {
        Assertions.checkState(this.seenTrack);
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.output.seekMap(seekMap);
    }

    @Override
    public void drmInitData(DrmInitData drmInitData) {
        this.output.drmInitData(drmInitData);
    }

    @Override
    public void format(MediaFormat format) {
        this.output.format(format);
    }

    @Override
    public int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        return this.output.sampleData(input, length, allowEndOfInput);
    }

    @Override
    public void sampleData(ParsableByteArray data, int length) {
        this.output.sampleData(data, length);
    }

    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
        this.output.sampleMetadata(timeUs, flags, size, offset, encryptionKey);
    }

    public static interface SingleTrackOutput
    extends TrackOutput {
        public void seekMap(SeekMap var1);

        public void drmInitData(DrmInitData var1);
    }
}

