/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.chunk.BaseChunkSampleSourceEventListener;
import com.google.android.exoplayer.chunk.BaseMediaChunk;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultTrackOutput;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ChunkSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    protected final DefaultTrackOutput sampleQueue;
    private static final int STATE_IDLE = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_ENABLED = 3;
    private static final long NO_RESET_PENDING = Long.MIN_VALUE;
    private final int eventSourceId;
    private final LoadControl loadControl;
    private final ChunkSource chunkSource;
    private final ChunkOperationHolder currentLoadableHolder;
    private final LinkedList<BaseMediaChunk> mediaChunks;
    private final List<BaseMediaChunk> readOnlyMediaChunks;
    private final int bufferSizeContribution;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final int minLoadableRetryCount;
    private int state;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private long lastPerformedBufferOperation;
    private boolean pendingDiscontinuity;
    private Loader loader;
    private boolean loadingFinished;
    private IOException currentLoadableException;
    private int enabledTrackCount;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private long currentLoadStartTimeMs;
    private DrmInitData downstreamDrmInitData;
    private MediaFormat downstreamMediaFormat;
    private Format downstreamFormat;

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution) {
        this(chunkSource, loadControl, bufferSizeContribution, null, null, 0);
    }

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution, Handler eventHandler, EventListener eventListener, int eventSourceId) {
        this(chunkSource, loadControl, bufferSizeContribution, eventHandler, eventListener, eventSourceId, 3);
    }

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution, Handler eventHandler, EventListener eventListener, int eventSourceId, int minLoadableRetryCount) {
        this.chunkSource = chunkSource;
        this.loadControl = loadControl;
        this.bufferSizeContribution = bufferSizeContribution;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.eventSourceId = eventSourceId;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.currentLoadableHolder = new ChunkOperationHolder();
        this.mediaChunks = new LinkedList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        this.sampleQueue = new DefaultTrackOutput(loadControl.getAllocator());
        this.state = 0;
        this.pendingResetPositionUs = Long.MIN_VALUE;
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        Assertions.checkState(this.state == 0);
        this.state = 1;
        return this;
    }

    @Override
    public boolean prepare(long positionUs) {
        Assertions.checkState(this.state == 1 || this.state == 2);
        if (this.state == 2) {
            return true;
        }
        if (!this.chunkSource.prepare()) {
            return false;
        }
        if (this.chunkSource.getTrackCount() > 0) {
            this.loader = new Loader("Loader:" + this.chunkSource.getFormat((int)0).mimeType);
        }
        this.state = 2;
        return true;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.state == 2 || this.state == 3);
        return this.chunkSource.getTrackCount();
    }

    @Override
    public MediaFormat getFormat(int track) {
        Assertions.checkState(this.state == 2 || this.state == 3);
        return this.chunkSource.getFormat(track);
    }

    @Override
    public void enable(int track, long positionUs) {
        Assertions.checkState(this.state == 2);
        Assertions.checkState(this.enabledTrackCount++ == 0);
        this.state = 3;
        this.chunkSource.enable(track);
        this.loadControl.register(this, this.bufferSizeContribution);
        this.downstreamFormat = null;
        this.downstreamMediaFormat = null;
        this.downstreamDrmInitData = null;
        this.downstreamPositionUs = positionUs;
        this.lastSeekPositionUs = positionUs;
        this.pendingDiscontinuity = false;
        this.restartFrom(positionUs);
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.state == 3);
        Assertions.checkState(--this.enabledTrackCount == 0);
        this.state = 2;
        try {
            this.chunkSource.disable(this.mediaChunks);
        }
        finally {
            this.loadControl.unregister(this);
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.sampleQueue.clear();
                this.mediaChunks.clear();
                this.clearCurrentLoadable();
                this.loadControl.trimAllocator();
            }
        }
    }

    @Override
    public boolean continueBuffering(int track, long positionUs) {
        Assertions.checkState(this.state == 3);
        this.downstreamPositionUs = positionUs;
        this.chunkSource.continueBuffering(positionUs);
        this.updateLoadControl();
        return this.loadingFinished || !this.sampleQueue.isEmpty();
    }

    @Override
    public long readDiscontinuity(int track) {
        if (this.pendingDiscontinuity) {
            this.pendingDiscontinuity = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int track, long positionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder) {
        Assertions.checkState(this.state == 3);
        this.downstreamPositionUs = positionUs;
        if (this.pendingDiscontinuity || this.isPendingReset()) {
            return -2;
        }
        boolean haveSamples = !this.sampleQueue.isEmpty();
        BaseMediaChunk currentChunk = this.mediaChunks.getFirst();
        while (haveSamples && this.mediaChunks.size() > 1 && this.mediaChunks.get(1).getFirstSampleIndex() <= this.sampleQueue.getReadIndex()) {
            this.mediaChunks.removeFirst();
            currentChunk = this.mediaChunks.getFirst();
        }
        Format format = currentChunk.format;
        if (!format.equals(this.downstreamFormat)) {
            this.notifyDownstreamFormatChanged(format, currentChunk.trigger, currentChunk.startTimeUs);
        }
        this.downstreamFormat = format;
        if (haveSamples || currentChunk.isMediaFormatFinal) {
            MediaFormat mediaFormat = currentChunk.getMediaFormat();
            DrmInitData drmInitData = currentChunk.getDrmInitData();
            if (!mediaFormat.equals(this.downstreamMediaFormat) || !Util.areEqual(this.downstreamDrmInitData, drmInitData)) {
                formatHolder.format = mediaFormat;
                formatHolder.drmInitData = drmInitData;
                this.downstreamMediaFormat = mediaFormat;
                this.downstreamDrmInitData = drmInitData;
                return -4;
            }
            this.downstreamMediaFormat = mediaFormat;
            this.downstreamDrmInitData = drmInitData;
        }
        if (!haveSamples) {
            if (this.loadingFinished) {
                return -1;
            }
            return -2;
        }
        if (this.sampleQueue.getSample(sampleHolder)) {
            boolean decodeOnly = sampleHolder.timeUs < this.lastSeekPositionUs;
            sampleHolder.flags = sampleHolder.flags | (decodeOnly ? 0x8000000 : 0);
            this.onSampleRead(currentChunk, sampleHolder);
            return -3;
        }
        return -2;
    }

    @Override
    public void seekToUs(long positionUs) {
        boolean seekInsideBuffer;
        Assertions.checkState(this.state == 3);
        long currentPositionUs = this.isPendingReset() ? this.pendingResetPositionUs : this.downstreamPositionUs;
        this.downstreamPositionUs = positionUs;
        this.lastSeekPositionUs = positionUs;
        if (currentPositionUs == positionUs) {
            return;
        }
        boolean bl = seekInsideBuffer = !this.isPendingReset() && this.sampleQueue.skipToKeyframeBefore(positionUs);
        if (seekInsideBuffer) {
            boolean haveSamples;
            boolean bl2 = haveSamples = !this.sampleQueue.isEmpty();
            while (haveSamples && this.mediaChunks.size() > 1 && this.mediaChunks.get(1).getFirstSampleIndex() <= this.sampleQueue.getReadIndex()) {
                this.mediaChunks.removeFirst();
            }
        } else {
            this.restartFrom(positionUs);
        }
        this.pendingDiscontinuity = true;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.currentLoadableException != null && this.currentLoadableExceptionCount > this.minLoadableRetryCount) {
            throw this.currentLoadableException;
        }
        if (this.currentLoadableHolder.chunk == null) {
            this.chunkSource.maybeThrowError();
        }
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.state == 3);
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        if (this.loadingFinished) {
            return -3L;
        }
        long largestParsedTimestampUs = this.sampleQueue.getLargestParsedTimestampUs();
        return largestParsedTimestampUs == Long.MIN_VALUE ? this.downstreamPositionUs : largestParsedTimestampUs;
    }

    @Override
    public void release() {
        Assertions.checkState(this.state != 3);
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
        this.state = 0;
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        long now = SystemClock.elapsedRealtime();
        long loadDurationMs = now - this.currentLoadStartTimeMs;
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        this.chunkSource.onChunkLoadCompleted(currentLoadable);
        if (this.isMediaChunk(currentLoadable)) {
            BaseMediaChunk mediaChunk = (BaseMediaChunk)currentLoadable;
            this.notifyLoadCompleted(currentLoadable.bytesLoaded(), mediaChunk.type, mediaChunk.trigger, mediaChunk.format, mediaChunk.startTimeUs, mediaChunk.endTimeUs, now, loadDurationMs);
        } else {
            this.notifyLoadCompleted(currentLoadable.bytesLoaded(), currentLoadable.type, currentLoadable.trigger, currentLoadable.format, -1L, -1L, now, loadDurationMs);
        }
        this.clearCurrentLoadable();
        this.updateLoadControl();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        this.notifyLoadCanceled(currentLoadable.bytesLoaded());
        this.clearCurrentLoadable();
        if (this.state == 3) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.sampleQueue.clear();
            this.mediaChunks.clear();
            this.clearCurrentLoadable();
            this.loadControl.trimAllocator();
        }
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException e) {
        this.currentLoadableException = e;
        ++this.currentLoadableExceptionCount;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyLoadError(e);
        this.chunkSource.onChunkLoadError(this.currentLoadableHolder.chunk, e);
        this.updateLoadControl();
    }

    protected void onSampleRead(MediaChunk mediaChunk, SampleHolder sampleHolder) {
    }

    private void restartFrom(long positionUs) {
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.sampleQueue.clear();
            this.mediaChunks.clear();
            this.clearCurrentLoadable();
            this.updateLoadControl();
        }
    }

    private void clearCurrentLoadable() {
        this.currentLoadableHolder.chunk = null;
        this.clearCurrentLoadableException();
    }

    private void clearCurrentLoadableException() {
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private void updateLoadControl() {
        boolean loadingOrBackedOff;
        long now = SystemClock.elapsedRealtime();
        long nextLoadPositionUs = this.getNextLoadPositionUs();
        boolean isBackedOff = this.currentLoadableException != null;
        boolean bl = loadingOrBackedOff = this.loader.isLoading() || isBackedOff;
        if (!loadingOrBackedOff && (this.currentLoadableHolder.chunk == null && nextLoadPositionUs != -1L || now - this.lastPerformedBufferOperation > 2000L)) {
            this.lastPerformedBufferOperation = now;
            this.doChunkOperation();
            boolean chunksDiscarded = this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            if (this.currentLoadableHolder.chunk == null) {
                nextLoadPositionUs = -1L;
            } else if (chunksDiscarded) {
                nextLoadPositionUs = this.getNextLoadPositionUs();
            }
        }
        boolean nextLoader = this.loadControl.update(this, this.downstreamPositionUs, nextLoadPositionUs, loadingOrBackedOff);
        if (isBackedOff) {
            long elapsedMillis = now - this.currentLoadableExceptionTimestamp;
            if (elapsedMillis >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.resumeFromBackOff();
            }
            return;
        }
        if (!this.loader.isLoading() && nextLoader) {
            this.maybeStartLoading();
        }
    }

    private long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? -1L : this.mediaChunks.getLast().endTimeUs;
    }

    private void resumeFromBackOff() {
        this.currentLoadableException = null;
        Chunk backedOffChunk = this.currentLoadableHolder.chunk;
        if (!this.isMediaChunk(backedOffChunk)) {
            this.doChunkOperation();
            this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            if (this.currentLoadableHolder.chunk == backedOffChunk) {
                this.loader.startLoading(backedOffChunk, this);
            } else {
                this.notifyLoadCanceled(backedOffChunk.bytesLoaded());
                this.maybeStartLoading();
            }
            return;
        }
        if (backedOffChunk == this.mediaChunks.getFirst()) {
            this.loader.startLoading(backedOffChunk, this);
            return;
        }
        BaseMediaChunk removedChunk = this.mediaChunks.removeLast();
        Assertions.checkState(backedOffChunk == removedChunk);
        this.doChunkOperation();
        this.mediaChunks.add(removedChunk);
        if (this.currentLoadableHolder.chunk == backedOffChunk) {
            this.loader.startLoading(backedOffChunk, this);
        } else {
            this.notifyLoadCanceled(backedOffChunk.bytesLoaded());
            this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            this.clearCurrentLoadableException();
            this.maybeStartLoading();
        }
    }

    private void maybeStartLoading() {
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        if (currentLoadable == null) {
            return;
        }
        this.currentLoadStartTimeMs = SystemClock.elapsedRealtime();
        if (this.isMediaChunk(currentLoadable)) {
            BaseMediaChunk mediaChunk = (BaseMediaChunk)currentLoadable;
            mediaChunk.init(this.sampleQueue);
            this.mediaChunks.add(mediaChunk);
            if (this.isPendingReset()) {
                this.pendingResetPositionUs = Long.MIN_VALUE;
            }
            this.notifyLoadStarted(mediaChunk.dataSpec.length, mediaChunk.type, mediaChunk.trigger, mediaChunk.format, mediaChunk.startTimeUs, mediaChunk.endTimeUs);
        } else {
            this.notifyLoadStarted(currentLoadable.dataSpec.length, currentLoadable.type, currentLoadable.trigger, currentLoadable.format, -1L, -1L);
        }
        this.loader.startLoading(currentLoadable, this);
    }

    private void doChunkOperation() {
        this.currentLoadableHolder.endOfStream = false;
        this.currentLoadableHolder.queueSize = this.readOnlyMediaChunks.size();
        this.chunkSource.getChunkOperation(this.readOnlyMediaChunks, this.pendingResetPositionUs != Long.MIN_VALUE ? this.pendingResetPositionUs : this.downstreamPositionUs, this.currentLoadableHolder);
        this.loadingFinished = this.currentLoadableHolder.endOfStream;
    }

    private boolean discardUpstreamMediaChunks(int queueLength) {
        if (this.mediaChunks.size() <= queueLength) {
            return false;
        }
        long startTimeUs = 0L;
        long endTimeUs = this.mediaChunks.getLast().endTimeUs;
        BaseMediaChunk removed = null;
        while (this.mediaChunks.size() > queueLength) {
            removed = this.mediaChunks.removeLast();
            startTimeUs = removed.startTimeUs;
            this.loadingFinished = false;
        }
        this.sampleQueue.discardUpstreamSamples(removed.getFirstSampleIndex());
        this.notifyUpstreamDiscarded(startTimeUs, endTimeUs);
        return true;
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof BaseMediaChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != Long.MIN_VALUE;
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    protected final long usToMs(long timeUs) {
        return timeUs / 1000L;
    }

    private void notifyLoadStarted(final long length, final int type, final int trigger, final Format format, final long mediaStartTimeUs, final long mediaEndTimeUs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadStarted(ChunkSampleSource.this.eventSourceId, length, type, trigger, format, ChunkSampleSource.this.usToMs(mediaStartTimeUs), ChunkSampleSource.this.usToMs(mediaEndTimeUs));
                }
            });
        }
    }

    private void notifyLoadCompleted(final long bytesLoaded, final int type, final int trigger, final Format format, final long mediaStartTimeUs, final long mediaEndTimeUs, final long elapsedRealtimeMs, final long loadDurationMs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadCompleted(ChunkSampleSource.this.eventSourceId, bytesLoaded, type, trigger, format, ChunkSampleSource.this.usToMs(mediaStartTimeUs), ChunkSampleSource.this.usToMs(mediaEndTimeUs), elapsedRealtimeMs, loadDurationMs);
                }
            });
        }
    }

    private void notifyLoadCanceled(final long bytesLoaded) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadCanceled(ChunkSampleSource.this.eventSourceId, bytesLoaded);
                }
            });
        }
    }

    private void notifyLoadError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadError(ChunkSampleSource.this.eventSourceId, e);
                }
            });
        }
    }

    private void notifyUpstreamDiscarded(final long mediaStartTimeUs, final long mediaEndTimeUs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onUpstreamDiscarded(ChunkSampleSource.this.eventSourceId, ChunkSampleSource.this.usToMs(mediaStartTimeUs), ChunkSampleSource.this.usToMs(mediaEndTimeUs));
                }
            });
        }
    }

    private void notifyDownstreamFormatChanged(final Format format, final int trigger, final long positionUs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onDownstreamFormatChanged(ChunkSampleSource.this.eventSourceId, format, trigger, ChunkSampleSource.this.usToMs(positionUs));
                }
            });
        }
    }

    public static interface EventListener
    extends BaseChunkSampleSourceEventListener {
    }
}

