/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.BaseMediaChunk;
import com.google.android.exoplayer.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public class ContainerMediaChunk
extends BaseMediaChunk
implements ChunkExtractorWrapper.SingleTrackOutput {
    private final ChunkExtractorWrapper extractorWrapper;
    private final long sampleOffsetUs;
    private final int adaptiveMaxWidth;
    private final int adaptiveMaxHeight;
    private MediaFormat mediaFormat;
    private DrmInitData drmInitData;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;

    public ContainerMediaChunk(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, long startTimeUs, long endTimeUs, int chunkIndex, long sampleOffsetUs, ChunkExtractorWrapper extractorWrapper, MediaFormat mediaFormat, int adaptiveMaxWidth, int adaptiveMaxHeight, DrmInitData drmInitData, boolean isMediaFormatFinal, int parentId) {
        super(dataSource, dataSpec, trigger, format, startTimeUs, endTimeUs, chunkIndex, isMediaFormatFinal, parentId);
        this.extractorWrapper = extractorWrapper;
        this.sampleOffsetUs = sampleOffsetUs;
        this.adaptiveMaxWidth = adaptiveMaxWidth;
        this.adaptiveMaxHeight = adaptiveMaxHeight;
        this.mediaFormat = ContainerMediaChunk.getAdjustedMediaFormat(mediaFormat, sampleOffsetUs, adaptiveMaxWidth, adaptiveMaxHeight);
        this.drmInitData = drmInitData;
    }

    @Override
    public final long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public final MediaFormat getMediaFormat() {
        return this.mediaFormat;
    }

    @Override
    public final DrmInitData getDrmInitData() {
        return this.drmInitData;
    }

    @Override
    public final void seekMap(SeekMap seekMap) {
    }

    @Override
    public final void drmInitData(DrmInitData drmInitData) {
        this.drmInitData = drmInitData;
    }

    @Override
    public final void format(MediaFormat mediaFormat) {
        this.mediaFormat = ContainerMediaChunk.getAdjustedMediaFormat(mediaFormat, this.sampleOffsetUs, this.adaptiveMaxWidth, this.adaptiveMaxHeight);
    }

    @Override
    public final int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        return this.getOutput().sampleData(input, length, allowEndOfInput);
    }

    @Override
    public final void sampleData(ParsableByteArray data, int length) {
        this.getOutput().sampleData(data, length);
    }

    @Override
    public final void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
        this.getOutput().sampleMetadata(timeUs + this.sampleOffsetUs, flags, size, offset, encryptionKey);
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() throws IOException, InterruptedException {
        DataSpec loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            if (this.bytesLoaded == 0) {
                this.extractorWrapper.init(this);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractorWrapper.read(input);
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    private static MediaFormat getAdjustedMediaFormat(MediaFormat format, long sampleOffsetUs, int adaptiveMaxWidth, int adaptiveMaxHeight) {
        if (format == null) {
            return null;
        }
        if (sampleOffsetUs != 0L && format.subsampleOffsetUs != Long.MAX_VALUE) {
            format = format.copyWithSubsampleOffsetUs(format.subsampleOffsetUs + sampleOffsetUs);
        }
        if (adaptiveMaxWidth != -1 || adaptiveMaxHeight != -1) {
            format = format.copyWithMaxVideoDimensions(adaptiveMaxWidth, adaptiveMaxHeight);
        }
        return format;
    }
}

