/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import java.util.List;
import java.util.Random;

public interface FormatEvaluator {
    public void enable();

    public void disable();

    public void evaluate(List<? extends MediaChunk> var1, long var2, Format[] var4, Evaluation var5);

    public static final class AdaptiveEvaluator
    implements FormatEvaluator {
        public static final int DEFAULT_MAX_INITIAL_BITRATE = 800000;
        public static final int DEFAULT_MIN_DURATION_FOR_QUALITY_INCREASE_MS = 10000;
        public static final int DEFAULT_MAX_DURATION_FOR_QUALITY_DECREASE_MS = 25000;
        public static final int DEFAULT_MIN_DURATION_TO_RETAIN_AFTER_DISCARD_MS = 25000;
        public static final float DEFAULT_BANDWIDTH_FRACTION = 0.75f;
        private final BandwidthMeter bandwidthMeter;
        private final int maxInitialBitrate;
        private final long minDurationForQualityIncreaseUs;
        private final long maxDurationForQualityDecreaseUs;
        private final long minDurationToRetainAfterDiscardUs;
        private final float bandwidthFraction;

        public AdaptiveEvaluator(BandwidthMeter bandwidthMeter) {
            this(bandwidthMeter, 800000, 10000, 25000, 25000, 0.75f);
        }

        public AdaptiveEvaluator(BandwidthMeter bandwidthMeter, int maxInitialBitrate, int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction) {
            this.bandwidthMeter = bandwidthMeter;
            this.maxInitialBitrate = maxInitialBitrate;
            this.minDurationForQualityIncreaseUs = (long)minDurationForQualityIncreaseMs * 1000L;
            this.maxDurationForQualityDecreaseUs = (long)maxDurationForQualityDecreaseMs * 1000L;
            this.minDurationToRetainAfterDiscardUs = (long)minDurationToRetainAfterDiscardMs * 1000L;
            this.bandwidthFraction = bandwidthFraction;
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> queue, long playbackPositionUs, Format[] formats, Evaluation evaluation) {
            boolean isLower;
            long bufferedDurationUs = queue.isEmpty() ? 0L : queue.get((int)(queue.size() - 1)).endTimeUs - playbackPositionUs;
            Format current = evaluation.format;
            Format ideal = this.determineIdealFormat(formats, this.bandwidthMeter.getBitrateEstimate());
            boolean isHigher = ideal != null && current != null && ideal.bitrate > current.bitrate;
            boolean bl = isLower = ideal != null && current != null && ideal.bitrate < current.bitrate;
            if (isHigher) {
                if (bufferedDurationUs < this.minDurationForQualityIncreaseUs) {
                    ideal = current;
                } else if (bufferedDurationUs >= this.minDurationToRetainAfterDiscardUs) {
                    for (int i = 1; i < queue.size(); ++i) {
                        MediaChunk thisChunk = queue.get(i);
                        long durationBeforeThisSegmentUs = thisChunk.startTimeUs - playbackPositionUs;
                        if (durationBeforeThisSegmentUs < this.minDurationToRetainAfterDiscardUs || thisChunk.format.bitrate >= ideal.bitrate || thisChunk.format.height >= ideal.height || thisChunk.format.height >= 720 || thisChunk.format.width >= 1280) continue;
                        evaluation.queueSize = i;
                        break;
                    }
                }
            } else if (isLower && current != null && bufferedDurationUs >= this.maxDurationForQualityDecreaseUs) {
                ideal = current;
            }
            if (current != null && ideal != current) {
                evaluation.trigger = 3;
            }
            evaluation.format = ideal;
        }

        private Format determineIdealFormat(Format[] formats, long bitrateEstimate) {
            long effectiveBitrate = bitrateEstimate == -1L ? (long)this.maxInitialBitrate : (long)((float)bitrateEstimate * this.bandwidthFraction);
            for (int i = 0; i < formats.length; ++i) {
                Format format = formats[i];
                if ((long)format.bitrate > effectiveBitrate) continue;
                return format;
            }
            return formats[formats.length - 1];
        }
    }

    public static final class RandomEvaluator
    implements FormatEvaluator {
        private final Random random;

        public RandomEvaluator() {
            this.random = new Random();
        }

        public RandomEvaluator(int seed) {
            this.random = new Random(seed);
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> queue, long playbackPositionUs, Format[] formats, Evaluation evaluation) {
            Format newFormat = formats[this.random.nextInt(formats.length)];
            if (evaluation.format != null && !evaluation.format.equals(newFormat)) {
                evaluation.trigger = 3;
            }
            evaluation.format = newFormat;
        }
    }

    public static final class FixedEvaluator
    implements FormatEvaluator {
        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> queue, long playbackPositionUs, Format[] formats, Evaluation evaluation) {
            evaluation.format = formats[0];
        }
    }

    public static final class Evaluation {
        public int queueSize;
        public int trigger = 1;
        public Format format;
    }
}

