/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;

public abstract class MediaChunk
extends Chunk {
    public final long startTimeUs;
    public final long endTimeUs;
    public final int chunkIndex;

    public MediaChunk(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, long startTimeUs, long endTimeUs, int chunkIndex) {
        this(dataSource, dataSpec, trigger, format, startTimeUs, endTimeUs, chunkIndex, -1);
    }

    public MediaChunk(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, long startTimeUs, long endTimeUs, int chunkIndex, int parentId) {
        super(dataSource, dataSpec, 1, trigger, format, parentId);
        Assertions.checkNotNull(format);
        this.startTimeUs = startTimeUs;
        this.endTimeUs = endTimeUs;
        this.chunkIndex = chunkIndex;
    }

    public int getNextChunkIndex() {
        return this.chunkIndex + 1;
    }

    public long getDurationUs() {
        return this.endTimeUs - this.startTimeUs;
    }
}

