/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.BaseMediaChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class SingleSampleMediaChunk
extends BaseMediaChunk {
    private final MediaFormat sampleFormat;
    private final DrmInitData sampleDrmInitData;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;

    public SingleSampleMediaChunk(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, long startTimeUs, long endTimeUs, int chunkIndex, MediaFormat sampleFormat, DrmInitData sampleDrmInitData, int parentId) {
        super(dataSource, dataSpec, trigger, format, startTimeUs, endTimeUs, chunkIndex, true, parentId);
        this.sampleFormat = sampleFormat;
        this.sampleDrmInitData = sampleDrmInitData;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public MediaFormat getMediaFormat() {
        return this.sampleFormat;
    }

    @Override
    public DrmInitData getDrmInitData() {
        return this.sampleDrmInitData;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        DataSpec loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            this.dataSource.open(loadDataSpec);
            int result = 0;
            while (result != -1) {
                this.bytesLoaded += result;
                result = this.getOutput().sampleData(this.dataSource, Integer.MAX_VALUE, true);
            }
            int sampleSize = this.bytesLoaded;
            this.getOutput().sampleMetadata(this.startTimeUs, 1, sampleSize, 0, null);
        }
        finally {
            this.dataSource.close();
        }
    }
}

