/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import android.content.Context;
import android.graphics.Point;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatWrapper;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class VideoFormatSelectorUtil {
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;

    public static int[] selectVideoFormatsForDefaultDisplay(Context context, List<? extends FormatWrapper> formatWrappers, String[] allowedContainerMimeTypes, boolean filterHdFormats) throws MediaCodecUtil.DecoderQueryException {
        Point viewportSize = Util.getPhysicalDisplaySize(context);
        return VideoFormatSelectorUtil.selectVideoFormats(formatWrappers, allowedContainerMimeTypes, filterHdFormats, true, false, viewportSize.x, viewportSize.y);
    }

    public static int[] selectVideoFormats(List<? extends FormatWrapper> formatWrappers, String[] allowedContainerMimeTypes, boolean filterHdFormats, boolean orientationMayChange, boolean secureDecoder, int viewportWidth, int viewportHeight) throws MediaCodecUtil.DecoderQueryException {
        Format format;
        int i;
        int maxVideoPixelsToRetain = Integer.MAX_VALUE;
        ArrayList<Integer> selectedIndexList = new ArrayList<Integer>();
        int formatWrapperCount = formatWrappers.size();
        for (i = 0; i < formatWrapperCount; ++i) {
            format = formatWrappers.get(i).getFormat();
            if (!VideoFormatSelectorUtil.isFormatPlayable(format, allowedContainerMimeTypes, filterHdFormats, secureDecoder)) continue;
            selectedIndexList.add(i);
            if (format.width <= 0 || format.height <= 0 || viewportWidth <= 0 || viewportHeight <= 0) continue;
            Point maxVideoSizeInViewport = VideoFormatSelectorUtil.getMaxVideoSizeInViewport(orientationMayChange, viewportWidth, viewportHeight, format.width, format.height);
            int videoPixels = format.width * format.height;
            if (format.width < (int)((float)maxVideoSizeInViewport.x * 0.98f) || format.height < (int)((float)maxVideoSizeInViewport.y * 0.98f) || videoPixels >= maxVideoPixelsToRetain) continue;
            maxVideoPixelsToRetain = videoPixels;
        }
        if (maxVideoPixelsToRetain != Integer.MAX_VALUE) {
            for (i = selectedIndexList.size() - 1; i >= 0; --i) {
                format = formatWrappers.get(selectedIndexList.get(i)).getFormat();
                if (format.width <= 0 || format.height <= 0 || format.width * format.height <= maxVideoPixelsToRetain) continue;
                selectedIndexList.remove(i);
            }
        }
        return Util.toArray(selectedIndexList);
    }

    private static boolean isFormatPlayable(Format format, String[] allowedContainerMimeTypes, boolean filterHdFormats, boolean secureDecoder) throws MediaCodecUtil.DecoderQueryException {
        if (allowedContainerMimeTypes != null && !Util.contains(allowedContainerMimeTypes, format.mimeType)) {
            return false;
        }
        if (filterHdFormats && (format.width >= 1280 || format.height >= 720)) {
            return false;
        }
        if (format.width > 0 && format.height > 0) {
            if (Util.SDK_INT >= 21) {
                String videoMediaMimeType = MimeTypes.getVideoMediaMimeType(format.codecs);
                if ("video/x-unknown".equals(videoMediaMimeType)) {
                    videoMediaMimeType = "video/avc";
                }
                if (format.frameRate > 0.0f) {
                    return MediaCodecUtil.isSizeAndRateSupportedV21(videoMediaMimeType, secureDecoder, format.width, format.height, format.frameRate);
                }
                return MediaCodecUtil.isSizeSupportedV21(videoMediaMimeType, secureDecoder, format.width, format.height);
            }
            if (format.width * format.height > MediaCodecUtil.maxH264DecodableFrameSize()) {
                return false;
            }
        }
        return true;
    }

    private static Point getMaxVideoSizeInViewport(boolean orientationMayChange, int viewportWidth, int viewportHeight, int videoWidth, int videoHeight) {
        if (orientationMayChange && videoWidth > videoHeight != viewportWidth > viewportHeight) {
            int tempViewportWidth = viewportWidth;
            viewportWidth = viewportHeight;
            viewportHeight = tempViewportWidth;
        }
        if (videoWidth * viewportHeight >= videoHeight * viewportWidth) {
            return new Point(viewportWidth, Util.ceilDivide(viewportWidth * videoHeight, videoWidth));
        }
        return new Point(Util.ceilDivide(viewportHeight * videoWidth, videoHeight), viewportHeight);
    }

    private VideoFormatSelectorUtil() {
    }
}

