/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash;

import com.google.android.exoplayer.dash.DashSegmentIndex;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.extractor.ChunkIndex;

final class DashWrappingSegmentIndex
implements DashSegmentIndex {
    private final ChunkIndex chunkIndex;
    private final String uri;

    public DashWrappingSegmentIndex(ChunkIndex chunkIndex, String uri) {
        this.chunkIndex = chunkIndex;
        this.uri = uri;
    }

    @Override
    public int getFirstSegmentNum() {
        return 0;
    }

    @Override
    public int getLastSegmentNum(long periodDurationUs) {
        return this.chunkIndex.length - 1;
    }

    @Override
    public long getTimeUs(int segmentNum) {
        return this.chunkIndex.timesUs[segmentNum];
    }

    @Override
    public long getDurationUs(int segmentNum, long periodDurationUs) {
        return this.chunkIndex.durationsUs[segmentNum];
    }

    @Override
    public RangedUri getSegmentUrl(int segmentNum) {
        return new RangedUri(this.uri, null, this.chunkIndex.offsets[segmentNum], this.chunkIndex.sizes[segmentNum]);
    }

    @Override
    public int getSegmentNum(long timeUs, long periodDurationUs) {
        return this.chunkIndex.getChunkIndex(timeUs);
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

