/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.ContentProtection;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.dash.mpd.SegmentBase;
import com.google.android.exoplayer.dash.mpd.UrlTemplate;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.ParserUtil;
import com.google.android.exoplayer.util.UriUtil;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MediaPresentationDescriptionParser
extends DefaultHandler
implements UriLoadable.Parser<MediaPresentationDescription> {
    private static final String TAG = "MediaPresentationDescriptionParser";
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("(\\d+)(?:/(\\d+))?");
    private final String contentId;
    private final XmlPullParserFactory xmlParserFactory;

    public MediaPresentationDescriptionParser() {
        this(null);
    }

    public MediaPresentationDescriptionParser(String contentId) {
        this.contentId = contentId;
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    public MediaPresentationDescription parse(String connectionUrl, InputStream inputStream) throws IOException, ParserException {
        try {
            XmlPullParser xpp = this.xmlParserFactory.newPullParser();
            xpp.setInput(inputStream, null);
            int eventType = xpp.next();
            if (eventType != 2 || !"MPD".equals(xpp.getName())) {
                throw new ParserException("inputStream does not contain a valid media presentation description");
            }
            return this.parseMediaPresentationDescription(xpp, connectionUrl);
        }
        catch (XmlPullParserException e) {
            throw new ParserException(e);
        }
        catch (ParseException e) {
            throw new ParserException(e);
        }
    }

    protected MediaPresentationDescription parseMediaPresentationDescription(XmlPullParser xpp, String baseUrl) throws XmlPullParserException, IOException, ParseException {
        long availabilityStartTime = MediaPresentationDescriptionParser.parseDateTime(xpp, "availabilityStartTime", -1L);
        long durationMs = MediaPresentationDescriptionParser.parseDuration(xpp, "mediaPresentationDuration", -1L);
        long minBufferTimeMs = MediaPresentationDescriptionParser.parseDuration(xpp, "minBufferTime", -1L);
        String typeString = xpp.getAttributeValue(null, "type");
        boolean dynamic = typeString != null ? typeString.equals("dynamic") : false;
        long minUpdateTimeMs = dynamic ? MediaPresentationDescriptionParser.parseDuration(xpp, "minimumUpdatePeriod", -1L) : -1L;
        long timeShiftBufferDepthMs = dynamic ? MediaPresentationDescriptionParser.parseDuration(xpp, "timeShiftBufferDepth", -1L) : -1L;
        UtcTimingElement utcTiming = null;
        String location = null;
        ArrayList<Period> periods = new ArrayList<Period>();
        long nextPeriodStartMs = dynamic ? -1L : 0L;
        boolean seenEarlyAccessPeriod = false;
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (ParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "UTCTiming")) {
                utcTiming = this.parseUtcTiming(xpp);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "Location")) {
                location = xpp.nextText();
                continue;
            }
            if (!ParserUtil.isStartTag(xpp, "Period") || seenEarlyAccessPeriod) continue;
            Pair<Period, Long> periodWithDurationMs = this.parsePeriod(xpp, baseUrl, nextPeriodStartMs);
            Period period = (Period)periodWithDurationMs.first;
            if (period.startMs == -1L) {
                if (dynamic) {
                    seenEarlyAccessPeriod = true;
                    continue;
                }
                throw new ParserException("Unable to determine start of period " + periods.size());
            }
            long periodDurationMs = (Long)periodWithDurationMs.second;
            nextPeriodStartMs = periodDurationMs == -1L ? -1L : period.startMs + periodDurationMs;
            periods.add(period);
        } while (!ParserUtil.isEndTag(xpp, "MPD"));
        if (durationMs == -1L) {
            if (nextPeriodStartMs != -1L) {
                durationMs = nextPeriodStartMs;
            } else if (!dynamic) {
                throw new ParserException("Unable to determine duration of static manifest.");
            }
        }
        if (periods.isEmpty()) {
            throw new ParserException("No periods found.");
        }
        return this.buildMediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, utcTiming, location, periods);
    }

    protected MediaPresentationDescription buildMediaPresentationDescription(long availabilityStartTime, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdateTimeMs, long timeShiftBufferDepthMs, UtcTimingElement utcTiming, String location, List<Period> periods) {
        return new MediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, utcTiming, location, periods);
    }

    protected UtcTimingElement parseUtcTiming(XmlPullParser xpp) {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        String value = xpp.getAttributeValue(null, "value");
        return this.buildUtcTimingElement(schemeIdUri, value);
    }

    protected UtcTimingElement buildUtcTimingElement(String schemeIdUri, String value) {
        return new UtcTimingElement(schemeIdUri, value);
    }

    protected Pair<Period, Long> parsePeriod(XmlPullParser xpp, String baseUrl, long defaultStartMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        long startMs = MediaPresentationDescriptionParser.parseDuration(xpp, "start", defaultStartMs);
        long durationMs = MediaPresentationDescriptionParser.parseDuration(xpp, "duration", -1L);
        SegmentBase segmentBase = null;
        ArrayList<AdaptationSet> adaptationSets = new ArrayList<AdaptationSet>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (ParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "AdaptationSet")) {
                adaptationSets.add(this.parseAdaptationSet(xpp, baseUrl, segmentBase));
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, null);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, null);
                continue;
            }
            if (!ParserUtil.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, null);
        } while (!ParserUtil.isEndTag(xpp, "Period"));
        return Pair.create((Object)this.buildPeriod(id, startMs, adaptationSets), (Object)durationMs);
    }

    protected Period buildPeriod(String id, long startMs, List<AdaptationSet> adaptationSets) {
        return new Period(id, startMs, adaptationSets);
    }

    protected AdaptationSet parseAdaptationSet(XmlPullParser xpp, String baseUrl, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        int id = MediaPresentationDescriptionParser.parseInt(xpp, "id", -1);
        int contentType = this.parseContentType(xpp);
        String mimeType = xpp.getAttributeValue(null, "mimeType");
        String codecs = xpp.getAttributeValue(null, "codecs");
        int width = MediaPresentationDescriptionParser.parseInt(xpp, "width", -1);
        int height = MediaPresentationDescriptionParser.parseInt(xpp, "height", -1);
        float frameRate = MediaPresentationDescriptionParser.parseFrameRate(xpp, -1.0f);
        int audioChannels = -1;
        int audioSamplingRate = MediaPresentationDescriptionParser.parseInt(xpp, "audioSamplingRate", -1);
        String language = xpp.getAttributeValue(null, "lang");
        ContentProtectionsBuilder contentProtectionsBuilder = new ContentProtectionsBuilder();
        ArrayList<Representation> representations = new ArrayList<Representation>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (ParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "ContentProtection")) {
                ContentProtection contentProtection = this.parseContentProtection(xpp);
                if (contentProtection == null) continue;
                contentProtectionsBuilder.addAdaptationSetProtection(contentProtection);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "ContentComponent")) {
                language = MediaPresentationDescriptionParser.checkLanguageConsistency(language, xpp.getAttributeValue(null, "lang"));
                contentType = MediaPresentationDescriptionParser.checkContentTypeConsistency(contentType, this.parseContentType(xpp));
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "Representation")) {
                Representation representation = this.parseRepresentation(xpp, baseUrl, mimeType, codecs, width, height, frameRate, audioChannels, audioSamplingRate, language, segmentBase, contentProtectionsBuilder);
                contentProtectionsBuilder.endRepresentation();
                contentType = MediaPresentationDescriptionParser.checkContentTypeConsistency(contentType, this.getContentType(representation));
                representations.add(representation);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (!ParserUtil.isStartTag(xpp)) continue;
            this.parseAdaptationSetChild(xpp);
        } while (!ParserUtil.isEndTag(xpp, "AdaptationSet"));
        return this.buildAdaptationSet(id, contentType, representations, contentProtectionsBuilder.build());
    }

    protected AdaptationSet buildAdaptationSet(int id, int contentType, List<Representation> representations, List<ContentProtection> contentProtections) {
        return new AdaptationSet(id, contentType, representations, contentProtections);
    }

    protected int parseContentType(XmlPullParser xpp) {
        String contentType = xpp.getAttributeValue(null, "contentType");
        return TextUtils.isEmpty((CharSequence)contentType) ? -1 : ("audio".equals(contentType) ? 1 : ("video".equals(contentType) ? 0 : ("text".equals(contentType) ? 2 : -1)));
    }

    protected int getContentType(Representation representation) {
        String codecs;
        String mimeType = representation.format.mimeType;
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return -1;
        }
        if (MimeTypes.isVideo(mimeType)) {
            return 0;
        }
        if (MimeTypes.isAudio(mimeType)) {
            return 1;
        }
        if (MimeTypes.isText(mimeType) || "application/ttml+xml".equals(mimeType)) {
            return 2;
        }
        if ("application/mp4".equals(mimeType) && ("stpp".equals(codecs = representation.format.codecs) || "wvtt".equals(codecs))) {
            return 2;
        }
        return -1;
    }

    protected ContentProtection parseContentProtection(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        UUID uuid = null;
        DrmInitData.SchemeInitData data = null;
        boolean seenPsshElement = false;
        do {
            xpp.next();
            if (!ParserUtil.isStartTag(xpp, "cenc:pssh") || xpp.next() != 4) continue;
            seenPsshElement = true;
            data = new DrmInitData.SchemeInitData("video/mp4", Base64.decode((String)xpp.getText(), (int)0));
            uuid = PsshAtomUtil.parseUuid(data.data);
        } while (!ParserUtil.isEndTag(xpp, "ContentProtection"));
        if (seenPsshElement && uuid == null) {
            Log.w((String)TAG, (String)"Skipped unsupported ContentProtection element");
            return null;
        }
        return this.buildContentProtection(schemeIdUri, uuid, data);
    }

    protected ContentProtection buildContentProtection(String schemeIdUri, UUID uuid, DrmInitData.SchemeInitData data) {
        return new ContentProtection(schemeIdUri, uuid, data);
    }

    protected void parseAdaptationSetChild(XmlPullParser xpp) throws XmlPullParserException, IOException {
    }

    protected Representation parseRepresentation(XmlPullParser xpp, String baseUrl, String adaptationSetMimeType, String adaptationSetCodecs, int adaptationSetWidth, int adaptationSetHeight, float adaptationSetFrameRate, int adaptationSetAudioChannels, int adaptationSetAudioSamplingRate, String adaptationSetLanguage, SegmentBase segmentBase, ContentProtectionsBuilder contentProtectionsBuilder) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        int bandwidth = MediaPresentationDescriptionParser.parseInt(xpp, "bandwidth");
        String mimeType = MediaPresentationDescriptionParser.parseString(xpp, "mimeType", adaptationSetMimeType);
        String codecs = MediaPresentationDescriptionParser.parseString(xpp, "codecs", adaptationSetCodecs);
        int width = MediaPresentationDescriptionParser.parseInt(xpp, "width", adaptationSetWidth);
        int height = MediaPresentationDescriptionParser.parseInt(xpp, "height", adaptationSetHeight);
        float frameRate = MediaPresentationDescriptionParser.parseFrameRate(xpp, adaptationSetFrameRate);
        int audioChannels = adaptationSetAudioChannels;
        int audioSamplingRate = MediaPresentationDescriptionParser.parseInt(xpp, "audioSamplingRate", adaptationSetAudioSamplingRate);
        String language = adaptationSetLanguage;
        boolean seenFirstBaseUrl = false;
        do {
            ContentProtection contentProtection;
            xpp.next();
            if (ParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (!ParserUtil.isStartTag(xpp, "ContentProtection") || (contentProtection = this.parseContentProtection(xpp)) == null) continue;
            contentProtectionsBuilder.addAdaptationSetProtection(contentProtection);
        } while (!ParserUtil.isEndTag(xpp, "Representation"));
        Format format = this.buildFormat(id, mimeType, width, height, frameRate, audioChannels, audioSamplingRate, bandwidth, language, codecs);
        return this.buildRepresentation(this.contentId, -1, format, segmentBase != null ? segmentBase : new SegmentBase.SingleSegmentBase(baseUrl));
    }

    protected Format buildFormat(String id, String mimeType, int width, int height, float frameRate, int audioChannels, int audioSamplingRate, int bandwidth, String language, String codecs) {
        return new Format(id, mimeType, width, height, frameRate, audioChannels, audioSamplingRate, bandwidth, language, codecs);
    }

    protected Representation buildRepresentation(String contentId, int revisionId, Format format, SegmentBase segmentBase) {
        return Representation.newInstance(contentId, revisionId, format, segmentBase);
    }

    protected SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xpp, String baseUrl, SegmentBase.SingleSegmentBase parent) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long indexStart = parent != null ? parent.indexStart : 0L;
        long indexLength = parent != null ? parent.indexLength : -1L;
        String indexRangeText = xpp.getAttributeValue(null, "indexRange");
        if (indexRangeText != null) {
            String[] indexRange = indexRangeText.split("-");
            indexStart = Long.parseLong(indexRange[0]);
            indexLength = Long.parseLong(indexRange[1]) - indexStart + 1L;
        }
        RangedUri initialization = parent != null ? parent.initialization : null;
        do {
            xpp.next();
            if (!ParserUtil.isStartTag(xpp, "Initialization")) continue;
            initialization = this.parseInitialization(xpp, baseUrl);
        } while (!ParserUtil.isEndTag(xpp, "SegmentBase"));
        return this.buildSingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    protected SegmentBase.SingleSegmentBase buildSingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, String baseUrl, long indexStart, long indexLength) {
        return new SegmentBase.SingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    protected SegmentBase.SegmentList parseSegmentList(XmlPullParser xpp, String baseUrl, SegmentBase.SegmentList parent) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = MediaPresentationDescriptionParser.parseLong(xpp, "duration", parent != null ? parent.duration : -1L);
        int startNumber = MediaPresentationDescriptionParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 1);
        RangedUri initialization = null;
        List timeline = null;
        ArrayList<RangedUri> segments = null;
        do {
            xpp.next();
            if (ParserUtil.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (ParserUtil.isStartTag(xpp, "SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp);
                continue;
            }
            if (!ParserUtil.isStartTag(xpp, "SegmentURL")) continue;
            if (segments == null) {
                segments = new ArrayList<RangedUri>();
            }
            segments.add(this.parseSegmentUrl(xpp, baseUrl));
        } while (!ParserUtil.isEndTag(xpp, "SegmentList"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
            segments = segments != null ? segments : parent.mediaSegments;
        }
        return this.buildSegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentList buildSegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, List<RangedUri> segments) {
        return new SegmentBase.SegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xpp, String baseUrl, SegmentBase.SegmentTemplate parent) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = MediaPresentationDescriptionParser.parseLong(xpp, "duration", parent != null ? parent.duration : -1L);
        int startNumber = MediaPresentationDescriptionParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 1);
        UrlTemplate mediaTemplate = this.parseUrlTemplate(xpp, "media", parent != null ? parent.mediaTemplate : null);
        UrlTemplate initializationTemplate = this.parseUrlTemplate(xpp, "initialization", parent != null ? parent.initializationTemplate : null);
        RangedUri initialization = null;
        List timeline = null;
        do {
            xpp.next();
            if (ParserUtil.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (!ParserUtil.isStartTag(xpp, "SegmentTimeline")) continue;
            timeline = this.parseSegmentTimeline(xpp);
        } while (!ParserUtil.isEndTag(xpp, "SegmentTemplate"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
        }
        return this.buildSegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    protected SegmentBase.SegmentTemplate buildSegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate, String baseUrl) {
        return new SegmentBase.SegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    protected List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xpp) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> segmentTimeline = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long elapsedTime = 0L;
        do {
            xpp.next();
            if (!ParserUtil.isStartTag(xpp, "S")) continue;
            elapsedTime = MediaPresentationDescriptionParser.parseLong(xpp, "t", elapsedTime);
            long duration = MediaPresentationDescriptionParser.parseLong(xpp, "d");
            int count = 1 + MediaPresentationDescriptionParser.parseInt(xpp, "r", 0);
            for (int i = 0; i < count; ++i) {
                segmentTimeline.add(this.buildSegmentTimelineElement(elapsedTime, duration));
                elapsedTime += duration;
            }
        } while (!ParserUtil.isEndTag(xpp, "SegmentTimeline"));
        return segmentTimeline;
    }

    protected SegmentBase.SegmentTimelineElement buildSegmentTimelineElement(long elapsedTime, long duration) {
        return new SegmentBase.SegmentTimelineElement(elapsedTime, duration);
    }

    protected UrlTemplate parseUrlTemplate(XmlPullParser xpp, String name, UrlTemplate defaultValue) {
        String valueString = xpp.getAttributeValue(null, name);
        if (valueString != null) {
            return UrlTemplate.compile(valueString);
        }
        return defaultValue;
    }

    protected RangedUri parseInitialization(XmlPullParser xpp, String baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "sourceURL", "range");
    }

    protected RangedUri parseSegmentUrl(XmlPullParser xpp, String baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "media", "mediaRange");
    }

    protected RangedUri parseRangedUrl(XmlPullParser xpp, String baseUrl, String urlAttribute, String rangeAttribute) {
        String urlText = xpp.getAttributeValue(null, urlAttribute);
        long rangeStart = 0L;
        long rangeLength = -1L;
        String rangeText = xpp.getAttributeValue(null, rangeAttribute);
        if (rangeText != null) {
            String[] rangeTextArray = rangeText.split("-");
            rangeStart = Long.parseLong(rangeTextArray[0]);
            if (rangeTextArray.length == 2) {
                rangeLength = Long.parseLong(rangeTextArray[1]) - rangeStart + 1L;
            }
        }
        return this.buildRangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected RangedUri buildRangedUri(String baseUrl, String urlText, long rangeStart, long rangeLength) {
        return new RangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected int parseAudioChannelConfiguration(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = MediaPresentationDescriptionParser.parseString(xpp, "schemeIdUri", null);
        int audioChannels = "urn:mpeg:dash:23003:3:audio_channel_configuration:2011".equals(schemeIdUri) ? MediaPresentationDescriptionParser.parseInt(xpp, "value") : -1;
        do {
            xpp.next();
        } while (!ParserUtil.isEndTag(xpp, "AudioChannelConfiguration"));
        return audioChannels;
    }

    private static String checkLanguageConsistency(String firstLanguage, String secondLanguage) {
        if (firstLanguage == null) {
            return secondLanguage;
        }
        if (secondLanguage == null) {
            return firstLanguage;
        }
        Assertions.checkState(firstLanguage.equals(secondLanguage));
        return firstLanguage;
    }

    private static int checkContentTypeConsistency(int firstType, int secondType) {
        if (firstType == -1) {
            return secondType;
        }
        if (secondType == -1) {
            return firstType;
        }
        Assertions.checkState(firstType == secondType);
        return firstType;
    }

    protected static float parseFrameRate(XmlPullParser xpp, float defaultValue) {
        Matcher frameRateMatcher;
        float frameRate = defaultValue;
        String frameRateAttribute = xpp.getAttributeValue(null, "frameRate");
        if (frameRateAttribute != null && (frameRateMatcher = FRAME_RATE_PATTERN.matcher(frameRateAttribute)).matches()) {
            int numerator = Integer.parseInt(frameRateMatcher.group(1));
            String denominatorString = frameRateMatcher.group(2);
            frameRate = !TextUtils.isEmpty((CharSequence)denominatorString) ? (float)numerator / (float)Integer.parseInt(denominatorString) : (float)numerator;
        }
        return frameRate;
    }

    protected static long parseDuration(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDuration(value);
    }

    protected static long parseDateTime(XmlPullParser xpp, String name, long defaultValue) throws ParseException {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDateTime(value);
    }

    protected static String parseBaseUrl(XmlPullParser xpp, String parentBaseUrl) throws XmlPullParserException, IOException {
        xpp.next();
        return UriUtil.resolve(parentBaseUrl, xpp.getText());
    }

    protected static int parseInt(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseInt(xpp, name, -1);
    }

    protected static int parseInt(XmlPullParser xpp, String name, int defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected static long parseLong(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseLong(xpp, name, -1L);
    }

    protected static long parseLong(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected static String parseString(XmlPullParser xpp, String name, String defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : value;
    }

    protected static final class ContentProtectionsBuilder
    implements Comparator<ContentProtection> {
        private ArrayList<ContentProtection> adaptationSetProtections;
        private ArrayList<ContentProtection> representationProtections;
        private ArrayList<ContentProtection> currentRepresentationProtections;
        private boolean representationProtectionsSet;

        protected ContentProtectionsBuilder() {
        }

        public void addAdaptationSetProtection(ContentProtection contentProtection) {
            if (this.adaptationSetProtections == null) {
                this.adaptationSetProtections = new ArrayList();
            }
            this.maybeAddContentProtection(this.adaptationSetProtections, contentProtection);
        }

        public void addRepresentationProtection(ContentProtection contentProtection) {
            if (this.currentRepresentationProtections == null) {
                this.currentRepresentationProtections = new ArrayList();
            }
            this.maybeAddContentProtection(this.currentRepresentationProtections, contentProtection);
        }

        public void endRepresentation() {
            if (!this.representationProtectionsSet) {
                if (this.currentRepresentationProtections != null) {
                    Collections.sort(this.currentRepresentationProtections, this);
                }
                this.representationProtections = this.currentRepresentationProtections;
                this.representationProtectionsSet = true;
            } else if (this.currentRepresentationProtections == null) {
                Assertions.checkState(this.representationProtections == null);
            } else {
                Collections.sort(this.currentRepresentationProtections, this);
                Assertions.checkState(this.currentRepresentationProtections.equals(this.representationProtections));
            }
            this.currentRepresentationProtections = null;
        }

        public ArrayList<ContentProtection> build() {
            if (this.adaptationSetProtections == null) {
                return this.representationProtections;
            }
            if (this.representationProtections == null) {
                return this.adaptationSetProtections;
            }
            for (int i = 0; i < this.representationProtections.size(); ++i) {
                this.maybeAddContentProtection(this.adaptationSetProtections, this.representationProtections.get(i));
            }
            return this.adaptationSetProtections;
        }

        private void maybeAddContentProtection(List<ContentProtection> contentProtections, ContentProtection contentProtection) {
            if (!contentProtections.contains(contentProtection)) {
                for (int i = 0; i < contentProtections.size(); ++i) {
                    Assertions.checkState(!contentProtections.get((int)i).schemeUriId.equals(contentProtection.schemeUriId));
                }
                contentProtections.add(contentProtection);
            }
        }

        @Override
        public int compare(ContentProtection first, ContentProtection second) {
            return first.schemeUriId.compareTo(second.schemeUriId);
        }
    }
}

