/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.UriUtil;

public final class RangedUri {
    public final long start;
    public final long length;
    private final String baseUri;
    private final String referenceUri;
    private int hashCode;

    public RangedUri(String baseUri, String referenceUri, long start, long length) {
        Assertions.checkArgument(baseUri != null || referenceUri != null);
        this.baseUri = baseUri;
        this.referenceUri = referenceUri;
        this.start = start;
        this.length = length;
    }

    public Uri getUri() {
        return UriUtil.resolveToUri(this.baseUri, this.referenceUri);
    }

    public String getUriString() {
        return UriUtil.resolve(this.baseUri, this.referenceUri);
    }

    public RangedUri attemptMerge(RangedUri other) {
        if (other == null || !this.getUriString().equals(other.getUriString())) {
            return null;
        }
        if (this.length != -1L && this.start + this.length == other.start) {
            return new RangedUri(this.baseUri, this.referenceUri, this.start, other.length == -1L ? -1L : this.length + other.length);
        }
        if (other.length != -1L && other.start + other.length == this.start) {
            return new RangedUri(this.baseUri, this.referenceUri, other.start, this.length == -1L ? -1L : other.length + this.length);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (int)this.start;
            result = 31 * result + (int)this.length;
            this.hashCode = result = 31 * result + this.getUriString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangedUri other = (RangedUri)obj;
        return this.start == other.start && this.length == other.length && this.getUriString().equals(other.getUriString());
    }
}

