/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.os.SystemClock;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;

public final class UtcTimingElementResolver
implements Loader.Callback {
    private final UriDataSource uriDataSource;
    private final UtcTimingElement timingElement;
    private final long timingElementElapsedRealtime;
    private final UtcTimingCallback callback;
    private Loader singleUseLoader;
    private UriLoadable<Long> singleUseLoadable;

    public static void resolveTimingElement(UriDataSource uriDataSource, UtcTimingElement timingElement, long timingElementElapsedRealtime, UtcTimingCallback callback) {
        UtcTimingElementResolver resolver = new UtcTimingElementResolver(uriDataSource, timingElement, timingElementElapsedRealtime, callback);
        resolver.resolve();
    }

    private UtcTimingElementResolver(UriDataSource uriDataSource, UtcTimingElement timingElement, long timingElementElapsedRealtime, UtcTimingCallback callback) {
        this.uriDataSource = uriDataSource;
        this.timingElement = Assertions.checkNotNull(timingElement);
        this.timingElementElapsedRealtime = timingElementElapsedRealtime;
        this.callback = Assertions.checkNotNull(callback);
    }

    private void resolve() {
        String scheme = this.timingElement.schemeIdUri;
        if (Util.areEqual(scheme, "urn:mpeg:dash:utc:direct:2012")) {
            this.resolveDirect();
        } else if (Util.areEqual(scheme, "urn:mpeg:dash:utc:http-iso:2014")) {
            this.resolveHttp(new Iso8601Parser());
        } else if (Util.areEqual(scheme, "urn:mpeg:dash:utc:http-xsdate:2012") || Util.areEqual(scheme, "urn:mpeg:dash:utc:http-xsdate:2014")) {
            this.resolveHttp(new XsDateTimeParser());
        } else {
            this.callback.onTimestampError(this.timingElement, new IOException("Unsupported utc timing scheme"));
        }
    }

    private void resolveDirect() {
        try {
            long utcTimestamp = Util.parseXsDateTime(this.timingElement.value);
            long elapsedRealtimeOffset = utcTimestamp - this.timingElementElapsedRealtime;
            this.callback.onTimestampResolved(this.timingElement, elapsedRealtimeOffset);
        }
        catch (ParseException e) {
            this.callback.onTimestampError(this.timingElement, new ParserException(e));
        }
    }

    private void resolveHttp(UriLoadable.Parser<Long> parser) {
        this.singleUseLoader = new Loader("utctiming");
        this.singleUseLoadable = new UriLoadable<Long>(this.timingElement.value, this.uriDataSource, parser);
        this.singleUseLoader.startLoading(this.singleUseLoadable, this);
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        this.onLoadError(loadable, new IOException("Load cancelled", new CancellationException()));
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        this.releaseLoader();
        long elapsedRealtimeOffset = this.singleUseLoadable.getResult() - SystemClock.elapsedRealtime();
        this.callback.onTimestampResolved(this.timingElement, elapsedRealtimeOffset);
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException exception) {
        this.releaseLoader();
        this.callback.onTimestampError(this.timingElement, exception);
    }

    private void releaseLoader() {
        this.singleUseLoader.release();
    }

    private static class Iso8601Parser
    implements UriLoadable.Parser<Long> {
        private Iso8601Parser() {
        }

        @Override
        public Long parse(String connectionUrl, InputStream inputStream) throws ParserException, IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.parse(firstLine).getTime();
            }
            catch (ParseException e) {
                throw new ParserException(e);
            }
        }
    }

    private static class XsDateTimeParser
    implements UriLoadable.Parser<Long> {
        private XsDateTimeParser() {
        }

        @Override
        public Long parse(String connectionUrl, InputStream inputStream) throws ParserException, IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                return Util.parseXsDateTime(firstLine);
            }
            catch (ParseException e) {
                throw new ParserException(e);
            }
        }
    }

    public static interface UtcTimingCallback {
        public void onTimestampResolved(UtcTimingElement var1, long var2);

        public void onTimestampError(UtcTimingElement var1, IOException var2);
    }
}

