/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.drm;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public interface DrmInitData {
    public SchemeInitData get(UUID var1);

    public static final class SchemeInitData {
        public final String mimeType;
        public final byte[] data;

        public SchemeInitData(String mimeType, byte[] data) {
            this.mimeType = Assertions.checkNotNull(mimeType);
            this.data = Assertions.checkNotNull(data);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemeInitData)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            SchemeInitData other = (SchemeInitData)obj;
            return this.mimeType.equals(other.mimeType) && Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            return this.mimeType.hashCode() + 31 * Arrays.hashCode(this.data);
        }
    }

    public static final class Universal
    implements DrmInitData {
        private SchemeInitData data;

        public Universal(SchemeInitData data) {
            this.data = data;
        }

        @Override
        public SchemeInitData get(UUID schemeUuid) {
            return this.data;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Util.areEqual(this.data, ((Universal)obj).data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }

    public static final class Mapped
    implements DrmInitData {
        private final Map<UUID, SchemeInitData> schemeData = new HashMap<UUID, SchemeInitData>();

        @Override
        public SchemeInitData get(UUID schemeUuid) {
            return this.schemeData.get(schemeUuid);
        }

        public void put(UUID schemeUuid, SchemeInitData schemeInitData) {
            this.schemeData.put(schemeUuid, schemeInitData);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Mapped rhs = (Mapped)obj;
            if (this.schemeData.size() != rhs.schemeData.size()) {
                return false;
            }
            for (UUID uuid : this.schemeData.keySet()) {
                if (Util.areEqual(this.schemeData.get(uuid), rhs.schemeData.get(uuid))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.schemeData.hashCode();
        }
    }
}

