/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.upstream.DataSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public final class DefaultExtractorInput
implements ExtractorInput {
    private static final byte[] SCRATCH_SPACE = new byte[4096];
    private final DataSource dataSource;
    private final long streamLength;
    private long position;
    private byte[] peekBuffer;
    private int peekBufferPosition;
    private int peekBufferLength;

    public DefaultExtractorInput(DataSource dataSource, long position, long length) {
        this.dataSource = dataSource;
        this.position = position;
        this.streamLength = length;
        this.peekBuffer = new byte[8192];
    }

    @Override
    public int read(byte[] target, int offset, int length) throws IOException, InterruptedException {
        int bytesRead = this.readFromPeekBuffer(target, offset, length);
        if (bytesRead == 0) {
            bytesRead = this.readFromDataSource(target, offset, length, 0, true);
        }
        this.commitBytesRead(bytesRead);
        return bytesRead;
    }

    @Override
    public boolean readFully(byte[] target, int offset, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        int bytesRead = this.readFromPeekBuffer(target, offset, length);
        while (bytesRead < length && bytesRead != -1) {
            bytesRead = this.readFromDataSource(target, offset, length, bytesRead, allowEndOfInput);
        }
        this.commitBytesRead(bytesRead);
        return bytesRead != -1;
    }

    @Override
    public void readFully(byte[] target, int offset, int length) throws IOException, InterruptedException {
        this.readFully(target, offset, length, false);
    }

    @Override
    public int skip(int length) throws IOException, InterruptedException {
        int bytesSkipped = this.skipFromPeekBuffer(length);
        if (bytesSkipped == 0) {
            bytesSkipped = this.readFromDataSource(SCRATCH_SPACE, 0, Math.min(length, SCRATCH_SPACE.length), 0, true);
        }
        this.commitBytesRead(bytesSkipped);
        return bytesSkipped;
    }

    @Override
    public boolean skipFully(int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        int bytesSkipped = this.skipFromPeekBuffer(length);
        while (bytesSkipped < length && bytesSkipped != -1) {
            bytesSkipped = this.readFromDataSource(SCRATCH_SPACE, -bytesSkipped, Math.min(length, bytesSkipped + SCRATCH_SPACE.length), bytesSkipped, allowEndOfInput);
        }
        this.commitBytesRead(bytesSkipped);
        return bytesSkipped != -1;
    }

    @Override
    public void skipFully(int length) throws IOException, InterruptedException {
        this.skipFully(length, false);
    }

    @Override
    public boolean peekFully(byte[] target, int offset, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        if (!this.advancePeekPosition(length, allowEndOfInput)) {
            return false;
        }
        System.arraycopy(this.peekBuffer, this.peekBufferPosition - length, target, offset, length);
        return true;
    }

    @Override
    public void peekFully(byte[] target, int offset, int length) throws IOException, InterruptedException {
        this.peekFully(target, offset, length, false);
    }

    @Override
    public boolean advancePeekPosition(int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        this.ensureSpaceForPeek(length);
        int bytesPeeked = Math.min(this.peekBufferLength - this.peekBufferPosition, length);
        this.peekBufferLength += length - bytesPeeked;
        while (bytesPeeked < length) {
            if ((bytesPeeked = this.readFromDataSource(this.peekBuffer, this.peekBufferPosition, length, bytesPeeked, allowEndOfInput)) != -1) continue;
            return false;
        }
        this.peekBufferPosition += length;
        return true;
    }

    @Override
    public void advancePeekPosition(int length) throws IOException, InterruptedException {
        this.advancePeekPosition(length, false);
    }

    @Override
    public void resetPeekPosition() {
        this.peekBufferPosition = 0;
    }

    @Override
    public long getPeekPosition() {
        return this.position + (long)this.peekBufferPosition;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getLength() {
        return this.streamLength;
    }

    private void ensureSpaceForPeek(int length) {
        int requiredLength = this.peekBufferPosition + length;
        if (requiredLength > this.peekBuffer.length) {
            this.peekBuffer = Arrays.copyOf(this.peekBuffer, Math.max(this.peekBuffer.length * 2, requiredLength));
        }
    }

    private int skipFromPeekBuffer(int length) {
        int bytesSkipped = Math.min(this.peekBufferLength, length);
        this.updatePeekBuffer(bytesSkipped);
        return bytesSkipped;
    }

    private int readFromPeekBuffer(byte[] target, int offset, int length) {
        if (this.peekBufferLength == 0) {
            return 0;
        }
        int peekBytes = Math.min(this.peekBufferLength, length);
        System.arraycopy(this.peekBuffer, 0, target, offset, peekBytes);
        this.updatePeekBuffer(peekBytes);
        return peekBytes;
    }

    private void updatePeekBuffer(int bytesConsumed) {
        this.peekBufferLength -= bytesConsumed;
        this.peekBufferPosition = 0;
        System.arraycopy(this.peekBuffer, bytesConsumed, this.peekBuffer, 0, this.peekBufferLength);
    }

    private int readFromDataSource(byte[] target, int offset, int length, int bytesAlreadyRead, boolean allowEndOfInput) throws InterruptedException, IOException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int bytesRead = this.dataSource.read(target, offset + bytesAlreadyRead, length - bytesAlreadyRead);
        if (bytesRead == -1) {
            if (bytesAlreadyRead == 0 && allowEndOfInput) {
                return -1;
            }
            throw new EOFException();
        }
        return bytesAlreadyRead + bytesRead;
    }

    private void commitBytesRead(int bytesRead) {
        if (bytesRead != -1) {
            this.position += (long)bytesRead;
        }
    }
}

