/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.RollingSampleBuffer;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

public class DefaultTrackOutput
implements TrackOutput {
    private final RollingSampleBuffer rollingBuffer;
    private final SampleHolder sampleInfoHolder;
    private boolean needKeyframe;
    private long lastReadTimeUs;
    private long spliceOutTimeUs;
    private volatile long largestParsedTimestampUs;
    private volatile MediaFormat format;

    public DefaultTrackOutput(Allocator allocator) {
        this.rollingBuffer = new RollingSampleBuffer(allocator);
        this.sampleInfoHolder = new SampleHolder(0);
        this.needKeyframe = true;
        this.lastReadTimeUs = Long.MIN_VALUE;
        this.spliceOutTimeUs = Long.MIN_VALUE;
        this.largestParsedTimestampUs = Long.MIN_VALUE;
    }

    public void clear() {
        this.rollingBuffer.clear();
        this.needKeyframe = true;
        this.lastReadTimeUs = Long.MIN_VALUE;
        this.spliceOutTimeUs = Long.MIN_VALUE;
        this.largestParsedTimestampUs = Long.MIN_VALUE;
    }

    public int getWriteIndex() {
        return this.rollingBuffer.getWriteIndex();
    }

    public void discardUpstreamSamples(int discardFromIndex) {
        this.rollingBuffer.discardUpstreamSamples(discardFromIndex);
        this.largestParsedTimestampUs = this.rollingBuffer.peekSample(this.sampleInfoHolder) ? this.sampleInfoHolder.timeUs : Long.MIN_VALUE;
    }

    public int getReadIndex() {
        return this.rollingBuffer.getReadIndex();
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public MediaFormat getFormat() {
        return this.format;
    }

    public long getLargestParsedTimestampUs() {
        return this.largestParsedTimestampUs;
    }

    public boolean isEmpty() {
        return !this.advanceToEligibleSample();
    }

    public boolean getSample(SampleHolder holder) {
        boolean foundEligibleSample = this.advanceToEligibleSample();
        if (!foundEligibleSample) {
            return false;
        }
        this.rollingBuffer.readSample(holder);
        this.needKeyframe = false;
        this.lastReadTimeUs = holder.timeUs;
        return true;
    }

    public void discardUntil(long timeUs) {
        while (this.rollingBuffer.peekSample(this.sampleInfoHolder) && this.sampleInfoHolder.timeUs < timeUs) {
            this.rollingBuffer.skipSample();
            this.needKeyframe = true;
        }
        this.lastReadTimeUs = Long.MIN_VALUE;
    }

    public boolean skipToKeyframeBefore(long timeUs) {
        return this.rollingBuffer.skipToKeyframeBefore(timeUs);
    }

    public boolean configureSpliceTo(DefaultTrackOutput nextQueue) {
        if (this.spliceOutTimeUs != Long.MIN_VALUE) {
            return true;
        }
        long firstPossibleSpliceTime = this.rollingBuffer.peekSample(this.sampleInfoHolder) ? this.sampleInfoHolder.timeUs : this.lastReadTimeUs + 1L;
        RollingSampleBuffer nextRollingBuffer = nextQueue.rollingBuffer;
        while (nextRollingBuffer.peekSample(this.sampleInfoHolder) && (this.sampleInfoHolder.timeUs < firstPossibleSpliceTime || !this.sampleInfoHolder.isSyncFrame())) {
            nextRollingBuffer.skipSample();
        }
        if (nextRollingBuffer.peekSample(this.sampleInfoHolder)) {
            this.spliceOutTimeUs = this.sampleInfoHolder.timeUs;
            return true;
        }
        return false;
    }

    private boolean advanceToEligibleSample() {
        boolean haveNext = this.rollingBuffer.peekSample(this.sampleInfoHolder);
        if (this.needKeyframe) {
            while (haveNext && !this.sampleInfoHolder.isSyncFrame()) {
                this.rollingBuffer.skipSample();
                haveNext = this.rollingBuffer.peekSample(this.sampleInfoHolder);
            }
        }
        if (!haveNext) {
            return false;
        }
        return this.spliceOutTimeUs == Long.MIN_VALUE || this.sampleInfoHolder.timeUs < this.spliceOutTimeUs;
    }

    public int sampleData(DataSource dataSource, int length, boolean allowEndOfInput) throws IOException {
        return this.rollingBuffer.appendData(dataSource, length, allowEndOfInput);
    }

    @Override
    public void format(MediaFormat format) {
        this.format = format;
    }

    @Override
    public int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        return this.rollingBuffer.appendData(input, length, allowEndOfInput);
    }

    @Override
    public void sampleData(ParsableByteArray buffer, int length) {
        this.rollingBuffer.appendData(buffer, length);
    }

    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
        this.largestParsedTimestampUs = Math.max(this.largestParsedTimestampUs, timeUs);
        this.rollingBuffer.commitSample(timeUs, flags, this.rollingBuffer.getWritePosition() - (long)size - (long)offset, size, encryptionKey);
    }
}

