/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.extractor.DefaultTrackOutput;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ExtractorSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
ExtractorOutput,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_ON_DEMAND = 3;
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_LIVE = 6;
    private static final int MIN_RETRY_COUNT_DEFAULT_FOR_MEDIA = -1;
    private static final long NO_RESET_PENDING = Long.MIN_VALUE;
    private static final List<Class<? extends Extractor>> DEFAULT_EXTRACTOR_CLASSES = new ArrayList<Class<? extends Extractor>>();
    private final ExtractorHolder extractorHolder;
    private final Allocator allocator;
    private final int requestedBufferSize;
    private final SparseArray<InternalTrackOutput> sampleQueues;
    private final int minLoadableRetryCount;
    private final Uri uri;
    private final DataSource dataSource;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final int eventSourceId;
    private volatile boolean tracksBuilt;
    private volatile SeekMap seekMap;
    private volatile DrmInitData drmInitData;
    private boolean prepared;
    private int enabledTrackCount;
    private MediaFormat[] mediaFormats;
    private long maxTrackDurationUs;
    private boolean[] pendingMediaFormat;
    private boolean[] pendingDiscontinuities;
    private boolean[] trackEnabledStates;
    private int remainingReleaseCount;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean havePendingNextSampleUs;
    private long pendingNextSampleUs;
    private long sampleTimeOffsetUs;
    private Loader loader;
    private ExtractingLoadable loadable;
    private IOException currentLoadableException;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private boolean loadingFinished;
    private int extractedSampleCount;
    private int extractedSampleCountAtStartOfLoad;

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int requestedBufferSize, Extractor ... extractors) {
        this(uri, dataSource, allocator, requestedBufferSize, -1, extractors);
    }

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int requestedBufferSize, Handler eventHandler, EventListener eventListener, int eventSourceId, Extractor ... extractors) {
        this(uri, dataSource, allocator, requestedBufferSize, -1, eventHandler, eventListener, eventSourceId, extractors);
    }

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int requestedBufferSize, int minLoadableRetryCount, Extractor ... extractors) {
        this(uri, dataSource, allocator, requestedBufferSize, minLoadableRetryCount, null, null, 0, extractors);
    }

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int requestedBufferSize, int minLoadableRetryCount, Handler eventHandler, EventListener eventListener, int eventSourceId, Extractor ... extractors) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.eventListener = eventListener;
        this.eventHandler = eventHandler;
        this.eventSourceId = eventSourceId;
        this.allocator = allocator;
        this.requestedBufferSize = requestedBufferSize;
        this.minLoadableRetryCount = minLoadableRetryCount;
        if (extractors == null || extractors.length == 0) {
            extractors = new Extractor[DEFAULT_EXTRACTOR_CLASSES.size()];
            for (int i = 0; i < extractors.length; ++i) {
                try {
                    extractors[i] = DEFAULT_EXTRACTOR_CLASSES.get(i).newInstance();
                    continue;
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Unexpected error creating default extractor", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unexpected error creating default extractor", e);
                }
            }
        }
        this.extractorHolder = new ExtractorHolder(extractors, this);
        this.sampleQueues = new SparseArray();
        this.pendingResetPositionUs = Long.MIN_VALUE;
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        ++this.remainingReleaseCount;
        return this;
    }

    @Override
    public boolean prepare(long positionUs) {
        if (this.prepared) {
            return true;
        }
        if (this.loader == null) {
            this.loader = new Loader("Loader:ExtractorSampleSource");
        }
        this.maybeStartLoading();
        if (this.seekMap != null && this.tracksBuilt && this.haveFormatsForAllTracks()) {
            int trackCount = this.sampleQueues.size();
            this.trackEnabledStates = new boolean[trackCount];
            this.pendingDiscontinuities = new boolean[trackCount];
            this.pendingMediaFormat = new boolean[trackCount];
            this.mediaFormats = new MediaFormat[trackCount];
            this.maxTrackDurationUs = -1L;
            for (int i = 0; i < trackCount; ++i) {
                MediaFormat format;
                this.mediaFormats[i] = format = ((InternalTrackOutput)this.sampleQueues.valueAt(i)).getFormat();
                if (format.durationUs == -1L || format.durationUs <= this.maxTrackDurationUs) continue;
                this.maxTrackDurationUs = format.durationUs;
            }
            this.prepared = true;
            return true;
        }
        return false;
    }

    @Override
    public int getTrackCount() {
        return this.sampleQueues.size();
    }

    @Override
    public MediaFormat getFormat(int track) {
        Assertions.checkState(this.prepared);
        return this.mediaFormats[track];
    }

    @Override
    public void enable(int track, long positionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(!this.trackEnabledStates[track]);
        ++this.enabledTrackCount;
        this.trackEnabledStates[track] = true;
        this.pendingMediaFormat[track] = true;
        this.pendingDiscontinuities[track] = false;
        if (this.enabledTrackCount == 1) {
            this.downstreamPositionUs = positionUs = !this.seekMap.isSeekable() ? 0L : positionUs;
            this.lastSeekPositionUs = positionUs;
            this.restartFrom(positionUs);
        }
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[track]);
        --this.enabledTrackCount;
        this.trackEnabledStates[track] = false;
        if (this.enabledTrackCount == 0) {
            this.downstreamPositionUs = Long.MIN_VALUE;
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.clearState();
                this.allocator.trim(0);
            }
        }
    }

    @Override
    public boolean continueBuffering(int track, long playbackPositionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[track]);
        this.downstreamPositionUs = playbackPositionUs;
        this.discardSamplesForDisabledTracks(this.downstreamPositionUs);
        if (this.loadingFinished) {
            return true;
        }
        this.maybeStartLoading();
        if (this.isPendingReset()) {
            return false;
        }
        return !((InternalTrackOutput)this.sampleQueues.valueAt(track)).isEmpty();
    }

    @Override
    public long readDiscontinuity(int track) {
        if (this.pendingDiscontinuities[track]) {
            this.pendingDiscontinuities[track] = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int track, long playbackPositionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder) {
        this.downstreamPositionUs = playbackPositionUs;
        if (this.pendingDiscontinuities[track] || this.isPendingReset()) {
            return -2;
        }
        InternalTrackOutput sampleQueue = (InternalTrackOutput)this.sampleQueues.valueAt(track);
        if (this.pendingMediaFormat[track]) {
            formatHolder.format = sampleQueue.getFormat();
            formatHolder.drmInitData = this.drmInitData;
            this.pendingMediaFormat[track] = false;
            return -4;
        }
        if (sampleQueue.getSample(sampleHolder)) {
            boolean decodeOnly = sampleHolder.timeUs < this.lastSeekPositionUs;
            sampleHolder.flags = sampleHolder.flags | (decodeOnly ? 0x8000000 : 0);
            if (this.havePendingNextSampleUs) {
                this.sampleTimeOffsetUs = this.pendingNextSampleUs - sampleHolder.timeUs;
                this.havePendingNextSampleUs = false;
            }
            sampleHolder.timeUs += this.sampleTimeOffsetUs;
            return -3;
        }
        if (this.loadingFinished) {
            return -1;
        }
        return -2;
    }

    @Override
    public void maybeThrowError() throws IOException {
        int minLoadableRetryCountForMedia;
        if (this.currentLoadableException == null) {
            return;
        }
        if (this.isCurrentLoadableExceptionFatal()) {
            throw this.currentLoadableException;
        }
        if (this.minLoadableRetryCount != -1) {
            minLoadableRetryCountForMedia = this.minLoadableRetryCount;
        } else {
            int n = minLoadableRetryCountForMedia = this.seekMap != null && !this.seekMap.isSeekable() ? 6 : 3;
        }
        if (this.currentLoadableExceptionCount > minLoadableRetryCountForMedia) {
            throw this.currentLoadableException;
        }
    }

    @Override
    public void seekToUs(long positionUs) {
        int i;
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        positionUs = !this.seekMap.isSeekable() ? 0L : positionUs;
        long currentPositionUs = this.isPendingReset() ? this.pendingResetPositionUs : this.downstreamPositionUs;
        this.downstreamPositionUs = positionUs;
        this.lastSeekPositionUs = positionUs;
        if (currentPositionUs == positionUs) {
            return;
        }
        boolean seekInsideBuffer = !this.isPendingReset();
        for (i = 0; seekInsideBuffer && i < this.sampleQueues.size(); seekInsideBuffer &= ((InternalTrackOutput)this.sampleQueues.valueAt(i)).skipToKeyframeBefore(positionUs), ++i) {
        }
        if (!seekInsideBuffer) {
            this.restartFrom(positionUs);
        }
        for (i = 0; i < this.pendingDiscontinuities.length; ++i) {
            this.pendingDiscontinuities[i] = true;
        }
    }

    @Override
    public long getBufferedPositionUs() {
        if (this.loadingFinished) {
            return -3L;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long largestParsedTimestampUs = Long.MIN_VALUE;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            largestParsedTimestampUs = Math.max(largestParsedTimestampUs, ((InternalTrackOutput)this.sampleQueues.valueAt(i)).getLargestParsedTimestampUs());
        }
        return largestParsedTimestampUs == Long.MIN_VALUE ? this.downstreamPositionUs : largestParsedTimestampUs;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0 && this.loader != null) {
            this.loader.release(new Runnable(){

                @Override
                public void run() {
                    ExtractorSampleSource.this.extractorHolder.release();
                }
            });
            this.loader = null;
        }
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        this.loadingFinished = true;
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        if (this.enabledTrackCount > 0) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.clearState();
            this.allocator.trim(0);
        }
    }

    @Override
    public void onLoadError(Loader.Loadable ignored, IOException e) {
        this.currentLoadableException = e;
        this.currentLoadableExceptionCount = this.extractedSampleCount > this.extractedSampleCountAtStartOfLoad ? 1 : this.currentLoadableExceptionCount + 1;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyLoadError(e);
        this.maybeStartLoading();
    }

    @Override
    public TrackOutput track(int id) {
        InternalTrackOutput sampleQueue = (InternalTrackOutput)this.sampleQueues.get(id);
        if (sampleQueue == null) {
            sampleQueue = new InternalTrackOutput(this.allocator);
            this.sampleQueues.put(id, (Object)sampleQueue);
        }
        return sampleQueue;
    }

    @Override
    public void endTracks() {
        this.tracksBuilt = true;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    @Override
    public void drmInitData(DrmInitData drmInitData) {
        this.drmInitData = drmInitData;
    }

    private void restartFrom(long positionUs) {
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearState();
            this.maybeStartLoading();
        }
    }

    private void maybeStartLoading() {
        if (this.loadingFinished || this.loader.isLoading()) {
            return;
        }
        if (this.currentLoadableException != null) {
            if (this.isCurrentLoadableExceptionFatal()) {
                return;
            }
            Assertions.checkState(this.loadable != null);
            long elapsedMillis = SystemClock.elapsedRealtime() - this.currentLoadableExceptionTimestamp;
            if (elapsedMillis >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.currentLoadableException = null;
                if (!this.prepared) {
                    for (int i = 0; i < this.sampleQueues.size(); ++i) {
                        ((InternalTrackOutput)this.sampleQueues.valueAt(i)).clear();
                    }
                    this.loadable = this.createLoadableFromStart();
                } else if (!this.seekMap.isSeekable() && this.maxTrackDurationUs == -1L) {
                    for (int i = 0; i < this.sampleQueues.size(); ++i) {
                        ((InternalTrackOutput)this.sampleQueues.valueAt(i)).clear();
                    }
                    this.loadable = this.createLoadableFromStart();
                    this.pendingNextSampleUs = this.downstreamPositionUs;
                    this.havePendingNextSampleUs = true;
                }
                this.extractedSampleCountAtStartOfLoad = this.extractedSampleCount;
                this.loader.startLoading(this.loadable, this);
            }
            return;
        }
        this.sampleTimeOffsetUs = 0L;
        this.havePendingNextSampleUs = false;
        if (!this.prepared) {
            this.loadable = this.createLoadableFromStart();
        } else {
            Assertions.checkState(this.isPendingReset());
            if (this.maxTrackDurationUs != -1L && this.pendingResetPositionUs >= this.maxTrackDurationUs) {
                this.loadingFinished = true;
                this.pendingResetPositionUs = Long.MIN_VALUE;
                return;
            }
            this.loadable = this.createLoadableFromPositionUs(this.pendingResetPositionUs);
            this.pendingResetPositionUs = Long.MIN_VALUE;
        }
        this.extractedSampleCountAtStartOfLoad = this.extractedSampleCount;
        this.loader.startLoading(this.loadable, this);
    }

    private ExtractingLoadable createLoadableFromStart() {
        return new ExtractingLoadable(this.uri, this.dataSource, this.extractorHolder, this.allocator, this.requestedBufferSize, 0L);
    }

    private ExtractingLoadable createLoadableFromPositionUs(long positionUs) {
        return new ExtractingLoadable(this.uri, this.dataSource, this.extractorHolder, this.allocator, this.requestedBufferSize, this.seekMap.getPosition(positionUs));
    }

    private boolean haveFormatsForAllTracks() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            if (((InternalTrackOutput)this.sampleQueues.valueAt(i)).hasFormat()) continue;
            return false;
        }
        return true;
    }

    private void discardSamplesForDisabledTracks(long timeUs) {
        for (int i = 0; i < this.trackEnabledStates.length; ++i) {
            if (this.trackEnabledStates[i]) continue;
            ((InternalTrackOutput)this.sampleQueues.valueAt(i)).discardUntil(timeUs);
        }
    }

    private void clearState() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            ((InternalTrackOutput)this.sampleQueues.valueAt(i)).clear();
        }
        this.loadable = null;
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != Long.MIN_VALUE;
    }

    private boolean isCurrentLoadableExceptionFatal() {
        return this.currentLoadableException instanceof UnrecognizedInputFormatException;
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    private void notifyLoadError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ExtractorSampleSource.this.eventListener.onLoadError(ExtractorSampleSource.this.eventSourceId, e);
                }
            });
        }
    }

    static {
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.webm.WebmExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.mp4.FragmentedMp4Extractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.mp4.Mp4Extractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.mp3.Mp3Extractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ts.AdtsExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ts.TsExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.flv.FlvExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ogg.OggExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ts.PsExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.wav.WavExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.ext.flac.FlacExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static final class ExtractorHolder {
        private final Extractor[] extractors;
        private final ExtractorOutput extractorOutput;
        private Extractor extractor;

        public ExtractorHolder(Extractor[] extractors, ExtractorOutput extractorOutput) {
            this.extractors = extractors;
            this.extractorOutput = extractorOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Extractor selectExtractor(ExtractorInput input) throws UnrecognizedInputFormatException, IOException, InterruptedException {
            if (this.extractor != null) {
                return this.extractor;
            }
            for (Extractor extractor : this.extractors) {
                try {
                    if (!extractor.sniff(input)) continue;
                    this.extractor = extractor;
                    break;
                }
                catch (EOFException eOFException) {
                }
                finally {
                    input.resetPeekPosition();
                }
            }
            if (this.extractor == null) {
                throw new UnrecognizedInputFormatException(this.extractors);
            }
            this.extractor.init(this.extractorOutput);
            return this.extractor;
        }

        public void release() {
            if (this.extractor != null) {
                this.extractor.release();
                this.extractor = null;
            }
        }
    }

    private static class ExtractingLoadable
    implements Loader.Loadable {
        private final Uri uri;
        private final DataSource dataSource;
        private final ExtractorHolder extractorHolder;
        private final Allocator allocator;
        private final int requestedBufferSize;
        private final PositionHolder positionHolder;
        private volatile boolean loadCanceled;
        private boolean pendingExtractorSeek;

        public ExtractingLoadable(Uri uri, DataSource dataSource, ExtractorHolder extractorHolder, Allocator allocator, int requestedBufferSize, long position) {
            this.uri = Assertions.checkNotNull(uri);
            this.dataSource = Assertions.checkNotNull(dataSource);
            this.extractorHolder = Assertions.checkNotNull(extractorHolder);
            this.allocator = Assertions.checkNotNull(allocator);
            this.requestedBufferSize = requestedBufferSize;
            this.positionHolder = new PositionHolder();
            this.positionHolder.position = position;
            this.pendingExtractorSeek = true;
        }

        @Override
        public void cancelLoad() {
            this.loadCanceled = true;
        }

        @Override
        public boolean isLoadCanceled() {
            return this.loadCanceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException, InterruptedException {
            int result = 0;
            while (result == 0 && !this.loadCanceled) {
                ExtractorInput input = null;
                try {
                    long position = this.positionHolder.position;
                    long length = this.dataSource.open(new DataSpec(this.uri, position, -1L, null));
                    if (length != -1L) {
                        length += position;
                    }
                    input = new DefaultExtractorInput(this.dataSource, position, length);
                    Extractor extractor = this.extractorHolder.selectExtractor(input);
                    if (this.pendingExtractorSeek) {
                        extractor.seek();
                        this.pendingExtractorSeek = false;
                    }
                    while (result == 0 && !this.loadCanceled) {
                        this.allocator.blockWhileTotalBytesAllocatedExceeds(this.requestedBufferSize);
                        result = extractor.read(input, this.positionHolder);
                    }
                }
                finally {
                    if (result == 1) {
                        result = 0;
                    } else if (input != null) {
                        this.positionHolder.position = input.getPosition();
                    }
                    this.dataSource.close();
                }
            }
        }
    }

    private class InternalTrackOutput
    extends DefaultTrackOutput {
        public InternalTrackOutput(Allocator allocator) {
            super(allocator);
        }

        @Override
        public void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
            super.sampleMetadata(timeUs, flags, size, offset, encryptionKey);
            ExtractorSampleSource.this.extractedSampleCount++;
        }
    }

    public static final class UnrecognizedInputFormatException
    extends ParserException {
        public UnrecognizedInputFormatException(Extractor[] extractors) {
            super("None of the available extractors (" + Util.getCommaDelimitedSimpleClassNames(extractors) + ") could read the stream.");
        }
    }

    public static interface EventListener {
        public void onLoadError(int var1, IOException var2);
    }
}

