/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.flv;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.flv.TagPayloadReader;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

final class ScriptTagPayloadReader
extends TagPayloadReader {
    private static final String NAME_METADATA = "onMetaData";
    private static final String KEY_DURATION = "duration";
    private static final int AMF_TYPE_NUMBER = 0;
    private static final int AMF_TYPE_BOOLEAN = 1;
    private static final int AMF_TYPE_STRING = 2;
    private static final int AMF_TYPE_OBJECT = 3;
    private static final int AMF_TYPE_ECMA_ARRAY = 8;
    private static final int AMF_TYPE_END_MARKER = 9;
    private static final int AMF_TYPE_STRICT_ARRAY = 10;
    private static final int AMF_TYPE_DATE = 11;

    public ScriptTagPayloadReader(TrackOutput output) {
        super(output);
    }

    @Override
    public void seek() {
    }

    @Override
    protected boolean parseHeader(ParsableByteArray data) {
        return true;
    }

    @Override
    protected void parsePayload(ParsableByteArray data, long timeUs) throws ParserException {
        double durationSeconds;
        int nameType = ScriptTagPayloadReader.readAmfType(data);
        if (nameType != 2) {
            throw new ParserException();
        }
        String name = ScriptTagPayloadReader.readAmfString(data);
        if (!NAME_METADATA.equals(name)) {
            return;
        }
        int type = ScriptTagPayloadReader.readAmfType(data);
        if (type != 8) {
            throw new ParserException();
        }
        HashMap<String, Object> metadata = ScriptTagPayloadReader.readAmfEcmaArray(data);
        if (metadata.containsKey(KEY_DURATION) && (durationSeconds = ((Double)metadata.get(KEY_DURATION)).doubleValue()) > 0.0) {
            this.setDurationUs((long)(durationSeconds * 1000000.0));
        }
    }

    private static int readAmfType(ParsableByteArray data) {
        return data.readUnsignedByte();
    }

    private static Boolean readAmfBoolean(ParsableByteArray data) {
        return data.readUnsignedByte() == 1;
    }

    private static Double readAmfDouble(ParsableByteArray data) {
        return Double.longBitsToDouble(data.readLong());
    }

    private static String readAmfString(ParsableByteArray data) {
        int size = data.readUnsignedShort();
        int position = data.getPosition();
        data.skipBytes(size);
        return new String(data.data, position, size);
    }

    private static ArrayList<Object> readAmfStrictArray(ParsableByteArray data) {
        int count = data.readUnsignedIntToInt();
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            int type = ScriptTagPayloadReader.readAmfType(data);
            list.add(ScriptTagPayloadReader.readAmfData(data, type));
        }
        return list;
    }

    private static HashMap<String, Object> readAmfObject(ParsableByteArray data) {
        HashMap<String, Object> array = new HashMap<String, Object>();
        while (true) {
            String key = ScriptTagPayloadReader.readAmfString(data);
            int type = ScriptTagPayloadReader.readAmfType(data);
            if (type == 9) break;
            array.put(key, ScriptTagPayloadReader.readAmfData(data, type));
        }
        return array;
    }

    private static HashMap<String, Object> readAmfEcmaArray(ParsableByteArray data) {
        int count = data.readUnsignedIntToInt();
        HashMap<String, Object> array = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String key = ScriptTagPayloadReader.readAmfString(data);
            int type = ScriptTagPayloadReader.readAmfType(data);
            array.put(key, ScriptTagPayloadReader.readAmfData(data, type));
        }
        return array;
    }

    private static Date readAmfDate(ParsableByteArray data) {
        Date date = new Date((long)ScriptTagPayloadReader.readAmfDouble(data).doubleValue());
        data.skipBytes(2);
        return date;
    }

    private static Object readAmfData(ParsableByteArray data, int type) {
        switch (type) {
            case 0: {
                return ScriptTagPayloadReader.readAmfDouble(data);
            }
            case 1: {
                return ScriptTagPayloadReader.readAmfBoolean(data);
            }
            case 2: {
                return ScriptTagPayloadReader.readAmfString(data);
            }
            case 3: {
                return ScriptTagPayloadReader.readAmfObject(data);
            }
            case 8: {
                return ScriptTagPayloadReader.readAmfEcmaArray(data);
            }
            case 10: {
                return ScriptTagPayloadReader.readAmfStrictArray(data);
            }
            case 11: {
                return ScriptTagPayloadReader.readAmfDate(data);
            }
        }
        return null;
    }
}

