/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.flv;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.util.ParsableByteArray;

abstract class TagPayloadReader {
    protected final TrackOutput output;
    private long durationUs;

    protected TagPayloadReader(TrackOutput output) {
        this.output = output;
        this.durationUs = -1L;
    }

    public final void setDurationUs(long durationUs) {
        this.durationUs = durationUs;
    }

    public final long getDurationUs() {
        return this.durationUs;
    }

    public abstract void seek();

    public final void consume(ParsableByteArray data, long timeUs) throws ParserException {
        if (this.parseHeader(data)) {
            this.parsePayload(data, timeUs);
        }
    }

    protected abstract boolean parseHeader(ParsableByteArray var1) throws ParserException;

    protected abstract void parsePayload(ParsableByteArray var1, long var2) throws ParserException;

    public static final class UnsupportedFormatException
    extends ParserException {
        public UnsupportedFormatException(String msg) {
            super(msg);
        }
    }
}

