/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp3;

import android.util.Pair;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.GaplessInfo;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.charset.Charset;

final class Id3Util {
    private static final int MAXIMUM_METADATA_SIZE = 0x300000;
    private static final int ID3_TAG = Util.getIntegerCodeForString("ID3");
    private static final Charset[] CHARSET_BY_ENCODING = new Charset[]{Charset.forName("ISO-8859-1"), Charset.forName("UTF-16LE"), Charset.forName("UTF-16BE"), Charset.forName("UTF-8")};

    public static GaplessInfo parseId3(ExtractorInput input) throws IOException, InterruptedException {
        ParsableByteArray scratch = new ParsableByteArray(10);
        int peekedId3Bytes = 0;
        GaplessInfo metadata = null;
        while (true) {
            input.peekFully(scratch.data, 0, 10);
            scratch.setPosition(0);
            if (scratch.readUnsignedInt24() != ID3_TAG) break;
            int majorVersion = scratch.readUnsignedByte();
            int minorVersion = scratch.readUnsignedByte();
            int flags = scratch.readUnsignedByte();
            int length = scratch.readSynchSafeInt();
            if (metadata == null && Id3Util.canParseMetadata(majorVersion, minorVersion, flags, length)) {
                byte[] frame = new byte[length];
                input.peekFully(frame, 0, length);
                metadata = Id3Util.parseGaplessInfo(new ParsableByteArray(frame), majorVersion, flags);
            } else {
                input.advancePeekPosition(length);
            }
            peekedId3Bytes += 10 + length;
        }
        input.resetPeekPosition();
        input.advancePeekPosition(peekedId3Bytes);
        return metadata;
    }

    private static boolean canParseMetadata(int majorVersion, int minorVersion, int flags, int length) {
        return !(minorVersion == 255 || majorVersion < 2 || majorVersion > 4 || length > 0x300000 || majorVersion == 2 && ((flags & 0x3F) != 0 || (flags & 0x40) != 0) || majorVersion == 3 && (flags & 0x1F) != 0 || majorVersion == 4 && (flags & 0xF) != 0);
    }

    private static GaplessInfo parseGaplessInfo(ParsableByteArray frame, int version, int flags) {
        Pair<String, String> comment;
        Id3Util.unescape(frame, version, flags);
        frame.setPosition(0);
        if (version == 3 && (flags & 0x40) != 0) {
            if (frame.bytesLeft() < 4) {
                return null;
            }
            int extendedHeaderSize = frame.readUnsignedIntToInt();
            if (extendedHeaderSize > frame.bytesLeft()) {
                return null;
            }
            int paddingSize = 0;
            if (extendedHeaderSize >= 6) {
                frame.skipBytes(2);
                paddingSize = frame.readUnsignedIntToInt();
                frame.setPosition(4);
                frame.setLimit(frame.limit() - paddingSize);
                if (frame.bytesLeft() < extendedHeaderSize) {
                    return null;
                }
            }
            frame.skipBytes(extendedHeaderSize);
        } else if (version == 4 && (flags & 0x40) != 0) {
            if (frame.bytesLeft() < 4) {
                return null;
            }
            int extendedHeaderSize = frame.readSynchSafeInt();
            if (extendedHeaderSize < 6 || extendedHeaderSize > frame.bytesLeft() + 4) {
                return null;
            }
            frame.setPosition(extendedHeaderSize);
        }
        while ((comment = Id3Util.findNextComment(version, frame)) != null) {
            GaplessInfo gaplessInfo;
            if (((String)comment.first).length() <= 3 || (gaplessInfo = GaplessInfo.createFromComment(((String)comment.first).substring(3), (String)comment.second)) == null) continue;
            return gaplessInfo;
        }
        return null;
    }

    private static Pair<String, String> findNextComment(int majorVersion, ParsableByteArray data) {
        int frameSize;
        while (true) {
            String id;
            if (majorVersion == 2) {
                if (data.bytesLeft() < 6) {
                    return null;
                }
                id = data.readString(3, Charset.forName("US-ASCII"));
                if (id.equals("\u0000\u0000\u0000")) {
                    return null;
                }
                frameSize = data.readUnsignedInt24();
                if (frameSize == 0 || frameSize > data.bytesLeft()) {
                    return null;
                }
                if (id.equals("COM")) {
                    break;
                }
            } else {
                boolean compressedOrEncrypted;
                if (data.bytesLeft() < 10) {
                    return null;
                }
                id = data.readString(4, Charset.forName("US-ASCII"));
                if (id.equals("\u0000\u0000\u0000\u0000")) {
                    return null;
                }
                int n = frameSize = majorVersion == 4 ? data.readSynchSafeInt() : data.readUnsignedIntToInt();
                if (frameSize == 0 || frameSize > data.bytesLeft() - 2) {
                    return null;
                }
                int flags = data.readUnsignedShort();
                boolean bl = compressedOrEncrypted = majorVersion == 4 && (flags & 0xC) != 0 || majorVersion == 3 && (flags & 0xC0) != 0;
                if (!compressedOrEncrypted && id.equals("COMM")) break;
            }
            data.skipBytes(frameSize);
        }
        int encoding = data.readUnsignedByte();
        if (encoding < 0 || encoding >= CHARSET_BY_ENCODING.length) {
            return null;
        }
        Charset charset = CHARSET_BY_ENCODING[encoding];
        String[] commentFields = data.readString(frameSize - 1, charset).split("\u0000");
        return commentFields.length == 2 ? Pair.create((Object)commentFields[0], (Object)commentFields[1]) : null;
    }

    private static boolean unescape(ParsableByteArray frame, int version, int flags) {
        if (version != 4) {
            if ((flags & 0x80) != 0) {
                byte[] bytes = frame.data;
                int newLength = bytes.length;
                int i = 0;
                while (i + 1 < newLength) {
                    if ((bytes[i] & 0xFF) == 255 && bytes[i + 1] == 0) {
                        System.arraycopy(bytes, i + 2, bytes, i + 1, newLength - i - 2);
                        --newLength;
                    }
                    ++i;
                }
                frame.setLimit(newLength);
            }
        } else if (Id3Util.canUnescapeVersion4(frame, false)) {
            Id3Util.unescapeVersion4(frame, false);
        } else if (Id3Util.canUnescapeVersion4(frame, true)) {
            Id3Util.unescapeVersion4(frame, true);
        } else {
            return false;
        }
        return true;
    }

    private static boolean canUnescapeVersion4(ParsableByteArray frame, boolean unsignedIntDataSizeHack) {
        frame.setPosition(0);
        while (frame.bytesLeft() >= 10) {
            if (frame.readInt() == 0) {
                return true;
            }
            long dataSize = frame.readUnsignedInt();
            if (!unsignedIntDataSizeHack) {
                if ((dataSize & 0x808080L) != 0L) {
                    return false;
                }
                dataSize = dataSize & 0x7FL | (dataSize >> 8 & 0x7FL) << 7 | (dataSize >> 16 & 0x7FL) << 14 | (dataSize >> 24 & 0x7FL) << 21;
            }
            if (dataSize > (long)(frame.bytesLeft() - 2)) {
                return false;
            }
            int flags = frame.readUnsignedShort();
            if ((flags & 1) != 0 && frame.bytesLeft() < 4) {
                return false;
            }
            frame.skipBytes((int)dataSize);
        }
        return true;
    }

    private static void unescapeVersion4(ParsableByteArray frame, boolean unsignedIntDataSizeHack) {
        frame.setPosition(0);
        byte[] bytes = frame.data;
        while (frame.bytesLeft() >= 10) {
            int flags;
            if (frame.readInt() == 0) {
                return;
            }
            int dataSize = unsignedIntDataSizeHack ? frame.readUnsignedIntToInt() : frame.readSynchSafeInt();
            int previousFlags = flags = frame.readUnsignedShort();
            if ((flags & 1) != 0) {
                int offset = frame.getPosition();
                System.arraycopy(bytes, offset + 4, bytes, offset, frame.bytesLeft() - 4);
                dataSize -= 4;
                flags &= 0xFFFFFFFE;
                frame.setLimit(frame.limit() - 4);
            }
            if ((flags & 2) != 0) {
                int readOffset;
                int writeOffset = readOffset = frame.getPosition() + 1;
                int i = 0;
                while (i + 1 < dataSize) {
                    if ((bytes[readOffset - 1] & 0xFF) == 255 && bytes[readOffset] == 0) {
                        --dataSize;
                    }
                    int n = writeOffset++;
                    int n2 = ++readOffset;
                    ++readOffset;
                    bytes[n] = bytes[n2];
                    ++i;
                }
                frame.setLimit(frame.limit() - (readOffset - writeOffset));
                System.arraycopy(bytes, readOffset, bytes, writeOffset, frame.bytesLeft() - readOffset);
                flags &= 0xFFFFFFFD;
            }
            if (flags != previousFlags || unsignedIntDataSizeHack) {
                int dataSizeOffset = frame.getPosition() - 6;
                Id3Util.writeSyncSafeInteger(bytes, dataSizeOffset, dataSize);
                bytes[dataSizeOffset + 4] = (byte)(flags >> 8);
                bytes[dataSizeOffset + 5] = (byte)(flags & 0xFF);
            }
            frame.skipBytes(dataSize);
        }
    }

    private static void writeSyncSafeInteger(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(value >> 21 & 0x7F);
        bytes[offset + 1] = (byte)(value >> 14 & 0x7F);
        bytes[offset + 2] = (byte)(value >> 7 & 0x7F);
        bytes[offset + 3] = (byte)(value & 0x7F);
    }

    private Id3Util() {
    }
}

