/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.GaplessInfo;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.extractor.mp4.FixedSampleSizeRechunker;
import com.google.android.exoplayer.extractor.mp4.Track;
import com.google.android.exoplayer.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer.util.Ac3Util;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class AtomParsers {
    public static Track parseTrak(Atom.ContainerAtom trak, Atom.LeafAtom mvhd, long duration, boolean isQuickTime) {
        Atom.ContainerAtom mdia = trak.getContainerAtomOfType(Atom.TYPE_mdia);
        int trackType = AtomParsers.parseHdlr(mdia.getLeafAtomOfType((int)Atom.TYPE_hdlr).data);
        if (trackType != Track.TYPE_soun && trackType != Track.TYPE_vide && trackType != Track.TYPE_text && trackType != Track.TYPE_sbtl && trackType != Track.TYPE_subt) {
            return null;
        }
        TkhdData tkhdData = AtomParsers.parseTkhd(trak.getLeafAtomOfType((int)Atom.TYPE_tkhd).data);
        if (duration == -1L) {
            duration = tkhdData.duration;
        }
        long movieTimescale = AtomParsers.parseMvhd(mvhd.data);
        long durationUs = duration == -1L ? -1L : Util.scaleLargeTimestamp(duration, 1000000L, movieTimescale);
        Atom.ContainerAtom stbl = mdia.getContainerAtomOfType(Atom.TYPE_minf).getContainerAtomOfType(Atom.TYPE_stbl);
        Pair<Long, String> mdhdData = AtomParsers.parseMdhd(mdia.getLeafAtomOfType((int)Atom.TYPE_mdhd).data);
        StsdData stsdData = AtomParsers.parseStsd(stbl.getLeafAtomOfType((int)Atom.TYPE_stsd).data, tkhdData.id, durationUs, tkhdData.rotationDegrees, (String)mdhdData.second, isQuickTime);
        Pair<long[], long[]> edtsData = AtomParsers.parseEdts(trak.getContainerAtomOfType(Atom.TYPE_edts));
        return stsdData.mediaFormat == null ? null : new Track(tkhdData.id, trackType, (Long)mdhdData.first, movieTimescale, durationUs, stsdData.mediaFormat, stsdData.trackEncryptionBoxes, stsdData.nalUnitLengthFieldLength, (long[])edtsData.first, (long[])edtsData.second);
    }

    public static TrackSampleTable parseStbl(Track track, Atom.ContainerAtom stblAtom) throws ParserException {
        int[] flags;
        long[] timestamps;
        int[] sizes;
        long[] offsets;
        SampleSizeBox sampleSizeBox;
        Atom.LeafAtom stszAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_stsz);
        if (stszAtom != null) {
            sampleSizeBox = new StszSampleSizeBox(stszAtom);
        } else {
            Atom.LeafAtom stz2Atom = stblAtom.getLeafAtomOfType(Atom.TYPE_stz2);
            if (stz2Atom == null) {
                throw new ParserException("Track has no sample table size information");
            }
            sampleSizeBox = new Stz2SampleSizeBox(stz2Atom);
        }
        int sampleCount = sampleSizeBox.getSampleCount();
        if (sampleCount == 0) {
            return new TrackSampleTable(new long[0], new int[0], 0, new long[0], new int[0]);
        }
        boolean chunkOffsetsAreLongs = false;
        Atom.LeafAtom chunkOffsetsAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_stco);
        if (chunkOffsetsAtom == null) {
            chunkOffsetsAreLongs = true;
            chunkOffsetsAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_co64);
        }
        ParsableByteArray chunkOffsets = chunkOffsetsAtom.data;
        ParsableByteArray stsc = stblAtom.getLeafAtomOfType((int)Atom.TYPE_stsc).data;
        ParsableByteArray stts = stblAtom.getLeafAtomOfType((int)Atom.TYPE_stts).data;
        Atom.LeafAtom stssAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_stss);
        ParsableByteArray stss = stssAtom != null ? stssAtom.data : null;
        Atom.LeafAtom cttsAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_ctts);
        ParsableByteArray ctts = cttsAtom != null ? cttsAtom.data : null;
        ChunkIterator chunkIterator = new ChunkIterator(stsc, chunkOffsets, chunkOffsetsAreLongs);
        stts.setPosition(12);
        int remainingTimestampDeltaChanges = stts.readUnsignedIntToInt() - 1;
        int remainingSamplesAtTimestampDelta = stts.readUnsignedIntToInt();
        int timestampDeltaInTimeUnits = stts.readUnsignedIntToInt();
        int remainingSamplesAtTimestampOffset = 0;
        int remainingTimestampOffsetChanges = 0;
        int timestampOffset = 0;
        if (ctts != null) {
            ctts.setPosition(12);
            remainingTimestampOffsetChanges = ctts.readUnsignedIntToInt();
        }
        int nextSynchronizationSampleIndex = -1;
        int remainingSynchronizationSamples = 0;
        if (stss != null) {
            stss.setPosition(12);
            remainingSynchronizationSamples = stss.readUnsignedIntToInt();
            if (remainingSynchronizationSamples > 0) {
                nextSynchronizationSampleIndex = stss.readUnsignedIntToInt() - 1;
            } else {
                stss = null;
            }
        }
        boolean isRechunkable = sampleSizeBox.isFixedSampleSize() && "audio/raw".equals(track.mediaFormat.mimeType) && remainingTimestampDeltaChanges == 0 && remainingTimestampOffsetChanges == 0 && remainingSynchronizationSamples == 0;
        int maximumSize = 0;
        if (!isRechunkable) {
            offsets = new long[sampleCount];
            sizes = new int[sampleCount];
            timestamps = new long[sampleCount];
            flags = new int[sampleCount];
            long timestampTimeUnits = 0L;
            long offset = 0L;
            int remainingSamplesInChunk = 0;
            for (int i = 0; i < sampleCount; ++i) {
                while (remainingSamplesInChunk == 0) {
                    Assertions.checkState(chunkIterator.moveNext());
                    offset = chunkIterator.offset;
                    remainingSamplesInChunk = chunkIterator.numSamples;
                }
                if (ctts != null) {
                    while (remainingSamplesAtTimestampOffset == 0 && remainingTimestampOffsetChanges > 0) {
                        remainingSamplesAtTimestampOffset = ctts.readUnsignedIntToInt();
                        timestampOffset = ctts.readInt();
                        --remainingTimestampOffsetChanges;
                    }
                    --remainingSamplesAtTimestampOffset;
                }
                offsets[i] = offset;
                sizes[i] = sampleSizeBox.readNextSampleSize();
                if (sizes[i] > maximumSize) {
                    maximumSize = sizes[i];
                }
                timestamps[i] = timestampTimeUnits + (long)timestampOffset;
                int n = flags[i] = stss == null ? 1 : 0;
                if (i == nextSynchronizationSampleIndex) {
                    flags[i] = 1;
                    if (--remainingSynchronizationSamples > 0) {
                        nextSynchronizationSampleIndex = stss.readUnsignedIntToInt() - 1;
                    }
                }
                timestampTimeUnits += (long)timestampDeltaInTimeUnits;
                if (--remainingSamplesAtTimestampDelta == 0 && remainingTimestampDeltaChanges > 0) {
                    remainingSamplesAtTimestampDelta = stts.readUnsignedIntToInt();
                    timestampDeltaInTimeUnits = stts.readUnsignedIntToInt();
                    --remainingTimestampDeltaChanges;
                }
                offset += (long)sizes[i];
                --remainingSamplesInChunk;
            }
            Assertions.checkArgument(remainingSamplesAtTimestampOffset == 0);
            while (remainingTimestampOffsetChanges > 0) {
                Assertions.checkArgument(ctts.readUnsignedIntToInt() == 0);
                ctts.readInt();
                --remainingTimestampOffsetChanges;
            }
            Assertions.checkArgument(remainingSynchronizationSamples == 0);
            Assertions.checkArgument(remainingSamplesAtTimestampDelta == 0);
            Assertions.checkArgument(remainingSamplesInChunk == 0);
            Assertions.checkArgument(remainingTimestampDeltaChanges == 0);
        } else {
            long[] chunkOffsetsBytes = new long[chunkIterator.length];
            int[] chunkSampleCounts = new int[chunkIterator.length];
            while (chunkIterator.moveNext()) {
                chunkOffsetsBytes[chunkIterator.index] = chunkIterator.offset;
                chunkSampleCounts[chunkIterator.index] = chunkIterator.numSamples;
            }
            int fixedSampleSize = sampleSizeBox.readNextSampleSize();
            FixedSampleSizeRechunker.Results rechunkedResults = FixedSampleSizeRechunker.rechunk(fixedSampleSize, chunkOffsetsBytes, chunkSampleCounts, timestampDeltaInTimeUnits);
            offsets = rechunkedResults.offsets;
            sizes = rechunkedResults.sizes;
            maximumSize = rechunkedResults.maximumSize;
            timestamps = rechunkedResults.timestamps;
            flags = rechunkedResults.flags;
        }
        if (track.editListDurations == null) {
            Util.scaleLargeTimestampsInPlace(timestamps, 1000000L, track.timescale);
            return new TrackSampleTable(offsets, sizes, maximumSize, timestamps, flags);
        }
        if (track.editListDurations.length == 1 && track.editListDurations[0] == 0L) {
            for (int i = 0; i < timestamps.length; ++i) {
                timestamps[i] = Util.scaleLargeTimestamp(timestamps[i] - track.editListMediaTimes[0], 1000000L, track.timescale);
            }
            return new TrackSampleTable(offsets, sizes, maximumSize, timestamps, flags);
        }
        int editedSampleCount = 0;
        int nextSampleIndex = 0;
        boolean copyMetadata = false;
        for (int i = 0; i < track.editListDurations.length; ++i) {
            long mediaTime = track.editListMediaTimes[i];
            if (mediaTime == -1L) continue;
            long duration = Util.scaleLargeTimestamp(track.editListDurations[i], track.timescale, track.movieTimescale);
            int startIndex = Util.binarySearchCeil(timestamps, mediaTime, true, true);
            int endIndex = Util.binarySearchCeil(timestamps, mediaTime + duration, true, false);
            editedSampleCount += endIndex - startIndex;
            copyMetadata |= nextSampleIndex != startIndex;
            nextSampleIndex = endIndex;
        }
        long[] editedOffsets = (copyMetadata |= editedSampleCount != sampleCount) ? new long[editedSampleCount] : offsets;
        int[] editedSizes = copyMetadata ? new int[editedSampleCount] : sizes;
        int editedMaximumSize = copyMetadata ? 0 : maximumSize;
        int[] editedFlags = copyMetadata ? new int[editedSampleCount] : flags;
        long[] editedTimestamps = new long[editedSampleCount];
        long pts = 0L;
        int sampleIndex = 0;
        for (int i = 0; i < track.editListDurations.length; ++i) {
            long mediaTime = track.editListMediaTimes[i];
            long duration = track.editListDurations[i];
            if (mediaTime != -1L) {
                long endMediaTime = mediaTime + Util.scaleLargeTimestamp(duration, track.timescale, track.movieTimescale);
                int startIndex = Util.binarySearchCeil(timestamps, mediaTime, true, true);
                int endIndex = Util.binarySearchCeil(timestamps, endMediaTime, true, false);
                if (copyMetadata) {
                    int count = endIndex - startIndex;
                    System.arraycopy(offsets, startIndex, editedOffsets, sampleIndex, count);
                    System.arraycopy(sizes, startIndex, editedSizes, sampleIndex, count);
                    System.arraycopy(flags, startIndex, editedFlags, sampleIndex, count);
                }
                for (int j = startIndex; j < endIndex; ++j) {
                    long ptsUs = Util.scaleLargeTimestamp(pts, 1000000L, track.movieTimescale);
                    long timeInSegmentUs = Util.scaleLargeTimestamp(timestamps[j] - mediaTime, 1000000L, track.timescale);
                    editedTimestamps[sampleIndex] = ptsUs + timeInSegmentUs;
                    if (copyMetadata && editedSizes[sampleIndex] > editedMaximumSize) {
                        editedMaximumSize = sizes[j];
                    }
                    ++sampleIndex;
                }
            }
            pts += duration;
        }
        boolean hasSyncSample = false;
        for (int i = 0; i < editedFlags.length && !hasSyncSample; hasSyncSample |= (editedFlags[i] & 1) != 0, ++i) {
        }
        if (!hasSyncSample) {
            throw new ParserException("The edited sample sequence does not contain a sync sample.");
        }
        return new TrackSampleTable(editedOffsets, editedSizes, editedMaximumSize, editedTimestamps, editedFlags);
    }

    public static GaplessInfo parseUdta(Atom.LeafAtom udtaAtom, boolean isQuickTime) {
        if (isQuickTime) {
            return null;
        }
        ParsableByteArray udtaData = udtaAtom.data;
        udtaData.setPosition(8);
        while (udtaData.bytesLeft() >= 8) {
            int atomSize = udtaData.readInt();
            int atomType = udtaData.readInt();
            if (atomType == Atom.TYPE_meta) {
                udtaData.setPosition(udtaData.getPosition() - 8);
                udtaData.setLimit(udtaData.getPosition() + atomSize);
                return AtomParsers.parseMetaAtom(udtaData);
            }
            udtaData.skipBytes(atomSize - 8);
        }
        return null;
    }

    private static GaplessInfo parseMetaAtom(ParsableByteArray data) {
        data.skipBytes(12);
        ParsableByteArray ilst = new ParsableByteArray();
        while (data.bytesLeft() >= 8) {
            int payloadSize = data.readInt() - 8;
            int atomType = data.readInt();
            if (atomType == Atom.TYPE_ilst) {
                ilst.reset(data.data, data.getPosition() + payloadSize);
                ilst.setPosition(data.getPosition());
                GaplessInfo gaplessInfo = AtomParsers.parseIlst(ilst);
                if (gaplessInfo != null) {
                    return gaplessInfo;
                }
            }
            data.skipBytes(payloadSize);
        }
        return null;
    }

    private static GaplessInfo parseIlst(ParsableByteArray ilst) {
        while (ilst.bytesLeft() > 0) {
            int position = ilst.getPosition();
            int endPosition = position + ilst.readInt();
            int type = ilst.readInt();
            if (type == Atom.TYPE_DASHES) {
                String lastCommentMean = null;
                String lastCommentName = null;
                String lastCommentData = null;
                while (ilst.getPosition() < endPosition) {
                    int length = ilst.readInt() - 12;
                    int key = ilst.readInt();
                    ilst.skipBytes(4);
                    if (key == Atom.TYPE_mean) {
                        lastCommentMean = ilst.readString(length);
                        continue;
                    }
                    if (key == Atom.TYPE_name) {
                        lastCommentName = ilst.readString(length);
                        continue;
                    }
                    if (key == Atom.TYPE_data) {
                        ilst.skipBytes(4);
                        lastCommentData = ilst.readString(length - 4);
                        continue;
                    }
                    ilst.skipBytes(length);
                }
                if (lastCommentName == null || lastCommentData == null || !"com.apple.iTunes".equals(lastCommentMean)) continue;
                return GaplessInfo.createFromComment(lastCommentName, lastCommentData);
            }
            ilst.setPosition(endPosition);
        }
        return null;
    }

    private static long parseMvhd(ParsableByteArray mvhd) {
        mvhd.setPosition(8);
        int fullAtom = mvhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        mvhd.skipBytes(version == 0 ? 8 : 16);
        return mvhd.readUnsignedInt();
    }

    private static TkhdData parseTkhd(ParsableByteArray tkhd) {
        long duration;
        tkhd.setPosition(8);
        int fullAtom = tkhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        tkhd.skipBytes(version == 0 ? 8 : 16);
        int trackId = tkhd.readInt();
        tkhd.skipBytes(4);
        boolean durationUnknown = true;
        int durationPosition = tkhd.getPosition();
        int durationByteCount = version == 0 ? 4 : 8;
        for (int i = 0; i < durationByteCount; ++i) {
            if (tkhd.data[durationPosition + i] == -1) continue;
            durationUnknown = false;
            break;
        }
        if (durationUnknown) {
            tkhd.skipBytes(durationByteCount);
            duration = -1L;
        } else {
            long l = duration = version == 0 ? tkhd.readUnsignedInt() : tkhd.readUnsignedLongToLong();
            if (duration == 0L) {
                duration = -1L;
            }
        }
        tkhd.skipBytes(16);
        int a00 = tkhd.readInt();
        int a01 = tkhd.readInt();
        tkhd.skipBytes(4);
        int a10 = tkhd.readInt();
        int a11 = tkhd.readInt();
        int fixedOne = 65536;
        int rotationDegrees = a00 == 0 && a01 == fixedOne && a10 == -fixedOne && a11 == 0 ? 90 : (a00 == 0 && a01 == -fixedOne && a10 == fixedOne && a11 == 0 ? 270 : (a00 == -fixedOne && a01 == 0 && a10 == 0 && a11 == -fixedOne ? 180 : 0));
        return new TkhdData(trackId, duration, rotationDegrees);
    }

    private static int parseHdlr(ParsableByteArray hdlr) {
        hdlr.setPosition(16);
        return hdlr.readInt();
    }

    private static Pair<Long, String> parseMdhd(ParsableByteArray mdhd) {
        mdhd.setPosition(8);
        int fullAtom = mdhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        mdhd.skipBytes(version == 0 ? 8 : 16);
        long timescale = mdhd.readUnsignedInt();
        mdhd.skipBytes(version == 0 ? 4 : 8);
        int languageCode = mdhd.readUnsignedShort();
        String language = "" + (char)((languageCode >> 10 & 0x1F) + 96) + (char)((languageCode >> 5 & 0x1F) + 96) + (char)((languageCode & 0x1F) + 96);
        return Pair.create((Object)timescale, (Object)language);
    }

    private static StsdData parseStsd(ParsableByteArray stsd, int trackId, long durationUs, int rotationDegrees, String language, boolean isQuickTime) {
        stsd.setPosition(12);
        int numberOfEntries = stsd.readInt();
        StsdData out = new StsdData(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            int childStartPosition = stsd.getPosition();
            int childAtomSize = stsd.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = stsd.readInt();
            if (childAtomType == Atom.TYPE_avc1 || childAtomType == Atom.TYPE_avc3 || childAtomType == Atom.TYPE_encv || childAtomType == Atom.TYPE_mp4v || childAtomType == Atom.TYPE_hvc1 || childAtomType == Atom.TYPE_hev1 || childAtomType == Atom.TYPE_s263 || childAtomType == Atom.TYPE_vp08 || childAtomType == Atom.TYPE_vp09) {
                AtomParsers.parseVideoSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, durationUs, rotationDegrees, out, i);
            } else if (childAtomType == Atom.TYPE_mp4a || childAtomType == Atom.TYPE_enca || childAtomType == Atom.TYPE_ac_3 || childAtomType == Atom.TYPE_ec_3 || childAtomType == Atom.TYPE_dtsc || childAtomType == Atom.TYPE_dtse || childAtomType == Atom.TYPE_dtsh || childAtomType == Atom.TYPE_dtsl || childAtomType == Atom.TYPE_samr || childAtomType == Atom.TYPE_sawb || childAtomType == Atom.TYPE_lpcm || childAtomType == Atom.TYPE_sowt) {
                AtomParsers.parseAudioSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, durationUs, language, isQuickTime, out, i);
            } else if (childAtomType == Atom.TYPE_TTML) {
                out.mediaFormat = MediaFormat.createTextFormat(Integer.toString(trackId), "application/ttml+xml", -1, durationUs, language);
            } else if (childAtomType == Atom.TYPE_tx3g) {
                out.mediaFormat = MediaFormat.createTextFormat(Integer.toString(trackId), "application/x-quicktime-tx3g", -1, durationUs, language);
            } else if (childAtomType == Atom.TYPE_wvtt) {
                out.mediaFormat = MediaFormat.createTextFormat(Integer.toString(trackId), "application/x-mp4vtt", -1, durationUs, language);
            } else if (childAtomType == Atom.TYPE_stpp) {
                out.mediaFormat = MediaFormat.createTextFormat(Integer.toString(trackId), "application/ttml+xml", -1, durationUs, language, 0L);
            }
            stsd.setPosition(childStartPosition + childAtomSize);
        }
        return out;
    }

    private static void parseVideoSampleEntry(ParsableByteArray parent, int atomType, int position, int size, int trackId, long durationUs, int rotationDegrees, StsdData out, int entryIndex) {
        parent.setPosition(position + 8);
        parent.skipBytes(24);
        int width = parent.readUnsignedShort();
        int height = parent.readUnsignedShort();
        boolean pixelWidthHeightRatioFromPasp = false;
        float pixelWidthHeightRatio = 1.0f;
        parent.skipBytes(50);
        int childPosition = parent.getPosition();
        if (atomType == Atom.TYPE_encv) {
            AtomParsers.parseSampleEntryEncryptionData(parent, position, size, out, entryIndex);
            parent.setPosition(childPosition);
        }
        List<Object> initializationData = null;
        String mimeType = null;
        byte[] projectionData = null;
        int stereoMode = -1;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            if (childAtomSize == 0 && parent.getPosition() - position == size) break;
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_avcC) {
                Assertions.checkState(mimeType == null);
                mimeType = "video/avc";
                AvcCData avcCData = AtomParsers.parseAvcCFromParent(parent, childStartPosition);
                initializationData = avcCData.initializationData;
                out.nalUnitLengthFieldLength = avcCData.nalUnitLengthFieldLength;
                if (!pixelWidthHeightRatioFromPasp) {
                    pixelWidthHeightRatio = avcCData.pixelWidthAspectRatio;
                }
            } else if (childAtomType == Atom.TYPE_hvcC) {
                Assertions.checkState(mimeType == null);
                mimeType = "video/hevc";
                Pair<List<byte[]>, Integer> hvcCData = AtomParsers.parseHvcCFromParent(parent, childStartPosition);
                initializationData = (List<Object>)hvcCData.first;
                out.nalUnitLengthFieldLength = (Integer)hvcCData.second;
            } else if (childAtomType == Atom.TYPE_d263) {
                Assertions.checkState(mimeType == null);
                mimeType = "video/3gpp";
            } else if (childAtomType == Atom.TYPE_esds) {
                Assertions.checkState(mimeType == null);
                Pair<String, byte[]> mimeTypeAndInitializationData = AtomParsers.parseEsdsFromParent(parent, childStartPosition);
                mimeType = (String)mimeTypeAndInitializationData.first;
                initializationData = Collections.singletonList(mimeTypeAndInitializationData.second);
            } else if (childAtomType == Atom.TYPE_pasp) {
                pixelWidthHeightRatio = AtomParsers.parsePaspFromParent(parent, childStartPosition);
                pixelWidthHeightRatioFromPasp = true;
            } else if (childAtomType == Atom.TYPE_vpcC) {
                Assertions.checkState(mimeType == null);
                mimeType = atomType == Atom.TYPE_vp08 ? "video/x-vnd.on2.vp8" : "video/x-vnd.on2.vp9";
            } else if (childAtomType == Atom.TYPE_sv3d) {
                projectionData = AtomParsers.parseProjFromParent(parent, childStartPosition, childAtomSize);
            } else if (childAtomType == Atom.TYPE_st3d) {
                int version = parent.readUnsignedByte();
                parent.skipBytes(3);
                if (version == 0) {
                    int layout = parent.readUnsignedByte();
                    switch (layout) {
                        case 0: {
                            stereoMode = 0;
                            break;
                        }
                        case 1: {
                            stereoMode = 1;
                            break;
                        }
                        case 2: {
                            stereoMode = 2;
                            break;
                        }
                    }
                }
            }
            childPosition += childAtomSize;
        }
        if (mimeType == null) {
            return;
        }
        out.mediaFormat = MediaFormat.createVideoFormat(Integer.toString(trackId), mimeType, -1, -1, durationUs, width, height, initializationData, rotationDegrees, pixelWidthHeightRatio, projectionData, stereoMode);
    }

    private static AvcCData parseAvcCFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 4);
        int nalUnitLengthFieldLength = (parent.readUnsignedByte() & 3) + 1;
        if (nalUnitLengthFieldLength == 3) {
            throw new IllegalStateException();
        }
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
        float pixelWidthAspectRatio = 1.0f;
        int numSequenceParameterSets = parent.readUnsignedByte() & 0x1F;
        for (int j = 0; j < numSequenceParameterSets; ++j) {
            initializationData.add(NalUnitUtil.parseChildNalUnit(parent));
        }
        int numPictureParameterSets = parent.readUnsignedByte();
        for (int j = 0; j < numPictureParameterSets; ++j) {
            initializationData.add(NalUnitUtil.parseChildNalUnit(parent));
        }
        if (numSequenceParameterSets > 0) {
            ParsableBitArray spsDataBitArray = new ParsableBitArray((byte[])initializationData.get(0));
            spsDataBitArray.setPosition(8 * (nalUnitLengthFieldLength + 1));
            pixelWidthAspectRatio = NalUnitUtil.parseSpsNalUnit((ParsableBitArray)spsDataBitArray).pixelWidthAspectRatio;
        }
        return new AvcCData(initializationData, nalUnitLengthFieldLength, pixelWidthAspectRatio);
    }

    private static Pair<List<byte[]>, Integer> parseHvcCFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 21);
        int lengthSizeMinusOne = parent.readUnsignedByte() & 3;
        int numberOfArrays = parent.readUnsignedByte();
        int csdLength = 0;
        int csdStartPosition = parent.getPosition();
        for (int i = 0; i < numberOfArrays; ++i) {
            parent.skipBytes(1);
            int numberOfNalUnits = parent.readUnsignedShort();
            for (int j = 0; j < numberOfNalUnits; ++j) {
                int nalUnitLength = parent.readUnsignedShort();
                csdLength += 4 + nalUnitLength;
                parent.skipBytes(nalUnitLength);
            }
        }
        parent.setPosition(csdStartPosition);
        byte[] buffer = new byte[csdLength];
        int bufferPosition = 0;
        for (int i = 0; i < numberOfArrays; ++i) {
            parent.skipBytes(1);
            int numberOfNalUnits = parent.readUnsignedShort();
            for (int j = 0; j < numberOfNalUnits; ++j) {
                int nalUnitLength = parent.readUnsignedShort();
                System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, buffer, bufferPosition, NalUnitUtil.NAL_START_CODE.length);
                System.arraycopy(parent.data, parent.getPosition(), buffer, bufferPosition += NalUnitUtil.NAL_START_CODE.length, nalUnitLength);
                bufferPosition += nalUnitLength;
                parent.skipBytes(nalUnitLength);
            }
        }
        List<byte[]> initializationData = csdLength == 0 ? null : Collections.singletonList(buffer);
        return Pair.create(initializationData, (Object)(lengthSizeMinusOne + 1));
    }

    private static Pair<long[], long[]> parseEdts(Atom.ContainerAtom edtsAtom) {
        Atom.LeafAtom elst;
        if (edtsAtom == null || (elst = edtsAtom.getLeafAtomOfType(Atom.TYPE_elst)) == null) {
            return Pair.create(null, null);
        }
        ParsableByteArray elstData = elst.data;
        elstData.setPosition(8);
        int fullAtom = elstData.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        int entryCount = elstData.readUnsignedIntToInt();
        long[] editListDurations = new long[entryCount];
        long[] editListMediaTimes = new long[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            editListDurations[i] = version == 1 ? elstData.readUnsignedLongToLong() : elstData.readUnsignedInt();
            editListMediaTimes[i] = version == 1 ? elstData.readLong() : (long)elstData.readInt();
            short mediaRateInteger = elstData.readShort();
            if (mediaRateInteger != 1) {
                throw new IllegalArgumentException("Unsupported media rate.");
            }
            elstData.skipBytes(2);
        }
        return Pair.create((Object)editListDurations, (Object)editListMediaTimes);
    }

    private static float parsePaspFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8);
        int hSpacing = parent.readUnsignedIntToInt();
        int vSpacing = parent.readUnsignedIntToInt();
        return (float)hSpacing / (float)vSpacing;
    }

    private static void parseAudioSampleEntry(ParsableByteArray parent, int atomType, int position, int size, int trackId, long durationUs, String language, boolean isQuickTime, StsdData out, int entryIndex) {
        int sampleRate;
        int channelCount;
        parent.setPosition(position + 8);
        int quickTimeSoundDescriptionVersion = 0;
        if (isQuickTime) {
            parent.skipBytes(8);
            quickTimeSoundDescriptionVersion = parent.readUnsignedShort();
            parent.skipBytes(6);
        } else {
            parent.skipBytes(16);
        }
        if (quickTimeSoundDescriptionVersion == 0 || quickTimeSoundDescriptionVersion == 1) {
            channelCount = parent.readUnsignedShort();
            parent.skipBytes(6);
            sampleRate = parent.readUnsignedFixedPoint1616();
            if (quickTimeSoundDescriptionVersion == 1) {
                parent.skipBytes(16);
            }
        } else if (quickTimeSoundDescriptionVersion == 2) {
            parent.skipBytes(16);
            sampleRate = (int)Math.round(parent.readDouble());
            channelCount = parent.readUnsignedIntToInt();
            parent.skipBytes(20);
        } else {
            return;
        }
        int childPosition = parent.getPosition();
        if (atomType == Atom.TYPE_enca) {
            atomType = AtomParsers.parseSampleEntryEncryptionData(parent, position, size, out, entryIndex);
            parent.setPosition(childPosition);
        }
        String mimeType = null;
        if (atomType == Atom.TYPE_ac_3) {
            mimeType = "audio/ac3";
        } else if (atomType == Atom.TYPE_ec_3) {
            mimeType = "audio/eac3";
        } else if (atomType == Atom.TYPE_dtsc) {
            mimeType = "audio/vnd.dts";
        } else if (atomType == Atom.TYPE_dtsh || atomType == Atom.TYPE_dtsl) {
            mimeType = "audio/vnd.dts.hd";
        } else if (atomType == Atom.TYPE_dtse) {
            mimeType = "audio/vnd.dts.hd;profile=lbr";
        } else if (atomType == Atom.TYPE_samr) {
            mimeType = "audio/3gpp";
        } else if (atomType == Atom.TYPE_sawb) {
            mimeType = "audio/amr-wb";
        } else if (atomType == Atom.TYPE_lpcm || atomType == Atom.TYPE_sowt) {
            mimeType = "audio/raw";
        }
        byte[] initializationData = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_esds || isQuickTime && childAtomType == Atom.TYPE_wave) {
                int esdsAtomPosition;
                int n = esdsAtomPosition = childAtomType == Atom.TYPE_esds ? childPosition : AtomParsers.findEsdsPosition(parent, childPosition, childAtomSize);
                if (esdsAtomPosition != -1) {
                    Pair<String, byte[]> mimeTypeAndInitializationData = AtomParsers.parseEsdsFromParent(parent, esdsAtomPosition);
                    mimeType = (String)mimeTypeAndInitializationData.first;
                    initializationData = (byte[])mimeTypeAndInitializationData.second;
                    if ("audio/mp4a-latm".equals(mimeType)) {
                        Pair<Integer, Integer> audioSpecificConfig = CodecSpecificDataUtil.parseAacAudioSpecificConfig(initializationData);
                        sampleRate = (Integer)audioSpecificConfig.first;
                        channelCount = (Integer)audioSpecificConfig.second;
                    }
                }
            } else if (childAtomType == Atom.TYPE_dac3) {
                parent.setPosition(8 + childPosition);
                out.mediaFormat = Ac3Util.parseAc3AnnexFFormat(parent, Integer.toString(trackId), durationUs, language);
            } else if (childAtomType == Atom.TYPE_dec3) {
                parent.setPosition(8 + childPosition);
                out.mediaFormat = Ac3Util.parseEAc3AnnexFFormat(parent, Integer.toString(trackId), durationUs, language);
            } else if (childAtomType == Atom.TYPE_ddts) {
                out.mediaFormat = MediaFormat.createAudioFormat(Integer.toString(trackId), mimeType, -1, -1, durationUs, channelCount, sampleRate, null, language);
            }
            childPosition += childAtomSize;
        }
        if (out.mediaFormat == null && mimeType != null) {
            int pcmEncoding = "audio/raw".equals(mimeType) ? 2 : -1;
            out.mediaFormat = MediaFormat.createAudioFormat(Integer.toString(trackId), mimeType, -1, -1, durationUs, channelCount, sampleRate, initializationData == null ? null : Collections.singletonList(initializationData), language, pcmEncoding);
        }
    }

    private static int findEsdsPosition(ParsableByteArray parent, int position, int size) {
        int childAtomPosition = parent.getPosition();
        while (childAtomPosition - position < size) {
            parent.setPosition(childAtomPosition);
            int childAtomSize = parent.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childType = parent.readInt();
            if (childType == Atom.TYPE_esds) {
                return childAtomPosition;
            }
            childAtomPosition += childAtomSize;
        }
        return -1;
    }

    private static Pair<String, byte[]> parseEsdsFromParent(ParsableByteArray parent, int position) {
        String mimeType;
        parent.setPosition(position + 8 + 4);
        parent.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parent);
        parent.skipBytes(2);
        int flags = parent.readUnsignedByte();
        if ((flags & 0x80) != 0) {
            parent.skipBytes(2);
        }
        if ((flags & 0x40) != 0) {
            parent.skipBytes(parent.readUnsignedShort());
        }
        if ((flags & 0x20) != 0) {
            parent.skipBytes(2);
        }
        parent.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parent);
        int objectTypeIndication = parent.readUnsignedByte();
        switch (objectTypeIndication) {
            case 107: {
                String mimeType2 = "audio/mpeg";
                return Pair.create((Object)mimeType2, null);
            }
            case 32: {
                mimeType = "video/mp4v-es";
                break;
            }
            case 33: {
                mimeType = "video/avc";
                break;
            }
            case 35: {
                mimeType = "video/hevc";
                break;
            }
            case 64: 
            case 102: 
            case 103: 
            case 104: {
                mimeType = "audio/mp4a-latm";
                break;
            }
            case 165: {
                mimeType = "audio/ac3";
                break;
            }
            case 166: {
                mimeType = "audio/eac3";
                break;
            }
            case 169: 
            case 172: {
                String mimeType3 = "audio/vnd.dts";
                return Pair.create((Object)mimeType3, null);
            }
            case 170: 
            case 171: {
                String mimeType4 = "audio/vnd.dts.hd";
                return Pair.create((Object)mimeType4, null);
            }
            default: {
                mimeType = null;
            }
        }
        parent.skipBytes(12);
        parent.skipBytes(1);
        int initializationDataSize = AtomParsers.parseExpandableClassSize(parent);
        byte[] initializationData = new byte[initializationDataSize];
        parent.readBytes(initializationData, 0, initializationDataSize);
        return Pair.create((Object)mimeType, (Object)initializationData);
    }

    private static int parseSampleEntryEncryptionData(ParsableByteArray parent, int position, int size, StsdData out, int entryIndex) {
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_sinf) {
                Pair<Integer, TrackEncryptionBox> result = AtomParsers.parseSinfFromParent(parent, childPosition, childAtomSize);
                Integer dataFormat = (Integer)result.first;
                Assertions.checkArgument(dataFormat != null, "frma atom is mandatory");
                out.trackEncryptionBoxes[entryIndex] = (TrackEncryptionBox)result.second;
                return dataFormat;
            }
            childPosition += childAtomSize;
        }
        return 0;
    }

    private static Pair<Integer, TrackEncryptionBox> parseSinfFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        TrackEncryptionBox trackEncryptionBox = null;
        Integer dataFormat = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_frma) {
                dataFormat = parent.readInt();
            } else if (childAtomType == Atom.TYPE_schm) {
                parent.skipBytes(4);
                parent.readInt();
                parent.readInt();
            } else if (childAtomType == Atom.TYPE_schi) {
                trackEncryptionBox = AtomParsers.parseSchiFromParent(parent, childPosition, childAtomSize);
            }
            childPosition += childAtomSize;
        }
        return Pair.create(dataFormat, trackEncryptionBox);
    }

    private static TrackEncryptionBox parseSchiFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_tenc) {
                parent.skipBytes(6);
                boolean defaultIsEncrypted = parent.readUnsignedByte() == 1;
                int defaultInitVectorSize = parent.readUnsignedByte();
                byte[] defaultKeyId = new byte[16];
                parent.readBytes(defaultKeyId, 0, defaultKeyId.length);
                return new TrackEncryptionBox(defaultIsEncrypted, defaultInitVectorSize, defaultKeyId);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static byte[] parseProjFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_proj) {
                return Arrays.copyOfRange(parent.data, childPosition, childPosition + childAtomSize);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static int parseExpandableClassSize(ParsableByteArray data) {
        int currentByte = data.readUnsignedByte();
        int size = currentByte & 0x7F;
        while ((currentByte & 0x80) == 128) {
            currentByte = data.readUnsignedByte();
            size = size << 7 | currentByte & 0x7F;
        }
        return size;
    }

    private AtomParsers() {
    }

    static final class Stz2SampleSizeBox
    implements SampleSizeBox {
        private final ParsableByteArray data;
        private final int sampleCount;
        private final int fieldSize;
        private int sampleIndex;
        private int currentByte;

        public Stz2SampleSizeBox(Atom.LeafAtom stz2Atom) {
            this.data = stz2Atom.data;
            this.data.setPosition(12);
            this.fieldSize = this.data.readUnsignedIntToInt() & 0xFF;
            this.sampleCount = this.data.readUnsignedIntToInt();
        }

        @Override
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public int readNextSampleSize() {
            if (this.fieldSize == 8) {
                return this.data.readUnsignedByte();
            }
            if (this.fieldSize == 16) {
                return this.data.readUnsignedShort();
            }
            if (this.sampleIndex++ % 2 == 0) {
                this.currentByte = this.data.readUnsignedByte();
                return (this.currentByte & 0xF0) >> 4;
            }
            return this.currentByte & 0xF;
        }

        @Override
        public boolean isFixedSampleSize() {
            return false;
        }
    }

    static final class StszSampleSizeBox
    implements SampleSizeBox {
        private final int fixedSampleSize;
        private final int sampleCount;
        private final ParsableByteArray data;

        public StszSampleSizeBox(Atom.LeafAtom stszAtom) {
            this.data = stszAtom.data;
            this.data.setPosition(12);
            this.fixedSampleSize = this.data.readUnsignedIntToInt();
            this.sampleCount = this.data.readUnsignedIntToInt();
        }

        @Override
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public int readNextSampleSize() {
            return this.fixedSampleSize == 0 ? this.data.readUnsignedIntToInt() : this.fixedSampleSize;
        }

        @Override
        public boolean isFixedSampleSize() {
            return this.fixedSampleSize != 0;
        }
    }

    private static interface SampleSizeBox {
        public int getSampleCount();

        public int readNextSampleSize();

        public boolean isFixedSampleSize();
    }

    private static final class AvcCData {
        public final List<byte[]> initializationData;
        public final int nalUnitLengthFieldLength;
        public final float pixelWidthAspectRatio;

        public AvcCData(List<byte[]> initializationData, int nalUnitLengthFieldLength, float pixelWidthAspectRatio) {
            this.initializationData = initializationData;
            this.nalUnitLengthFieldLength = nalUnitLengthFieldLength;
            this.pixelWidthAspectRatio = pixelWidthAspectRatio;
        }
    }

    private static final class StsdData {
        public final TrackEncryptionBox[] trackEncryptionBoxes;
        public MediaFormat mediaFormat;
        public int nalUnitLengthFieldLength;

        public StsdData(int numberOfEntries) {
            this.trackEncryptionBoxes = new TrackEncryptionBox[numberOfEntries];
            this.nalUnitLengthFieldLength = -1;
        }
    }

    private static final class TkhdData {
        private final int id;
        private final long duration;
        private final int rotationDegrees;

        public TkhdData(int id, long duration, int rotationDegrees) {
            this.id = id;
            this.duration = duration;
            this.rotationDegrees = rotationDegrees;
        }
    }

    private static final class ChunkIterator {
        public final int length;
        public int index;
        public int numSamples;
        public long offset;
        private final boolean chunkOffsetsAreLongs;
        private final ParsableByteArray chunkOffsets;
        private final ParsableByteArray stsc;
        private int nextSamplesPerChunkChangeIndex;
        private int remainingSamplesPerChunkChanges;

        public ChunkIterator(ParsableByteArray stsc, ParsableByteArray chunkOffsets, boolean chunkOffsetsAreLongs) {
            this.stsc = stsc;
            this.chunkOffsets = chunkOffsets;
            this.chunkOffsetsAreLongs = chunkOffsetsAreLongs;
            chunkOffsets.setPosition(12);
            this.length = chunkOffsets.readUnsignedIntToInt();
            stsc.setPosition(12);
            this.remainingSamplesPerChunkChanges = stsc.readUnsignedIntToInt();
            Assertions.checkState(stsc.readInt() == 1, "first_chunk must be 1");
            this.index = -1;
        }

        public boolean moveNext() {
            if (++this.index == this.length) {
                return false;
            }
            long l = this.offset = this.chunkOffsetsAreLongs ? this.chunkOffsets.readUnsignedLongToLong() : this.chunkOffsets.readUnsignedInt();
            if (this.index == this.nextSamplesPerChunkChangeIndex) {
                this.numSamples = this.stsc.readUnsignedIntToInt();
                this.stsc.skipBytes(4);
                this.nextSamplesPerChunkChangeIndex = --this.remainingSamplesPerChunkChanges > 0 ? this.stsc.readUnsignedIntToInt() - 1 : -1;
            }
            return true;
        }
    }
}

