/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class PsshAtomUtil {
    private static final String TAG = "PsshAtomUtil";

    private PsshAtomUtil() {
    }

    public static byte[] buildPsshAtom(UUID uuid, byte[] data) {
        int psshBoxLength = 32 + data.length;
        ByteBuffer psshBox = ByteBuffer.allocate(psshBoxLength);
        psshBox.putInt(psshBoxLength);
        psshBox.putInt(Atom.TYPE_pssh);
        psshBox.putInt(0);
        psshBox.putLong(uuid.getMostSignificantBits());
        psshBox.putLong(uuid.getLeastSignificantBits());
        psshBox.putInt(data.length);
        psshBox.put(data);
        return psshBox.array();
    }

    public static UUID parseUuid(byte[] atom) {
        Pair<UUID, byte[]> parsedAtom = PsshAtomUtil.parsePsshAtom(atom);
        if (parsedAtom == null) {
            return null;
        }
        return (UUID)parsedAtom.first;
    }

    public static byte[] parseSchemeSpecificData(byte[] atom, UUID uuid) {
        Pair<UUID, byte[]> parsedAtom = PsshAtomUtil.parsePsshAtom(atom);
        if (parsedAtom == null) {
            return null;
        }
        if (uuid != null && !uuid.equals(parsedAtom.first)) {
            Log.w((String)TAG, (String)("UUID mismatch. Expected: " + uuid + ", got: " + parsedAtom.first + "."));
            return null;
        }
        return (byte[])parsedAtom.second;
    }

    private static Pair<UUID, byte[]> parsePsshAtom(byte[] atom) {
        int dataSize;
        ParsableByteArray atomData = new ParsableByteArray(atom);
        if (atomData.limit() < 32) {
            return null;
        }
        atomData.setPosition(0);
        int atomSize = atomData.readInt();
        if (atomSize != atomData.bytesLeft() + 4) {
            return null;
        }
        int atomType = atomData.readInt();
        if (atomType != Atom.TYPE_pssh) {
            return null;
        }
        int atomVersion = Atom.parseFullAtomVersion(atomData.readInt());
        if (atomVersion > 1) {
            Log.w((String)TAG, (String)("Unsupported pssh version: " + atomVersion));
            return null;
        }
        UUID uuid = new UUID(atomData.readLong(), atomData.readLong());
        if (atomVersion == 1) {
            int keyIdCount = atomData.readUnsignedIntToInt();
            atomData.skipBytes(16 * keyIdCount);
        }
        if ((dataSize = atomData.readUnsignedIntToInt()) != atomData.bytesLeft()) {
            return null;
        }
        byte[] data = new byte[dataSize];
        atomData.readBytes(data, 0, dataSize);
        return Pair.create((Object)uuid, (Object)data);
    }
}

