/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;

final class TrackSampleTable {
    public static final int NO_SAMPLE = -1;
    public final int sampleCount;
    public final long[] offsets;
    public final int[] sizes;
    public final int maximumSize;
    public final long[] timestampsUs;
    public final int[] flags;

    TrackSampleTable(long[] offsets, int[] sizes, int maximumSize, long[] timestampsUs, int[] flags) {
        Assertions.checkArgument(sizes.length == timestampsUs.length);
        Assertions.checkArgument(offsets.length == timestampsUs.length);
        Assertions.checkArgument(flags.length == timestampsUs.length);
        this.offsets = offsets;
        this.sizes = sizes;
        this.maximumSize = maximumSize;
        this.timestampsUs = timestampsUs;
        this.flags = flags;
        this.sampleCount = offsets.length;
    }

    public int getIndexOfEarlierOrEqualSynchronizationSample(long timeUs) {
        int startIndex;
        for (int i = startIndex = Util.binarySearchFloor(this.timestampsUs, timeUs, true, false); i >= 0; --i) {
            if ((this.flags[i] & 1) == 0) continue;
            return i;
        }
        return -1;
    }

    public int getIndexOfLaterOrEqualSynchronizationSample(long timeUs) {
        int startIndex;
        for (int i = startIndex = Util.binarySearchCeil(this.timestampsUs, timeUs, true, false); i < this.timestampsUs.length; ++i) {
            if ((this.flags[i] & 1) == 0) continue;
            return i;
        }
        return -1;
    }
}

