/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.ogg.StreamReader;
import com.google.android.exoplayer.util.FlacSeekTable;
import com.google.android.exoplayer.util.FlacStreamInfo;
import com.google.android.exoplayer.util.FlacUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class FlacReader
extends StreamReader {
    private static final byte AUDIO_PACKET_TYPE = -1;
    private static final byte SEEKTABLE_PACKET_TYPE = 3;
    private FlacStreamInfo streamInfo;
    private FlacSeekTable seekTable;
    private boolean firstAudioPacketProcessed;

    FlacReader() {
    }

    static boolean verifyBitstreamType(ParsableByteArray data) {
        return data.readUnsignedByte() == 127 && data.readUnsignedInt() == 1179402563L;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        long position = input.getPosition();
        if (!this.oggParser.readPacket(input, this.scratch)) {
            return -1;
        }
        byte[] data = this.scratch.data;
        if (this.streamInfo == null) {
            this.streamInfo = new FlacStreamInfo(data, 17);
            byte[] metadata = Arrays.copyOfRange(data, 9, this.scratch.limit());
            metadata[4] = -128;
            List<byte[]> initializationData = Collections.singletonList(metadata);
            MediaFormat mediaFormat = MediaFormat.createAudioFormat(null, "audio/x-flac", this.streamInfo.bitRate(), -1, this.streamInfo.durationUs(), this.streamInfo.channels, this.streamInfo.sampleRate, initializationData, null);
            this.trackOutput.format(mediaFormat);
        } else if (data[0] == -1) {
            if (!this.firstAudioPacketProcessed) {
                if (this.seekTable != null) {
                    this.extractorOutput.seekMap(this.seekTable.createSeekMap(position, this.streamInfo.sampleRate));
                    this.seekTable = null;
                } else {
                    this.extractorOutput.seekMap(SeekMap.UNSEEKABLE);
                }
                this.firstAudioPacketProcessed = true;
            }
            this.trackOutput.sampleData(this.scratch, this.scratch.limit());
            this.scratch.setPosition(0);
            long timeUs = FlacUtil.extractSampleTimestamp(this.streamInfo, this.scratch);
            this.trackOutput.sampleMetadata(timeUs, 1, this.scratch.limit(), 0, null);
        } else if ((data[0] & 0x7F) == 3 && this.seekTable == null) {
            this.seekTable = FlacSeekTable.parseSeekTable(this.scratch);
        }
        this.scratch.reset();
        return 0;
    }
}

