/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ogg.OggUtil;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

final class OggSeeker {
    private static final int MATCH_RANGE = 72000;
    private final OggUtil.PageHeader pageHeader = new OggUtil.PageHeader();
    private final ParsableByteArray headerArray = new ParsableByteArray(282);
    private long audioDataLength = -1L;
    private long totalSamples;

    OggSeeker() {
    }

    public void setup(long audioDataLength, long totalSamples) {
        Assertions.checkArgument(audioDataLength > 0L && totalSamples > 0L);
        this.audioDataLength = audioDataLength;
        this.totalSamples = totalSamples;
    }

    public long getNextSeekPosition(long targetGranule, ExtractorInput input) throws IOException, InterruptedException {
        Assertions.checkState(this.audioDataLength != -1L && this.totalSamples != 0L);
        OggUtil.populatePageHeader(input, this.pageHeader, this.headerArray, false);
        long granuleDistance = targetGranule - this.pageHeader.granulePosition;
        if (granuleDistance <= 0L || granuleDistance > 72000L) {
            long offset = (this.pageHeader.bodySize + this.pageHeader.headerSize) * (granuleDistance <= 0L ? 2 : 1);
            return input.getPosition() - offset + granuleDistance * this.audioDataLength / this.totalSamples;
        }
        input.resetPeekPosition();
        return -1L;
    }
}

