/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.ogg.OggSeeker;
import com.google.android.exoplayer.extractor.ogg.OggUtil;
import com.google.android.exoplayer.extractor.ogg.StreamReader;
import com.google.android.exoplayer.extractor.ogg.VorbisUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;
import java.util.ArrayList;

final class VorbisReader
extends StreamReader
implements SeekMap {
    private static final long LARGEST_EXPECTED_PAGE_SIZE = 8000L;
    private VorbisSetup vorbisSetup;
    private int previousPacketBlockSize;
    private long elapsedSamples;
    private boolean seenFirstAudioPacket;
    private final OggSeeker oggSeeker = new OggSeeker();
    private long targetGranule = -1L;
    private VorbisUtil.VorbisIdHeader vorbisIdHeader;
    private VorbisUtil.CommentHeader commentHeader;
    private long inputLength;
    private long audioStartPosition;
    private long totalSamples;
    private long duration;

    VorbisReader() {
    }

    static boolean verifyBitstreamType(ParsableByteArray data) {
        try {
            return VorbisUtil.verifyVorbisHeaderCapturePattern(1, data, true);
        }
        catch (ParserException e) {
            return false;
        }
    }

    @Override
    public void seek() {
        super.seek();
        this.previousPacketBlockSize = 0;
        this.elapsedSamples = 0L;
        this.seenFirstAudioPacket = false;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        if (this.totalSamples == 0L) {
            if (this.vorbisSetup == null) {
                this.inputLength = input.getLength();
                this.vorbisSetup = this.readSetupHeaders(input, this.scratch);
                this.audioStartPosition = input.getPosition();
                this.extractorOutput.seekMap(this);
                if (this.inputLength != -1L) {
                    seekPosition.position = Math.max(0L, input.getLength() - 8000L);
                    return 1;
                }
            }
            this.totalSamples = this.inputLength == -1L ? -1L : this.oggParser.readGranuleOfLastPage(input);
            ArrayList<byte[]> codecInitialisationData = new ArrayList<byte[]>();
            codecInitialisationData.add(this.vorbisSetup.idHeader.data);
            codecInitialisationData.add(this.vorbisSetup.setupHeaderData);
            this.duration = this.inputLength == -1L ? -1L : this.totalSamples * 1000000L / this.vorbisSetup.idHeader.sampleRate;
            this.trackOutput.format(MediaFormat.createAudioFormat(null, "audio/vorbis", this.vorbisSetup.idHeader.bitrateNominal, 65025, this.duration, this.vorbisSetup.idHeader.channels, (int)this.vorbisSetup.idHeader.sampleRate, codecInitialisationData, null));
            if (this.inputLength != -1L) {
                this.oggSeeker.setup(this.inputLength - this.audioStartPosition, this.totalSamples);
                seekPosition.position = this.audioStartPosition;
                return 1;
            }
        }
        if (!this.seenFirstAudioPacket && this.targetGranule > -1L) {
            OggUtil.skipToNextPage(input);
            long position = this.oggSeeker.getNextSeekPosition(this.targetGranule, input);
            if (position != -1L) {
                seekPosition.position = position;
                return 1;
            }
            this.elapsedSamples = this.oggParser.skipToPageOfGranule(input, this.targetGranule);
            this.previousPacketBlockSize = this.vorbisIdHeader.blockSize0;
            this.seenFirstAudioPacket = true;
        }
        if (this.oggParser.readPacket(input, this.scratch)) {
            if ((this.scratch.data[0] & 1) != 1) {
                int samplesInPacket;
                int packetBlockSize = VorbisReader.decodeBlockSize(this.scratch.data[0], this.vorbisSetup);
                int n = samplesInPacket = this.seenFirstAudioPacket ? (packetBlockSize + this.previousPacketBlockSize) / 4 : 0;
                if (this.elapsedSamples + (long)samplesInPacket >= this.targetGranule) {
                    VorbisReader.appendNumberOfSamples(this.scratch, samplesInPacket);
                    long timeUs = this.elapsedSamples * 1000000L / this.vorbisSetup.idHeader.sampleRate;
                    this.trackOutput.sampleData(this.scratch, this.scratch.limit());
                    this.trackOutput.sampleMetadata(timeUs, 1, this.scratch.limit(), 0, null);
                    this.targetGranule = -1L;
                }
                this.seenFirstAudioPacket = true;
                this.elapsedSamples += (long)samplesInPacket;
                this.previousPacketBlockSize = packetBlockSize;
            }
            this.scratch.reset();
            return 0;
        }
        return -1;
    }

    VorbisSetup readSetupHeaders(ExtractorInput input, ParsableByteArray scratch) throws IOException, InterruptedException {
        if (this.vorbisIdHeader == null) {
            this.oggParser.readPacket(input, scratch);
            this.vorbisIdHeader = VorbisUtil.readVorbisIdentificationHeader(scratch);
            scratch.reset();
        }
        if (this.commentHeader == null) {
            this.oggParser.readPacket(input, scratch);
            this.commentHeader = VorbisUtil.readVorbisCommentHeader(scratch);
            scratch.reset();
        }
        this.oggParser.readPacket(input, scratch);
        byte[] setupHeaderData = new byte[scratch.limit()];
        System.arraycopy(scratch.data, 0, setupHeaderData, 0, scratch.limit());
        VorbisUtil.Mode[] modes = VorbisUtil.readVorbisModes(scratch, this.vorbisIdHeader.channels);
        int iLogModes = VorbisUtil.iLog(modes.length - 1);
        scratch.reset();
        return new VorbisSetup(this.vorbisIdHeader, this.commentHeader, setupHeaderData, modes, iLogModes);
    }

    static void appendNumberOfSamples(ParsableByteArray buffer, long packetSampleCount) {
        buffer.setLimit(buffer.limit() + 4);
        buffer.data[buffer.limit() - 4] = (byte)(packetSampleCount & 0xFFL);
        buffer.data[buffer.limit() - 3] = (byte)(packetSampleCount >>> 8 & 0xFFL);
        buffer.data[buffer.limit() - 2] = (byte)(packetSampleCount >>> 16 & 0xFFL);
        buffer.data[buffer.limit() - 1] = (byte)(packetSampleCount >>> 24 & 0xFFL);
    }

    private static int decodeBlockSize(byte firstByteOfAudioPacket, VorbisSetup vorbisSetup) {
        int modeNumber = OggUtil.readBits(firstByteOfAudioPacket, vorbisSetup.iLogModes, 1);
        int currentBlockSize = !vorbisSetup.modes[modeNumber].blockFlag ? vorbisSetup.idHeader.blockSize0 : vorbisSetup.idHeader.blockSize1;
        return currentBlockSize;
    }

    @Override
    public boolean isSeekable() {
        return this.vorbisSetup != null && this.inputLength != -1L;
    }

    @Override
    public long getPosition(long timeUs) {
        if (timeUs == 0L) {
            this.targetGranule = -1L;
            return this.audioStartPosition;
        }
        this.targetGranule = this.vorbisSetup.idHeader.sampleRate * timeUs / 1000000L;
        return Math.max(this.audioStartPosition, (this.inputLength - this.audioStartPosition) * timeUs / this.duration - 4000L);
    }

    static final class VorbisSetup {
        public final VorbisUtil.VorbisIdHeader idHeader;
        public final VorbisUtil.CommentHeader commentHeader;
        public final byte[] setupHeaderData;
        public final VorbisUtil.Mode[] modes;
        public final int iLogModes;

        public VorbisSetup(VorbisUtil.VorbisIdHeader idHeader, VorbisUtil.CommentHeader commentHeader, byte[] setupHeaderData, VorbisUtil.Mode[] modes, int iLogModes) {
            this.idHeader = idHeader;
            this.commentHeader = commentHeader;
            this.setupHeaderData = setupHeaderData;
            this.modes = modes;
            this.iLogModes = iLogModes;
        }
    }
}

