/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.util.MpegAudioHeader;
import com.google.android.exoplayer.util.ParsableByteArray;

final class MpegAudioReader
extends ElementaryStreamReader {
    private static final int STATE_FINDING_HEADER = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_FRAME = 2;
    private static final int HEADER_SIZE = 4;
    private final ParsableByteArray headerScratch = new ParsableByteArray(4);
    private final MpegAudioHeader header;
    private int state = 0;
    private int frameBytesRead;
    private boolean hasOutputFormat;
    private boolean lastByteWasFF;
    private long frameDurationUs;
    private int frameSize;
    private long timeUs;

    public MpegAudioReader(TrackOutput output) {
        super(output);
        this.headerScratch.data[0] = -1;
        this.header = new MpegAudioHeader();
    }

    @Override
    public void seek() {
        this.state = 0;
        this.frameBytesRead = 0;
        this.lastByteWasFF = false;
    }

    @Override
    public void packetStarted(long pesTimeUs, boolean dataAlignmentIndicator) {
        this.timeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    this.findHeader(data);
                    break;
                }
                case 1: {
                    this.readHeaderRemainder(data);
                    break;
                }
                case 2: {
                    this.readFrameRemainder(data);
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private void findHeader(ParsableByteArray source) {
        byte[] data = source.data;
        int startOffset = source.getPosition();
        int endOffset = source.limit();
        for (int i = startOffset; i < endOffset; ++i) {
            boolean byteIsFF = (data[i] & 0xFF) == 255;
            boolean found = this.lastByteWasFF && (data[i] & 0xE0) == 224;
            this.lastByteWasFF = byteIsFF;
            if (!found) continue;
            source.setPosition(i + 1);
            this.lastByteWasFF = false;
            this.headerScratch.data[1] = data[i];
            this.frameBytesRead = 2;
            this.state = 1;
            return;
        }
        source.setPosition(endOffset);
    }

    private void readHeaderRemainder(ParsableByteArray source) {
        int bytesToRead = Math.min(source.bytesLeft(), 4 - this.frameBytesRead);
        source.readBytes(this.headerScratch.data, this.frameBytesRead, bytesToRead);
        this.frameBytesRead += bytesToRead;
        if (this.frameBytesRead < 4) {
            return;
        }
        this.headerScratch.setPosition(0);
        boolean parsedHeader = MpegAudioHeader.populateHeader(this.headerScratch.readInt(), this.header);
        if (!parsedHeader) {
            this.frameBytesRead = 0;
            this.state = 1;
            return;
        }
        this.frameSize = this.header.frameSize;
        if (!this.hasOutputFormat) {
            this.frameDurationUs = 1000000L * (long)this.header.samplesPerFrame / (long)this.header.sampleRate;
            MediaFormat mediaFormat = MediaFormat.createAudioFormat(null, this.header.mimeType, -1, 4096, -1L, this.header.channels, this.header.sampleRate, null, null);
            this.output.format(mediaFormat);
            this.hasOutputFormat = true;
        }
        this.headerScratch.setPosition(0);
        this.output.sampleData(this.headerScratch, 4);
        this.state = 2;
    }

    private void readFrameRemainder(ParsableByteArray source) {
        int bytesToRead = Math.min(source.bytesLeft(), this.frameSize - this.frameBytesRead);
        this.output.sampleData(source, bytesToRead);
        this.frameBytesRead += bytesToRead;
        if (this.frameBytesRead < this.frameSize) {
            return;
        }
        this.output.sampleMetadata(this.timeUs, 1, this.frameSize, 0, null);
        this.timeUs += this.frameDurationUs;
        this.frameBytesRead = 0;
        this.state = 0;
    }
}

