/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

public final class PtsTimestampAdjuster {
    public static final long DO_NOT_OFFSET = Long.MAX_VALUE;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    private final long firstSampleTimestampUs;
    private long timestampOffsetUs;
    private volatile long lastPts;

    public PtsTimestampAdjuster(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.lastPts = Long.MIN_VALUE;
    }

    public void reset() {
        this.lastPts = Long.MIN_VALUE;
    }

    public boolean isInitialized() {
        return this.lastPts != Long.MIN_VALUE;
    }

    public long adjustTimestamp(long pts) {
        if (this.lastPts != Long.MIN_VALUE) {
            long closestWrapCount = (this.lastPts + 0x100000000L) / 0x200000000L;
            long ptsWrapBelow = pts + 0x200000000L * (closestWrapCount - 1L);
            long ptsWrapAbove = pts + 0x200000000L * closestWrapCount;
            pts = Math.abs(ptsWrapBelow - this.lastPts) < Math.abs(ptsWrapAbove - this.lastPts) ? ptsWrapBelow : ptsWrapAbove;
        }
        long timeUs = PtsTimestampAdjuster.ptsToUs(pts);
        if (this.firstSampleTimestampUs != Long.MAX_VALUE && this.lastPts == Long.MIN_VALUE) {
            this.timestampOffsetUs = this.firstSampleTimestampUs - timeUs;
        }
        this.lastPts = pts;
        return timeUs + this.timestampOffsetUs;
    }

    public static long ptsToUs(long pts) {
        return pts * 1000000L / 90000L;
    }

    public static long usToPts(long us) {
        return us * 90000L / 1000000L;
    }
}

