/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.wav;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.wav.WavHeader;
import com.google.android.exoplayer.extractor.wav.WavHeaderReader;
import java.io.IOException;

public final class WavExtractor
implements Extractor,
SeekMap {
    private static final int MAX_INPUT_SIZE = 32768;
    private ExtractorOutput extractorOutput;
    private TrackOutput trackOutput;
    private WavHeader wavHeader;
    private int bytesPerFrame;
    private int pendingBytes;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        return WavHeaderReader.peek(input) != null;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.trackOutput = output.track(0);
        this.wavHeader = null;
        output.endTracks();
    }

    @Override
    public void seek() {
        this.pendingBytes = 0;
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        int frameBytes;
        int bytesAppended;
        if (this.wavHeader == null) {
            this.wavHeader = WavHeaderReader.peek(input);
            if (this.wavHeader == null) {
                throw new ParserException("Error initializing WavHeader. Did you sniff first?");
            }
            this.bytesPerFrame = this.wavHeader.getBytesPerFrame();
        }
        if (!this.wavHeader.hasDataBounds()) {
            WavHeaderReader.skipToData(input, this.wavHeader);
            this.trackOutput.format(MediaFormat.createAudioFormat(null, "audio/raw", this.wavHeader.getBitrate(), 32768, this.wavHeader.getDurationUs(), this.wavHeader.getNumChannels(), this.wavHeader.getSampleRateHz(), null, null, this.wavHeader.getEncoding()));
            this.extractorOutput.seekMap(this);
        }
        if ((bytesAppended = this.trackOutput.sampleData(input, 32768 - this.pendingBytes, true)) != -1) {
            this.pendingBytes += bytesAppended;
        }
        if ((frameBytes = this.pendingBytes / this.bytesPerFrame * this.bytesPerFrame) > 0) {
            long sampleStartPosition = input.getPosition() - (long)this.pendingBytes;
            this.pendingBytes -= frameBytes;
            this.trackOutput.sampleMetadata(this.wavHeader.getTimeUs(sampleStartPosition), 1, frameBytes, this.pendingBytes, null);
        }
        if (bytesAppended == -1) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getPosition(long timeUs) {
        return this.wavHeader.getPosition(timeUs);
    }
}

