/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.webm;

import android.util.Pair;
import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.ChunkIndex;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.webm.DefaultEbmlReader;
import com.google.android.exoplayer.extractor.webm.EbmlReader;
import com.google.android.exoplayer.extractor.webm.EbmlReaderOutput;
import com.google.android.exoplayer.extractor.webm.Sniffer;
import com.google.android.exoplayer.extractor.webm.VarintReader;
import com.google.android.exoplayer.util.LongArray;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public final class WebmExtractor
implements Extractor {
    private static final int BLOCK_STATE_START = 0;
    private static final int BLOCK_STATE_HEADER = 1;
    private static final int BLOCK_STATE_DATA = 2;
    private static final String DOC_TYPE_WEBM = "webm";
    private static final String DOC_TYPE_MATROSKA = "matroska";
    private static final String CODEC_ID_VP8 = "V_VP8";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final String CODEC_ID_MPEG2 = "V_MPEG2";
    private static final String CODEC_ID_MPEG4_SP = "V_MPEG4/ISO/SP";
    private static final String CODEC_ID_MPEG4_ASP = "V_MPEG4/ISO/ASP";
    private static final String CODEC_ID_MPEG4_AP = "V_MPEG4/ISO/AP";
    private static final String CODEC_ID_H264 = "V_MPEG4/ISO/AVC";
    private static final String CODEC_ID_H265 = "V_MPEGH/ISO/HEVC";
    private static final String CODEC_ID_FOURCC = "V_MS/VFW/FOURCC";
    private static final String CODEC_ID_VORBIS = "A_VORBIS";
    private static final String CODEC_ID_OPUS = "A_OPUS";
    private static final String CODEC_ID_AAC = "A_AAC";
    private static final String CODEC_ID_MP3 = "A_MPEG/L3";
    private static final String CODEC_ID_AC3 = "A_AC3";
    private static final String CODEC_ID_E_AC3 = "A_EAC3";
    private static final String CODEC_ID_TRUEHD = "A_TRUEHD";
    private static final String CODEC_ID_DTS = "A_DTS";
    private static final String CODEC_ID_DTS_EXPRESS = "A_DTS/EXPRESS";
    private static final String CODEC_ID_DTS_LOSSLESS = "A_DTS/LOSSLESS";
    private static final String CODEC_ID_FLAC = "A_FLAC";
    private static final String CODEC_ID_ACM = "A_MS/ACM";
    private static final String CODEC_ID_PCM_INT_LIT = "A_PCM/INT/LIT";
    private static final String CODEC_ID_SUBRIP = "S_TEXT/UTF8";
    private static final String CODEC_ID_VOBSUB = "S_VOBSUB";
    private static final String CODEC_ID_PGS = "S_HDMV/PGS";
    private static final int VORBIS_MAX_INPUT_SIZE = 8192;
    private static final int OPUS_MAX_INPUT_SIZE = 5760;
    private static final int MP3_MAX_INPUT_SIZE = 4096;
    private static final int ENCRYPTION_IV_SIZE = 8;
    private static final int TRACK_TYPE_AUDIO = 2;
    private static final int UNKNOWN = -1;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_SEGMENT_INFO = 357149030;
    private static final int ID_SEEK_HEAD = 290298740;
    private static final int ID_SEEK = 19899;
    private static final int ID_SEEK_ID = 21419;
    private static final int ID_SEEK_POSITION = 21420;
    private static final int ID_INFO = 357149030;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_DURATION = 17545;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_BLOCK_GROUP = 160;
    private static final int ID_BLOCK = 161;
    private static final int ID_BLOCK_DURATION = 155;
    private static final int ID_REFERENCE_BLOCK = 251;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_TRACK_NUMBER = 215;
    private static final int ID_TRACK_TYPE = 131;
    private static final int ID_DEFAULT_DURATION = 2352003;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_CODEC_PRIVATE = 25506;
    private static final int ID_CODEC_DELAY = 22186;
    private static final int ID_SEEK_PRE_ROLL = 22203;
    private static final int ID_VIDEO = 224;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_DISPLAY_WIDTH = 21680;
    private static final int ID_DISPLAY_HEIGHT = 21690;
    private static final int ID_DISPLAY_UNIT = 21682;
    private static final int ID_AUDIO = 225;
    private static final int ID_CHANNELS = 159;
    private static final int ID_AUDIO_BIT_DEPTH = 25188;
    private static final int ID_SAMPLING_FREQUENCY = 181;
    private static final int ID_CONTENT_ENCODINGS = 28032;
    private static final int ID_CONTENT_ENCODING = 25152;
    private static final int ID_CONTENT_ENCODING_ORDER = 20529;
    private static final int ID_CONTENT_ENCODING_SCOPE = 20530;
    private static final int ID_CONTENT_COMPRESSION = 20532;
    private static final int ID_CONTENT_COMPRESSION_ALGORITHM = 16980;
    private static final int ID_CONTENT_COMPRESSION_SETTINGS = 16981;
    private static final int ID_CONTENT_ENCRYPTION = 20533;
    private static final int ID_CONTENT_ENCRYPTION_ALGORITHM = 18401;
    private static final int ID_CONTENT_ENCRYPTION_KEY_ID = 18402;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS = 18407;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS_CIPHER_MODE = 18408;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int ID_LANGUAGE = 2274716;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int LACING_FIXED_SIZE = 2;
    private static final int LACING_EBML = 3;
    private static final int FOURCC_COMPRESSION_VC1 = 826496599;
    private static final byte[] SUBRIP_PREFIX = new byte[]{49, 10, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 32, 45, 45, 62, 32, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 10};
    private static final byte[] SUBRIP_TIMECODE_EMPTY = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int SUBRIP_PREFIX_END_TIMECODE_OFFSET = 19;
    private static final int SUBRIP_TIMECODE_LENGTH = 12;
    private static final int WAVE_FORMAT_SIZE = 18;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final UUID WAVE_SUBFORMAT_PCM = new UUID(0x100000000001000L, -9223371306706625679L);
    private final EbmlReader reader;
    private final VarintReader varintReader;
    private final SparseArray<Track> tracks;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray scratch;
    private final ParsableByteArray vorbisNumPageSamples;
    private final ParsableByteArray seekEntryIdBytes;
    private final ParsableByteArray sampleStrippedBytes;
    private final ParsableByteArray subripSample;
    private final ParsableByteArray encryptionInitializationVector;
    private final ParsableByteArray encryptionSubsampleData;
    private ByteBuffer encryptionSubsampleDataBuffer;
    private long segmentContentPosition = -1L;
    private long segmentContentSize = -1L;
    private long timecodeScale = -1L;
    private long durationTimecode = -1L;
    private long durationUs = -1L;
    private Track currentTrack;
    private boolean sentDrmInitData;
    private boolean sentSeekMap;
    private int seekEntryId;
    private long seekEntryPosition;
    private boolean seekForCues;
    private long cuesContentPosition = -1L;
    private long seekPositionAfterBuildingCues = -1L;
    private long clusterTimecodeUs = -1L;
    private LongArray cueTimesUs;
    private LongArray cueClusterPositions;
    private boolean seenClusterPositionForCurrentCuePoint;
    private int blockState;
    private long blockTimeUs;
    private long blockDurationUs;
    private int blockLacingSampleIndex;
    private int blockLacingSampleCount;
    private int[] blockLacingSampleSizes;
    private int blockTrackNumber;
    private int blockTrackNumberLength;
    private int blockFlags;
    private int sampleBytesRead;
    private boolean sampleEncodingHandled;
    private boolean sampleSignalByteRead;
    private boolean sampleInitializationVectorRead;
    private boolean samplePartitionCountRead;
    private byte sampleSignalByte;
    private int samplePartitionCount;
    private int sampleCurrentNalBytesRemaining;
    private int sampleBytesWritten;
    private boolean sampleRead;
    private boolean sampleSeenReferenceBlock;
    private ExtractorOutput extractorOutput;

    public WebmExtractor() {
        this(new DefaultEbmlReader());
    }

    WebmExtractor(EbmlReader reader) {
        this.reader = reader;
        this.reader.init(new InnerEbmlReaderOutput());
        this.varintReader = new VarintReader();
        this.tracks = new SparseArray();
        this.scratch = new ParsableByteArray(4);
        this.vorbisNumPageSamples = new ParsableByteArray(ByteBuffer.allocate(4).putInt(-1).array());
        this.seekEntryIdBytes = new ParsableByteArray(4);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.sampleStrippedBytes = new ParsableByteArray();
        this.subripSample = new ParsableByteArray();
        this.encryptionInitializationVector = new ParsableByteArray(8);
        this.encryptionSubsampleData = new ParsableByteArray();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        return new Sniffer().sniff(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
    }

    @Override
    public void seek() {
        this.clusterTimecodeUs = -1L;
        this.blockState = 0;
        this.reader.reset();
        this.varintReader.reset();
        this.resetSample();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        this.sampleRead = false;
        boolean continueReading = true;
        while (continueReading && !this.sampleRead) {
            continueReading = this.reader.read(input);
            if (!continueReading || !this.maybeSeekForCues(seekPosition, input.getPosition())) continue;
            return 1;
        }
        return continueReading ? 0 : -1;
    }

    int getElementType(int id) {
        switch (id) {
            case 160: 
            case 174: 
            case 183: 
            case 187: 
            case 224: 
            case 225: 
            case 18407: 
            case 19899: 
            case 20532: 
            case 20533: 
            case 25152: 
            case 28032: 
            case 290298740: 
            case 357149030: 
            case 374648427: 
            case 408125543: 
            case 440786851: 
            case 475249515: 
            case 524531317: {
                return 1;
            }
            case 131: 
            case 155: 
            case 159: 
            case 176: 
            case 179: 
            case 186: 
            case 215: 
            case 231: 
            case 241: 
            case 251: 
            case 16980: 
            case 17029: 
            case 17143: 
            case 18401: 
            case 18408: 
            case 20529: 
            case 20530: 
            case 21420: 
            case 21680: 
            case 21682: 
            case 21690: 
            case 22186: 
            case 22203: 
            case 25188: 
            case 2352003: 
            case 2807729: {
                return 2;
            }
            case 134: 
            case 17026: 
            case 2274716: {
                return 3;
            }
            case 161: 
            case 163: 
            case 16981: 
            case 18402: 
            case 21419: 
            case 25506: {
                return 4;
            }
            case 181: 
            case 17545: {
                return 5;
            }
        }
        return 0;
    }

    boolean isLevel1Element(int id) {
        return id == 357149030 || id == 524531317 || id == 475249515 || id == 374648427;
    }

    void startMasterElement(int id, long contentPosition, long contentSize) throws ParserException {
        switch (id) {
            case 408125543: {
                if (this.segmentContentPosition != -1L && this.segmentContentPosition != contentPosition) {
                    throw new ParserException("Multiple Segment elements not supported");
                }
                this.segmentContentPosition = contentPosition;
                this.segmentContentSize = contentSize;
                return;
            }
            case 19899: {
                this.seekEntryId = -1;
                this.seekEntryPosition = -1L;
                return;
            }
            case 475249515: {
                this.cueTimesUs = new LongArray();
                this.cueClusterPositions = new LongArray();
                return;
            }
            case 187: {
                this.seenClusterPositionForCurrentCuePoint = false;
                return;
            }
            case 524531317: {
                if (!this.sentSeekMap) {
                    if (this.cuesContentPosition != -1L) {
                        this.seekForCues = true;
                    } else {
                        this.extractorOutput.seekMap(SeekMap.UNSEEKABLE);
                        this.sentSeekMap = true;
                    }
                }
                return;
            }
            case 160: {
                this.sampleSeenReferenceBlock = false;
                return;
            }
            case 25152: {
                return;
            }
            case 20533: {
                this.currentTrack.hasContentEncryption = true;
                return;
            }
            case 174: {
                this.currentTrack = new Track();
                return;
            }
        }
    }

    void endMasterElement(int id) throws ParserException {
        switch (id) {
            case 357149030: {
                if (this.timecodeScale == -1L) {
                    this.timecodeScale = 1000000L;
                }
                if (this.durationTimecode != -1L) {
                    this.durationUs = this.scaleTimecodeToUs(this.durationTimecode);
                }
                return;
            }
            case 19899: {
                if (this.seekEntryId == -1 || this.seekEntryPosition == -1L) {
                    throw new ParserException("Mandatory element SeekID or SeekPosition not found");
                }
                if (this.seekEntryId == 475249515) {
                    this.cuesContentPosition = this.seekEntryPosition;
                }
                return;
            }
            case 475249515: {
                if (!this.sentSeekMap) {
                    this.extractorOutput.seekMap(this.buildSeekMap());
                    this.sentSeekMap = true;
                }
                return;
            }
            case 160: {
                if (this.blockState != 2) {
                    return;
                }
                if (!this.sampleSeenReferenceBlock) {
                    this.blockFlags |= 1;
                }
                this.commitSampleToOutput((Track)this.tracks.get(this.blockTrackNumber), this.blockTimeUs);
                this.blockState = 0;
                return;
            }
            case 25152: {
                if (this.currentTrack.hasContentEncryption) {
                    if (this.currentTrack.encryptionKeyId == null) {
                        throw new ParserException("Encrypted Track found but ContentEncKeyID was not found");
                    }
                    if (!this.sentDrmInitData) {
                        this.extractorOutput.drmInitData(new DrmInitData.Universal(new DrmInitData.SchemeInitData("video/webm", this.currentTrack.encryptionKeyId)));
                        this.sentDrmInitData = true;
                    }
                }
                return;
            }
            case 28032: {
                if (this.currentTrack.hasContentEncryption && this.currentTrack.sampleStrippedBytes != null) {
                    throw new ParserException("Combining encryption and compression is not supported");
                }
                return;
            }
            case 174: {
                if (this.tracks.get(this.currentTrack.number) == null && WebmExtractor.isCodecSupported(this.currentTrack.codecId)) {
                    this.currentTrack.initializeOutput(this.extractorOutput, this.currentTrack.number, this.durationUs);
                    this.tracks.put(this.currentTrack.number, (Object)this.currentTrack);
                }
                this.currentTrack = null;
                return;
            }
            case 374648427: {
                if (this.tracks.size() == 0) {
                    throw new ParserException("No valid tracks were found");
                }
                this.extractorOutput.endTracks();
                return;
            }
        }
    }

    void integerElement(int id, long value) throws ParserException {
        switch (id) {
            case 17143: {
                if (value != 1L) {
                    throw new ParserException("EBMLReadVersion " + value + " not supported");
                }
                return;
            }
            case 17029: {
                if (value < 1L || value > 2L) {
                    throw new ParserException("DocTypeReadVersion " + value + " not supported");
                }
                return;
            }
            case 21420: {
                this.seekEntryPosition = value + this.segmentContentPosition;
                return;
            }
            case 2807729: {
                this.timecodeScale = value;
                return;
            }
            case 176: {
                this.currentTrack.width = (int)value;
                return;
            }
            case 186: {
                this.currentTrack.height = (int)value;
                return;
            }
            case 21680: {
                this.currentTrack.displayWidth = (int)value;
                return;
            }
            case 21690: {
                this.currentTrack.displayHeight = (int)value;
                return;
            }
            case 21682: {
                this.currentTrack.displayUnit = (int)value;
                return;
            }
            case 215: {
                this.currentTrack.number = (int)value;
                return;
            }
            case 131: {
                this.currentTrack.type = (int)value;
                return;
            }
            case 2352003: {
                this.currentTrack.defaultSampleDurationNs = (int)value;
                return;
            }
            case 22186: {
                this.currentTrack.codecDelayNs = value;
                return;
            }
            case 22203: {
                this.currentTrack.seekPreRollNs = value;
                return;
            }
            case 159: {
                this.currentTrack.channelCount = (int)value;
                return;
            }
            case 25188: {
                this.currentTrack.audioBitDepth = (int)value;
                return;
            }
            case 251: {
                this.sampleSeenReferenceBlock = true;
                return;
            }
            case 20529: {
                if (value != 0L) {
                    throw new ParserException("ContentEncodingOrder " + value + " not supported");
                }
                return;
            }
            case 20530: {
                if (value != 1L) {
                    throw new ParserException("ContentEncodingScope " + value + " not supported");
                }
                return;
            }
            case 16980: {
                if (value != 3L) {
                    throw new ParserException("ContentCompAlgo " + value + " not supported");
                }
                return;
            }
            case 18401: {
                if (value != 5L) {
                    throw new ParserException("ContentEncAlgo " + value + " not supported");
                }
                return;
            }
            case 18408: {
                if (value != 1L) {
                    throw new ParserException("AESSettingsCipherMode " + value + " not supported");
                }
                return;
            }
            case 179: {
                this.cueTimesUs.add(this.scaleTimecodeToUs(value));
                return;
            }
            case 241: {
                if (!this.seenClusterPositionForCurrentCuePoint) {
                    this.cueClusterPositions.add(value);
                    this.seenClusterPositionForCurrentCuePoint = true;
                }
                return;
            }
            case 231: {
                this.clusterTimecodeUs = this.scaleTimecodeToUs(value);
                return;
            }
            case 155: {
                this.blockDurationUs = this.scaleTimecodeToUs(value);
                return;
            }
        }
    }

    void floatElement(int id, double value) {
        switch (id) {
            case 17545: {
                this.durationTimecode = (long)value;
                return;
            }
            case 181: {
                this.currentTrack.sampleRate = (int)value;
                return;
            }
        }
    }

    void stringElement(int id, String value) throws ParserException {
        switch (id) {
            case 17026: {
                if (!DOC_TYPE_WEBM.equals(value) && !DOC_TYPE_MATROSKA.equals(value)) {
                    throw new ParserException("DocType " + value + " not supported");
                }
                return;
            }
            case 134: {
                this.currentTrack.codecId = value;
                return;
            }
            case 2274716: {
                this.currentTrack.language = value;
                return;
            }
        }
    }

    void binaryElement(int id, int contentSize, ExtractorInput input) throws IOException, InterruptedException {
        switch (id) {
            case 21419: {
                Arrays.fill(this.seekEntryIdBytes.data, (byte)0);
                input.readFully(this.seekEntryIdBytes.data, 4 - contentSize, contentSize);
                this.seekEntryIdBytes.setPosition(0);
                this.seekEntryId = (int)this.seekEntryIdBytes.readUnsignedInt();
                return;
            }
            case 25506: {
                this.currentTrack.codecPrivate = new byte[contentSize];
                input.readFully(this.currentTrack.codecPrivate, 0, contentSize);
                return;
            }
            case 16981: {
                this.currentTrack.sampleStrippedBytes = new byte[contentSize];
                input.readFully(this.currentTrack.sampleStrippedBytes, 0, contentSize);
                return;
            }
            case 18402: {
                this.currentTrack.encryptionKeyId = new byte[contentSize];
                input.readFully(this.currentTrack.encryptionKeyId, 0, contentSize);
                return;
            }
            case 161: 
            case 163: {
                Track track;
                if (this.blockState == 0) {
                    this.blockTrackNumber = (int)this.varintReader.readUnsignedVarint(input, false, true, 8);
                    this.blockTrackNumberLength = this.varintReader.getLastLength();
                    this.blockDurationUs = -1L;
                    this.blockState = 1;
                    this.scratch.reset();
                }
                if ((track = (Track)this.tracks.get(this.blockTrackNumber)) == null) {
                    input.skipFully(contentSize - this.blockTrackNumberLength);
                    this.blockState = 0;
                    return;
                }
                if (this.blockState == 1) {
                    this.readScratch(input, 3);
                    int lacing = (this.scratch.data[2] & 6) >> 1;
                    if (lacing == 0) {
                        this.blockLacingSampleCount = 1;
                        this.blockLacingSampleSizes = WebmExtractor.ensureArrayCapacity(this.blockLacingSampleSizes, 1);
                        this.blockLacingSampleSizes[0] = contentSize - this.blockTrackNumberLength - 3;
                    } else {
                        int sampleIndex;
                        int headerSize;
                        int totalSamplesSize;
                        if (id != 163) {
                            throw new ParserException("Lacing only supported in SimpleBlocks.");
                        }
                        this.readScratch(input, 4);
                        this.blockLacingSampleCount = (this.scratch.data[3] & 0xFF) + 1;
                        this.blockLacingSampleSizes = WebmExtractor.ensureArrayCapacity(this.blockLacingSampleSizes, this.blockLacingSampleCount);
                        if (lacing == 2) {
                            int blockLacingSampleSize = (contentSize - this.blockTrackNumberLength - 4) / this.blockLacingSampleCount;
                            Arrays.fill(this.blockLacingSampleSizes, 0, this.blockLacingSampleCount, blockLacingSampleSize);
                        } else if (lacing == 1) {
                            totalSamplesSize = 0;
                            headerSize = 4;
                            for (sampleIndex = 0; sampleIndex < this.blockLacingSampleCount - 1; ++sampleIndex) {
                                int byteValue;
                                this.blockLacingSampleSizes[sampleIndex] = 0;
                                do {
                                    this.readScratch(input, ++headerSize);
                                    byteValue = this.scratch.data[headerSize - 1] & 0xFF;
                                    int n = sampleIndex;
                                    this.blockLacingSampleSizes[n] = this.blockLacingSampleSizes[n] + byteValue;
                                } while (byteValue == 255);
                                totalSamplesSize += this.blockLacingSampleSizes[sampleIndex];
                            }
                            this.blockLacingSampleSizes[this.blockLacingSampleCount - 1] = contentSize - this.blockTrackNumberLength - headerSize - totalSamplesSize;
                        } else if (lacing == 3) {
                            totalSamplesSize = 0;
                            headerSize = 4;
                            for (sampleIndex = 0; sampleIndex < this.blockLacingSampleCount - 1; ++sampleIndex) {
                                this.blockLacingSampleSizes[sampleIndex] = 0;
                                this.readScratch(input, ++headerSize);
                                if (this.scratch.data[headerSize - 1] == 0) {
                                    throw new ParserException("No valid varint length mask found");
                                }
                                long readValue = 0L;
                                for (int i = 0; i < 8; ++i) {
                                    int lengthMask = 1 << 7 - i;
                                    if ((this.scratch.data[headerSize - 1] & lengthMask) == 0) continue;
                                    int readPosition = headerSize - 1;
                                    this.readScratch(input, headerSize += i);
                                    readValue = this.scratch.data[readPosition++] & 0xFF & ~lengthMask;
                                    while (readPosition < headerSize) {
                                        readValue <<= 8;
                                        readValue |= (long)(this.scratch.data[readPosition++] & 0xFF);
                                    }
                                    if (sampleIndex <= 0) break;
                                    readValue -= (1L << 6 + i * 7) - 1L;
                                    break;
                                }
                                if (readValue < Integer.MIN_VALUE || readValue > Integer.MAX_VALUE) {
                                    throw new ParserException("EBML lacing sample size out of range.");
                                }
                                int intReadValue = (int)readValue;
                                this.blockLacingSampleSizes[sampleIndex] = sampleIndex == 0 ? intReadValue : this.blockLacingSampleSizes[sampleIndex - 1] + intReadValue;
                                totalSamplesSize += this.blockLacingSampleSizes[sampleIndex];
                            }
                            this.blockLacingSampleSizes[this.blockLacingSampleCount - 1] = contentSize - this.blockTrackNumberLength - headerSize - totalSamplesSize;
                        } else {
                            throw new ParserException("Unexpected lacing value: " + lacing);
                        }
                    }
                    int timecode = this.scratch.data[0] << 8 | this.scratch.data[1] & 0xFF;
                    this.blockTimeUs = this.clusterTimecodeUs + this.scaleTimecodeToUs(timecode);
                    boolean isInvisible = (this.scratch.data[2] & 8) == 8;
                    boolean isKeyframe = track.type == 2 || id == 163 && (this.scratch.data[2] & 0x80) == 128;
                    this.blockFlags = (isKeyframe ? 1 : 0) | (isInvisible ? 0x8000000 : 0);
                    this.blockState = 2;
                    this.blockLacingSampleIndex = 0;
                }
                if (id == 163) {
                    while (this.blockLacingSampleIndex < this.blockLacingSampleCount) {
                        this.writeSampleData(input, track, this.blockLacingSampleSizes[this.blockLacingSampleIndex]);
                        long sampleTimeUs = this.blockTimeUs + (long)(this.blockLacingSampleIndex * track.defaultSampleDurationNs / 1000);
                        this.commitSampleToOutput(track, sampleTimeUs);
                        ++this.blockLacingSampleIndex;
                    }
                    this.blockState = 0;
                } else {
                    this.writeSampleData(input, track, this.blockLacingSampleSizes[0]);
                }
                return;
            }
        }
        throw new ParserException("Unexpected id: " + id);
    }

    private void commitSampleToOutput(Track track, long timeUs) {
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            this.writeSubripSample(track);
        }
        track.output.sampleMetadata(timeUs, this.blockFlags, this.sampleBytesWritten, 0, track.encryptionKeyId);
        this.sampleRead = true;
        this.resetSample();
    }

    private void resetSample() {
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.sampleEncodingHandled = false;
        this.sampleSignalByteRead = false;
        this.samplePartitionCountRead = false;
        this.samplePartitionCount = 0;
        this.sampleSignalByte = 0;
        this.sampleInitializationVectorRead = false;
        this.sampleStrippedBytes.reset();
    }

    private void readScratch(ExtractorInput input, int requiredLength) throws IOException, InterruptedException {
        if (this.scratch.limit() >= requiredLength) {
            return;
        }
        if (this.scratch.capacity() < requiredLength) {
            this.scratch.reset(Arrays.copyOf(this.scratch.data, Math.max(this.scratch.data.length * 2, requiredLength)), this.scratch.limit());
        }
        input.readFully(this.scratch.data, this.scratch.limit(), requiredLength - this.scratch.limit());
        this.scratch.setLimit(requiredLength);
    }

    private void writeSampleData(ExtractorInput input, Track track, int size) throws IOException, InterruptedException {
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            int sizeWithPrefix = SUBRIP_PREFIX.length + size;
            if (this.subripSample.capacity() < sizeWithPrefix) {
                this.subripSample.data = Arrays.copyOf(SUBRIP_PREFIX, sizeWithPrefix + size);
            }
            input.readFully(this.subripSample.data, SUBRIP_PREFIX.length, size);
            this.subripSample.setPosition(0);
            this.subripSample.setLimit(sizeWithPrefix);
            return;
        }
        TrackOutput output = track.output;
        if (!this.sampleEncodingHandled) {
            if (track.hasContentEncryption) {
                boolean isEncrypted;
                this.blockFlags &= 0xFFFFFFFD;
                if (!this.sampleSignalByteRead) {
                    input.readFully(this.scratch.data, 0, 1);
                    ++this.sampleBytesRead;
                    if ((this.scratch.data[0] & 0x80) == 128) {
                        throw new ParserException("Extension bit is set in signal byte");
                    }
                    this.sampleSignalByte = this.scratch.data[0];
                    this.sampleSignalByteRead = true;
                }
                boolean bl = isEncrypted = (this.sampleSignalByte & 1) == 1;
                if (isEncrypted) {
                    boolean hasSubsampleEncryption = (this.sampleSignalByte & 2) == 2;
                    this.blockFlags |= 2;
                    if (!this.sampleInitializationVectorRead) {
                        input.readFully(this.encryptionInitializationVector.data, 0, 8);
                        this.sampleBytesRead += 8;
                        this.sampleInitializationVectorRead = true;
                        this.scratch.data[0] = (byte)(8 | (hasSubsampleEncryption ? 128 : 0));
                        this.scratch.setPosition(0);
                        output.sampleData(this.scratch, 1);
                        ++this.sampleBytesWritten;
                        this.encryptionInitializationVector.setPosition(0);
                        output.sampleData(this.encryptionInitializationVector, 8);
                        this.sampleBytesWritten += 8;
                    }
                    if (hasSubsampleEncryption) {
                        if (!this.samplePartitionCountRead) {
                            input.readFully(this.scratch.data, 0, 1);
                            ++this.sampleBytesRead;
                            this.scratch.setPosition(0);
                            this.samplePartitionCount = this.scratch.readUnsignedByte();
                            this.samplePartitionCountRead = true;
                        }
                        int samplePartitionDataSize = this.samplePartitionCount * 4;
                        if (this.scratch.limit() < samplePartitionDataSize) {
                            this.scratch.reset(new byte[samplePartitionDataSize], samplePartitionDataSize);
                        }
                        input.readFully(this.scratch.data, 0, samplePartitionDataSize);
                        this.sampleBytesRead += samplePartitionDataSize;
                        this.scratch.setPosition(0);
                        this.scratch.setLimit(samplePartitionDataSize);
                        short subsampleCount = (short)(1 + this.samplePartitionCount / 2);
                        int subsampleDataSize = 2 + 6 * subsampleCount;
                        if (this.encryptionSubsampleDataBuffer == null || this.encryptionSubsampleDataBuffer.capacity() < subsampleDataSize) {
                            this.encryptionSubsampleDataBuffer = ByteBuffer.allocate(subsampleDataSize);
                        }
                        this.encryptionSubsampleDataBuffer.position(0);
                        this.encryptionSubsampleDataBuffer.putShort(subsampleCount);
                        int partitionOffset = 0;
                        for (int i = 0; i < this.samplePartitionCount; ++i) {
                            int previousPartitionOffset = partitionOffset;
                            partitionOffset = this.scratch.readUnsignedIntToInt();
                            if (i % 2 == 0) {
                                this.encryptionSubsampleDataBuffer.putShort((short)(partitionOffset - previousPartitionOffset));
                                continue;
                            }
                            this.encryptionSubsampleDataBuffer.putInt(partitionOffset - previousPartitionOffset);
                        }
                        int finalPartitionSize = size - this.sampleBytesRead - partitionOffset;
                        if (this.samplePartitionCount % 2 == 1) {
                            this.encryptionSubsampleDataBuffer.putInt(finalPartitionSize);
                        } else {
                            this.encryptionSubsampleDataBuffer.putShort((short)finalPartitionSize);
                            this.encryptionSubsampleDataBuffer.putInt(0);
                        }
                        this.encryptionSubsampleData.reset(this.encryptionSubsampleDataBuffer.array(), subsampleDataSize);
                        output.sampleData(this.encryptionSubsampleData, subsampleDataSize);
                        this.sampleBytesWritten += subsampleDataSize;
                    }
                }
            } else if (track.sampleStrippedBytes != null) {
                this.sampleStrippedBytes.reset(track.sampleStrippedBytes, track.sampleStrippedBytes.length);
            }
            this.sampleEncodingHandled = true;
        }
        size += this.sampleStrippedBytes.limit();
        if (CODEC_ID_H264.equals(track.codecId) || CODEC_ID_H265.equals(track.codecId)) {
            byte[] nalLengthData = this.nalLength.data;
            nalLengthData[0] = 0;
            nalLengthData[1] = 0;
            nalLengthData[2] = 0;
            int nalUnitLengthFieldLength = track.nalUnitLengthFieldLength;
            int nalUnitLengthFieldLengthDiff = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesRead < size) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    this.readToTarget(input, nalLengthData, nalUnitLengthFieldLengthDiff, nalUnitLengthFieldLength);
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    output.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    continue;
                }
                this.sampleCurrentNalBytesRemaining -= this.readToOutput(input, output, this.sampleCurrentNalBytesRemaining);
            }
        } else {
            while (this.sampleBytesRead < size) {
                this.readToOutput(input, output, size - this.sampleBytesRead);
            }
        }
        if (CODEC_ID_VORBIS.equals(track.codecId)) {
            this.vorbisNumPageSamples.setPosition(0);
            output.sampleData(this.vorbisNumPageSamples, 4);
            this.sampleBytesWritten += 4;
        }
    }

    private void writeSubripSample(Track track) {
        WebmExtractor.setSubripSampleEndTimecode(this.subripSample.data, this.blockDurationUs);
        track.output.sampleData(this.subripSample, this.subripSample.limit());
        this.sampleBytesWritten += this.subripSample.limit();
    }

    private static void setSubripSampleEndTimecode(byte[] subripSampleData, long timeUs) {
        byte[] timeCodeData;
        if (timeUs == -1L) {
            timeCodeData = SUBRIP_TIMECODE_EMPTY;
        } else {
            int hours = (int)(timeUs / 3600000000L);
            int minutes = (int)((timeUs -= (long)hours * 3600000000L) / 60000000L);
            int seconds = (int)((timeUs -= (long)(minutes * 60000000)) / 1000000L);
            int milliseconds = (int)((timeUs -= (long)(seconds * 1000000)) / 1000L);
            timeCodeData = String.format(Locale.US, "%02d:%02d:%02d,%03d", hours, minutes, seconds, milliseconds).getBytes();
        }
        System.arraycopy(timeCodeData, 0, subripSampleData, 19, 12);
    }

    private void readToTarget(ExtractorInput input, byte[] target, int offset, int length) throws IOException, InterruptedException {
        int pendingStrippedBytes = Math.min(length, this.sampleStrippedBytes.bytesLeft());
        input.readFully(target, offset + pendingStrippedBytes, length - pendingStrippedBytes);
        if (pendingStrippedBytes > 0) {
            this.sampleStrippedBytes.readBytes(target, offset, pendingStrippedBytes);
        }
        this.sampleBytesRead += length;
    }

    private int readToOutput(ExtractorInput input, TrackOutput output, int length) throws IOException, InterruptedException {
        int bytesRead;
        int strippedBytesLeft = this.sampleStrippedBytes.bytesLeft();
        if (strippedBytesLeft > 0) {
            bytesRead = Math.min(length, strippedBytesLeft);
            output.sampleData(this.sampleStrippedBytes, bytesRead);
        } else {
            bytesRead = output.sampleData(input, length, false);
        }
        this.sampleBytesRead += bytesRead;
        this.sampleBytesWritten += bytesRead;
        return bytesRead;
    }

    private SeekMap buildSeekMap() {
        int i;
        if (this.segmentContentPosition == -1L || this.durationUs == -1L || this.cueTimesUs == null || this.cueTimesUs.size() == 0 || this.cueClusterPositions == null || this.cueClusterPositions.size() != this.cueTimesUs.size()) {
            this.cueTimesUs = null;
            this.cueClusterPositions = null;
            return SeekMap.UNSEEKABLE;
        }
        int cuePointsSize = this.cueTimesUs.size();
        int[] sizes = new int[cuePointsSize];
        long[] offsets = new long[cuePointsSize];
        long[] durationsUs = new long[cuePointsSize];
        long[] timesUs = new long[cuePointsSize];
        for (i = 0; i < cuePointsSize; ++i) {
            timesUs[i] = this.cueTimesUs.get(i);
            offsets[i] = this.segmentContentPosition + this.cueClusterPositions.get(i);
        }
        for (i = 0; i < cuePointsSize - 1; ++i) {
            sizes[i] = (int)(offsets[i + 1] - offsets[i]);
            durationsUs[i] = timesUs[i + 1] - timesUs[i];
        }
        sizes[cuePointsSize - 1] = (int)(this.segmentContentPosition + this.segmentContentSize - offsets[cuePointsSize - 1]);
        durationsUs[cuePointsSize - 1] = this.durationUs - timesUs[cuePointsSize - 1];
        this.cueTimesUs = null;
        this.cueClusterPositions = null;
        return new ChunkIndex(sizes, offsets, durationsUs, timesUs);
    }

    private boolean maybeSeekForCues(PositionHolder seekPosition, long currentPosition) {
        if (this.seekForCues) {
            this.seekPositionAfterBuildingCues = currentPosition;
            seekPosition.position = this.cuesContentPosition;
            this.seekForCues = false;
            return true;
        }
        if (this.sentSeekMap && this.seekPositionAfterBuildingCues != -1L) {
            seekPosition.position = this.seekPositionAfterBuildingCues;
            this.seekPositionAfterBuildingCues = -1L;
            return true;
        }
        return false;
    }

    private long scaleTimecodeToUs(long unscaledTimecode) throws ParserException {
        if (this.timecodeScale == -1L) {
            throw new ParserException("Can't scale timecode prior to timecodeScale being set.");
        }
        return Util.scaleLargeTimestamp(unscaledTimecode, this.timecodeScale, 1000L);
    }

    private static boolean isCodecSupported(String codecId) {
        return CODEC_ID_VP8.equals(codecId) || CODEC_ID_VP9.equals(codecId) || CODEC_ID_MPEG2.equals(codecId) || CODEC_ID_MPEG4_SP.equals(codecId) || CODEC_ID_MPEG4_ASP.equals(codecId) || CODEC_ID_MPEG4_AP.equals(codecId) || CODEC_ID_H264.equals(codecId) || CODEC_ID_H265.equals(codecId) || CODEC_ID_FOURCC.equals(codecId) || CODEC_ID_OPUS.equals(codecId) || CODEC_ID_VORBIS.equals(codecId) || CODEC_ID_AAC.equals(codecId) || CODEC_ID_MP3.equals(codecId) || CODEC_ID_AC3.equals(codecId) || CODEC_ID_E_AC3.equals(codecId) || CODEC_ID_TRUEHD.equals(codecId) || CODEC_ID_DTS.equals(codecId) || CODEC_ID_DTS_EXPRESS.equals(codecId) || CODEC_ID_DTS_LOSSLESS.equals(codecId) || CODEC_ID_FLAC.equals(codecId) || CODEC_ID_ACM.equals(codecId) || CODEC_ID_PCM_INT_LIT.equals(codecId) || CODEC_ID_SUBRIP.equals(codecId) || CODEC_ID_VOBSUB.equals(codecId) || CODEC_ID_PGS.equals(codecId);
    }

    private static int[] ensureArrayCapacity(int[] array, int length) {
        if (array == null) {
            return new int[length];
        }
        if (array.length >= length) {
            return array;
        }
        return new int[Math.max(array.length * 2, length)];
    }

    private static final class Track {
        private static final int DISPLAY_UNIT_PIXELS = 0;
        public String codecId;
        public int number;
        public int type;
        public int defaultSampleDurationNs;
        public boolean hasContentEncryption;
        public byte[] sampleStrippedBytes;
        public byte[] encryptionKeyId;
        public byte[] codecPrivate;
        public int width = -1;
        public int height = -1;
        public int displayWidth = -1;
        public int displayHeight = -1;
        public int displayUnit = 0;
        public int channelCount = 1;
        public int audioBitDepth = -1;
        public int sampleRate = 8000;
        public long codecDelayNs = 0L;
        public long seekPreRollNs = 0L;
        private String language = "eng";
        public TrackOutput output;
        public int nalUnitLengthFieldLength;

        private Track() {
        }

        public void initializeOutput(ExtractorOutput output, int trackId, long durationUs) throws ParserException {
            MediaFormat format;
            String mimeType;
            int maxInputSize = -1;
            int pcmEncoding = -1;
            List initializationData = null;
            switch (this.codecId) {
                case "V_VP8": {
                    mimeType = "video/x-vnd.on2.vp8";
                    break;
                }
                case "V_VP9": {
                    mimeType = "video/x-vnd.on2.vp9";
                    break;
                }
                case "V_MPEG2": {
                    mimeType = "video/mpeg2";
                    break;
                }
                case "V_MPEG4/ISO/SP": 
                case "V_MPEG4/ISO/ASP": 
                case "V_MPEG4/ISO/AP": {
                    mimeType = "video/mp4v-es";
                    initializationData = this.codecPrivate == null ? null : Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "V_MPEG4/ISO/AVC": {
                    mimeType = "video/avc";
                    Pair<List<byte[]>, Integer> h264Data = Track.parseAvcCodecPrivate(new ParsableByteArray(this.codecPrivate));
                    initializationData = (List)h264Data.first;
                    this.nalUnitLengthFieldLength = (Integer)h264Data.second;
                    break;
                }
                case "V_MPEGH/ISO/HEVC": {
                    mimeType = "video/hevc";
                    Pair<List<byte[]>, Integer> hevcData = Track.parseHevcCodecPrivate(new ParsableByteArray(this.codecPrivate));
                    initializationData = (List)hevcData.first;
                    this.nalUnitLengthFieldLength = (Integer)hevcData.second;
                    break;
                }
                case "V_MS/VFW/FOURCC": {
                    mimeType = "video/wvc1";
                    initializationData = Track.parseFourCcVc1Private(new ParsableByteArray(this.codecPrivate));
                    break;
                }
                case "A_VORBIS": {
                    mimeType = "audio/vorbis";
                    maxInputSize = 8192;
                    initializationData = Track.parseVorbisCodecPrivate(this.codecPrivate);
                    break;
                }
                case "A_OPUS": {
                    mimeType = "audio/opus";
                    maxInputSize = 5760;
                    initializationData = new ArrayList<byte[]>(3);
                    initializationData.add(this.codecPrivate);
                    initializationData.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.codecDelayNs).array());
                    initializationData.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.seekPreRollNs).array());
                    break;
                }
                case "A_AAC": {
                    mimeType = "audio/mp4a-latm";
                    initializationData = Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "A_MPEG/L3": {
                    mimeType = "audio/mpeg";
                    maxInputSize = 4096;
                    break;
                }
                case "A_AC3": {
                    mimeType = "audio/ac3";
                    break;
                }
                case "A_EAC3": {
                    mimeType = "audio/eac3";
                    break;
                }
                case "A_TRUEHD": {
                    mimeType = "audio/true-hd";
                    break;
                }
                case "A_DTS": 
                case "A_DTS/EXPRESS": {
                    mimeType = "audio/vnd.dts";
                    break;
                }
                case "A_DTS/LOSSLESS": {
                    mimeType = "audio/vnd.dts.hd";
                    break;
                }
                case "A_FLAC": {
                    mimeType = "audio/x-flac";
                    initializationData = Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "A_MS/ACM": {
                    mimeType = "audio/raw";
                    if (!Track.parseMsAcmCodecPrivate(new ParsableByteArray(this.codecPrivate))) {
                        throw new ParserException("Non-PCM MS/ACM is unsupported");
                    }
                    pcmEncoding = Util.getPcmEncoding(this.audioBitDepth);
                    if (pcmEncoding != 0) break;
                    throw new ParserException("Unsupported PCM bit depth: " + this.audioBitDepth);
                }
                case "A_PCM/INT/LIT": {
                    mimeType = "audio/raw";
                    pcmEncoding = Util.getPcmEncoding(this.audioBitDepth);
                    if (pcmEncoding != 0) break;
                    throw new ParserException("Unsupported PCM bit depth: " + this.audioBitDepth);
                }
                case "S_TEXT/UTF8": {
                    mimeType = "application/x-subrip";
                    break;
                }
                case "S_VOBSUB": {
                    mimeType = "application/vobsub";
                    initializationData = Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "S_HDMV/PGS": {
                    mimeType = "application/pgs";
                    break;
                }
                default: {
                    throw new ParserException("Unrecognized codec identifier.");
                }
            }
            if (MimeTypes.isAudio(mimeType)) {
                format = MediaFormat.createAudioFormat(Integer.toString(trackId), mimeType, -1, maxInputSize, durationUs, this.channelCount, this.sampleRate, initializationData, this.language, pcmEncoding);
            } else if (MimeTypes.isVideo(mimeType)) {
                if (this.displayUnit == 0) {
                    this.displayWidth = this.displayWidth == -1 ? this.width : this.displayWidth;
                    this.displayHeight = this.displayHeight == -1 ? this.height : this.displayHeight;
                }
                float pixelWidthHeightRatio = -1.0f;
                if (this.displayWidth != -1 && this.displayHeight != -1) {
                    pixelWidthHeightRatio = (float)(this.height * this.displayWidth) / (float)(this.width * this.displayHeight);
                }
                format = MediaFormat.createVideoFormat(Integer.toString(trackId), mimeType, -1, maxInputSize, durationUs, this.width, this.height, initializationData, -1, pixelWidthHeightRatio);
            } else if ("application/x-subrip".equals(mimeType)) {
                format = MediaFormat.createTextFormat(Integer.toString(trackId), mimeType, -1, durationUs, this.language);
            } else if ("application/vobsub".equals(mimeType) || "application/pgs".equals(mimeType)) {
                format = MediaFormat.createImageFormat(Integer.toString(trackId), mimeType, -1, durationUs, initializationData, this.language);
            } else {
                throw new ParserException("Unexpected MIME type.");
            }
            this.output = output.track(this.number);
            this.output.format(format);
        }

        private static List<byte[]> parseFourCcVc1Private(ParsableByteArray buffer) throws ParserException {
            try {
                buffer.skipBytes(16);
                long compression = buffer.readLittleEndianUnsignedInt();
                if (compression != 826496599L) {
                    throw new ParserException("Unsupported FourCC compression type: " + compression);
                }
                int startOffset = buffer.getPosition() + 20;
                byte[] bufferData = buffer.data;
                for (int offset = startOffset; offset < bufferData.length - 4; ++offset) {
                    if (bufferData[offset] != 0 || bufferData[offset + 1] != 0 || bufferData[offset + 2] != 1 || bufferData[offset + 3] != 15) continue;
                    byte[] initializationData = Arrays.copyOfRange(bufferData, offset, bufferData.length);
                    return Collections.singletonList(initializationData);
                }
                throw new ParserException("Failed to find FourCC VC1 initialization data");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParserException("Error parsing FourCC VC1 codec private");
            }
        }

        private static Pair<List<byte[]>, Integer> parseAvcCodecPrivate(ParsableByteArray buffer) throws ParserException {
            try {
                buffer.setPosition(4);
                int nalUnitLengthFieldLength = (buffer.readUnsignedByte() & 3) + 1;
                if (nalUnitLengthFieldLength == 3) {
                    throw new ParserException();
                }
                ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
                int numSequenceParameterSets = buffer.readUnsignedByte() & 0x1F;
                for (int i = 0; i < numSequenceParameterSets; ++i) {
                    initializationData.add(NalUnitUtil.parseChildNalUnit(buffer));
                }
                int numPictureParameterSets = buffer.readUnsignedByte();
                for (int j = 0; j < numPictureParameterSets; ++j) {
                    initializationData.add(NalUnitUtil.parseChildNalUnit(buffer));
                }
                return Pair.create(initializationData, (Object)nalUnitLengthFieldLength);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParserException("Error parsing AVC codec private");
            }
        }

        private static Pair<List<byte[]>, Integer> parseHevcCodecPrivate(ParsableByteArray parent) throws ParserException {
            try {
                parent.setPosition(21);
                int lengthSizeMinusOne = parent.readUnsignedByte() & 3;
                int numberOfArrays = parent.readUnsignedByte();
                int csdLength = 0;
                int csdStartPosition = parent.getPosition();
                for (int i = 0; i < numberOfArrays; ++i) {
                    parent.skipBytes(1);
                    int numberOfNalUnits = parent.readUnsignedShort();
                    for (int j = 0; j < numberOfNalUnits; ++j) {
                        int nalUnitLength = parent.readUnsignedShort();
                        csdLength += 4 + nalUnitLength;
                        parent.skipBytes(nalUnitLength);
                    }
                }
                parent.setPosition(csdStartPosition);
                byte[] buffer = new byte[csdLength];
                int bufferPosition = 0;
                for (int i = 0; i < numberOfArrays; ++i) {
                    parent.skipBytes(1);
                    int numberOfNalUnits = parent.readUnsignedShort();
                    for (int j = 0; j < numberOfNalUnits; ++j) {
                        int nalUnitLength = parent.readUnsignedShort();
                        System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, buffer, bufferPosition, NalUnitUtil.NAL_START_CODE.length);
                        System.arraycopy(parent.data, parent.getPosition(), buffer, bufferPosition += NalUnitUtil.NAL_START_CODE.length, nalUnitLength);
                        bufferPosition += nalUnitLength;
                        parent.skipBytes(nalUnitLength);
                    }
                }
                List<byte[]> initializationData = csdLength == 0 ? null : Collections.singletonList(buffer);
                return Pair.create(initializationData, (Object)(lengthSizeMinusOne + 1));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParserException("Error parsing HEVC codec private");
            }
        }

        private static List<byte[]> parseVorbisCodecPrivate(byte[] codecPrivate) throws ParserException {
            try {
                if (codecPrivate[0] != 2) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                int offset = 1;
                int vorbisInfoLength = 0;
                while (codecPrivate[offset] == -1) {
                    vorbisInfoLength += 255;
                    ++offset;
                }
                vorbisInfoLength += codecPrivate[offset++];
                int vorbisSkipLength = 0;
                while (codecPrivate[offset] == -1) {
                    vorbisSkipLength += 255;
                    ++offset;
                }
                vorbisSkipLength += codecPrivate[offset++];
                if (codecPrivate[offset] != 1) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                byte[] vorbisInfo = new byte[vorbisInfoLength];
                System.arraycopy(codecPrivate, offset, vorbisInfo, 0, vorbisInfoLength);
                if (codecPrivate[offset += vorbisInfoLength] != 3) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                if (codecPrivate[offset += vorbisSkipLength] != 5) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                byte[] vorbisBooks = new byte[codecPrivate.length - offset];
                System.arraycopy(codecPrivate, offset, vorbisBooks, 0, codecPrivate.length - offset);
                ArrayList<byte[]> initializationData = new ArrayList<byte[]>(2);
                initializationData.add(vorbisInfo);
                initializationData.add(vorbisBooks);
                return initializationData;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParserException("Error parsing vorbis codec private");
            }
        }

        private static boolean parseMsAcmCodecPrivate(ParsableByteArray buffer) throws ParserException {
            try {
                int formatTag = buffer.readLittleEndianUnsignedShort();
                if (formatTag == 1) {
                    return true;
                }
                if (formatTag == 65534) {
                    buffer.setPosition(24);
                    return buffer.readLong() == WAVE_SUBFORMAT_PCM.getMostSignificantBits() && buffer.readLong() == WAVE_SUBFORMAT_PCM.getLeastSignificantBits();
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParserException("Error parsing MS/ACM codec private");
            }
        }
    }

    private final class InnerEbmlReaderOutput
    implements EbmlReaderOutput {
        private InnerEbmlReaderOutput() {
        }

        @Override
        public int getElementType(int id) {
            return WebmExtractor.this.getElementType(id);
        }

        @Override
        public boolean isLevel1Element(int id) {
            return WebmExtractor.this.isLevel1Element(id);
        }

        @Override
        public void startMasterElement(int id, long contentPosition, long contentSize) throws ParserException {
            WebmExtractor.this.startMasterElement(id, contentPosition, contentSize);
        }

        @Override
        public void endMasterElement(int id) throws ParserException {
            WebmExtractor.this.endMasterElement(id);
        }

        @Override
        public void integerElement(int id, long value) throws ParserException {
            WebmExtractor.this.integerElement(id, value);
        }

        @Override
        public void floatElement(int id, double value) throws ParserException {
            WebmExtractor.this.floatElement(id, value);
        }

        @Override
        public void stringElement(int id, String value) throws ParserException {
            WebmExtractor.this.stringElement(id, value);
        }

        @Override
        public void binaryElement(int id, int contentsSize, ExtractorInput input) throws IOException, InterruptedException {
            WebmExtractor.this.binaryElement(id, contentsSize, input);
        }
    }
}

