/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.exoplayer.chunk.VideoFormatSelectorUtil;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.Variant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefaultHlsTrackSelector
implements HlsTrackSelector {
    private static final int TYPE_DEFAULT = 0;
    private static final int TYPE_AUDIO = 1;
    private static final int TYPE_SUBTITLE = 2;
    private final Context context;
    private final int type;

    public static DefaultHlsTrackSelector newDefaultInstance(Context context) {
        return new DefaultHlsTrackSelector(context, 0);
    }

    public static DefaultHlsTrackSelector newAudioInstance() {
        return new DefaultHlsTrackSelector(null, 1);
    }

    public static DefaultHlsTrackSelector newSubtitleInstance() {
        return new DefaultHlsTrackSelector(null, 2);
    }

    private DefaultHlsTrackSelector(Context context, int type) {
        this.context = context;
        this.type = type;
    }

    @Override
    public void selectTracks(HlsMasterPlaylist playlist, HlsTrackSelector.Output output) throws IOException {
        int i;
        if (this.type == 1 || this.type == 2) {
            List<Variant> variants;
            List<Variant> list = variants = this.type == 1 ? playlist.audios : playlist.subtitles;
            if (variants != null && !variants.isEmpty()) {
                for (int i2 = 0; i2 < variants.size(); ++i2) {
                    output.fixedTrack(playlist, variants.get(i2));
                }
            }
            return;
        }
        ArrayList<Variant> enabledVariantList = new ArrayList<Variant>();
        int[] variantIndices = VideoFormatSelectorUtil.selectVideoFormatsForDefaultDisplay(this.context, playlist.variants, null, false);
        for (int i3 = 0; i3 < variantIndices.length; ++i3) {
            enabledVariantList.add(playlist.variants.get(variantIndices[i3]));
        }
        ArrayList<Variant> definiteVideoVariants = new ArrayList<Variant>();
        ArrayList<Variant> definiteAudioOnlyVariants = new ArrayList<Variant>();
        for (i = 0; i < enabledVariantList.size(); ++i) {
            Variant variant = (Variant)enabledVariantList.get(i);
            if (variant.format.height > 0 || DefaultHlsTrackSelector.variantHasExplicitCodecWithPrefix(variant, "avc")) {
                definiteVideoVariants.add(variant);
                continue;
            }
            if (!DefaultHlsTrackSelector.variantHasExplicitCodecWithPrefix(variant, "mp4a")) continue;
            definiteAudioOnlyVariants.add(variant);
        }
        if (!definiteVideoVariants.isEmpty()) {
            enabledVariantList = definiteVideoVariants;
        } else if (definiteAudioOnlyVariants.size() < enabledVariantList.size()) {
            enabledVariantList.removeAll(definiteAudioOnlyVariants);
        }
        if (enabledVariantList.size() > 1) {
            Variant[] enabledVariants = new Variant[enabledVariantList.size()];
            enabledVariantList.toArray(enabledVariants);
            output.adaptiveTrack(playlist, enabledVariants);
        }
        for (i = 0; i < enabledVariantList.size(); ++i) {
            output.fixedTrack(playlist, (Variant)enabledVariantList.get(i));
        }
    }

    private static boolean variantHasExplicitCodecWithPrefix(Variant variant, String prefix) {
        String codecs = variant.format.codecs;
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return false;
        }
        String[] codecArray = codecs.split("(\\s*,\\s*)|(\\s*$)");
        for (int i = 0; i < codecArray.length; ++i) {
            if (!codecArray[i].startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

