/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.DataChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer.extractor.ts.PtsTimestampAdjuster;
import com.google.android.exoplayer.extractor.ts.TsExtractor;
import com.google.android.exoplayer.hls.HlsExtractorWrapper;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsMediaPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.PtsTimestampAdjusterProvider;
import com.google.android.exoplayer.hls.TsChunk;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.hls.WebvttExtractor;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.HttpDataSource;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.UriUtil;
import com.google.android.exoplayer.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

public class HlsChunkSource
implements HlsTrackSelector.Output {
    public static final long DEFAULT_MIN_BUFFER_TO_SWITCH_UP_MS = 5000L;
    public static final long DEFAULT_MAX_BUFFER_TO_SWITCH_DOWN_MS = 20000L;
    public static final long DEFAULT_PLAYLIST_BLACKLIST_MS = 60000L;
    private static final double LIVE_VARIANT_SWITCH_SAFETY_EXTRA_SECS = 2.0;
    private static final String TAG = "HlsChunkSource";
    private static final String AAC_FILE_EXTENSION = ".aac";
    private static final String MP3_FILE_EXTENSION = ".mp3";
    private static final String VTT_FILE_EXTENSION = ".vtt";
    private static final String WEBVTT_FILE_EXTENSION = ".webvtt";
    private static final float BANDWIDTH_FRACTION = 0.8f;
    private final boolean isMaster;
    private final DataSource dataSource;
    private final HlsPlaylistParser playlistParser;
    private final HlsMasterPlaylist masterPlaylist;
    private final HlsTrackSelector trackSelector;
    private final BandwidthMeter bandwidthMeter;
    private final PtsTimestampAdjusterProvider timestampAdjusterProvider;
    private final String baseUri;
    private final long minBufferDurationToSwitchUpUs;
    private final long maxBufferDurationToSwitchDownUs;
    private final ArrayList<ExposedTrack> tracks;
    private int selectedTrackIndex;
    private Variant[] variants;
    private HlsMediaPlaylist[] variantPlaylists;
    private long[] variantLastPlaylistLoadTimesMs;
    private long[] variantBlacklistTimes;
    private int selectedVariantIndex;
    private boolean prepareCalled;
    private byte[] scratchSpace;
    private boolean live;
    private long durationUs;
    private IOException fatalError;
    private Uri encryptionKeyUri;
    private byte[] encryptionKey;
    private String encryptionIvString;
    private byte[] encryptionIv;
    private final EventListener eventListener;
    private final Handler eventHandler;

    public HlsChunkSource(boolean isMaster, DataSource dataSource, HlsPlaylist playlist, HlsTrackSelector trackSelector, BandwidthMeter bandwidthMeter, PtsTimestampAdjusterProvider timestampAdjusterProvider) {
        this(isMaster, dataSource, playlist, trackSelector, bandwidthMeter, timestampAdjusterProvider, 5000L, 20000L, null, null);
    }

    public HlsChunkSource(boolean isMaster, DataSource dataSource, HlsPlaylist playlist, HlsTrackSelector trackSelector, BandwidthMeter bandwidthMeter, PtsTimestampAdjusterProvider timestampAdjusterProvider, long minBufferDurationToSwitchUpMs, long maxBufferDurationToSwitchDownMs) {
        this(isMaster, dataSource, playlist, trackSelector, bandwidthMeter, timestampAdjusterProvider, minBufferDurationToSwitchUpMs, maxBufferDurationToSwitchDownMs, null, null);
    }

    public HlsChunkSource(boolean isMaster, DataSource dataSource, HlsPlaylist playlist, HlsTrackSelector trackSelector, BandwidthMeter bandwidthMeter, PtsTimestampAdjusterProvider timestampAdjusterProvider, long minBufferDurationToSwitchUpMs, long maxBufferDurationToSwitchDownMs, Handler eventHandler, EventListener eventListener) {
        this.isMaster = isMaster;
        this.dataSource = dataSource;
        this.trackSelector = trackSelector;
        this.bandwidthMeter = bandwidthMeter;
        this.timestampAdjusterProvider = timestampAdjusterProvider;
        this.eventListener = eventListener;
        this.eventHandler = eventHandler;
        this.minBufferDurationToSwitchUpUs = minBufferDurationToSwitchUpMs * 1000L;
        this.maxBufferDurationToSwitchDownUs = maxBufferDurationToSwitchDownMs * 1000L;
        this.baseUri = playlist.baseUri;
        this.playlistParser = new HlsPlaylistParser();
        this.tracks = new ArrayList();
        if (playlist.type == 0) {
            this.masterPlaylist = (HlsMasterPlaylist)playlist;
        } else {
            Format format = new Format("0", "application/x-mpegURL", -1, -1, -1.0f, -1, -1, -1, null, null);
            ArrayList<Variant> variants = new ArrayList<Variant>();
            variants.add(new Variant(this.baseUri, format));
            this.masterPlaylist = new HlsMasterPlaylist(this.baseUri, variants, Collections.emptyList(), Collections.emptyList(), null, null);
        }
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
    }

    public boolean prepare() {
        if (!this.prepareCalled) {
            this.prepareCalled = true;
            try {
                this.trackSelector.selectTracks(this.masterPlaylist, this);
                this.selectTrack(0);
            }
            catch (IOException e) {
                this.fatalError = e;
            }
        }
        return this.fatalError == null;
    }

    public boolean isLive() {
        return this.live;
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public int getTrackCount() {
        return this.tracks.size();
    }

    public Variant getFixedTrackVariant(int index) {
        Variant[] variants = this.tracks.get(index).variants;
        return variants.length == 1 ? variants[0] : null;
    }

    public String getMuxedAudioLanguage() {
        return this.masterPlaylist.muxedAudioLanguage;
    }

    public String getMuxedCaptionLanguage() {
        return this.masterPlaylist.muxedCaptionLanguage;
    }

    public int getSelectedTrackIndex() {
        return this.selectedTrackIndex;
    }

    public void selectTrack(int index) {
        this.selectedTrackIndex = index;
        ExposedTrack selectedTrack = this.tracks.get(this.selectedTrackIndex);
        this.selectedVariantIndex = selectedTrack.defaultVariantIndex;
        this.variants = selectedTrack.variants;
        this.variantPlaylists = new HlsMediaPlaylist[this.variants.length];
        this.variantLastPlaylistLoadTimesMs = new long[this.variants.length];
        this.variantBlacklistTimes = new long[this.variants.length];
    }

    public void seek() {
        if (this.isMaster) {
            this.timestampAdjusterProvider.reset();
        }
    }

    public void reset() {
        this.fatalError = null;
    }

    public void getChunkOperation(TsChunk previousTsChunk, long playbackPositionUs, ChunkOperationHolder out) {
        HlsExtractorWrapper extractorWrapper;
        int chunkMediaSequence;
        int previousChunkVariantIndex = previousTsChunk == null ? -1 : this.getVariantIndex(previousTsChunk.format);
        int nextVariantIndex = this.getNextVariantIndex(previousTsChunk, playbackPositionUs);
        boolean switchingVariant = previousTsChunk != null && previousChunkVariantIndex != nextVariantIndex;
        HlsMediaPlaylist mediaPlaylist = this.variantPlaylists[nextVariantIndex];
        if (mediaPlaylist == null) {
            out.chunk = this.newMediaPlaylistChunk(nextVariantIndex);
            return;
        }
        this.selectedVariantIndex = nextVariantIndex;
        if (this.live) {
            if (previousTsChunk == null) {
                chunkMediaSequence = this.getLiveStartChunkSequenceNumber(this.selectedVariantIndex);
            } else {
                chunkMediaSequence = this.getLiveNextChunkSequenceNumber(previousTsChunk.chunkIndex, previousChunkVariantIndex, this.selectedVariantIndex);
                if (chunkMediaSequence < mediaPlaylist.mediaSequence) {
                    this.fatalError = new BehindLiveWindowException();
                    return;
                }
            }
        } else {
            chunkMediaSequence = previousTsChunk == null ? Util.binarySearchFloor(mediaPlaylist.segments, Long.valueOf(playbackPositionUs), true, true) + mediaPlaylist.mediaSequence : (switchingVariant ? Util.binarySearchFloor(mediaPlaylist.segments, Long.valueOf(previousTsChunk.startTimeUs), true, true) + mediaPlaylist.mediaSequence : previousTsChunk.getNextChunkIndex());
        }
        int chunkIndex = chunkMediaSequence - mediaPlaylist.mediaSequence;
        if (chunkIndex >= mediaPlaylist.segments.size()) {
            if (!mediaPlaylist.live) {
                out.endOfStream = true;
            } else if (this.shouldRerequestLiveMediaPlaylist(this.selectedVariantIndex)) {
                out.chunk = this.newMediaPlaylistChunk(this.selectedVariantIndex);
            }
            return;
        }
        HlsMediaPlaylist.Segment segment = mediaPlaylist.segments.get(chunkIndex);
        Uri chunkUri = UriUtil.resolveToUri(mediaPlaylist.baseUri, segment.url);
        if (segment.isEncrypted) {
            Uri keyUri = UriUtil.resolveToUri(mediaPlaylist.baseUri, segment.encryptionKeyUri);
            if (!keyUri.equals((Object)this.encryptionKeyUri)) {
                out.chunk = this.newEncryptionKeyChunk(keyUri, segment.encryptionIV, this.selectedVariantIndex);
                return;
            }
            if (!Util.areEqual(segment.encryptionIV, this.encryptionIvString)) {
                this.setEncryptionData(keyUri, segment.encryptionIV, this.encryptionKey);
            }
        } else {
            this.clearEncryptionData();
        }
        DataSpec dataSpec = new DataSpec(chunkUri, segment.byterangeOffset, segment.byterangeLength, null);
        long startTimeUs = this.live ? (previousTsChunk == null ? 0L : previousTsChunk.getAdjustedEndTimeUs() - (switchingVariant ? previousTsChunk.getDurationUs() : 0L)) : segment.startTimeUs;
        long endTimeUs = startTimeUs + (long)(segment.durationSecs * 1000000.0);
        int trigger = 0;
        Format format = this.variants[this.selectedVariantIndex].format;
        String lastPathSegment = chunkUri.getLastPathSegment();
        if (lastPathSegment.endsWith(AAC_FILE_EXTENSION)) {
            AdtsExtractor extractor = new AdtsExtractor(startTimeUs);
            extractorWrapper = new HlsExtractorWrapper(trigger, format, startTimeUs, extractor, switchingVariant, -1, -1);
        } else if (lastPathSegment.endsWith(MP3_FILE_EXTENSION)) {
            Mp3Extractor extractor = new Mp3Extractor(startTimeUs);
            extractorWrapper = new HlsExtractorWrapper(trigger, format, startTimeUs, extractor, switchingVariant, -1, -1);
        } else if (lastPathSegment.endsWith(WEBVTT_FILE_EXTENSION) || lastPathSegment.endsWith(VTT_FILE_EXTENSION)) {
            PtsTimestampAdjuster timestampAdjuster = this.timestampAdjusterProvider.getAdjuster(this.isMaster, segment.discontinuitySequenceNumber, startTimeUs);
            if (timestampAdjuster == null) {
                return;
            }
            WebvttExtractor extractor = new WebvttExtractor(timestampAdjuster);
            extractorWrapper = new HlsExtractorWrapper(trigger, format, startTimeUs, extractor, switchingVariant, -1, -1);
        } else if (previousTsChunk == null || previousTsChunk.discontinuitySequenceNumber != segment.discontinuitySequenceNumber || !format.equals(previousTsChunk.format)) {
            PtsTimestampAdjuster timestampAdjuster = this.timestampAdjusterProvider.getAdjuster(this.isMaster, segment.discontinuitySequenceNumber, startTimeUs);
            if (timestampAdjuster == null) {
                return;
            }
            int workaroundFlags = 16;
            String codecs = format.codecs;
            if (!TextUtils.isEmpty((CharSequence)codecs)) {
                if (MimeTypes.getAudioMediaMimeType(codecs) != "audio/mp4a-latm") {
                    workaroundFlags |= 2;
                }
                if (MimeTypes.getVideoMediaMimeType(codecs) != "video/avc") {
                    workaroundFlags |= 4;
                }
            }
            TsExtractor extractor = new TsExtractor(timestampAdjuster, workaroundFlags);
            ExposedTrack selectedTrack = this.tracks.get(this.selectedTrackIndex);
            extractorWrapper = new HlsExtractorWrapper(trigger, format, startTimeUs, extractor, switchingVariant, selectedTrack.adaptiveMaxWidth, selectedTrack.adaptiveMaxHeight);
        } else {
            extractorWrapper = previousTsChunk.extractorWrapper;
        }
        out.chunk = new TsChunk(this.dataSource, dataSpec, trigger, format, startTimeUs, endTimeUs, chunkMediaSequence, segment.discontinuitySequenceNumber, extractorWrapper, this.encryptionKey, this.encryptionIv);
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof MediaPlaylistChunk) {
            MediaPlaylistChunk mediaPlaylistChunk = (MediaPlaylistChunk)chunk;
            this.scratchSpace = mediaPlaylistChunk.getDataHolder();
            this.setMediaPlaylist(mediaPlaylistChunk.variantIndex, mediaPlaylistChunk.getResult());
            if (this.eventHandler != null && this.eventListener != null) {
                final byte[] rawResponse = mediaPlaylistChunk.getRawResponse();
                this.eventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        HlsChunkSource.this.eventListener.onMediaPlaylistLoadCompleted(rawResponse);
                    }
                });
            }
        } else if (chunk instanceof EncryptionKeyChunk) {
            EncryptionKeyChunk encryptionKeyChunk = (EncryptionKeyChunk)chunk;
            this.scratchSpace = encryptionKeyChunk.getDataHolder();
            this.setEncryptionData(encryptionKeyChunk.dataSpec.uri, encryptionKeyChunk.iv, encryptionKeyChunk.getResult());
        }
    }

    public boolean onChunkLoadError(Chunk chunk, IOException e) {
        if (chunk.bytesLoaded() == 0L && (chunk instanceof TsChunk || chunk instanceof MediaPlaylistChunk || chunk instanceof EncryptionKeyChunk) && e instanceof HttpDataSource.InvalidResponseCodeException) {
            HttpDataSource.InvalidResponseCodeException responseCodeException = (HttpDataSource.InvalidResponseCodeException)e;
            int responseCode = responseCodeException.responseCode;
            if (responseCode == 404 || responseCode == 410) {
                int variantIndex;
                if (chunk instanceof TsChunk) {
                    TsChunk tsChunk = (TsChunk)chunk;
                    variantIndex = this.getVariantIndex(tsChunk.format);
                } else if (chunk instanceof MediaPlaylistChunk) {
                    MediaPlaylistChunk playlistChunk = (MediaPlaylistChunk)chunk;
                    variantIndex = playlistChunk.variantIndex;
                } else {
                    EncryptionKeyChunk encryptionChunk = (EncryptionKeyChunk)chunk;
                    variantIndex = encryptionChunk.variantIndex;
                }
                boolean alreadyBlacklisted = this.variantBlacklistTimes[variantIndex] != 0L;
                this.variantBlacklistTimes[variantIndex] = SystemClock.elapsedRealtime();
                if (alreadyBlacklisted) {
                    Log.w((String)TAG, (String)("Already blacklisted variant (" + responseCode + "): " + chunk.dataSpec.uri));
                    return false;
                }
                if (!this.allVariantsBlacklisted()) {
                    Log.w((String)TAG, (String)("Blacklisted variant (" + responseCode + "): " + chunk.dataSpec.uri));
                    return true;
                }
                Log.w((String)TAG, (String)("Final variant not blacklisted (" + responseCode + "): " + chunk.dataSpec.uri));
                this.variantBlacklistTimes[variantIndex] = 0L;
                return false;
            }
        }
        return false;
    }

    @Override
    public void adaptiveTrack(HlsMasterPlaylist playlist, Variant[] variants) {
        Arrays.sort(variants, new Comparator<Variant>(){
            private final Comparator<Format> formatComparator = new Format.DecreasingBandwidthComparator();

            @Override
            public int compare(Variant first, Variant second) {
                return this.formatComparator.compare(first.format, second.format);
            }
        });
        int defaultVariantIndex = this.computeDefaultVariantIndex(playlist, variants, this.bandwidthMeter);
        int maxWidth = -1;
        int maxHeight = -1;
        for (int i = 0; i < variants.length; ++i) {
            Format variantFormat = variants[i].format;
            maxWidth = Math.max(variantFormat.width, maxWidth);
            maxHeight = Math.max(variantFormat.height, maxHeight);
        }
        maxWidth = maxWidth > 0 ? maxWidth : 1920;
        maxHeight = maxHeight > 0 ? maxHeight : 1080;
        this.tracks.add(new ExposedTrack(variants, defaultVariantIndex, maxWidth, maxHeight));
    }

    @Override
    public void fixedTrack(HlsMasterPlaylist playlist, Variant variant) {
        this.tracks.add(new ExposedTrack(variant));
    }

    protected int computeDefaultVariantIndex(HlsMasterPlaylist playlist, Variant[] variants, BandwidthMeter bandwidthMeter) {
        int defaultVariantIndex = 0;
        int minOriginalVariantIndex = Integer.MAX_VALUE;
        for (int i = 0; i < variants.length; ++i) {
            int originalVariantIndex = playlist.variants.indexOf(variants[i]);
            if (originalVariantIndex >= minOriginalVariantIndex) continue;
            minOriginalVariantIndex = originalVariantIndex;
            defaultVariantIndex = i;
        }
        return defaultVariantIndex;
    }

    private int getLiveStartChunkSequenceNumber(int variantIndex) {
        HlsMediaPlaylist mediaPlaylist = this.variantPlaylists[variantIndex];
        int chunkIndex = mediaPlaylist.segments.size() > 3 ? mediaPlaylist.segments.size() - 3 : 0;
        return chunkIndex + mediaPlaylist.mediaSequence;
    }

    private int getLiveNextChunkSequenceNumber(int previousChunkIndex, int oldVariantIndex, int newVariantIndex) {
        if (oldVariantIndex == newVariantIndex) {
            return previousChunkIndex + 1;
        }
        HlsMediaPlaylist oldMediaPlaylist = this.variantPlaylists[oldVariantIndex];
        HlsMediaPlaylist newMediaPlaylist = this.variantPlaylists[newVariantIndex];
        double offsetToLiveInstantSecs = 0.0;
        for (int i = previousChunkIndex - oldMediaPlaylist.mediaSequence; i < oldMediaPlaylist.segments.size(); ++i) {
            offsetToLiveInstantSecs += oldMediaPlaylist.segments.get((int)i).durationSecs;
        }
        long currentTimeMs = SystemClock.elapsedRealtime();
        offsetToLiveInstantSecs += (double)(currentTimeMs - this.variantLastPlaylistLoadTimesMs[oldVariantIndex]) / 1000.0;
        offsetToLiveInstantSecs += 2.0;
        if ((offsetToLiveInstantSecs -= (double)(currentTimeMs - this.variantLastPlaylistLoadTimesMs[newVariantIndex]) / 1000.0) < 0.0) {
            return newMediaPlaylist.mediaSequence + newMediaPlaylist.segments.size() + 1;
        }
        for (int i = newMediaPlaylist.segments.size() - 1; i >= 0; --i) {
            if (!((offsetToLiveInstantSecs -= newMediaPlaylist.segments.get((int)i).durationSecs) < 0.0)) continue;
            return newMediaPlaylist.mediaSequence + i;
        }
        return newMediaPlaylist.mediaSequence - 1;
    }

    private int getNextVariantIndex(TsChunk previousTsChunk, long playbackPositionUs) {
        this.clearStaleBlacklistedVariants();
        long bitrateEstimate = this.bandwidthMeter.getBitrateEstimate();
        if (this.variantBlacklistTimes[this.selectedVariantIndex] != 0L) {
            return this.getVariantIndexForBandwidth(bitrateEstimate);
        }
        if (previousTsChunk == null) {
            return this.selectedVariantIndex;
        }
        if (bitrateEstimate == -1L) {
            return this.selectedVariantIndex;
        }
        int idealIndex = this.getVariantIndexForBandwidth(bitrateEstimate);
        if (idealIndex == this.selectedVariantIndex) {
            return this.selectedVariantIndex;
        }
        long bufferedUs = previousTsChunk.getAdjustedEndTimeUs() - previousTsChunk.getDurationUs() - playbackPositionUs;
        if (this.variantBlacklistTimes[this.selectedVariantIndex] != 0L || idealIndex > this.selectedVariantIndex && bufferedUs < this.maxBufferDurationToSwitchDownUs || idealIndex < this.selectedVariantIndex && bufferedUs > this.minBufferDurationToSwitchUpUs) {
            return idealIndex;
        }
        return this.selectedVariantIndex;
    }

    private int getVariantIndexForBandwidth(long bitrateEstimate) {
        if (bitrateEstimate == -1L) {
            bitrateEstimate = 0L;
        }
        int effectiveBitrate = (int)((float)bitrateEstimate * 0.8f);
        int lowestQualityEnabledVariantIndex = -1;
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variantBlacklistTimes[i] != 0L) continue;
            if (this.variants[i].format.bitrate <= effectiveBitrate) {
                return i;
            }
            lowestQualityEnabledVariantIndex = i;
        }
        Assertions.checkState(lowestQualityEnabledVariantIndex != -1);
        return lowestQualityEnabledVariantIndex;
    }

    private boolean shouldRerequestLiveMediaPlaylist(int nextVariantIndex) {
        HlsMediaPlaylist mediaPlaylist = this.variantPlaylists[nextVariantIndex];
        long timeSinceLastMediaPlaylistLoadMs = SystemClock.elapsedRealtime() - this.variantLastPlaylistLoadTimesMs[nextVariantIndex];
        return timeSinceLastMediaPlaylistLoadMs >= (long)(mediaPlaylist.targetDurationSecs * 1000 / 2);
    }

    private MediaPlaylistChunk newMediaPlaylistChunk(int variantIndex) {
        Uri mediaPlaylistUri = UriUtil.resolveToUri(this.baseUri, this.variants[variantIndex].url);
        DataSpec dataSpec = new DataSpec(mediaPlaylistUri, 0L, -1L, null, 1);
        return new MediaPlaylistChunk(this.dataSource, dataSpec, this.scratchSpace, this.playlistParser, variantIndex, mediaPlaylistUri.toString());
    }

    private EncryptionKeyChunk newEncryptionKeyChunk(Uri keyUri, String iv, int variantIndex) {
        DataSpec dataSpec = new DataSpec(keyUri, 0L, -1L, null, 1);
        return new EncryptionKeyChunk(this.dataSource, dataSpec, this.scratchSpace, iv, variantIndex);
    }

    private void setEncryptionData(Uri keyUri, String iv, byte[] secretKey) {
        String trimmedIv = iv.toLowerCase(Locale.getDefault()).startsWith("0x") ? iv.substring(2) : iv;
        byte[] ivData = new BigInteger(trimmedIv, 16).toByteArray();
        byte[] ivDataWithPadding = new byte[16];
        int offset = ivData.length > 16 ? ivData.length - 16 : 0;
        System.arraycopy(ivData, offset, ivDataWithPadding, ivDataWithPadding.length - ivData.length + offset, ivData.length - offset);
        this.encryptionKeyUri = keyUri;
        this.encryptionKey = secretKey;
        this.encryptionIvString = iv;
        this.encryptionIv = ivDataWithPadding;
    }

    private void clearEncryptionData() {
        this.encryptionKeyUri = null;
        this.encryptionKey = null;
        this.encryptionIvString = null;
        this.encryptionIv = null;
    }

    private void setMediaPlaylist(int variantIndex, HlsMediaPlaylist mediaPlaylist) {
        this.variantLastPlaylistLoadTimesMs[variantIndex] = SystemClock.elapsedRealtime();
        this.variantPlaylists[variantIndex] = mediaPlaylist;
        this.live |= mediaPlaylist.live;
        this.durationUs = this.live ? -1L : mediaPlaylist.durationUs;
    }

    private boolean allVariantsBlacklisted() {
        for (long variantBlacklistTime : this.variantBlacklistTimes) {
            if (variantBlacklistTime != 0L) continue;
            return false;
        }
        return true;
    }

    private void clearStaleBlacklistedVariants() {
        long currentTime = SystemClock.elapsedRealtime();
        for (int i = 0; i < this.variantBlacklistTimes.length; ++i) {
            if (this.variantBlacklistTimes[i] == 0L || currentTime - this.variantBlacklistTimes[i] <= 60000L) continue;
            this.variantBlacklistTimes[i] = 0L;
        }
    }

    private int getVariantIndex(Format format) {
        for (int i = 0; i < this.variants.length; ++i) {
            if (!this.variants[i].format.equals(format)) continue;
            return i;
        }
        throw new IllegalStateException("Invalid format: " + format);
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        public final String iv;
        public final int variantIndex;
        private byte[] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, byte[] scratchSpace, String iv, int variantIndex) {
            super(dataSource, dataSpec, 3, 0, null, -1, scratchSpace);
            this.iv = iv;
            this.variantIndex = variantIndex;
        }

        @Override
        protected void consume(byte[] data, int limit) throws IOException {
            this.result = Arrays.copyOf(data, limit);
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    private static final class MediaPlaylistChunk
    extends DataChunk {
        public final int variantIndex;
        private final HlsPlaylistParser playlistParser;
        private final String playlistUrl;
        private byte[] rawResponse;
        private HlsMediaPlaylist result;

        public MediaPlaylistChunk(DataSource dataSource, DataSpec dataSpec, byte[] scratchSpace, HlsPlaylistParser playlistParser, int variantIndex, String playlistUrl) {
            super(dataSource, dataSpec, 4, 0, null, -1, scratchSpace);
            this.variantIndex = variantIndex;
            this.playlistParser = playlistParser;
            this.playlistUrl = playlistUrl;
        }

        @Override
        protected void consume(byte[] data, int limit) throws IOException {
            this.rawResponse = Arrays.copyOf(data, limit);
            this.result = (HlsMediaPlaylist)this.playlistParser.parse(this.playlistUrl, new ByteArrayInputStream(this.rawResponse));
        }

        public byte[] getRawResponse() {
            return this.rawResponse;
        }

        public HlsMediaPlaylist getResult() {
            return this.result;
        }
    }

    private static final class ExposedTrack {
        private final Variant[] variants;
        private final int defaultVariantIndex;
        private final int adaptiveMaxWidth;
        private final int adaptiveMaxHeight;

        public ExposedTrack(Variant fixedVariant) {
            this.variants = new Variant[]{fixedVariant};
            this.defaultVariantIndex = 0;
            this.adaptiveMaxWidth = -1;
            this.adaptiveMaxHeight = -1;
        }

        public ExposedTrack(Variant[] adaptiveVariants, int defaultVariantIndex, int maxWidth, int maxHeight) {
            this.variants = adaptiveVariants;
            this.defaultVariantIndex = defaultVariantIndex;
            this.adaptiveMaxWidth = maxWidth;
            this.adaptiveMaxHeight = maxHeight;
        }
    }

    public static interface EventListener {
        public void onMediaPlaylistLoadCompleted(byte[] var1);
    }
}

