/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultTrackOutput;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import java.io.IOException;

public final class HlsExtractorWrapper
implements ExtractorOutput {
    public final int trigger;
    public final Format format;
    public final long startTimeUs;
    private final Extractor extractor;
    private final SparseArray<DefaultTrackOutput> sampleQueues;
    private final boolean shouldSpliceIn;
    private final int adaptiveMaxWidth;
    private final int adaptiveMaxHeight;
    private MediaFormat[] sampleQueueFormats;
    private Allocator allocator;
    private volatile boolean tracksBuilt;
    private boolean prepared;
    private boolean spliceConfigured;

    public HlsExtractorWrapper(int trigger, Format format, long startTimeUs, Extractor extractor, boolean shouldSpliceIn, int adaptiveMaxWidth, int adaptiveMaxHeight) {
        this.trigger = trigger;
        this.format = format;
        this.startTimeUs = startTimeUs;
        this.extractor = extractor;
        this.shouldSpliceIn = shouldSpliceIn;
        this.adaptiveMaxWidth = adaptiveMaxWidth;
        this.adaptiveMaxHeight = adaptiveMaxHeight;
        this.sampleQueues = new SparseArray();
    }

    public void init(Allocator allocator) {
        this.allocator = allocator;
        this.extractor.init(this);
    }

    public boolean isPrepared() {
        if (!this.prepared && this.tracksBuilt) {
            int i;
            for (i = 0; i < this.sampleQueues.size(); ++i) {
                if (((DefaultTrackOutput)this.sampleQueues.valueAt(i)).hasFormat()) continue;
                return false;
            }
            this.prepared = true;
            this.sampleQueueFormats = new MediaFormat[this.sampleQueues.size()];
            for (i = 0; i < this.sampleQueueFormats.length; ++i) {
                MediaFormat format = ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getFormat();
                if (MimeTypes.isVideo(format.mimeType) && (this.adaptiveMaxWidth != -1 || this.adaptiveMaxHeight != -1)) {
                    format = format.copyWithMaxVideoDimensions(this.adaptiveMaxWidth, this.adaptiveMaxHeight);
                }
                this.sampleQueueFormats[i] = format;
            }
        }
        return this.prepared;
    }

    public void clear() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).clear();
        }
    }

    public long getLargestParsedTimestampUs() {
        long largestParsedTimestampUs = Long.MIN_VALUE;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            largestParsedTimestampUs = Math.max(largestParsedTimestampUs, ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getLargestParsedTimestampUs());
        }
        return largestParsedTimestampUs;
    }

    public final void configureSpliceTo(HlsExtractorWrapper nextExtractor) {
        Assertions.checkState(this.isPrepared());
        if (this.spliceConfigured || !nextExtractor.shouldSpliceIn || !nextExtractor.isPrepared()) {
            return;
        }
        boolean spliceConfigured = true;
        int trackCount = this.getTrackCount();
        for (int i = 0; i < trackCount; ++i) {
            DefaultTrackOutput currentSampleQueue = (DefaultTrackOutput)this.sampleQueues.valueAt(i);
            DefaultTrackOutput nextSampleQueue = (DefaultTrackOutput)nextExtractor.sampleQueues.valueAt(i);
            spliceConfigured &= currentSampleQueue.configureSpliceTo(nextSampleQueue);
        }
        this.spliceConfigured = spliceConfigured;
    }

    public int getTrackCount() {
        Assertions.checkState(this.isPrepared());
        return this.sampleQueues.size();
    }

    public MediaFormat getMediaFormat(int track) {
        Assertions.checkState(this.isPrepared());
        return this.sampleQueueFormats[track];
    }

    public boolean getSample(int track, SampleHolder holder) {
        Assertions.checkState(this.isPrepared());
        return ((DefaultTrackOutput)this.sampleQueues.valueAt(track)).getSample(holder);
    }

    public void discardUntil(int track, long timeUs) {
        Assertions.checkState(this.isPrepared());
        ((DefaultTrackOutput)this.sampleQueues.valueAt(track)).discardUntil(timeUs);
    }

    public boolean hasSamples(int track) {
        Assertions.checkState(this.isPrepared());
        return !((DefaultTrackOutput)this.sampleQueues.valueAt(track)).isEmpty();
    }

    public int read(ExtractorInput input) throws IOException, InterruptedException {
        int result = this.extractor.read(input, null);
        Assertions.checkState(result != 1);
        return result;
    }

    public long getAdjustedEndTimeUs() {
        long largestAdjustedPtsParsed = Long.MIN_VALUE;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            largestAdjustedPtsParsed = Math.max(largestAdjustedPtsParsed, ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getLargestParsedTimestampUs());
        }
        return largestAdjustedPtsParsed;
    }

    @Override
    public TrackOutput track(int id) {
        DefaultTrackOutput trackOutput = (DefaultTrackOutput)this.sampleQueues.get(id);
        if (trackOutput != null) {
            return trackOutput;
        }
        trackOutput = new DefaultTrackOutput(this.allocator);
        this.sampleQueues.put(id, (Object)trackOutput);
        return trackOutput;
    }

    @Override
    public void endTracks() {
        this.tracksBuilt = true;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
    }

    @Override
    public void drmInitData(DrmInitData drmInit) {
    }
}

