/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsMediaPlaylist;
import com.google.android.exoplayer.hls.HlsParserUtil;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.upstream.UriLoadable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Pattern;

public final class HlsPlaylistParser
implements UriLoadable.Parser<HlsPlaylist> {
    private static final String VERSION_TAG = "#EXT-X-VERSION";
    private static final String STREAM_INF_TAG = "#EXT-X-STREAM-INF";
    private static final String MEDIA_TAG = "#EXT-X-MEDIA";
    private static final String DISCONTINUITY_TAG = "#EXT-X-DISCONTINUITY";
    private static final String DISCONTINUITY_SEQUENCE_TAG = "#EXT-X-DISCONTINUITY-SEQUENCE";
    private static final String MEDIA_DURATION_TAG = "#EXTINF";
    private static final String MEDIA_SEQUENCE_TAG = "#EXT-X-MEDIA-SEQUENCE";
    private static final String TARGET_DURATION_TAG = "#EXT-X-TARGETDURATION";
    private static final String ENDLIST_TAG = "#EXT-X-ENDLIST";
    private static final String KEY_TAG = "#EXT-X-KEY";
    private static final String BYTERANGE_TAG = "#EXT-X-BYTERANGE";
    private static final String BANDWIDTH_ATTR = "BANDWIDTH";
    private static final String CODECS_ATTR = "CODECS";
    private static final String RESOLUTION_ATTR = "RESOLUTION";
    private static final String LANGUAGE_ATTR = "LANGUAGE";
    private static final String NAME_ATTR = "NAME";
    private static final String TYPE_ATTR = "TYPE";
    private static final String METHOD_ATTR = "METHOD";
    private static final String URI_ATTR = "URI";
    private static final String IV_ATTR = "IV";
    private static final String INSTREAM_ID_ATTR = "INSTREAM-ID";
    private static final String AUDIO_TYPE = "AUDIO";
    private static final String VIDEO_TYPE = "VIDEO";
    private static final String SUBTITLES_TYPE = "SUBTITLES";
    private static final String CLOSED_CAPTIONS_TYPE = "CLOSED-CAPTIONS";
    private static final String METHOD_NONE = "NONE";
    private static final String METHOD_AES128 = "AES-128";
    private static final Pattern BANDWIDTH_ATTR_REGEX = Pattern.compile("BANDWIDTH=(\\d+)\\b");
    private static final Pattern CODECS_ATTR_REGEX = Pattern.compile("CODECS=\"(.+?)\"");
    private static final Pattern RESOLUTION_ATTR_REGEX = Pattern.compile("RESOLUTION=(\\d+x\\d+)");
    private static final Pattern MEDIA_DURATION_REGEX = Pattern.compile("#EXTINF:([\\d.]+)\\b");
    private static final Pattern MEDIA_SEQUENCE_REGEX = Pattern.compile("#EXT-X-MEDIA-SEQUENCE:(\\d+)\\b");
    private static final Pattern TARGET_DURATION_REGEX = Pattern.compile("#EXT-X-TARGETDURATION:(\\d+)\\b");
    private static final Pattern VERSION_REGEX = Pattern.compile("#EXT-X-VERSION:(\\d+)\\b");
    private static final Pattern BYTERANGE_REGEX = Pattern.compile("#EXT-X-BYTERANGE:(\\d+(?:@\\d+)?)\\b");
    private static final Pattern METHOD_ATTR_REGEX = Pattern.compile("METHOD=(NONE|AES-128)");
    private static final Pattern URI_ATTR_REGEX = Pattern.compile("URI=\"(.+?)\"");
    private static final Pattern IV_ATTR_REGEX = Pattern.compile("IV=([^,.*]+)");
    private static final Pattern TYPE_ATTR_REGEX = Pattern.compile("TYPE=(AUDIO|VIDEO|SUBTITLES|CLOSED-CAPTIONS)");
    private static final Pattern LANGUAGE_ATTR_REGEX = Pattern.compile("LANGUAGE=\"(.+?)\"");
    private static final Pattern NAME_ATTR_REGEX = Pattern.compile("NAME=\"(.+?)\"");
    private static final Pattern INSTREAM_ID_ATTR_REGEX = Pattern.compile("INSTREAM-ID=\"(.+?)\"");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HlsPlaylist parse(String connectionUrl, InputStream inputStream) throws IOException, ParserException {
        LinkedList<String> extraLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(STREAM_INF_TAG)) {
                    extraLines.add(line);
                    HlsMasterPlaylist hlsMasterPlaylist = HlsPlaylistParser.parseMasterPlaylist(new LineIterator(extraLines, reader), connectionUrl);
                    return hlsMasterPlaylist;
                }
                if (line.startsWith(TARGET_DURATION_TAG) || line.startsWith(MEDIA_SEQUENCE_TAG) || line.startsWith(MEDIA_DURATION_TAG) || line.startsWith(KEY_TAG) || line.startsWith(BYTERANGE_TAG) || line.equals(DISCONTINUITY_TAG) || line.equals(DISCONTINUITY_SEQUENCE_TAG) || line.equals(ENDLIST_TAG)) {
                    extraLines.add(line);
                    HlsMediaPlaylist hlsMediaPlaylist = HlsPlaylistParser.parseMediaPlaylist(new LineIterator(extraLines, reader), connectionUrl);
                    return hlsMediaPlaylist;
                }
                extraLines.add(line);
            }
        }
        throw new ParserException("Failed to parse the playlist, could not identify any tags.");
    }

    private static HlsMasterPlaylist parseMasterPlaylist(LineIterator iterator, String baseUri) throws IOException {
        ArrayList<Variant> variants = new ArrayList<Variant>();
        ArrayList<Variant> audios = new ArrayList<Variant>();
        ArrayList<Variant> subtitles = new ArrayList<Variant>();
        int bitrate = 0;
        String codecs = null;
        int width = -1;
        int height = -1;
        String name = null;
        String muxedAudioLanguage = null;
        String muxedCaptionLanguage = null;
        boolean expectingStreamInfUrl = false;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(MEDIA_TAG)) {
                Format format;
                String uri;
                String type = HlsParserUtil.parseStringAttr(line, TYPE_ATTR_REGEX, TYPE_ATTR);
                if (CLOSED_CAPTIONS_TYPE.equals(type)) {
                    String instreamId = HlsParserUtil.parseStringAttr(line, INSTREAM_ID_ATTR_REGEX, INSTREAM_ID_ATTR);
                    if (!"CC1".equals(instreamId)) continue;
                    muxedCaptionLanguage = HlsParserUtil.parseOptionalStringAttr(line, LANGUAGE_ATTR_REGEX);
                    continue;
                }
                if (SUBTITLES_TYPE.equals(type)) {
                    String subtitleName = HlsParserUtil.parseStringAttr(line, NAME_ATTR_REGEX, NAME_ATTR);
                    uri = HlsParserUtil.parseStringAttr(line, URI_ATTR_REGEX, URI_ATTR);
                    String language = HlsParserUtil.parseOptionalStringAttr(line, LANGUAGE_ATTR_REGEX);
                    format = new Format(subtitleName, "application/x-mpegURL", -1, -1, -1.0f, -1, -1, -1, language, codecs);
                    subtitles.add(new Variant(uri, format));
                    continue;
                }
                if (!AUDIO_TYPE.equals(type)) continue;
                String language = HlsParserUtil.parseOptionalStringAttr(line, LANGUAGE_ATTR_REGEX);
                uri = HlsParserUtil.parseOptionalStringAttr(line, URI_ATTR_REGEX);
                if (uri != null) {
                    String audioName = HlsParserUtil.parseStringAttr(line, NAME_ATTR_REGEX, NAME_ATTR);
                    format = new Format(audioName, "application/x-mpegURL", -1, -1, -1.0f, -1, -1, -1, language, codecs);
                    audios.add(new Variant(uri, format));
                    continue;
                }
                muxedAudioLanguage = language;
                continue;
            }
            if (line.startsWith(STREAM_INF_TAG)) {
                bitrate = HlsParserUtil.parseIntAttr(line, BANDWIDTH_ATTR_REGEX, BANDWIDTH_ATTR);
                codecs = HlsParserUtil.parseOptionalStringAttr(line, CODECS_ATTR_REGEX);
                name = HlsParserUtil.parseOptionalStringAttr(line, NAME_ATTR_REGEX);
                String resolutionString = HlsParserUtil.parseOptionalStringAttr(line, RESOLUTION_ATTR_REGEX);
                if (resolutionString != null) {
                    String[] widthAndHeight = resolutionString.split("x");
                    width = Integer.parseInt(widthAndHeight[0]);
                    if (width <= 0) {
                        width = -1;
                    }
                    if ((height = Integer.parseInt(widthAndHeight[1])) <= 0) {
                        height = -1;
                    }
                } else {
                    width = -1;
                    height = -1;
                }
                expectingStreamInfUrl = true;
                continue;
            }
            if (line.startsWith("#") || !expectingStreamInfUrl) continue;
            if (name == null) {
                name = Integer.toString(variants.size());
            }
            Format format = new Format(name, "application/x-mpegURL", width, height, -1.0f, -1, -1, bitrate, null, codecs);
            variants.add(new Variant(line, format));
            bitrate = 0;
            codecs = null;
            name = null;
            width = -1;
            height = -1;
            expectingStreamInfUrl = false;
        }
        return new HlsMasterPlaylist(baseUri, variants, audios, subtitles, muxedAudioLanguage, muxedCaptionLanguage);
    }

    private static HlsMediaPlaylist parseMediaPlaylist(LineIterator iterator, String baseUri) throws IOException {
        int mediaSequence = 0;
        int targetDurationSecs = 0;
        int version = 1;
        boolean live = true;
        ArrayList<HlsMediaPlaylist.Segment> segments = new ArrayList<HlsMediaPlaylist.Segment>();
        double segmentDurationSecs = 0.0;
        int discontinuitySequenceNumber = 0;
        long segmentStartTimeUs = 0L;
        long segmentByterangeOffset = 0L;
        long segmentByterangeLength = -1L;
        int segmentMediaSequence = 0;
        boolean isEncrypted = false;
        String encryptionKeyUri = null;
        String encryptionIV = null;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(TARGET_DURATION_TAG)) {
                targetDurationSecs = HlsParserUtil.parseIntAttr(line, TARGET_DURATION_REGEX, TARGET_DURATION_TAG);
                continue;
            }
            if (line.startsWith(MEDIA_SEQUENCE_TAG)) {
                segmentMediaSequence = mediaSequence = HlsParserUtil.parseIntAttr(line, MEDIA_SEQUENCE_REGEX, MEDIA_SEQUENCE_TAG);
                continue;
            }
            if (line.startsWith(VERSION_TAG)) {
                version = HlsParserUtil.parseIntAttr(line, VERSION_REGEX, VERSION_TAG);
                continue;
            }
            if (line.startsWith(MEDIA_DURATION_TAG)) {
                segmentDurationSecs = HlsParserUtil.parseDoubleAttr(line, MEDIA_DURATION_REGEX, MEDIA_DURATION_TAG);
                continue;
            }
            if (line.startsWith(KEY_TAG)) {
                String method = HlsParserUtil.parseStringAttr(line, METHOD_ATTR_REGEX, METHOD_ATTR);
                isEncrypted = METHOD_AES128.equals(method);
                if (isEncrypted) {
                    encryptionKeyUri = HlsParserUtil.parseStringAttr(line, URI_ATTR_REGEX, URI_ATTR);
                    encryptionIV = HlsParserUtil.parseOptionalStringAttr(line, IV_ATTR_REGEX);
                    continue;
                }
                encryptionKeyUri = null;
                encryptionIV = null;
                continue;
            }
            if (line.startsWith(BYTERANGE_TAG)) {
                String byteRange = HlsParserUtil.parseStringAttr(line, BYTERANGE_REGEX, BYTERANGE_TAG);
                String[] splitByteRange = byteRange.split("@");
                segmentByterangeLength = Long.parseLong(splitByteRange[0]);
                if (splitByteRange.length <= 1) continue;
                segmentByterangeOffset = Long.parseLong(splitByteRange[1]);
                continue;
            }
            if (line.startsWith(DISCONTINUITY_SEQUENCE_TAG)) {
                discontinuitySequenceNumber = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                continue;
            }
            if (line.equals(DISCONTINUITY_TAG)) {
                ++discontinuitySequenceNumber;
                continue;
            }
            if (!line.startsWith("#")) {
                String segmentEncryptionIV = !isEncrypted ? null : (encryptionIV != null ? encryptionIV : Integer.toHexString(segmentMediaSequence));
                ++segmentMediaSequence;
                if (segmentByterangeLength == -1L) {
                    segmentByterangeOffset = 0L;
                }
                segments.add(new HlsMediaPlaylist.Segment(line, segmentDurationSecs, discontinuitySequenceNumber, segmentStartTimeUs, isEncrypted, encryptionKeyUri, segmentEncryptionIV, segmentByterangeOffset, segmentByterangeLength));
                segmentStartTimeUs += (long)(segmentDurationSecs * 1000000.0);
                segmentDurationSecs = 0.0;
                if (segmentByterangeLength != -1L) {
                    segmentByterangeOffset += segmentByterangeLength;
                }
                segmentByterangeLength = -1L;
                continue;
            }
            if (!line.equals(ENDLIST_TAG)) continue;
            live = false;
        }
        return new HlsMediaPlaylist(baseUri, mediaSequence, targetDurationSecs, version, live, Collections.unmodifiableList(segments));
    }

    private static class LineIterator {
        private final BufferedReader reader;
        private final Queue<String> extraLines;
        private String next;

        public LineIterator(Queue<String> extraLines, BufferedReader reader) {
            this.extraLines = extraLines;
            this.reader = reader;
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (!this.extraLines.isEmpty()) {
                this.next = this.extraLines.poll();
                return true;
            }
            while ((this.next = this.reader.readLine()) != null) {
                this.next = this.next.trim();
                if (this.next.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String next() throws IOException {
            String result = null;
            if (this.hasNext()) {
                result = this.next;
                this.next = null;
            }
            return result;
        }
    }
}

