/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.chunk.BaseChunkSampleSourceEventListener;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.HlsExtractorWrapper;
import com.google.android.exoplayer.hls.TsChunk;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public final class HlsSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private static final long NO_RESET_PENDING = Long.MIN_VALUE;
    private static final int PRIMARY_TYPE_NONE = 0;
    private static final int PRIMARY_TYPE_TEXT = 1;
    private static final int PRIMARY_TYPE_AUDIO = 2;
    private static final int PRIMARY_TYPE_VIDEO = 3;
    private final HlsChunkSource chunkSource;
    private final LinkedList<HlsExtractorWrapper> extractors;
    private final int minLoadableRetryCount;
    private final int bufferSizeContribution;
    private final ChunkOperationHolder chunkOperationHolder;
    private final int eventSourceId;
    private final LoadControl loadControl;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private int remainingReleaseCount;
    private boolean prepared;
    private boolean loadControlRegistered;
    private int trackCount;
    private int enabledTrackCount;
    private Format downstreamFormat;
    private MediaFormat[] trackFormats;
    private boolean[] trackEnabledStates;
    private boolean[] pendingDiscontinuities;
    private MediaFormat[] downstreamMediaFormats;
    private int[] chunkSourceTrackIndices;
    private int[] extractorTrackIndices;
    private boolean[] extractorTrackEnabledStates;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean loadingFinished;
    private Chunk currentLoadable;
    private TsChunk currentTsLoadable;
    private TsChunk previousTsLoadable;
    private Loader loader;
    private IOException currentLoadableException;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private long currentLoadStartTimeMs;

    public HlsSampleSource(HlsChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution) {
        this(chunkSource, loadControl, bufferSizeContribution, null, null, 0);
    }

    public HlsSampleSource(HlsChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution, Handler eventHandler, EventListener eventListener, int eventSourceId) {
        this(chunkSource, loadControl, bufferSizeContribution, eventHandler, eventListener, eventSourceId, 3);
    }

    public HlsSampleSource(HlsChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution, Handler eventHandler, EventListener eventListener, int eventSourceId, int minLoadableRetryCount) {
        this.chunkSource = chunkSource;
        this.loadControl = loadControl;
        this.bufferSizeContribution = bufferSizeContribution;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.eventSourceId = eventSourceId;
        this.pendingResetPositionUs = Long.MIN_VALUE;
        this.extractors = new LinkedList();
        this.chunkOperationHolder = new ChunkOperationHolder();
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        ++this.remainingReleaseCount;
        return this;
    }

    @Override
    public boolean prepare(long positionUs) {
        if (this.prepared) {
            return true;
        }
        if (!this.chunkSource.prepare()) {
            return false;
        }
        if (!this.extractors.isEmpty()) {
            while (true) {
                HlsExtractorWrapper extractor;
                if ((extractor = this.extractors.getFirst()).isPrepared()) {
                    this.buildTracks(extractor);
                    this.prepared = true;
                    this.maybeStartLoading();
                    return true;
                }
                if (this.extractors.size() <= 1) break;
                this.extractors.removeFirst().clear();
            }
        }
        if (this.loader == null) {
            this.loader = new Loader("Loader:HLS");
            this.loadControl.register(this, this.bufferSizeContribution);
            this.loadControlRegistered = true;
        }
        if (!this.loader.isLoading()) {
            this.pendingResetPositionUs = positionUs;
            this.downstreamPositionUs = positionUs;
        }
        this.maybeStartLoading();
        return false;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.trackCount;
    }

    @Override
    public MediaFormat getFormat(int track) {
        Assertions.checkState(this.prepared);
        return this.trackFormats[track];
    }

    @Override
    public void enable(int track, long positionUs) {
        Assertions.checkState(this.prepared);
        this.setTrackEnabledState(track, true);
        this.downstreamMediaFormats[track] = null;
        this.pendingDiscontinuities[track] = false;
        this.downstreamFormat = null;
        boolean wasLoadControlRegistered = this.loadControlRegistered;
        if (!this.loadControlRegistered) {
            this.loadControl.register(this, this.bufferSizeContribution);
            this.loadControlRegistered = true;
        }
        positionUs = this.chunkSource.isLive() ? 0L : positionUs;
        int chunkSourceTrack = this.chunkSourceTrackIndices[track];
        if (chunkSourceTrack != -1 && chunkSourceTrack != this.chunkSource.getSelectedTrackIndex()) {
            this.chunkSource.selectTrack(chunkSourceTrack);
            this.seekToInternal(positionUs);
            return;
        }
        if (this.enabledTrackCount == 1) {
            this.lastSeekPositionUs = positionUs;
            if (wasLoadControlRegistered && this.downstreamPositionUs == positionUs) {
                this.maybeStartLoading();
            } else {
                this.downstreamPositionUs = positionUs;
                this.restartFrom(positionUs);
            }
        }
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.prepared);
        this.setTrackEnabledState(track, false);
        if (this.enabledTrackCount == 0) {
            this.chunkSource.reset();
            this.downstreamPositionUs = Long.MIN_VALUE;
            if (this.loadControlRegistered) {
                this.loadControl.unregister(this);
                this.loadControlRegistered = false;
            }
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.clearState();
                this.loadControl.trimAllocator();
            }
        }
    }

    @Override
    public boolean continueBuffering(int track, long playbackPositionUs) {
        HlsExtractorWrapper extractor;
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[track]);
        this.downstreamPositionUs = playbackPositionUs;
        if (!this.extractors.isEmpty()) {
            this.discardSamplesForDisabledTracks(this.getCurrentExtractor(), this.downstreamPositionUs);
        }
        this.maybeStartLoading();
        if (this.loadingFinished) {
            return true;
        }
        if (this.isPendingReset() || this.extractors.isEmpty()) {
            return false;
        }
        for (int extractorIndex = 0; extractorIndex < this.extractors.size() && (extractor = this.extractors.get(extractorIndex)).isPrepared(); ++extractorIndex) {
            int extractorTrack = this.extractorTrackIndices[track];
            if (!extractor.hasSamples(extractorTrack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long readDiscontinuity(int track) {
        if (this.pendingDiscontinuities[track]) {
            this.pendingDiscontinuities[track] = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int track, long playbackPositionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder) {
        Assertions.checkState(this.prepared);
        this.downstreamPositionUs = playbackPositionUs;
        if (this.pendingDiscontinuities[track] || this.isPendingReset()) {
            return -2;
        }
        HlsExtractorWrapper extractor = this.getCurrentExtractor();
        if (!extractor.isPrepared()) {
            return -2;
        }
        Format format = extractor.format;
        if (!format.equals(this.downstreamFormat)) {
            this.notifyDownstreamFormatChanged(format, extractor.trigger, extractor.startTimeUs);
        }
        this.downstreamFormat = format;
        if (this.extractors.size() > 1) {
            extractor.configureSpliceTo(this.extractors.get(1));
        }
        int extractorTrack = this.extractorTrackIndices[track];
        int extractorIndex = 0;
        while (this.extractors.size() > extractorIndex + 1 && !extractor.hasSamples(extractorTrack)) {
            if ((extractor = this.extractors.get(++extractorIndex)).isPrepared()) continue;
            return -2;
        }
        MediaFormat mediaFormat = extractor.getMediaFormat(extractorTrack);
        if (mediaFormat != null) {
            if (!mediaFormat.equals(this.downstreamMediaFormats[track])) {
                formatHolder.format = mediaFormat;
                this.downstreamMediaFormats[track] = mediaFormat;
                return -4;
            }
            this.downstreamMediaFormats[track] = mediaFormat;
        }
        if (extractor.getSample(extractorTrack, sampleHolder)) {
            boolean decodeOnly = sampleHolder.timeUs < this.lastSeekPositionUs;
            sampleHolder.flags = sampleHolder.flags | (decodeOnly ? 0x8000000 : 0);
            return -3;
        }
        if (this.loadingFinished) {
            return -1;
        }
        return -2;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.currentLoadableException != null && this.currentLoadableExceptionCount > this.minLoadableRetryCount) {
            throw this.currentLoadableException;
        }
        if (this.currentLoadable == null) {
            this.chunkSource.maybeThrowError();
        }
    }

    @Override
    public void seekToUs(long positionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        positionUs = this.chunkSource.isLive() ? 0L : positionUs;
        long currentPositionUs = this.isPendingReset() ? this.pendingResetPositionUs : this.downstreamPositionUs;
        this.downstreamPositionUs = positionUs;
        this.lastSeekPositionUs = positionUs;
        if (currentPositionUs == positionUs) {
            return;
        }
        this.seekToInternal(positionUs);
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        if (this.loadingFinished) {
            return -3L;
        }
        long largestParsedTimestampUs = this.extractors.getLast().getLargestParsedTimestampUs();
        if (this.extractors.size() > 1) {
            largestParsedTimestampUs = Math.max(largestParsedTimestampUs, this.extractors.get(this.extractors.size() - 2).getLargestParsedTimestampUs());
        }
        return largestParsedTimestampUs == Long.MIN_VALUE ? this.downstreamPositionUs : largestParsedTimestampUs;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0 && this.loader != null) {
            if (this.loadControlRegistered) {
                this.loadControl.unregister(this);
                this.loadControlRegistered = false;
            }
            this.loader.release();
            this.loader = null;
        }
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        Assertions.checkState(loadable == this.currentLoadable);
        long now = SystemClock.elapsedRealtime();
        long loadDurationMs = now - this.currentLoadStartTimeMs;
        this.chunkSource.onChunkLoadCompleted(this.currentLoadable);
        if (this.isTsChunk(this.currentLoadable)) {
            Assertions.checkState(this.currentLoadable == this.currentTsLoadable);
            this.previousTsLoadable = this.currentTsLoadable;
            this.notifyLoadCompleted(this.currentLoadable.bytesLoaded(), this.currentTsLoadable.type, this.currentTsLoadable.trigger, this.currentTsLoadable.format, this.currentTsLoadable.startTimeUs, this.currentTsLoadable.endTimeUs, now, loadDurationMs);
        } else {
            this.notifyLoadCompleted(this.currentLoadable.bytesLoaded(), this.currentLoadable.type, this.currentLoadable.trigger, this.currentLoadable.format, -1L, -1L, now, loadDurationMs);
        }
        this.clearCurrentLoadable();
        this.maybeStartLoading();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        this.notifyLoadCanceled(this.currentLoadable.bytesLoaded());
        if (this.enabledTrackCount > 0) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.clearState();
            this.loadControl.trimAllocator();
        }
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException e) {
        if (this.chunkSource.onChunkLoadError(this.currentLoadable, e)) {
            if (this.previousTsLoadable == null && !this.isPendingReset()) {
                this.pendingResetPositionUs = this.lastSeekPositionUs;
            }
            this.clearCurrentLoadable();
        } else {
            this.currentLoadableException = e;
            ++this.currentLoadableExceptionCount;
            this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        }
        this.notifyLoadError(e);
        this.maybeStartLoading();
    }

    private void buildTracks(HlsExtractorWrapper extractor) {
        int primaryExtractorTrackType = 0;
        int primaryExtractorTrackIndex = -1;
        int extractorTrackCount = extractor.getTrackCount();
        for (int i = 0; i < extractorTrackCount; ++i) {
            String mimeType = extractor.getMediaFormat((int)i).mimeType;
            int trackType = MimeTypes.isVideo(mimeType) ? 3 : (MimeTypes.isAudio(mimeType) ? 2 : (MimeTypes.isText(mimeType) ? 1 : 0));
            if (trackType > primaryExtractorTrackType) {
                primaryExtractorTrackType = trackType;
                primaryExtractorTrackIndex = i;
                continue;
            }
            if (trackType != primaryExtractorTrackType || primaryExtractorTrackIndex == -1) continue;
            primaryExtractorTrackIndex = -1;
        }
        int chunkSourceTrackCount = this.chunkSource.getTrackCount();
        boolean expandPrimaryExtractorTrack = primaryExtractorTrackIndex != -1;
        this.trackCount = extractorTrackCount;
        if (expandPrimaryExtractorTrack) {
            this.trackCount += chunkSourceTrackCount - 1;
        }
        this.trackFormats = new MediaFormat[this.trackCount];
        this.trackEnabledStates = new boolean[this.trackCount];
        this.pendingDiscontinuities = new boolean[this.trackCount];
        this.downstreamMediaFormats = new MediaFormat[this.trackCount];
        this.chunkSourceTrackIndices = new int[this.trackCount];
        this.extractorTrackIndices = new int[this.trackCount];
        this.extractorTrackEnabledStates = new boolean[extractorTrackCount];
        long durationUs = this.chunkSource.getDurationUs();
        int trackIndex = 0;
        for (int i = 0; i < extractorTrackCount; ++i) {
            MediaFormat format = extractor.getMediaFormat(i).copyWithDurationUs(durationUs);
            String muxedLanguage = null;
            if (MimeTypes.isAudio(format.mimeType)) {
                muxedLanguage = this.chunkSource.getMuxedAudioLanguage();
            } else if ("application/eia-608".equals(format.mimeType)) {
                muxedLanguage = this.chunkSource.getMuxedCaptionLanguage();
            }
            if (i == primaryExtractorTrackIndex) {
                for (int j = 0; j < chunkSourceTrackCount; ++j) {
                    this.extractorTrackIndices[trackIndex] = i;
                    this.chunkSourceTrackIndices[trackIndex] = j;
                    Variant fixedTrackVariant = this.chunkSource.getFixedTrackVariant(j);
                    this.trackFormats[trackIndex++] = fixedTrackVariant == null ? format.copyAsAdaptive(null) : HlsSampleSource.copyWithFixedTrackInfo(format, fixedTrackVariant.format, muxedLanguage);
                }
                continue;
            }
            this.extractorTrackIndices[trackIndex] = i;
            this.chunkSourceTrackIndices[trackIndex] = -1;
            this.trackFormats[trackIndex++] = format.copyWithLanguage(muxedLanguage);
        }
    }

    private void setTrackEnabledState(int track, boolean enabledState) {
        Assertions.checkState(this.trackEnabledStates[track] != enabledState);
        int extractorTrack = this.extractorTrackIndices[track];
        Assertions.checkState(this.extractorTrackEnabledStates[extractorTrack] != enabledState);
        this.trackEnabledStates[track] = enabledState;
        this.extractorTrackEnabledStates[extractorTrack] = enabledState;
        this.enabledTrackCount += enabledState ? 1 : -1;
    }

    private static MediaFormat copyWithFixedTrackInfo(MediaFormat format, Format fixedTrackFormat, String muxedLanguage) {
        int width = fixedTrackFormat.width == -1 ? -1 : fixedTrackFormat.width;
        int height = fixedTrackFormat.height == -1 ? -1 : fixedTrackFormat.height;
        String language = fixedTrackFormat.language == null ? muxedLanguage : fixedTrackFormat.language;
        return format.copyWithFixedTrackInfo(fixedTrackFormat.id, fixedTrackFormat.bitrate, width, height, language);
    }

    private void seekToInternal(long positionUs) {
        this.lastSeekPositionUs = positionUs;
        this.downstreamPositionUs = positionUs;
        Arrays.fill(this.pendingDiscontinuities, true);
        this.chunkSource.seek();
        this.restartFrom(positionUs);
    }

    private HlsExtractorWrapper getCurrentExtractor() {
        HlsExtractorWrapper extractor = this.extractors.getFirst();
        while (this.extractors.size() > 1 && !this.haveSamplesForEnabledTracks(extractor)) {
            this.extractors.removeFirst().clear();
            extractor = this.extractors.getFirst();
        }
        return extractor;
    }

    private void discardSamplesForDisabledTracks(HlsExtractorWrapper extractor, long timeUs) {
        if (!extractor.isPrepared()) {
            return;
        }
        for (int i = 0; i < this.extractorTrackEnabledStates.length; ++i) {
            if (this.extractorTrackEnabledStates[i]) continue;
            extractor.discardUntil(i, timeUs);
        }
    }

    private boolean haveSamplesForEnabledTracks(HlsExtractorWrapper extractor) {
        if (!extractor.isPrepared()) {
            return false;
        }
        for (int i = 0; i < this.extractorTrackEnabledStates.length; ++i) {
            if (!this.extractorTrackEnabledStates[i] || !extractor.hasSamples(i)) continue;
            return true;
        }
        return false;
    }

    private void restartFrom(long positionUs) {
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearState();
            this.maybeStartLoading();
        }
    }

    private void clearState() {
        for (int i = 0; i < this.extractors.size(); ++i) {
            this.extractors.get(i).clear();
        }
        this.extractors.clear();
        this.clearCurrentLoadable();
        this.previousTsLoadable = null;
    }

    private void clearCurrentLoadable() {
        this.currentTsLoadable = null;
        this.currentLoadable = null;
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private void maybeStartLoading() {
        long now = SystemClock.elapsedRealtime();
        long nextLoadPositionUs = this.getNextLoadPositionUs();
        boolean isBackedOff = this.currentLoadableException != null;
        boolean loadingOrBackedOff = this.loader.isLoading() || isBackedOff;
        boolean nextLoader = this.loadControl.update(this, this.downstreamPositionUs, nextLoadPositionUs, loadingOrBackedOff);
        if (isBackedOff) {
            long elapsedMillis = now - this.currentLoadableExceptionTimestamp;
            if (elapsedMillis >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.currentLoadableException = null;
                this.loader.startLoading(this.currentLoadable, this);
            }
            return;
        }
        if (this.loader.isLoading() || !nextLoader || this.prepared && this.enabledTrackCount == 0) {
            return;
        }
        this.chunkSource.getChunkOperation(this.previousTsLoadable, this.pendingResetPositionUs != Long.MIN_VALUE ? this.pendingResetPositionUs : this.downstreamPositionUs, this.chunkOperationHolder);
        boolean endOfStream = this.chunkOperationHolder.endOfStream;
        Chunk nextLoadable = this.chunkOperationHolder.chunk;
        this.chunkOperationHolder.clear();
        if (endOfStream) {
            this.loadingFinished = true;
            this.loadControl.update(this, this.downstreamPositionUs, -1L, false);
            return;
        }
        if (nextLoadable == null) {
            return;
        }
        this.currentLoadStartTimeMs = now;
        this.currentLoadable = nextLoadable;
        if (this.isTsChunk(this.currentLoadable)) {
            TsChunk tsChunk = (TsChunk)this.currentLoadable;
            if (this.isPendingReset()) {
                this.pendingResetPositionUs = Long.MIN_VALUE;
            }
            HlsExtractorWrapper extractorWrapper = tsChunk.extractorWrapper;
            if (this.extractors.isEmpty() || this.extractors.getLast() != extractorWrapper) {
                extractorWrapper.init(this.loadControl.getAllocator());
                this.extractors.addLast(extractorWrapper);
            }
            this.notifyLoadStarted(tsChunk.dataSpec.length, tsChunk.type, tsChunk.trigger, tsChunk.format, tsChunk.startTimeUs, tsChunk.endTimeUs);
            this.currentTsLoadable = tsChunk;
        } else {
            this.notifyLoadStarted(this.currentLoadable.dataSpec.length, this.currentLoadable.type, this.currentLoadable.trigger, this.currentLoadable.format, -1L, -1L);
        }
        this.loader.startLoading(this.currentLoadable, this);
    }

    private long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished || this.prepared && this.enabledTrackCount == 0 ? -1L : (this.currentTsLoadable != null ? this.currentTsLoadable.endTimeUs : this.previousTsLoadable.endTimeUs);
    }

    private boolean isTsChunk(Chunk chunk) {
        return chunk instanceof TsChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != Long.MIN_VALUE;
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    long usToMs(long timeUs) {
        return timeUs / 1000L;
    }

    private void notifyLoadStarted(final long length, final int type, final int trigger, final Format format, final long mediaStartTimeUs, final long mediaEndTimeUs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadStarted(HlsSampleSource.this.eventSourceId, length, type, trigger, format, HlsSampleSource.this.usToMs(mediaStartTimeUs), HlsSampleSource.this.usToMs(mediaEndTimeUs));
                }
            });
        }
    }

    private void notifyLoadCompleted(final long bytesLoaded, final int type, final int trigger, final Format format, final long mediaStartTimeUs, final long mediaEndTimeUs, final long elapsedRealtimeMs, final long loadDurationMs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadCompleted(HlsSampleSource.this.eventSourceId, bytesLoaded, type, trigger, format, HlsSampleSource.this.usToMs(mediaStartTimeUs), HlsSampleSource.this.usToMs(mediaEndTimeUs), elapsedRealtimeMs, loadDurationMs);
                }
            });
        }
    }

    private void notifyLoadCanceled(final long bytesLoaded) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadCanceled(HlsSampleSource.this.eventSourceId, bytesLoaded);
                }
            });
        }
    }

    private void notifyLoadError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadError(HlsSampleSource.this.eventSourceId, e);
                }
            });
        }
    }

    private void notifyDownstreamFormatChanged(final Format format, final int trigger, final long positionUs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onDownstreamFormatChanged(HlsSampleSource.this.eventSourceId, format, trigger, HlsSampleSource.this.usToMs(positionUs));
                }
            });
        }
    }

    public static interface EventListener
    extends BaseChunkSampleSourceEventListener {
    }
}

