/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.hls.Aes128DataSource;
import com.google.android.exoplayer.hls.HlsExtractorWrapper;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class TsChunk
extends MediaChunk {
    public final int discontinuitySequenceNumber;
    public final HlsExtractorWrapper extractorWrapper;
    private final boolean isEncrypted;
    private int bytesLoaded;
    private long adjustedEndTimeUs;
    private volatile boolean loadCanceled;

    public TsChunk(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, long startTimeUs, long endTimeUs, int chunkIndex, int discontinuitySequenceNumber, HlsExtractorWrapper extractorWrapper, byte[] encryptionKey, byte[] encryptionIv) {
        super(TsChunk.buildDataSource(dataSource, encryptionKey, encryptionIv), dataSpec, trigger, format, startTimeUs, endTimeUs, chunkIndex);
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.extractorWrapper = extractorWrapper;
        this.isEncrypted = this.dataSource instanceof Aes128DataSource;
        this.adjustedEndTimeUs = startTimeUs;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        boolean skipLoadedBytes;
        DataSpec loadDataSpec;
        if (this.isEncrypted) {
            loadDataSpec = this.dataSpec;
            skipLoadedBytes = this.bytesLoaded != 0;
        } else {
            loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
            skipLoadedBytes = false;
        }
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            if (skipLoadedBytes) {
                input.skipFully(this.bytesLoaded);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractorWrapper.read(input);
                }
                long tsChunkEndTimeUs = this.extractorWrapper.getAdjustedEndTimeUs();
                if (tsChunkEndTimeUs != Long.MIN_VALUE) {
                    this.adjustedEndTimeUs = tsChunkEndTimeUs;
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    public long getAdjustedEndTimeUs() {
        return this.adjustedEndTimeUs;
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] encryptionKey, byte[] encryptionIv) {
        if (encryptionKey == null || encryptionIv == null) {
            return dataSource;
        }
        return new Aes128DataSource(dataSource, encryptionKey, encryptionIv);
    }
}

