/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.metadata.id3;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.metadata.id3.ApicFrame;
import com.google.android.exoplayer.metadata.id3.BinaryFrame;
import com.google.android.exoplayer.metadata.id3.GeobFrame;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import com.google.android.exoplayer.metadata.id3.PrivFrame;
import com.google.android.exoplayer.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer.metadata.id3.TxxxFrame;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class Id3Parser
implements MetadataParser<List<Id3Frame>> {
    private static final int ID3_TEXT_ENCODING_ISO_8859_1 = 0;
    private static final int ID3_TEXT_ENCODING_UTF_16 = 1;
    private static final int ID3_TEXT_ENCODING_UTF_16BE = 2;
    private static final int ID3_TEXT_ENCODING_UTF_8 = 3;

    @Override
    public boolean canParse(String mimeType) {
        return mimeType.equals("application/id3");
    }

    @Override
    public List<Id3Frame> parse(byte[] data, int size) throws ParserException {
        int frameSize;
        ArrayList<TxxxFrame> id3Frames = new ArrayList<TxxxFrame>();
        ParsableByteArray id3Data = new ParsableByteArray(data, size);
        for (int id3Size = Id3Parser.parseId3Header(id3Data); id3Size > 0; id3Size -= frameSize + 10) {
            int frameId0 = id3Data.readUnsignedByte();
            int frameId1 = id3Data.readUnsignedByte();
            int frameId2 = id3Data.readUnsignedByte();
            int frameId3 = id3Data.readUnsignedByte();
            frameSize = id3Data.readSynchSafeInt();
            if (frameSize <= 1) break;
            id3Data.skipBytes(2);
            try {
                String id;
                Id3Frame frame;
                if (frameId0 == 84 && frameId1 == 88 && frameId2 == 88 && frameId3 == 88) {
                    frame = Id3Parser.parseTxxxFrame(id3Data, frameSize);
                } else if (frameId0 == 80 && frameId1 == 82 && frameId2 == 73 && frameId3 == 86) {
                    frame = Id3Parser.parsePrivFrame(id3Data, frameSize);
                } else if (frameId0 == 71 && frameId1 == 69 && frameId2 == 79 && frameId3 == 66) {
                    frame = Id3Parser.parseGeobFrame(id3Data, frameSize);
                } else if (frameId0 == 65 && frameId1 == 80 && frameId2 == 73 && frameId3 == 67) {
                    frame = Id3Parser.parseApicFrame(id3Data, frameSize);
                } else if (frameId0 == 84) {
                    id = String.format(Locale.US, "%c%c%c%c", frameId0, frameId1, frameId2, frameId3);
                    frame = Id3Parser.parseTextInformationFrame(id3Data, frameSize, id);
                } else {
                    id = String.format(Locale.US, "%c%c%c%c", frameId0, frameId1, frameId2, frameId3);
                    frame = Id3Parser.parseBinaryFrame(id3Data, frameSize, id);
                }
                id3Frames.add((TxxxFrame)frame);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new ParserException(e);
            }
        }
        return Collections.unmodifiableList(id3Frames);
    }

    private static int indexOfEos(byte[] data, int fromIndex, int encoding) {
        int terminationPos = Id3Parser.indexOfZeroByte(data, fromIndex);
        if (encoding == 0 || encoding == 3) {
            return terminationPos;
        }
        while (terminationPos < data.length - 1) {
            if (terminationPos % 2 == 0 && data[terminationPos + 1] == 0) {
                return terminationPos;
            }
            terminationPos = Id3Parser.indexOfZeroByte(data, terminationPos + 1);
        }
        return data.length;
    }

    private static int indexOfZeroByte(byte[] data, int fromIndex) {
        for (int i = fromIndex; i < data.length; ++i) {
            if (data[i] != 0) continue;
            return i;
        }
        return data.length;
    }

    private static int delimiterLength(int encodingByte) {
        return encodingByte == 0 || encodingByte == 3 ? 1 : 2;
    }

    private static int parseId3Header(ParsableByteArray id3Buffer) throws ParserException {
        int id1 = id3Buffer.readUnsignedByte();
        int id2 = id3Buffer.readUnsignedByte();
        int id3 = id3Buffer.readUnsignedByte();
        if (id1 != 73 || id2 != 68 || id3 != 51) {
            throw new ParserException(String.format(Locale.US, "Unexpected ID3 file identifier, expected \"ID3\", actual \"%c%c%c\".", id1, id2, id3));
        }
        id3Buffer.skipBytes(2);
        int flags = id3Buffer.readUnsignedByte();
        int id3Size = id3Buffer.readSynchSafeInt();
        if ((flags & 2) != 0) {
            int extendedHeaderSize = id3Buffer.readSynchSafeInt();
            if (extendedHeaderSize > 4) {
                id3Buffer.skipBytes(extendedHeaderSize - 4);
            }
            id3Size -= extendedHeaderSize;
        }
        if ((flags & 8) != 0) {
            id3Size -= 10;
        }
        return id3Size;
    }

    private static TxxxFrame parseTxxxFrame(ParsableByteArray id3Data, int frameSize) throws UnsupportedEncodingException {
        int encoding = id3Data.readUnsignedByte();
        String charset = Id3Parser.getCharsetName(encoding);
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int descriptionEndIndex = Id3Parser.indexOfEos(data, 0, encoding);
        String description = new String(data, 0, descriptionEndIndex, charset);
        int valueStartIndex = descriptionEndIndex + Id3Parser.delimiterLength(encoding);
        int valueEndIndex = Id3Parser.indexOfEos(data, valueStartIndex, encoding);
        String value = new String(data, valueStartIndex, valueEndIndex - valueStartIndex, charset);
        return new TxxxFrame(description, value);
    }

    private static PrivFrame parsePrivFrame(ParsableByteArray id3Data, int frameSize) throws UnsupportedEncodingException {
        byte[] data = new byte[frameSize];
        id3Data.readBytes(data, 0, frameSize);
        int ownerEndIndex = Id3Parser.indexOfZeroByte(data, 0);
        String owner = new String(data, 0, ownerEndIndex, "ISO-8859-1");
        int privateDataStartIndex = ownerEndIndex + 1;
        byte[] privateData = Arrays.copyOfRange(data, privateDataStartIndex, data.length);
        return new PrivFrame(owner, privateData);
    }

    private static GeobFrame parseGeobFrame(ParsableByteArray id3Data, int frameSize) throws UnsupportedEncodingException {
        int encoding = id3Data.readUnsignedByte();
        String charset = Id3Parser.getCharsetName(encoding);
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int mimeTypeEndIndex = Id3Parser.indexOfZeroByte(data, 0);
        String mimeType = new String(data, 0, mimeTypeEndIndex, "ISO-8859-1");
        int filenameStartIndex = mimeTypeEndIndex + 1;
        int filenameEndIndex = Id3Parser.indexOfEos(data, filenameStartIndex, encoding);
        String filename = new String(data, filenameStartIndex, filenameEndIndex - filenameStartIndex, charset);
        int descriptionStartIndex = filenameEndIndex + Id3Parser.delimiterLength(encoding);
        int descriptionEndIndex = Id3Parser.indexOfEos(data, descriptionStartIndex, encoding);
        String description = new String(data, descriptionStartIndex, descriptionEndIndex - descriptionStartIndex, charset);
        int objectDataStartIndex = descriptionEndIndex + Id3Parser.delimiterLength(encoding);
        byte[] objectData = Arrays.copyOfRange(data, objectDataStartIndex, data.length);
        return new GeobFrame(mimeType, filename, description, objectData);
    }

    private static ApicFrame parseApicFrame(ParsableByteArray id3Data, int frameSize) throws UnsupportedEncodingException {
        int encoding = id3Data.readUnsignedByte();
        String charset = Id3Parser.getCharsetName(encoding);
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int mimeTypeEndIndex = Id3Parser.indexOfZeroByte(data, 0);
        String mimeType = new String(data, 0, mimeTypeEndIndex, "ISO-8859-1");
        int pictureType = data[mimeTypeEndIndex + 1] & 0xFF;
        int descriptionStartIndex = mimeTypeEndIndex + 2;
        int descriptionEndIndex = Id3Parser.indexOfEos(data, descriptionStartIndex, encoding);
        String description = new String(data, descriptionStartIndex, descriptionEndIndex - descriptionStartIndex, charset);
        int pictureDataStartIndex = descriptionEndIndex + Id3Parser.delimiterLength(encoding);
        byte[] pictureData = Arrays.copyOfRange(data, pictureDataStartIndex, data.length);
        return new ApicFrame(mimeType, description, pictureType, pictureData);
    }

    private static TextInformationFrame parseTextInformationFrame(ParsableByteArray id3Data, int frameSize, String id) throws UnsupportedEncodingException {
        int encoding = id3Data.readUnsignedByte();
        String charset = Id3Parser.getCharsetName(encoding);
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int descriptionEndIndex = Id3Parser.indexOfEos(data, 0, encoding);
        String description = new String(data, 0, descriptionEndIndex, charset);
        return new TextInformationFrame(id, description);
    }

    private static BinaryFrame parseBinaryFrame(ParsableByteArray id3Data, int frameSize, String id) {
        byte[] frame = new byte[frameSize];
        id3Data.readBytes(frame, 0, frameSize);
        return new BinaryFrame(id, frame);
    }

    private static String getCharsetName(int encodingByte) {
        switch (encodingByte) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "UTF-16";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-8";
            }
        }
        return "ISO-8859-1";
    }
}

