/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.net.Uri;
import android.os.SystemClock;
import android.util.Base64;
import android.util.SparseArray;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.ContainerMediaChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.extractor.mp4.Track;
import com.google.android.exoplayer.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingTrackSelector;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ManifestFetcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SmoothStreamingChunkSource
implements ChunkSource,
SmoothStreamingTrackSelector.Output {
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final int INITIALIZATION_VECTOR_SIZE = 8;
    private final SmoothStreamingTrackSelector trackSelector;
    private final DataSource dataSource;
    private final FormatEvaluator.Evaluation evaluation;
    private final long liveEdgeLatencyUs;
    private final TrackEncryptionBox[] trackEncryptionBoxes;
    private final ManifestFetcher<SmoothStreamingManifest> manifestFetcher;
    private final DrmInitData.Mapped drmInitData;
    private final FormatEvaluator adaptiveFormatEvaluator;
    private final boolean live;
    private final ArrayList<ExposedTrack> tracks;
    private final SparseArray<ChunkExtractorWrapper> extractorWrappers;
    private final SparseArray<MediaFormat> mediaFormats;
    private boolean prepareCalled;
    private SmoothStreamingManifest currentManifest;
    private int currentManifestChunkOffset;
    private boolean needManifestRefresh;
    private ExposedTrack enabledTrack;
    private IOException fatalError;

    public SmoothStreamingChunkSource(ManifestFetcher<SmoothStreamingManifest> manifestFetcher, SmoothStreamingTrackSelector trackSelector, DataSource dataSource, FormatEvaluator adaptiveFormatEvaluator, long liveEdgeLatencyMs) {
        this(manifestFetcher, manifestFetcher.getManifest(), trackSelector, dataSource, adaptiveFormatEvaluator, liveEdgeLatencyMs);
    }

    public SmoothStreamingChunkSource(SmoothStreamingManifest manifest, SmoothStreamingTrackSelector trackSelector, DataSource dataSource, FormatEvaluator adaptiveFormatEvaluator) {
        this(null, manifest, trackSelector, dataSource, adaptiveFormatEvaluator, 0L);
    }

    private SmoothStreamingChunkSource(ManifestFetcher<SmoothStreamingManifest> manifestFetcher, SmoothStreamingManifest initialManifest, SmoothStreamingTrackSelector trackSelector, DataSource dataSource, FormatEvaluator adaptiveFormatEvaluator, long liveEdgeLatencyMs) {
        this.manifestFetcher = manifestFetcher;
        this.currentManifest = initialManifest;
        this.trackSelector = trackSelector;
        this.dataSource = dataSource;
        this.adaptiveFormatEvaluator = adaptiveFormatEvaluator;
        this.liveEdgeLatencyUs = liveEdgeLatencyMs * 1000L;
        this.evaluation = new FormatEvaluator.Evaluation();
        this.tracks = new ArrayList();
        this.extractorWrappers = new SparseArray();
        this.mediaFormats = new SparseArray();
        this.live = initialManifest.isLive;
        SmoothStreamingManifest.ProtectionElement protectionElement = initialManifest.protectionElement;
        if (protectionElement != null) {
            byte[] keyId = SmoothStreamingChunkSource.getProtectionElementKeyId(protectionElement.data);
            this.trackEncryptionBoxes = new TrackEncryptionBox[1];
            this.trackEncryptionBoxes[0] = new TrackEncryptionBox(true, 8, keyId);
            this.drmInitData = new DrmInitData.Mapped();
            this.drmInitData.put(protectionElement.uuid, new DrmInitData.SchemeInitData("video/mp4", protectionElement.data));
        } else {
            this.trackEncryptionBoxes = null;
            this.drmInitData = null;
        }
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestFetcher.maybeThrowError();
    }

    @Override
    public boolean prepare() {
        if (!this.prepareCalled) {
            this.prepareCalled = true;
            try {
                this.trackSelector.selectTracks(this.currentManifest, this);
            }
            catch (IOException e) {
                this.fatalError = e;
            }
        }
        return this.fatalError == null;
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    @Override
    public final MediaFormat getFormat(int track) {
        return this.tracks.get((int)track).trackFormat;
    }

    @Override
    public void enable(int track) {
        this.enabledTrack = this.tracks.get(track);
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.enable();
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.enable();
        }
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
        if (this.manifestFetcher == null || !this.currentManifest.isLive || this.fatalError != null) {
            return;
        }
        SmoothStreamingManifest newManifest = this.manifestFetcher.getManifest();
        if (this.currentManifest != newManifest && newManifest != null) {
            long newElementStartTimeUs;
            long currentElementEndTimeUs;
            SmoothStreamingManifest.StreamElement currentElement = this.currentManifest.streamElements[this.enabledTrack.elementIndex];
            int currentElementChunkCount = currentElement.chunkCount;
            SmoothStreamingManifest.StreamElement newElement = newManifest.streamElements[this.enabledTrack.elementIndex];
            this.currentManifestChunkOffset = currentElementChunkCount == 0 || newElement.chunkCount == 0 ? (this.currentManifestChunkOffset += currentElementChunkCount) : ((currentElementEndTimeUs = currentElement.getStartTimeUs(currentElementChunkCount - 1) + currentElement.getChunkDurationUs(currentElementChunkCount - 1)) <= (newElementStartTimeUs = newElement.getStartTimeUs(0)) ? (this.currentManifestChunkOffset += currentElementChunkCount) : (this.currentManifestChunkOffset += currentElement.getChunkIndex(newElementStartTimeUs)));
            this.currentManifest = newManifest;
            this.needManifestRefresh = false;
        }
        if (this.needManifestRefresh && SystemClock.elapsedRealtime() > this.manifestFetcher.getManifestLoadStartTimestamp() + 5000L) {
            this.manifestFetcher.requestRefresh();
        }
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> queue, long playbackPositionUs, ChunkOperationHolder out) {
        int chunkIndex;
        if (this.fatalError != null) {
            out.chunk = null;
            return;
        }
        this.evaluation.queueSize = queue.size();
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.evaluate(queue, playbackPositionUs, this.enabledTrack.adaptiveFormats, this.evaluation);
        } else {
            this.evaluation.format = this.enabledTrack.fixedFormat;
            this.evaluation.trigger = 2;
        }
        Format selectedFormat = this.evaluation.format;
        out.queueSize = this.evaluation.queueSize;
        if (selectedFormat == null) {
            out.chunk = null;
            return;
        }
        if (out.queueSize == queue.size() && out.chunk != null && out.chunk.format.equals(selectedFormat)) {
            return;
        }
        out.chunk = null;
        SmoothStreamingManifest.StreamElement streamElement = this.currentManifest.streamElements[this.enabledTrack.elementIndex];
        if (streamElement.chunkCount == 0) {
            if (this.currentManifest.isLive) {
                this.needManifestRefresh = true;
            } else {
                out.endOfStream = true;
            }
            return;
        }
        if (queue.isEmpty()) {
            if (this.live) {
                playbackPositionUs = SmoothStreamingChunkSource.getLiveSeekPosition(this.currentManifest, this.liveEdgeLatencyUs);
            }
            chunkIndex = streamElement.getChunkIndex(playbackPositionUs);
        } else {
            MediaChunk previous = queue.get(out.queueSize - 1);
            chunkIndex = previous.chunkIndex + 1 - this.currentManifestChunkOffset;
        }
        if (this.live && chunkIndex < 0) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        if (this.currentManifest.isLive) {
            if (chunkIndex >= streamElement.chunkCount) {
                this.needManifestRefresh = true;
                return;
            }
            if (chunkIndex == streamElement.chunkCount - 1) {
                this.needManifestRefresh = true;
            }
        } else if (chunkIndex >= streamElement.chunkCount) {
            out.endOfStream = true;
            return;
        }
        boolean isLastChunk = !this.currentManifest.isLive && chunkIndex == streamElement.chunkCount - 1;
        long chunkStartTimeUs = streamElement.getStartTimeUs(chunkIndex);
        long chunkEndTimeUs = isLastChunk ? -1L : chunkStartTimeUs + streamElement.getChunkDurationUs(chunkIndex);
        int currentAbsoluteChunkIndex = chunkIndex + this.currentManifestChunkOffset;
        int manifestTrackIndex = SmoothStreamingChunkSource.getManifestTrackIndex(streamElement, selectedFormat);
        int manifestTrackKey = SmoothStreamingChunkSource.getManifestTrackKey(this.enabledTrack.elementIndex, manifestTrackIndex);
        Uri uri = streamElement.buildRequestUri(manifestTrackIndex, chunkIndex);
        MediaChunk mediaChunk = SmoothStreamingChunkSource.newMediaChunk(selectedFormat, uri, null, (ChunkExtractorWrapper)this.extractorWrappers.get(manifestTrackKey), this.drmInitData, this.dataSource, currentAbsoluteChunkIndex, chunkStartTimeUs, chunkEndTimeUs, this.evaluation.trigger, (MediaFormat)this.mediaFormats.get(manifestTrackKey), this.enabledTrack.adaptiveMaxWidth, this.enabledTrack.adaptiveMaxHeight);
        out.chunk = mediaChunk;
    }

    @Override
    public void onChunkLoadCompleted(Chunk chunk) {
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception e) {
    }

    @Override
    public void disable(List<? extends MediaChunk> queue) {
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.disable();
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.disable();
        }
        this.evaluation.format = null;
        this.fatalError = null;
    }

    @Override
    public void adaptiveTrack(SmoothStreamingManifest manifest, int element, int[] trackIndices) {
        if (this.adaptiveFormatEvaluator == null) {
            return;
        }
        MediaFormat maxHeightMediaFormat = null;
        SmoothStreamingManifest.StreamElement streamElement = manifest.streamElements[element];
        int maxWidth = -1;
        int maxHeight = -1;
        Format[] formats = new Format[trackIndices.length];
        for (int i = 0; i < formats.length; ++i) {
            int manifestTrackIndex = trackIndices[i];
            formats[i] = streamElement.tracks[manifestTrackIndex].format;
            MediaFormat mediaFormat = this.initManifestTrack(manifest, element, manifestTrackIndex);
            if (maxHeightMediaFormat == null || mediaFormat.height > maxHeight) {
                maxHeightMediaFormat = mediaFormat;
            }
            maxWidth = Math.max(maxWidth, mediaFormat.width);
            maxHeight = Math.max(maxHeight, mediaFormat.height);
        }
        Arrays.sort(formats, new Format.DecreasingBandwidthComparator());
        MediaFormat adaptiveMediaFormat = maxHeightMediaFormat.copyAsAdaptive(null);
        this.tracks.add(new ExposedTrack(adaptiveMediaFormat, element, formats, maxWidth, maxHeight));
    }

    @Override
    public void fixedTrack(SmoothStreamingManifest manifest, int element, int trackIndex) {
        MediaFormat mediaFormat = this.initManifestTrack(manifest, element, trackIndex);
        Format format = manifest.streamElements[element].tracks[trackIndex].format;
        this.tracks.add(new ExposedTrack(mediaFormat, element, format));
    }

    private MediaFormat initManifestTrack(SmoothStreamingManifest manifest, int elementIndex, int trackIndex) {
        int mp4TrackType;
        int manifestTrackKey = SmoothStreamingChunkSource.getManifestTrackKey(elementIndex, trackIndex);
        MediaFormat mediaFormat = (MediaFormat)this.mediaFormats.get(manifestTrackKey);
        if (mediaFormat != null) {
            return mediaFormat;
        }
        long durationUs = this.live ? -1L : manifest.durationUs;
        SmoothStreamingManifest.StreamElement element = manifest.streamElements[elementIndex];
        Format format = element.tracks[trackIndex].format;
        byte[][] csdArray = element.tracks[trackIndex].csd;
        switch (element.type) {
            case 1: {
                mediaFormat = MediaFormat.createVideoFormat(format.id, format.mimeType, format.bitrate, -1, durationUs, format.width, format.height, Arrays.asList(csdArray));
                mp4TrackType = Track.TYPE_vide;
                break;
            }
            case 0: {
                List<Object> csd = csdArray != null ? Arrays.asList(csdArray) : Collections.singletonList(CodecSpecificDataUtil.buildAacAudioSpecificConfig(format.audioSamplingRate, format.audioChannels));
                mediaFormat = MediaFormat.createAudioFormat(format.id, format.mimeType, format.bitrate, -1, durationUs, format.audioChannels, format.audioSamplingRate, csd, format.language);
                mp4TrackType = Track.TYPE_soun;
                break;
            }
            case 2: {
                mediaFormat = MediaFormat.createTextFormat(format.id, format.mimeType, format.bitrate, durationUs, format.language);
                mp4TrackType = Track.TYPE_text;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + element.type);
            }
        }
        Track mp4Track = new Track(trackIndex, mp4TrackType, element.timescale, -1L, durationUs, mediaFormat, this.trackEncryptionBoxes, mp4TrackType == Track.TYPE_vide ? 4 : -1, null, null);
        FragmentedMp4Extractor mp4Extractor = new FragmentedMp4Extractor(3, mp4Track);
        this.mediaFormats.put(manifestTrackKey, (Object)mediaFormat);
        this.extractorWrappers.put(manifestTrackKey, (Object)new ChunkExtractorWrapper(mp4Extractor));
        return mediaFormat;
    }

    private static long getLiveSeekPosition(SmoothStreamingManifest manifest, long liveEdgeLatencyUs) {
        long liveEdgeTimestampUs = Long.MIN_VALUE;
        for (int i = 0; i < manifest.streamElements.length; ++i) {
            SmoothStreamingManifest.StreamElement streamElement = manifest.streamElements[i];
            if (streamElement.chunkCount <= 0) continue;
            long elementLiveEdgeTimestampUs = streamElement.getStartTimeUs(streamElement.chunkCount - 1) + streamElement.getChunkDurationUs(streamElement.chunkCount - 1);
            liveEdgeTimestampUs = Math.max(liveEdgeTimestampUs, elementLiveEdgeTimestampUs);
        }
        return liveEdgeTimestampUs - liveEdgeLatencyUs;
    }

    private static int getManifestTrackIndex(SmoothStreamingManifest.StreamElement element, Format format) {
        SmoothStreamingManifest.TrackElement[] tracks = element.tracks;
        for (int i = 0; i < tracks.length; ++i) {
            if (!tracks[i].format.equals(format)) continue;
            return i;
        }
        throw new IllegalStateException("Invalid format: " + format);
    }

    private static MediaChunk newMediaChunk(Format formatInfo, Uri uri, String cacheKey, ChunkExtractorWrapper extractorWrapper, DrmInitData drmInitData, DataSource dataSource, int chunkIndex, long chunkStartTimeUs, long chunkEndTimeUs, int trigger, MediaFormat mediaFormat, int adaptiveMaxWidth, int adaptiveMaxHeight) {
        long offset = 0L;
        DataSpec dataSpec = new DataSpec(uri, offset, -1L, cacheKey);
        return new ContainerMediaChunk(dataSource, dataSpec, trigger, formatInfo, chunkStartTimeUs, chunkEndTimeUs, chunkIndex, chunkStartTimeUs, extractorWrapper, mediaFormat, adaptiveMaxWidth, adaptiveMaxHeight, drmInitData, true, -1);
    }

    private static int getManifestTrackKey(int elementIndex, int trackIndex) {
        Assertions.checkState(elementIndex <= 65536 && trackIndex <= 65536);
        return elementIndex << 16 | trackIndex;
    }

    private static byte[] getProtectionElementKeyId(byte[] initData) {
        StringBuilder initDataStringBuilder = new StringBuilder();
        for (int i = 0; i < initData.length; i += 2) {
            initDataStringBuilder.append((char)initData[i]);
        }
        String initDataString = initDataStringBuilder.toString();
        String keyIdString = initDataString.substring(initDataString.indexOf("<KID>") + 5, initDataString.indexOf("</KID>"));
        byte[] keyId = Base64.decode((String)keyIdString, (int)0);
        SmoothStreamingChunkSource.swap(keyId, 0, 3);
        SmoothStreamingChunkSource.swap(keyId, 1, 2);
        SmoothStreamingChunkSource.swap(keyId, 4, 5);
        SmoothStreamingChunkSource.swap(keyId, 6, 7);
        return keyId;
    }

    private static void swap(byte[] data, int firstPosition, int secondPosition) {
        byte temp = data[firstPosition];
        data[firstPosition] = data[secondPosition];
        data[secondPosition] = temp;
    }

    private static final class ExposedTrack {
        public final MediaFormat trackFormat;
        private final int elementIndex;
        private final Format fixedFormat;
        private final Format[] adaptiveFormats;
        private final int adaptiveMaxWidth;
        private final int adaptiveMaxHeight;

        public ExposedTrack(MediaFormat trackFormat, int elementIndex, Format fixedFormat) {
            this.trackFormat = trackFormat;
            this.elementIndex = elementIndex;
            this.fixedFormat = fixedFormat;
            this.adaptiveFormats = null;
            this.adaptiveMaxWidth = -1;
            this.adaptiveMaxHeight = -1;
        }

        public ExposedTrack(MediaFormat trackFormat, int elementIndex, Format[] adaptiveFormats, int adaptiveMaxWidth, int adaptiveMaxHeight) {
            this.trackFormat = trackFormat;
            this.elementIndex = elementIndex;
            this.adaptiveFormats = adaptiveFormats;
            this.adaptiveMaxWidth = adaptiveMaxWidth;
            this.adaptiveMaxHeight = adaptiveMaxHeight;
            this.fixedFormat = null;
        }

        public boolean isAdaptive() {
            return this.adaptiveFormats != null;
        }
    }
}

